/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.bugs;

import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.ajax.share.actions.ExtendedPermissionEntity;
import com.openexchange.ajax.share.actions.GetLinkRequest;
import com.openexchange.ajax.share.actions.GetLinkResponse;
import com.openexchange.ajax.share.actions.ShareLink;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageObjectPermission;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.share.ShareTarget;
import junit.framework.TestCase;

public class Bug40369Test
extends ShareTest {
    private static final int NUM_THREADS = 20;

    public Bug40369Test(String name) {
        super(name);
    }

    public void testCreateFolderLinkConcurrentlyRandomly() throws Exception {
        this.testCreateFolderLinkConcurrently(Bug40369Test.randomFolderAPI(), Bug40369Test.randomModule());
    }

    public void noTestCreateFolderLinkConcurrentlyExtensively() throws Exception {
        for (EnumAPI api : TESTED_FOLDER_APIS) {
            for (int module : TESTED_MODULES) {
                this.testCreateFolderLinkConcurrently(api, module);
            }
        }
    }

    private void testCreateFolderLinkConcurrently(EnumAPI api, int module) throws Exception {
        this.testCreateFolderLinkConcurrently(api, module, this.getDefaultFolder(module));
    }

    public void testCreateFileLinkConcurrently() throws Exception {
        FolderObject folder = this.insertPrivateFolder(EnumAPI.OX_NEW, 8, this.getDefaultFolder(8));
        File file = this.insertFile(folder.getObjectID());
        ShareTarget target = new ShareTarget(8, file.getFolderId(), file.getId());
        GetLinkResponse[] responses = this.getLinkConcurrently(target, 20);
        file = this.getFile(file.getId());
        Bug40369Test.assertNotNull((Object)file.getObjectPermissions());
        Bug40369Test.assertEquals((int)1, (int)file.getObjectPermissions().size());
        FileStorageObjectPermission matchingPermission = (FileStorageObjectPermission)file.getObjectPermissions().get(0);
        Bug40369Test.assertNotNull((String)"No matching permission in created file found", (Object)matchingPermission);
        ExtendedPermissionEntity guest = this.discoverGuestEntity(file.getFolderId(), file.getId(), matchingPermission.getEntity());
        Bug40369Test.assertNotNull((Object)guest);
        String shareURL = null;
        boolean oneNew = false;
        for (GetLinkResponse response : responses) {
            if (response.hasError()) {
                Bug40369Test.fail((String)response.getErrorMessage());
            }
            ShareLink shareLink = response.getShareLink();
            Bug40369Test.assertNotNull((Object)shareLink);
            if (null == shareURL) {
                shareURL = shareLink.getShareURL();
            } else {
                Bug40369Test.assertEquals((String)shareURL, (String)shareLink.getShareURL());
            }
            if (!shareLink.isNew()) continue;
            Bug40369Test.assertFalse((boolean)oneNew);
            oneNew = true;
        }
    }

    private void testCreateFolderLinkConcurrently(EnumAPI api, int module, int parent) throws Exception {
        FolderObject folder = this.insertPrivateFolder(api, module, parent);
        ShareTarget target = new ShareTarget(module, String.valueOf(folder.getObjectID()));
        GetLinkResponse[] responses = this.getLinkConcurrently(target, 20);
        folder = this.getFolder(api, folder.getObjectID());
        Bug40369Test.assertNotNull((Object)folder.getPermissions());
        Bug40369Test.assertEquals((int)2, (int)folder.getPermissions().size());
        OCLPermission matchingPermission = null;
        for (OCLPermission permission : folder.getPermissions()) {
            if (permission.getEntity() == this.client.getValues().getUserId()) continue;
            matchingPermission = permission;
            break;
        }
        Bug40369Test.assertNotNull((String)"No matching permission in created file found", matchingPermission);
        ExtendedPermissionEntity guest = this.discoverGuestEntity(api, module, folder.getObjectID(), matchingPermission.getEntity());
        Bug40369Test.assertNotNull((Object)guest);
        String shareURL = null;
        boolean oneNew = false;
        for (GetLinkResponse response : responses) {
            if (response.hasError()) {
                Bug40369Test.fail((String)response.getErrorMessage());
                continue;
            }
            ShareLink shareLink = response.getShareLink();
            Bug40369Test.assertNotNull((Object)shareLink);
            if (null == shareURL) {
                shareURL = shareLink.getShareURL();
            } else {
                Bug40369Test.assertEquals((String)shareURL, (String)shareLink.getShareURL());
            }
            if (!shareLink.isNew()) continue;
            Bug40369Test.assertFalse((boolean)oneNew);
            oneNew = true;
        }
    }

    private GetLinkResponse[] getLinkConcurrently(ShareTarget target, int numThreads) throws Exception {
        int i;
        final GetLinkRequest request = new GetLinkRequest(target, this.getTimeZone());
        request.setFailOnError(false);
        Thread[] threads = new Thread[numThreads];
        final GetLinkResponse[] responses = new GetLinkResponse[threads.length];
        for (i = 0; i < threads.length; ++i) {
            final int index = i;
            threads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        responses[index] = Bug40369Test.this.client.execute(request);
                    }
                    catch (Exception e) {
                        TestCase.fail((String)e.getMessage());
                    }
                }
            });
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].join();
        }
        return responses;
    }
}

