/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.actions;

import com.openexchange.ajax.framework.AbstractRedirectParser;
import com.openexchange.ajax.share.actions.ResolveShareResponse;
import com.openexchange.java.Charsets;
import com.openexchange.java.Strings;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;

public class ResolveShareParser
extends AbstractRedirectParser<ResolveShareResponse> {
    public ResolveShareParser() {
        this(true);
    }

    public ResolveShareParser(boolean failOnNonRedirect) {
        super(false, failOnNonRedirect, failOnNonRedirect);
    }

    @Override
    public String checkResponse(HttpResponse resp, HttpRequest request) throws ParseException, IOException {
        return super.checkResponse(resp, request);
    }

    @Override
    protected ResolveShareResponse createResponse(String location) {
        int fragIndex;
        Map<String, String> map = Collections.emptyMap();
        String path = location;
        if (!Strings.isEmpty((String)location) && -1 != (fragIndex = location.indexOf(35))) {
            path = location.substring(0, fragIndex);
            String hashData = location.substring(fragIndex + 1);
            map = hashData.startsWith("?") ? this.deserialize(this.rot(ResolveShareParser.decodeURIComponent(hashData.substring(1)), -1)) : this.deserialize(hashData);
        }
        return new ResolveShareResponse(this.getStatusCode(), path, map);
    }

    private Map<String, String> deserialize(String str) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (str == null) {
            str = "";
        }
        String[] pairs = str.split("&");
        for (int i = 0; i < pairs.length; ++i) {
            String pair = pairs[i];
            String[] keyValue = pair.split("=");
            String key = null;
            String value = null;
            if (keyValue.length != 2) continue;
            key = keyValue[0];
            value = keyValue[1];
            if (!Strings.isNotEmpty((String)key) && value == null) continue;
            result.put(ResolveShareParser.decodeURIComponent(key), ResolveShareParser.decodeURIComponent(value));
        }
        return result;
    }

    private String rot(String str, int shift) {
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = (char)(chars[i] + shift);
        }
        return new String(chars);
    }

    private static String decodeURIComponent(String content) {
        if (content == null) {
            return null;
        }
        ByteBuffer bb = ByteBuffer.allocate(content.length());
        CharBuffer cb = CharBuffer.wrap(content);
        while (cb.hasRemaining()) {
            char c = cb.get();
            if (c == '%' && cb.remaining() >= 2) {
                char uc = cb.get();
                char lc = cb.get();
                int u = Character.digit(uc, 16);
                int l = Character.digit(lc, 16);
                if (u != -1 && l != -1) {
                    bb.put((byte)((u << 4) + l));
                    continue;
                }
                bb.put((byte)37);
                bb.put((byte)uc);
                bb.put((byte)lc);
                continue;
            }
            bb.put((byte)c);
        }
        bb.flip();
        return Charsets.UTF_8.decode(bb).toString();
    }
}

