/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.resource;

import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.resource.actions.ResourceDeleteRequest;
import com.openexchange.ajax.resource.actions.ResourceGetRequest;
import com.openexchange.ajax.resource.actions.ResourceGetResponse;
import com.openexchange.ajax.resource.actions.ResourceNewRequest;
import com.openexchange.exception.OXException;
import com.openexchange.resource.Resource;
import java.io.IOException;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONException;
import org.xml.sax.SAXException;

public abstract class AbstractResourceTest
extends AbstractAJAXSession {
    protected AbstractResourceTest(String name) {
        super(name);
    }

    protected TimeZone getTimeZone() throws OXException, IOException, SAXException, JSONException {
        return this.getClient().getValues().getTimeZone();
    }

    protected Resource getResource(int resourceId) throws OXException, JSONException, IOException, SAXException {
        if (resourceId <= 0) {
            return null;
        }
        return ((ResourceGetResponse)((Object)Executor.execute(this.getSession(), new ResourceGetRequest(resourceId, true)))).getResource();
    }

    protected void deleteResource(int resourceId) throws OXException, JSONException, IOException, SAXException {
        if (resourceId <= 0) {
            return;
        }
        ResourceGetResponse getResponse = (ResourceGetResponse)((Object)Executor.execute(this.getSession(), new ResourceGetRequest(resourceId, true)));
        Date timestamp = getResponse.getTimestamp();
        Executor.execute(this.getSession(), new ResourceDeleteRequest(getResponse.getResource(), timestamp.getTime(), true));
    }

    protected int createResource(Resource toCreate) throws OXException, JSONException, IOException, SAXException {
        int id = Executor.execute(this.getSession(), new ResourceNewRequest(toCreate, true)).getID();
        return id;
    }
}

