/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.oauth.provider.protocol;

import com.openexchange.java.Charsets;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.junit.Assert;

abstract class AbstractResponse {
    protected final Map<String, String> headers = new HashMap<String, String>();
    protected final int statusCode;
    protected final byte[] body;

    protected AbstractResponse(HttpResponse response) throws IOException {
        this.statusCode = response.getStatusLine().getStatusCode();
        HeaderIterator hit = response.headerIterator();
        while (hit.hasNext()) {
            Header header = hit.nextHeader();
            this.headers.put(header.getName().toLowerCase(), header.getValue());
        }
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            this.body = null;
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            entity.writeTo((OutputStream)baos);
            this.body = baos.toByteArray();
        }
    }

    public void assertStatus(int statusCode) {
        Assert.assertEquals((String)"Unexpected status code", (long)statusCode, (long)this.statusCode);
    }

    public void assertOK() {
        this.assertStatus(200);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getHeader(String name) {
        return this.headers.get(name.toLowerCase());
    }

    public boolean containsHeader(String name) {
        return this.headers.containsKey(name.toLowerCase());
    }

    public byte[] getBody() {
        return this.body;
    }

    public String getBodyAsString() {
        return new String(this.body, Charsets.UTF_8);
    }
}

