/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.oauth.provider;

import com.openexchange.ajax.oauth.provider.EndpointTest;
import com.openexchange.ajax.oauth.provider.OAuthClient;
import com.openexchange.ajax.oauth.provider.OAuthSession;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class RevokeTokensTest
extends EndpointTest {
    @Test
    public void testRevokeAccessToken() throws Exception {
        OAuthClient oauthClient = new OAuthClient(this.getClientId(), this.getClientSecret(), this.getRedirectURI(), this.getScope());
        oauthClient.assertAccess();
        HttpGet revoke = new HttpGet(new URIBuilder().setScheme("https").setHost(hostname).setPath("/ajax/oauth/provider/revoke").setParameter("access_token", ((OAuthSession)oauthClient.getSession()).getAccessToken()).build());
        HttpResponse revokeResponse = this.client.execute((HttpUriRequest)revoke);
        revoke.reset();
        Assert.assertEquals((long)200L, (long)revokeResponse.getStatusLine().getStatusCode());
        RevokeTokensTest.assertNoAccess(oauthClient);
    }

    @Test
    public void testRevokeRefreshToken() throws Exception {
        OAuthClient oauthClient = new OAuthClient(this.getClientId(), this.getClientSecret(), this.getRedirectURI(), this.getScope());
        oauthClient.assertAccess();
        HttpGet revoke = new HttpGet(new URIBuilder().setScheme("https").setHost(hostname).setPath("/ajax/oauth/provider/revoke").setParameter("refresh_token", ((OAuthSession)oauthClient.getSession()).getRefreshToken()).build());
        HttpResponse revokeResponse = this.client.execute((HttpUriRequest)revoke);
        Assert.assertEquals((long)200L, (long)revokeResponse.getStatusLine().getStatusCode());
        RevokeTokensTest.assertNoAccess(oauthClient);
    }

    @Test
    public void testFailWithInvalidTokens() throws Exception {
        HttpGet revoke = new HttpGet(new URIBuilder().setScheme("https").setHost(hostname).setPath("/ajax/oauth/provider/revoke").build());
        HttpResponse revokeResponse = this.client.execute((HttpUriRequest)revoke);
        Assert.assertEquals((long)400L, (long)revokeResponse.getStatusLine().getStatusCode());
        JSONObject errorObject = JSONObject.parse((Reader)new InputStreamReader(revokeResponse.getEntity().getContent(), revokeResponse.getEntity().getContentEncoding() == null ? "UTF-8" : revokeResponse.getEntity().getContentEncoding().getValue())).toObject();
        Assert.assertEquals((Object)"invalid_request", (Object)errorObject.getString("error"));
        revoke = new HttpGet(new URIBuilder().setScheme("https").setHost(hostname).setPath("/ajax/oauth/provider/revoke").setParameter("access_token", "invalid").build());
        revokeResponse = this.client.execute((HttpUriRequest)revoke);
        Assert.assertEquals((long)400L, (long)revokeResponse.getStatusLine().getStatusCode());
        errorObject = JSONObject.parse((Reader)new InputStreamReader(revokeResponse.getEntity().getContent(), revokeResponse.getEntity().getContentEncoding() == null ? "UTF-8" : revokeResponse.getEntity().getContentEncoding().getValue())).toObject();
        Assert.assertEquals((Object)"invalid_request", (Object)errorObject.getString("error"));
        revoke = new HttpGet(new URIBuilder().setScheme("https").setHost(hostname).setPath("/ajax/oauth/provider/revoke").setParameter("refresh_token", "invalid").build());
        revokeResponse = this.client.execute((HttpUriRequest)revoke);
        Assert.assertEquals((long)400L, (long)revokeResponse.getStatusLine().getStatusCode());
        errorObject = JSONObject.parse((Reader)new InputStreamReader(revokeResponse.getEntity().getContent(), revokeResponse.getEntity().getContentEncoding() == null ? "UTF-8" : revokeResponse.getEntity().getContentEncoding().getValue())).toObject();
        Assert.assertEquals((Object)"invalid_request", (Object)errorObject.getString("error"));
    }
}

