/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.oauth.provider;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.message.BasicRequestLine;

public class RedirectEndpoint
extends Thread {
    private static final Pattern REQUEST_LINE = Pattern.compile("^([A-Z]+)\\s([^\\s]+)\\sHTTP/([0-9])\\.([0-9])$");
    private final Queue<HttpRequest> requests = new LinkedList<HttpRequest>();
    private volatile boolean started;
    private ServerSocket ss;

    private RedirectEndpoint() {
    }

    public static RedirectEndpoint create() {
        RedirectEndpoint endpoint = new RedirectEndpoint();
        endpoint.start();
        return endpoint;
    }

    public void shutdown() throws IOException, InterruptedException {
        this.started = false;
        this.ss.close();
        this.join();
    }

    public HttpRequest pollRequest() {
        return this.requests.poll();
    }

    public String getLocation() {
        return "http://localhost:8080";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.started = true;
        try {
            this.ss = new ServerSocket(8080);
            System.out.println("Server up and running...");
            while (this.started && !this.isInterrupted()) {
                BasicHttpRequest request;
                Socket client = this.ss.accept();
                InputStream inputStream = client.getInputStream();
                OutputStream outputStream = client.getOutputStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "ASCII"));
                String line = br.readLine();
                if (line == null) {
                    this.sendBadRequest(outputStream);
                    continue;
                }
                Matcher rlMatcher = REQUEST_LINE.matcher(line);
                if (!rlMatcher.matches()) {
                    this.sendBadRequest(outputStream);
                    continue;
                }
                BasicRequestLine requestLine = new BasicRequestLine(rlMatcher.group(1), rlMatcher.group(2), new ProtocolVersion("HTTP", Integer.parseInt(rlMatcher.group(3)), Integer.parseInt(rlMatcher.group(4))));
                HashMap<String, String> headers = new HashMap<String, String>();
                String contentTypeHeader = null;
                while (!"".equals(line)) {
                    int delimIdx = line.indexOf(58);
                    if (delimIdx > 0 && line.length() > delimIdx) {
                        String headerName = line.substring(0, delimIdx).trim();
                        String headerValue = line.substring(delimIdx + 1).trim();
                        headers.put(headerName, headerValue);
                        if (headerName.equalsIgnoreCase("Content-Type")) {
                            contentTypeHeader = headerValue;
                        }
                    }
                    line = br.readLine();
                }
                byte[] contentBytes = IOUtils.toByteArray((InputStream)inputStream);
                if (contentBytes.length > 0) {
                    ContentType contentType = contentTypeHeader == null ? ContentType.APPLICATION_OCTET_STREAM : ContentType.parse(contentTypeHeader);
                    BasicHttpEntityEnclosingRequest entityRequest = new BasicHttpEntityEnclosingRequest((RequestLine)requestLine);
                    entityRequest.setEntity((HttpEntity)new ByteArrayEntity(contentBytes, contentType));
                    request = entityRequest;
                } else {
                    request = new BasicHttpRequest((RequestLine)requestLine);
                }
                for (Map.Entry header : headers.entrySet()) {
                    request.addHeader((String)header.getKey(), (String)header.getValue());
                }
                this.requests.add((HttpRequest)request);
                this.sendOK(outputStream);
                client.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            System.out.println("Shutting down server...");
            try {
                this.ss.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void sendBadRequest(OutputStream outputStream) throws UnsupportedEncodingException {
        this.sendEmptyReponse("HTTP/1.1 400 Bad Request", outputStream);
    }

    private void sendOK(OutputStream outputStream) throws UnsupportedEncodingException {
        this.sendEmptyReponse("HTTP/1.1 200 OK", outputStream);
    }

    private void sendEmptyReponse(String statusLine, OutputStream outputStream) throws UnsupportedEncodingException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        PrintWriter headers = new PrintWriter(new OutputStreamWriter(outputStream, "ASCII"));
        headers.print(statusLine);
        headers.print("\r\n");
        headers.print("Date: " + dateFormat.format(new Date()));
        headers.print("\r\n");
        headers.print("Server: localhost");
        headers.print("\r\n");
        headers.print("Content-Length: 0");
        headers.print("\r\n");
        headers.print("\r\n");
        headers.flush();
    }
}

