/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail.filter;

import com.openexchange.admin.rmi.OXContextInterface;
import com.openexchange.admin.rmi.OXUserInterface;
import com.openexchange.admin.rmi.dataobjects.Context;
import com.openexchange.admin.rmi.dataobjects.Credentials;
import com.openexchange.admin.rmi.dataobjects.User;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.mail.filter.AbstractMailFilterTest;
import com.openexchange.ajax.mail.filter.Rule;
import com.openexchange.ajax.mail.filter.action.AbstractAction;
import com.openexchange.ajax.mail.filter.action.Keep;
import com.openexchange.ajax.mail.filter.comparison.IsComparison;
import com.openexchange.ajax.mail.filter.test.HeaderTest;
import com.openexchange.ajax.mailaccount.actions.MailAccountGetRequest;
import com.openexchange.ajax.mailaccount.actions.MailAccountGetResponse;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.mailaccount.MailAccountDescription;
import java.rmi.Naming;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class AdminListTest
extends AbstractMailFilterTest {
    private AJAXClient userClient;
    private AJAXSession userSession;
    private AJAXClient adminClient;
    private AJAXSession adminSession;
    private Rule rule;
    private String rid = null;

    public AdminListTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.adminClient = new AJAXClient(AJAXClient.User.OXAdmin);
        Context ctx = new Context(Integer.valueOf(this.adminClient.getValues().getContextId()));
        ctx.setUserAttribute("config", "com.openexchange.mail.adminMailLoginEnabled", "true");
        Credentials credentials = new Credentials(AJAXConfig.getProperty(AJAXConfig.Property.OX_ADMIN_MASTER), AJAXConfig.getProperty(AJAXConfig.Property.OX_ADMIN_MASTER_PWD));
        OXContextInterface ctxInterface = (OXContextInterface)Naming.lookup("rmi://" + AJAXConfig.getProperty(AJAXConfig.Property.RMI_HOST) + ":1099/" + "OXContext_V2");
        ctxInterface.change(ctx, credentials);
        User user = new User(this.adminClient.getValues().getUserId());
        HashSet<String> cap = new HashSet<String>(1);
        cap.add("webmail");
        Credentials userCreds = new Credentials(AJAXConfig.getProperty(AJAXClient.User.OXAdmin.getLogin()), AJAXConfig.getProperty(AJAXClient.User.OXAdmin.getPassword()));
        OXUserInterface usrInterface = (OXUserInterface)Naming.lookup("rmi://" + AJAXConfig.getProperty(AJAXConfig.Property.RMI_HOST) + ":1099/" + "OXUser_V2");
        Set emptySet = Collections.emptySet();
        usrInterface.changeCapabilities(new Context(Integer.valueOf(this.adminClient.getValues().getContextId())), user, cap, emptySet, emptySet, userCreds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown() throws Exception {
        try {
            Context ctx = new Context(Integer.valueOf(this.adminClient.getValues().getContextId()));
            ctx.setUserAttribute("config", "com.openexchange.mail.adminMailLoginEnabled", "false");
            Credentials credentials = new Credentials(AJAXConfig.getProperty(AJAXConfig.Property.OX_ADMIN_MASTER), AJAXConfig.getProperty(AJAXConfig.Property.OX_ADMIN_MASTER_PWD));
            OXContextInterface iface = (OXContextInterface)Naming.lookup("rmi://" + AJAXConfig.getProperty(AJAXConfig.Property.RMI_HOST) + ":1099/" + "OXContext_V2");
            iface.change(ctx, credentials);
            User user = new User(this.adminClient.getValues().getUserId());
            HashSet<String> cap = new HashSet<String>(1);
            cap.add("webmail");
            Credentials userCreds = new Credentials(AJAXConfig.getProperty(AJAXClient.User.OXAdmin.getLogin()), AJAXConfig.getProperty(AJAXClient.User.OXAdmin.getPassword()));
            OXUserInterface usrInterface = (OXUserInterface)Naming.lookup("rmi://" + AJAXConfig.getProperty(AJAXConfig.Property.RMI_HOST) + ":1099/" + "OXUser_V2");
            Set emptySet = Collections.emptySet();
            usrInterface.changeCapabilities(new Context(Integer.valueOf(this.adminClient.getValues().getContextId())), user, emptySet, cap, emptySet, userCreds);
            if (this.rid != null) {
                AdminListTest.deleteRule(this.rid, null, this.userClient.getSession());
            }
            this.adminClient.logout();
            this.adminClient = null;
        }
        finally {
            super.tearDown();
        }
    }

    public void testUserHasAccessToOtherUsersRules() throws Exception {
        this.userClient = this.getClient();
        this.userSession = this.userClient.getSession();
        this.adminSession = this.adminClient.getSession();
        this.rule = new Rule();
        this.rule.setName("testUserHasAccessToOtherUsersRules");
        this.rule.setActioncmds(new AbstractAction[]{new Keep()});
        IsComparison isComp = new IsComparison();
        this.rule.setTest(new HeaderTest(isComp, new String[]{"testheader"}, new String[]{"testvalue"}));
        this.rid = AdminListTest.insertRule(this.rule, null, this.userSession);
        Rule[] userRules = AdminListTest.listRules(this.userSession);
        MailAccountGetRequest getMailAcc = new MailAccountGetRequest(0, false);
        MailAccountGetResponse response = this.userClient.execute(getMailAcc);
        MailAccountDescription description = response.getAsDescription();
        String userImapLogin = description.getLogin();
        Rule[] adminRules = AdminListTest.listRulesForUser(this.adminSession, userImapLogin);
        for (Rule ur : userRules) {
            boolean foundRule = false;
            for (Rule ar : adminRules) {
                if (!ar.getId().equals(ur.getId())) continue;
                foundRule = true;
                break;
            }
            AdminListTest.assertTrue((String)"Did not find rule.", (boolean)foundRule);
        }
    }
}

