/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.UserValues;
import com.openexchange.ajax.mail.MailFlag;
import com.openexchange.ajax.mail.TestMails;
import com.openexchange.ajax.mail.actions.DeleteRequest;
import com.openexchange.ajax.mail.actions.GetRequest;
import com.openexchange.ajax.mail.actions.GetResponse;
import com.openexchange.ajax.mail.actions.ImportMailRequest;
import com.openexchange.ajax.mail.actions.ImportMailResponse;
import com.openexchange.ajax.mail.actions.MoveMailRequest;
import com.openexchange.ajax.mail.actions.UpdateMailResponse;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import java.io.ByteArrayInputStream;
import java.util.Date;
import java.util.TimeZone;

public class Bug15777Test
extends AbstractAJAXSession {
    private AJAXClient client;
    private String folder;
    private String address;
    private String[][] ids;
    private UserValues values;
    FolderObject subFolder;

    public Bug15777Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.values = this.client.getValues();
        this.folder = this.values.getInboxFolder();
        this.address = this.values.getSendAddress();
        String testmail = TestMails.replaceAddresses("From: #ADDR#\nTo: #ADDR#\nSubject: Test for bug 15901\nMime-Version: 1.0\nContent-Type: text/html; charset=\"UTF-8\"\nContent-Transfer-Encoding: 8bit\n\nSome plain text... <br> blah <a href=\"www.xyz.de\">blubb</a><dl><dt>AA</dt><dd>Auto Answer (Modem)</dd><dt>AAE</dt><dd>Allgemeine Anschalte-Erlaubnis</dd><dt>AARP</dt><dd>Appletalk Address Resolution Protocol</dd></dl>", this.address);
        byte[] buf = testmail.getBytes();
        ByteArrayInputStream mail = new ByteArrayInputStream(buf);
        ImportMailRequest request = new ImportMailRequest(this.folder, 33, mail);
        ImportMailResponse response = this.client.execute(request);
        this.ids = response.getIds();
    }

    public void testFlagsAfterMove() throws Exception {
        this.subFolder = Create.createPrivateFolder("bug15777movefolder", 7, this.values.getUserId(), new OCLPermission[0]);
        this.subFolder.setFullName(this.folder + "/bug15777movefolder");
        InsertRequest subFolderReq = new InsertRequest((API)EnumAPI.OX_NEW, this.subFolder, false);
        this.client.execute(subFolderReq);
        this.subFolder.setLastModified(new Date(0L));
        MoveMailRequest moveMailReq = new MoveMailRequest(this.folder, this.subFolder.getFullName(), this.ids[0][1]);
        UpdateMailResponse moveMailResp = this.client.execute(moveMailReq);
        GetRequest getMovedMailReq = new GetRequest(this.subFolder.getFullName(), moveMailResp.getID());
        GetResponse getMovedMailResp = this.client.execute(getMovedMailReq);
        Bug15777Test.assertTrue((String)"Flag 'answered' is missing", (boolean)MailFlag.transform(getMovedMailResp.getMail(TimeZone.getDefault()).getFlags()).contains((Object)MailFlag.ANSWERED));
    }

    @Override
    protected void tearDown() throws Exception {
        DeleteRequest del = new DeleteRequest(this.ids);
        this.client.execute(del);
        com.openexchange.ajax.folder.actions.DeleteRequest fDel = new com.openexchange.ajax.folder.actions.DeleteRequest((API)EnumAPI.OX_NEW, this.subFolder);
        this.client.execute(fDel);
        super.tearDown();
    }
}

