/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.kata.folders;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.FolderUpdatesResponse;
import com.openexchange.ajax.folder.actions.ListRequest;
import com.openexchange.ajax.folder.actions.ListResponse;
import com.openexchange.ajax.folder.actions.UpdatesRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.kata.NeedExistingStep;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.search.Order;
import com.openexchange.test.FolderTestManager;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.json.JSONException;
import org.junit.Assert;
import org.xml.sax.SAXException;

public class FolderVerificationStep
extends NeedExistingStep<FolderObject> {
    private final FolderObject entry;
    private FolderTestManager manager;

    public FolderVerificationStep(FolderObject entry, String name) {
        super(name, null);
        this.entry = entry;
    }

    @Override
    public void perform(AJAXClient myClient) throws Exception {
        this.client = myClient;
        this.manager = new FolderTestManager(myClient);
        this.assumeIdentity(this.entry);
        this.checkWithReadMethods(this.entry);
    }

    private void checkWithReadMethods(FolderObject folder) throws JSONException, OXException, IOException, SAXException {
        this.checkViaGet(folder);
        this.checkViaList(folder);
        this.checkViaUpdates(folder);
    }

    private void checkViaGet(FolderObject folder) {
        FolderObject loaded = this.manager.getFolderFromServer(folder);
        this.compare(folder, loaded);
    }

    private void checkViaList(FolderObject folder) throws OXException, IOException, SAXException, JSONException {
        int[] requestedFields = FolderObject.ALL_COLUMNS;
        ListRequest listRequest = new ListRequest((API)EnumAPI.OX_OLD, Integer.toString(folder.getParentFolderID()), requestedFields, true);
        ListResponse response = this.client.execute(listRequest);
        Object[][] rows = response.getArray();
        this.checkInList(folder, rows, requestedFields, "list-");
    }

    private void checkViaUpdates(FolderObject folder) throws OXException, IOException, SAXException, JSONException {
        UpdatesRequest updates = new UpdatesRequest(EnumAPI.OX_OLD, FolderObject.ALL_COLUMNS, -1, Order.ASCENDING, new Date(0L));
        FolderUpdatesResponse response = this.client.execute(updates);
        List<FolderObject> folders = response.getFolders();
        this.checkInList(folder, folders);
    }

    private void checkInList(FolderObject folder, Object[][] rows, int[] columns, String typeOfAction) {
        int idPos = this.findIDIndex(columns);
        for (int i = 0; i < rows.length; ++i) {
            Object[] row = rows[i];
            int id = (Integer)row[idPos];
            if (id != folder.getObjectID()) continue;
            this.compare(folder, row, columns);
            return;
        }
        Assert.fail((String)("Object not found in " + typeOfAction + "response. " + this.name));
    }

    private void compare(FolderObject folder, FolderObject loaded) {
        int[] columns = FolderObject.ALL_COLUMNS;
        for (int i = 0; i < columns.length; ++i) {
            int col = columns[i];
            if (col == 6 || col == 5 || this.isIgnoredColumn(col) || !folder.contains(col)) continue;
            Assert.assertEquals((String)(this.name + ": Column " + col + " differs!"), (Object)folder.get(col), (Object)loaded.get(col));
        }
    }

    private boolean isIgnoredColumn(int col) {
        return col == 305 || col == 306 || col == 307 || col == 308 || col == 309 || col == 310 || col == 311 || col == 312 || col == 313 || col == 314 || col == 315;
    }

    private void compare(FolderObject folder, Object[] row, int[] columns) {
        Assert.assertEquals((String)"Result should contain same number of elements as the request", (Object)row.length, (Object)columns.length);
        for (int i = 0; i < columns.length; ++i) {
            int column = columns[i];
            if (column == 6 || column == 5 || this.isIgnoredColumn(column) || !folder.contains(column)) continue;
            Object expected = folder.get(column);
            Object actual = row[i];
            actual = this.transform(actual);
            Assert.assertEquals((String)(this.name + " Column: " + column), (Object)expected, (Object)actual);
        }
    }

    private int findIDIndex(int[] columns) {
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i] != 1) continue;
            return i;
        }
        Assert.fail((String)("No ID column requested. This won't work. " + this.name));
        return -1;
    }

    private void checkInList(FolderObject folder, List<FolderObject> folders) {
        for (FolderObject folderFromList : folders) {
            if (folderFromList.getObjectID() != folder.getObjectID()) continue;
            this.compare(folder, folderFromList);
            return;
        }
        Assert.fail((String)("Object not found in response: (" + folder.getObjectID() + ") " + this.name));
    }

    private Object transform(Object actual) {
        return actual;
    }

    @Override
    public void cleanUp() throws Exception {
    }
}

