/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.group;

import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.group.actions.AbstractGroupResponse;
import com.openexchange.ajax.group.actions.AllRequest;
import com.openexchange.ajax.group.actions.AllResponse;
import com.openexchange.ajax.group.actions.CreateRequest;
import com.openexchange.ajax.group.actions.CreateResponse;
import com.openexchange.ajax.group.actions.DeleteRequest;
import com.openexchange.ajax.group.actions.DeleteResponse;
import com.openexchange.ajax.group.actions.GetRequest;
import com.openexchange.ajax.group.actions.GetResponse;
import com.openexchange.ajax.group.actions.ListRequest;
import com.openexchange.ajax.group.actions.SearchRequest;
import com.openexchange.ajax.group.actions.SearchResponse;
import com.openexchange.ajax.group.actions.UpdatesRequest;
import com.openexchange.ajax.group.actions.UpdatesResponse;
import com.openexchange.group.Group;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FunctionTest
extends AbstractAJAXSession {
    private static final Logger LOG = LoggerFactory.getLogger(FunctionTest.class);
    private Set<Integer> groupsToDelete;

    public FunctionTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.groupsToDelete = new HashSet<Integer>();
    }

    @Override
    protected void tearDown() throws Exception {
        for (int id : this.groupsToDelete) {
            this.getClient().execute(new DeleteRequest(id, new Date(Long.MAX_VALUE), false));
        }
        super.tearDown();
    }

    public void testSearch() throws Throwable {
        SearchResponse response = this.getClient().execute(new SearchRequest("*"));
        Group[] groups = response.getGroups();
        LOG.trace("Found " + groups.length + " groups.");
        FunctionTest.assertTrue((String)"Size of group array should be more than 0.", (groups.length > 0 ? 1 : 0) != 0);
        JSONArray arr = (JSONArray)response.getResponse().getData();
        this.assertContainsLastModifiedUTC(arr);
    }

    public void testRealSearch() throws Throwable {
        Group[] groups = this.getClient().execute(new SearchRequest("*l*")).getGroups();
        LOG.trace("Found " + groups.length + " groups.");
        FunctionTest.assertNotNull((Object)groups);
    }

    public void testList() throws Throwable {
        Group[] groups = this.getClient().execute(new SearchRequest("*")).getGroups();
        LOG.trace("Found " + groups.length + " groups.");
        FunctionTest.assertTrue((String)"Size of group array should be more than 0.", (groups.length > 0 ? 1 : 0) != 0);
        int[] groupIds = new int[groups.length];
        for (int i = 0; i < groupIds.length; ++i) {
            groupIds[i] = groups[i].getIdentifier();
        }
        AbstractGroupResponse listResponse = this.getClient().execute(new ListRequest(groupIds));
        groups = listResponse.getGroups();
        LOG.trace("Listed " + groups.length + " groups.");
        FunctionTest.assertTrue((String)"Size of group array should be more than 0.", (groups.length > 0 ? 1 : 0) != 0);
        FunctionTest.assertEquals((String)"Size of requested groups and listed groups should be equal.", (int)groupIds.length, (int)groups.length);
        JSONArray arr = (JSONArray)listResponse.getResponse().getData();
        this.assertContainsLastModifiedUTC(arr);
    }

    public void testAllWithMembers() throws Throwable {
        int groupLengthBySearch = this.getClient().execute(new SearchRequest("*")).getGroups().length;
        AllRequest allRequest = new AllRequest(Group.ALL_COLUMNS, true);
        AllResponse allResponse = this.getClient().execute(allRequest);
        JSONArray data = (JSONArray)allResponse.getData();
        int groupLengthByAll = data.length();
        FunctionTest.assertEquals((int)groupLengthBySearch, (int)groupLengthByAll);
        int memberPos = 4;
        int memberCount = 0;
        for (int i = 0; i < data.length(); ++i) {
            JSONArray row = data.getJSONArray(i);
            String[] members = row.getString(memberPos).split(",");
            memberCount += members.length;
        }
        FunctionTest.assertTrue((memberCount > 0 ? 1 : 0) != 0);
    }

    public void testAllWithoutMembers() throws Throwable {
        int groupLengthBySearch = this.getClient().execute(new SearchRequest("*")).getGroups().length;
        AllResponse allResponse = this.getClient().execute(new AllRequest(Group.ALL_COLUMNS_EXCEPT_MEMBERS, true));
        JSONArray data = (JSONArray)allResponse.getData();
        int groupLengthByAll = data.length();
        FunctionTest.assertEquals((int)groupLengthBySearch, (int)groupLengthByAll);
        int arrLen = Group.ALL_COLUMNS_EXCEPT_MEMBERS.length;
        for (int i = 0; i < data.length(); ++i) {
            JSONArray row = data.getJSONArray(i);
            FunctionTest.assertEquals((int)arrLen, (int)row.length());
        }
    }

    public void testUpdatesViaComparingWithSearch() throws Exception {
        Group[] groupsViaSearch = this.getClient().execute(new SearchRequest("*")).getGroups();
        UpdatesResponse response = this.getClient().execute(new UpdatesRequest(new Date(0L), false));
        List<Group> groupsViaUpdates = response.getModified();
        FunctionTest.assertEquals((String)"Should find the same amount of groups via *-search as via updates since day 0", (int)groupsViaSearch.length, (int)groupsViaUpdates.size());
    }

    public void testUpdatesViaCreateAndDelete() throws Exception {
        int staticGroupCount = 2;
        Group group = new Group();
        group.setSimpleName("simplename_" + new Date().getTime());
        group.setDisplayName("Group Updates Test" + new Date());
        CreateResponse createResponse = this.getClient().execute(new CreateRequest(group, true));
        int id = createResponse.getId();
        group.setIdentifier(id);
        this.groupsToDelete.add(id);
        group.setLastModified(createResponse.getTimestamp());
        Date lm = new Date(group.getLastModified().getTime() - 1L);
        UpdatesResponse updatesResponseAfterCreate = this.getClient().execute(new UpdatesRequest(lm, true));
        int numberNewAfterCreation = updatesResponseAfterCreate.getNew().size();
        int numberModifiedAfterCreation = updatesResponseAfterCreate.getModified().size();
        int numberDeletedAfterCreation = updatesResponseAfterCreate.getDeleted().size();
        FunctionTest.assertEquals((String)"Amount of modified elements should have increased after creation", (int)(1 + staticGroupCount), (int)numberModifiedAfterCreation);
        FunctionTest.assertEquals((String)"Amount of deleted elements should not change after creation", (int)(0 + staticGroupCount), (int)numberDeletedAfterCreation);
        FunctionTest.assertEquals((String)"Amount of new elements should equal modfied elements, since we cannot distinguish between the two", (int)numberNewAfterCreation, (int)numberModifiedAfterCreation);
        DeleteResponse deleteResponse = this.getClient().execute(new DeleteRequest(group, true));
        if (deleteResponse.hasError()) {
            this.groupsToDelete.remove(id);
        }
        UpdatesResponse updatesResponseAfterDeletion = this.getClient().execute(new UpdatesRequest(lm, true));
        int numberNewAfterDeletion = updatesResponseAfterDeletion.getNew().size();
        int numberModifiedAfterDeletion = updatesResponseAfterDeletion.getModified().size();
        int numberDeletedAfterDeletion = updatesResponseAfterDeletion.getDeleted().size();
        FunctionTest.assertEquals((String)"Amount of modified elements should have decreased after deletion", (int)(0 + staticGroupCount), (int)numberModifiedAfterDeletion);
        FunctionTest.assertEquals((String)"Amount of deleted elements should have increased after deletion", (int)(1 + staticGroupCount), (int)numberDeletedAfterDeletion);
        FunctionTest.assertEquals((String)"Amount of new elements should equal modfied elements, since we cannot distinguish between the two", (int)numberNewAfterDeletion, (int)numberModifiedAfterDeletion);
    }

    public void assertContainsLastModifiedUTC(JSONArray arr) {
        int size = arr.length();
        for (int i = 0; i < size; ++i) {
            JSONObject entry = arr.optJSONObject(i);
            FunctionTest.assertNotNull((Object)entry);
            FunctionTest.assertTrue((boolean)entry.has("last_modified_utc"));
        }
    }

    public void testGet() throws Throwable {
        Group[] groups = this.getClient().execute(new SearchRequest("*")).getGroups();
        LOG.trace("Found " + groups.length + " groups.");
        FunctionTest.assertTrue((String)"Size of group array should be more than 0.", (groups.length > 0 ? 1 : 0) != 0);
        int pos = new Random(System.currentTimeMillis()).nextInt(groups.length);
        GetResponse response = this.getClient().execute(new GetRequest(groups[pos].getIdentifier()));
        Group group = response.getGroup();
        LOG.trace("Loaded group: " + group.toString());
        JSONObject entry = (JSONObject)response.getData();
        FunctionTest.assertTrue((boolean)entry.has("last_modified_utc"));
    }

    public void testCreateChangeDelete() throws Throwable {
    }
}

