/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder.actions;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.AbstractFolderRequest;
import com.openexchange.ajax.folder.actions.InsertParser;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.share.notification.ShareNotificationService;
import java.util.List;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class InsertRequest
extends AbstractFolderRequest<InsertResponse> {
    private final FolderObject folder;
    boolean failOnError;
    private ShareNotificationService.Transport notificationTransport;
    private String notificationMessage;

    public InsertRequest(API api, FolderObject folder) {
        this(api, folder, true);
    }

    public InsertRequest(API api, FolderObject folder, boolean failOnError) {
        super(api);
        this.failOnError = failOnError;
        this.folder = folder;
    }

    public InsertRequest(API api, FolderObject folder, TimeZone timeZone) {
        this(api, folder, timeZone, true);
    }

    public InsertRequest(API api, FolderObject folder, TimeZone timeZone, boolean failOnError) {
        super(api, timeZone);
        this.failOnError = failOnError;
        this.folder = folder;
    }

    public void setNotifyPermissionEntities(ShareNotificationService.Transport transport) {
        this.setNotifyPermissionEntities(transport, null);
    }

    public void setNotifyPermissionEntities(ShareNotificationService.Transport transport, String message) {
        this.notificationTransport = transport;
        this.notificationMessage = message;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    @Override
    public Object getBody() throws JSONException {
        if (this.notificationTransport != null) {
            JSONObject data = new JSONObject();
            data.put("folder", (Object)this.convert(this.folder));
            JSONObject jNotification = new JSONObject();
            jNotification.put("transport", (Object)this.notificationTransport.getID());
            jNotification.put("message", (Object)this.notificationMessage);
            data.put("notification", (Object)jNotification);
            return data;
        }
        return this.convert(this.folder);
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    protected void addParameters(List<AJAXRequest.Parameter> params) {
        params.add(new AJAXRequest.Parameter("action", "new"));
        if (this.folder.containsModule() && this.folder.getFullName() != null && this.folder.getModule() == 7) {
            String[] parts = this.folder.getFullName().split("/");
            StringBuilder parentBuilder = new StringBuilder();
            for (int i = 0; i < parts.length - 1; ++i) {
                parentBuilder.append(parts[i]);
                parentBuilder.append('/');
            }
            String parent = parentBuilder.substring(0, parentBuilder.length() - 1);
            params.add(new AJAXRequest.Parameter("folder_id", parent));
        } else {
            params.add(new AJAXRequest.Parameter("folder_id", this.folder.getParentFolderID()));
        }
    }

    public InsertParser getParser() {
        return new InsertParser(this.failOnError);
    }
}

