/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder.actions;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.AllowedModules;
import com.openexchange.ajax.folder.actions.OCLGuestPermission;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.framework.Header;
import com.openexchange.ajax.tools.JSONCoercion;
import com.openexchange.folder.json.FolderField;
import com.openexchange.folderstorage.Permissions;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.java.Strings;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.share.recipient.AnonymousRecipient;
import com.openexchange.share.recipient.GuestRecipient;
import com.openexchange.share.recipient.ShareRecipient;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;

public abstract class AbstractFolderRequest<T extends AbstractAJAXResponse>
implements AJAXRequest<T> {
    private final API api;
    private AllowedModules[] allowedModules;
    private final TimeZone timeZone;

    protected AbstractFolderRequest(API api) {
        this(api, null);
    }

    protected AbstractFolderRequest(API api, TimeZone timeZone) {
        this.api = api;
        this.timeZone = timeZone;
    }

    @Override
    public String getServletPath() {
        return this.api.getUrl();
    }

    @Override
    public Header[] getHeaders() {
        return NO_HEADER;
    }

    protected JSONObject convert(FolderObject folder) throws JSONException {
        JSONObject jsonFolder;
        block12: {
            jsonFolder = new JSONObject();
            if (folder.containsFolderName()) {
                jsonFolder.put("title", (Object)folder.getFolderName());
            }
            if (!folder.containsPermissions()) break block12;
            JSONArray jsonPerms = new JSONArray();
            for (OCLPermission perm : folder.getPermissions()) {
                JSONObject jsonPermission;
                block14: {
                    block13: {
                        jsonPermission = new JSONObject();
                        if (!OCLGuestPermission.class.isInstance(perm)) break block13;
                        OCLGuestPermission guestPerm = (OCLGuestPermission)perm;
                        ShareRecipient recipient = guestPerm.getRecipient();
                        jsonPermission.put("type", (Object)recipient.getType());
                        switch (recipient.getType()) {
                            case ANONYMOUS: {
                                AnonymousRecipient anonymousRecipient = (AnonymousRecipient)recipient;
                                jsonPermission.putOpt(FolderField.PASSWORD.getName(), (Object)anonymousRecipient.getPassword());
                                if (null != anonymousRecipient.getExpiryDate()) {
                                    long date = anonymousRecipient.getExpiryDate().getTime();
                                    if (null != this.timeZone) {
                                        date += (long)this.timeZone.getOffset(date);
                                    }
                                    jsonPermission.put(FolderField.EXPIRY_DATE.getName(), date);
                                    break;
                                }
                                break block14;
                            }
                            case GUEST: {
                                GuestRecipient guestRecipient = (GuestRecipient)recipient;
                                jsonPermission.putOpt(FolderField.EMAIL_ADDRESS.getName(), (Object)guestRecipient.getEmailAddress());
                                jsonPermission.putOpt(FolderField.PASSWORD.getName(), (Object)guestRecipient.getPassword());
                                jsonPermission.putOpt(FolderField.DISPLAY_NAME.getName(), (Object)guestRecipient.getDisplayName());
                                jsonPermission.putOpt(FolderField.CONTACT_FOLDER_ID.getName(), (Object)guestRecipient.getContactFolder());
                                jsonPermission.putOpt(FolderField.CONTACT_ID.getName(), (Object)guestRecipient.getContactID());
                                break;
                            }
                            default: {
                                Assert.fail((String)("Unsupported recipient: " + recipient.getType()));
                                break;
                            }
                        }
                        break block14;
                    }
                    jsonPermission.put("entity", perm.getEntity());
                    jsonPermission.put("group", perm.isGroupPermission());
                }
                jsonPermission.put("bits", Permissions.createPermissionBits((int)perm.getFolderPermission(), (int)perm.getReadPermission(), (int)perm.getWritePermission(), (int)perm.getDeletePermission(), (boolean)perm.isFolderAdmin()));
                jsonPerms.put((Object)jsonPermission);
            }
            jsonFolder.put("permissions", (Object)jsonPerms);
        }
        if (folder.containsModule()) {
            jsonFolder.put("module", (Object)this.convertModule(folder.getModule()));
        }
        if (folder.containsType()) {
            jsonFolder.put("type", folder.getType());
        }
        if (folder.containsParentFolderID()) {
            jsonFolder.put("folder_id", folder.getParentFolderID());
        }
        if (folder.containsMeta()) {
            jsonFolder.put("meta", JSONCoercion.coerceToJSON((Object)folder.getMeta()));
        }
        return jsonFolder;
    }

    private String convertModule(int module) {
        String retval;
        switch (module) {
            case 1: {
                retval = "tasks";
                break;
            }
            case 2: {
                retval = "calendar";
                break;
            }
            case 3: {
                retval = "contacts";
                break;
            }
            case 7: {
                retval = "mail";
                break;
            }
            case 8: {
                retval = "infostore";
                break;
            }
            default: {
                retval = "";
            }
        }
        return retval;
    }

    public void setAllowedModules(AllowedModules ... allowedModules) {
        this.allowedModules = allowedModules;
    }

    @Override
    public final AJAXRequest.Parameter[] getParameters() {
        ArrayList<AJAXRequest.Parameter> params = new ArrayList<AJAXRequest.Parameter>();
        this.addParameters(params);
        if (this.api.getTreeId() != -1) {
            params.add(new AJAXRequest.Parameter("tree", this.api.getTreeId()));
        }
        if (null != this.allowedModules) {
            Object[] tmp = new String[this.allowedModules.length];
            for (int i = 0; i < this.allowedModules.length; ++i) {
                tmp[i] = this.allowedModules[i].getJSONValue();
            }
            params.add(new AJAXRequest.Parameter("allowed_modules", Strings.join((Object[])tmp, (String)",")));
        }
        return params.toArray(new AJAXRequest.Parameter[params.size()]);
    }

    protected abstract void addParameters(List<AJAXRequest.Parameter> var1);

    protected static String[] i2s(int[] intArr) {
        String[] strArr = new String[intArr.length];
        for (int i = 0; i < intArr.length; ++i) {
            strArr[i] = Integer.valueOf(intArr[i]).toString();
        }
        return strArr;
    }
}

