/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.find.tasks;

import com.openexchange.ajax.find.PropDocument;
import com.openexchange.ajax.find.actions.AutocompleteRequest;
import com.openexchange.ajax.find.actions.AutocompleteResponse;
import com.openexchange.ajax.find.actions.QueryRequest;
import com.openexchange.ajax.find.actions.QueryResponse;
import com.openexchange.ajax.find.tasks.AbstractFindTasksTest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.exception.OXException;
import com.openexchange.find.Document;
import com.openexchange.find.Module;
import com.openexchange.find.SearchResult;
import com.openexchange.find.common.CommonFacetType;
import com.openexchange.find.common.FolderType;
import com.openexchange.find.facet.ActiveFacet;
import com.openexchange.find.facet.DefaultFacet;
import com.openexchange.find.facet.ExclusiveFacet;
import com.openexchange.find.facet.Facet;
import com.openexchange.find.facet.FacetType;
import com.openexchange.find.facet.FacetValue;
import com.openexchange.find.facet.Filter;
import com.openexchange.find.facet.SimpleFacet;
import com.openexchange.find.tasks.TasksFacetType;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.test.TaskTestManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.junit.Test;

public class FindTasksQueryTests
extends AbstractFindTasksTest {
    public FindTasksQueryTests(String name) {
        super(name);
    }

    @Test
    public void testWithSimpleQuery() throws OXException, IOException, JSONException {
        this.assertResults(30, Collections.emptyList(), -1, 30);
    }

    @Test
    public void testPagination() throws OXException, IOException, JSONException {
        this.assertResults(5, Collections.emptyList(), 5, 10);
    }

    @Test
    public void testQueryAttachmentName() throws OXException, IOException, JSONException {
        ArrayList<ActiveFacet> facets = new ArrayList<ActiveFacet>();
        facets.add(new ActiveFacet((FacetType)TasksFacetType.TASK_ATTACHMENT_NAME, "attachment", new Filter(Collections.singletonList("attachment"), "cool")));
        this.assertResults(5, facets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTokenizedQuery() throws Exception {
        TaskTestManager manager = new TaskTestManager(this.client);
        try {
            String t1 = FindTasksQueryTests.randomUID();
            String t2 = FindTasksQueryTests.randomUID();
            String t3 = FindTasksQueryTests.randomUID();
            Task task = manager.insertTaskOnServer(manager.newTask(t1 + " " + t2 + " " + t3));
            SimpleFacet globalFacet = (SimpleFacet)FindTasksQueryTests.findByType((FacetType)CommonFacetType.GLOBAL, this.autocomplete(Module.TASKS, t1 + " " + t3));
            List<PropDocument> documents = this.query(this.client, Collections.singletonList(FindTasksQueryTests.createActiveFacet(globalFacet)));
            FindTasksQueryTests.assertTrue((String)"no task found", (0 < documents.size() ? 1 : 0) != 0);
            FindTasksQueryTests.assertNotNull((String)"task not found", (Object)FindTasksQueryTests.findByProperty(documents, "title", task.getTitle()));
            globalFacet = (SimpleFacet)FindTasksQueryTests.findByType((FacetType)CommonFacetType.GLOBAL, this.autocomplete(Module.TASKS, "\"" + t1 + " " + t2 + "\""));
            documents = this.query(this.client, Collections.singletonList(FindTasksQueryTests.createActiveFacet(globalFacet)));
            FindTasksQueryTests.assertTrue((String)"no task found", (0 < documents.size() ? 1 : 0) != 0);
            FindTasksQueryTests.assertNotNull((String)"task not found", (Object)FindTasksQueryTests.findByProperty(documents, "title", task.getTitle()));
            globalFacet = (SimpleFacet)FindTasksQueryTests.findByType((FacetType)CommonFacetType.GLOBAL, this.autocomplete(Module.TASKS, "\"" + t1 + " " + t3 + "\""));
            documents = this.query(this.client, Collections.singletonList(FindTasksQueryTests.createActiveFacet(globalFacet)));
            FindTasksQueryTests.assertTrue((String)"task found", (0 == documents.size() ? 1 : 0) != 0);
        }
        finally {
            manager.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFolderTypeFacet() throws Exception {
        AJAXClient client2 = new AJAXClient(AJAXClient.User.User2);
        TaskTestManager manager = new TaskTestManager(this.client);
        try {
            FolderType[] typesInOrder = new FolderType[]{FolderType.PRIVATE, FolderType.PUBLIC, FolderType.SHARED};
            AJAXClient[] clients = new AJAXClient[]{this.client, this.client, client2};
            FolderObject[] folders = new FolderObject[]{this.folderManager.insertFolderOnServer(this.folderManager.generatePrivateFolder(FindTasksQueryTests.randomUID(), 1, this.client.getValues().getPrivateTaskFolder(), this.client.getValues().getUserId())), this.folderManager.insertFolderOnServer(this.folderManager.generatePublicFolder(FindTasksQueryTests.randomUID(), 1, 2, this.client.getValues().getUserId())), this.folderManager.insertFolderOnServer(this.folderManager.generateSharedFolder(FindTasksQueryTests.randomUID(), 1, this.client.getValues().getPrivateTaskFolder(), this.client.getValues().getUserId(), client2.getValues().getUserId()))};
            Task[] tasks = new Task[]{manager.insertTaskOnServer(manager.newTask(FindTasksQueryTests.randomUID(), folders[0].getObjectID())), manager.insertTaskOnServer(manager.newTask(FindTasksQueryTests.randomUID(), folders[1].getObjectID())), manager.insertTaskOnServer(manager.newTask(FindTasksQueryTests.randomUID(), folders[2].getObjectID()))};
            block8: for (int i = 0; i < 3; ++i) {
                FolderType folderType = typesInOrder[i];
                List<Facet> facets = this.autocomplete(clients[i], "");
                ExclusiveFacet folderTypeFacet = (ExclusiveFacet)FindTasksQueryTests.findByType((FacetType)CommonFacetType.FOLDER_TYPE, facets);
                FacetValue typeValue = FindTasksQueryTests.findByValueId(folderType.getIdentifier(), (DefaultFacet)folderTypeFacet);
                List<PropDocument> docs = this.query(clients[i], Collections.singletonList(FindTasksQueryTests.createActiveFacet((DefaultFacet)folderTypeFacet, typeValue)));
                PropDocument[] foundDocs = new PropDocument[3];
                for (PropDocument doc : docs) {
                    Map<String, Object> props = doc.getProps();
                    if (tasks[0].getTitle().equals(props.get("title"))) {
                        foundDocs[0] = doc;
                        continue;
                    }
                    if (tasks[1].getTitle().equals(props.get("title"))) {
                        foundDocs[1] = doc;
                        continue;
                    }
                    if (!tasks[2].getTitle().equals(props.get("title"))) continue;
                    foundDocs[2] = doc;
                }
                switch (folderType) {
                    case PRIVATE: {
                        FindTasksQueryTests.assertNotNull((String)"Private task not found", (Object)foundDocs[0]);
                        FindTasksQueryTests.assertNull((String)"Public task found but should not", (Object)foundDocs[1]);
                        FindTasksQueryTests.assertNotNull((String)"Shared task not found", (Object)foundDocs[2]);
                        continue block8;
                    }
                    case PUBLIC: {
                        FindTasksQueryTests.assertNull((String)"Private task found but should not", (Object)foundDocs[0]);
                        FindTasksQueryTests.assertNotNull((String)"Public task not found", (Object)foundDocs[1]);
                        FindTasksQueryTests.assertNull((String)"Shared task found but should not", (Object)foundDocs[2]);
                        continue block8;
                    }
                    case SHARED: {
                        FindTasksQueryTests.assertNull((String)"Private task found but should not", (Object)foundDocs[0]);
                        FindTasksQueryTests.assertNull((String)"Public task found but should not", (Object)foundDocs[1]);
                        FindTasksQueryTests.assertNotNull((String)"Shared task not found", (Object)foundDocs[2]);
                    }
                }
            }
        }
        finally {
            manager.cleanUp();
            client2.logout();
        }
    }

    protected List<Facet> autocomplete(AJAXClient client, String prefix) throws Exception {
        AutocompleteRequest autocompleteRequest = new AutocompleteRequest(prefix, Module.TASKS.getIdentifier());
        AutocompleteResponse autocompleteResponse = client.execute(autocompleteRequest);
        return autocompleteResponse.getFacets();
    }

    protected List<PropDocument> query(AJAXClient client, List<ActiveFacet> facets) throws Exception {
        QueryRequest queryRequest = new QueryRequest(0, Integer.MAX_VALUE, facets, Module.TASKS.getIdentifier());
        QueryResponse queryResponse = client.execute(queryRequest);
        SearchResult result = queryResponse.getSearchResult();
        ArrayList<PropDocument> propDocuments = new ArrayList<PropDocument>();
        List documents = result.getDocuments();
        for (Document document : documents) {
            propDocuments.add((PropDocument)document);
        }
        return propDocuments;
    }
}

