/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.attach;

import com.openexchange.ajax.parser.AttachmentParser;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentMetadata;
import junit.framework.TestCase;
import org.json.JSONException;

public class AttachmentParserTest
extends TestCase {
    public void testParse() throws JSONException {
        AttachmentParser parser = new AttachmentParser();
        AttachmentMetadata attachment = parser.getAttachmentMetadata("{ \"filename\" : \"test.txt\", \"file_mimetype\" :\"text/plain\", \"file_size\" : 12345 , \"folder\" : 23, \"id\" : 24, \"module\" : 25, \"attached\" : 26, \"created_by\" : 27, \"creation_date\":230023 }");
        AttachmentParserTest.assertEquals((String)"test.txt", (String)attachment.getFilename());
        AttachmentParserTest.assertEquals((String)"text/plain", (String)attachment.getFileMIMEType());
        AttachmentParserTest.assertEquals((long)12345L, (long)attachment.getFilesize());
        AttachmentParserTest.assertEquals((int)23, (int)attachment.getFolderId());
        AttachmentParserTest.assertEquals((int)24, (int)attachment.getId());
        AttachmentParserTest.assertEquals((int)25, (int)attachment.getModuleId());
        AttachmentParserTest.assertEquals((int)26, (int)attachment.getAttachedId());
        AttachmentParserTest.assertEquals((int)27, (int)attachment.getCreatedBy());
        AttachmentParserTest.assertEquals((long)230023L, (long)attachment.getCreationDate().getTime());
    }

    public void testNullColumns() throws OXException {
        AttachmentParser parser = new AttachmentParser();
        AttachmentParserTest.assertEquals(null, (Object)parser.getColumns(null));
    }
}

