/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.recurrence;

import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonDeleteResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.test.CalendarTestManager;
import java.io.IOException;
import java.util.Date;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class DeleteExceptionTimestampTest
extends AbstractAJAXSession {
    private CalendarTestManager manager;
    private Appointment appointment;

    public DeleteExceptionTimestampTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.manager = new CalendarTestManager(this.getClient());
        this.appointment = new Appointment();
        this.appointment.setTitle(this.getName());
        this.appointment.setStartDate(TimeTools.D("24/02/2007 10:00"));
        this.appointment.setEndDate(TimeTools.D("24/02/2007 12:00"));
        this.appointment.setRecurrenceType(1);
        this.appointment.setInterval(1);
        this.appointment.setOccurrence(5);
        this.appointment.setParentFolderID(this.getClient().getValues().getPrivateAppointmentFolder());
        this.manager.insert(this.appointment);
    }

    @Override
    protected void tearDown() throws Exception {
        this.manager.cleanUp();
        super.tearDown();
    }

    public void testTimestampShouldBeDifferentAfterCreatingDeleteException() throws OXException, IOException, SAXException, JSONException {
        Date oldTimestamp = this.appointment.getLastModified();
        DeleteRequest deleteRequest = new DeleteRequest(this.appointment.getObjectID(), this.appointment.getParentFolderID(), 3, oldTimestamp, true);
        CommonDeleteResponse response = this.getClient().execute(deleteRequest);
        DeleteExceptionTimestampTest.assertTrue((String)"Timestamp should be later", (boolean)oldTimestamp.before(response.getTimestamp()));
    }
}

