/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;

public class Bug24502Test
extends AbstractAJAXSession {
    private AJAXClient clientA;
    private AJAXClient clientB;
    private AJAXClient clientC;
    private FolderObject folder;
    private Appointment appointment;

    public Bug24502Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.clientA = this.getClient();
        this.clientB = new AJAXClient(AJAXClient.User.User2);
        this.clientC = new AJAXClient(AJAXClient.User.User3);
        this.folder = Create.folder(1, "Folder to test bug 18455", 2, 1, Create.ocl(this.clientA.getValues().getUserId(), false, true, 128, 128, 128, 128), Create.ocl(this.clientB.getValues().getUserId(), false, false, 128, 128, 128, 128));
        CommonInsertResponse response = this.clientA.execute(new com.openexchange.ajax.folder.actions.InsertRequest((API)EnumAPI.OX_OLD, this.folder));
        response.fillObject((DataObject)this.folder);
        this.appointment = new Appointment();
        this.appointment.setTitle("Bug 18455 Test");
        this.appointment.setStartDate(TimeTools.D("01.03.2011 08:00"));
        this.appointment.setEndDate(TimeTools.D("01.03.2011 09:00"));
        this.appointment.setParentFolderID(this.folder.getObjectID());
        this.appointment.setIgnoreConflicts(true);
        this.appointment.setUsers(new UserParticipant[]{new UserParticipant(this.clientA.getValues().getUserId()), new UserParticipant(this.clientC.getValues().getUserId())});
        this.appointment.setParticipants(new Participant[]{new UserParticipant(this.clientA.getValues().getUserId()), new UserParticipant(this.clientC.getValues().getUserId())});
        InsertRequest insertRequest = new InsertRequest(this.appointment, this.clientA.getValues().getTimeZone());
        AppointmentInsertResponse insertResponse = this.clientA.execute(insertRequest);
        insertResponse.fillObject((DataObject)this.appointment);
    }

    public void testBug() throws Exception {
        com.openexchange.ajax.appointment.action.DeleteRequest deleteRequest = new com.openexchange.ajax.appointment.action.DeleteRequest(this.appointment.getObjectID(), this.appointment.getParentFolderID(), this.appointment.getLastModified());
        this.clientB.execute(deleteRequest);
        GetRequest getRequest = new GetRequest(this.clientC.getValues().getPrivateAppointmentFolder(), this.appointment.getObjectID(), false);
        GetResponse getResponse = this.clientC.execute(getRequest);
        Bug24502Test.assertTrue((String)"Appointment should be deleted completely.", (boolean)getResponse.hasError());
        Bug24502Test.assertTrue((String)"Appointment should be deleted completely.", (boolean)getResponse.getErrorMessage().contains("not found"));
    }

    @Override
    public void tearDown() throws Exception {
        this.clientA.execute(new DeleteRequest((API)EnumAPI.OX_OLD, this.folder));
        super.tearDown();
    }
}

