/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment;

import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.java.Autoboxing;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public final class FunambolTest
extends AbstractAJAXSession {
    private AJAXClient client;
    private int folderId;
    private TimeZone timeZone;
    private List<Appointment> toDelete;

    public FunambolTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.folderId = this.client.getValues().getPrivateAppointmentFolder();
        this.timeZone = this.client.getValues().getTimeZone();
        this.toDelete = new ArrayList<Appointment>();
    }

    private Appointment getAppointment() {
        Appointment appointment = new Appointment();
        appointment.setParentFolderID(this.folderId);
        appointment.setTitle("TestCreationTime");
        appointment.setStartDate(new Date(TimeTools.getHour(0, this.timeZone)));
        appointment.setEndDate(new Date(TimeTools.getHour(1, this.timeZone)));
        appointment.setIgnoreConflicts(true);
        return appointment;
    }

    @Override
    protected void tearDown() throws Exception {
        for (Appointment app : this.toDelete) {
            this.client.execute(new DeleteRequest(app));
        }
        super.tearDown();
    }

    public void testAppointmentCreationTime() throws Throwable {
        Date lastModified = null;
        Date timeAfterCreation = null;
        Date timeBeforeCreation = null;
        Appointment reload = null;
        boolean potentialTimestamp = false;
        while (!potentialTimestamp) {
            Appointment appointment = this.getAppointment();
            timeBeforeCreation = new Date(this.client.getValues().getServerTime().getTime() - 1L);
            CommonInsertResponse insertResponse = this.client.execute(new InsertRequest(appointment, this.timeZone));
            insertResponse.fillObject((DataObject)appointment);
            GetResponse response = this.client.execute(new GetRequest(appointment));
            reload = response.getAppointment(this.timeZone);
            lastModified = reload.getLastModified();
            timeAfterCreation = new Date(this.client.getValues().getServerTime().getTime() + 1L);
            System.out.println(lastModified.getTime());
            if (lastModified.getTime() % 1000L >= 500L) {
                potentialTimestamp = true;
            }
            this.toDelete.add(appointment);
        }
        FunambolTest.assertTrue((String)"Appointment creation time is not after time request before creation.", (boolean)lastModified.after(timeBeforeCreation));
        FunambolTest.assertTrue((String)"Appointment creation time is not before time request after creation.", (boolean)lastModified.before(timeAfterCreation));
        FunambolTest.assertEquals((String)"Last modified and creation date are different.", (Object)Autoboxing.L((long)(lastModified.getTime() / 1000L)), (Object)Autoboxing.L((long)(reload.getCreationDate().getTime() / 1000L)));
    }
}

