/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.mbox;

import com.sun.mail.mbox.InboxFile;
import com.sun.mail.mbox.UNIXFile;
import com.sun.mail.mbox.UNIXFolder;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class UNIXInbox
extends UNIXFolder
implements InboxFile {
    private final String user;
    private static final long serialVersionUID = 651261842162777620L;
    private transient RandomAccessFile lockfile;
    private transient String lockfileName;

    public UNIXInbox(String user, String name) {
        super(name);
        this.user = user;
        if (user == null) {
            throw new NullPointerException("user name is null in UNIXInbox");
        }
    }

    @Override
    public boolean lock(String mode) {
        if (lockType == 1) {
            if (!loaded) {
                return false;
            }
            if (!this.maillock(this.user, 5)) {
                return false;
            }
        }
        if (!super.lock(mode)) {
            if (loaded) {
                this.mailunlock();
            }
            return false;
        }
        return true;
    }

    @Override
    public void unlock() {
        super.unlock();
        if (loaded) {
            this.mailunlock();
        }
    }

    @Override
    public void touchlock() {
        if (loaded) {
            this.touchlock0();
        }
    }

    @Override
    public boolean openLock(String mode) {
        if (mode.equals("r")) {
            return true;
        }
        if (this.lockfileName == null) {
            String home = System.getProperty("user.home");
            this.lockfileName = home + File.separator + ".Maillock";
        }
        try {
            boolean ret;
            this.lockfile = new RandomAccessFile(this.lockfileName, mode);
            switch (lockType) {
                case 0: {
                    ret = true;
                    break;
                }
                default: {
                    ret = UNIXFile.lock(this.lockfile.getFD(), mode);
                    break;
                }
                case 2: {
                    boolean bl = ret = this.lockfile.getChannel().tryLock(0L, Long.MAX_VALUE, !mode.equals("rw")) != null;
                }
            }
            if (!ret) {
                this.closeLock();
            }
            return ret;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeLock() {
        if (this.lockfile == null) {
            return;
        }
        try {
            this.lockfile.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.lockfile = null;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof UNIXInbox)) {
            return false;
        }
        UNIXInbox other = (UNIXInbox)o;
        return this.user.equals(other.user) && super.equals(other);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.user.hashCode();
    }

    private native boolean maillock(String var1, int var2);

    private native void mailunlock();

    private native void touchlock0();
}

