/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.threadpool.internal;

import com.openexchange.config.ConfigurationService;
import com.openexchange.log.LogProperties;
import com.openexchange.threadpool.AbstractTask;
import com.openexchange.threadpool.MdcProvider;
import com.openexchange.threadpool.Task;
import com.openexchange.threadpool.TaskWrapper;
import com.openexchange.threadpool.ThreadRenamer;
import com.openexchange.threadpool.internal.CustomFutureTask;
import com.openexchange.threadpool.internal.CustomThread;
import com.openexchange.threadpool.internal.CustomUncaughtExceptionhandler;
import com.openexchange.threadpool.osgi.ThreadPoolServiceRegistry;
import java.io.File;
import java.security.AccessController;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public final class CustomThreadPoolExecutor
extends ThreadPoolExecutor
implements ScheduledExecutorService {
    static final Logger LOG = LoggerFactory.getLogger(CustomThreadPoolExecutor.class);
    static final Object PRESENT = new Object();
    private static final Runnable[] EMPTY_RUNNABLE_ARRAY = new Runnable[0];
    private static final RuntimePermission shutdownPerm = new RuntimePermission("modifyThread");
    private static final AtomicLong sequencer = new AtomicLong(0L);
    private static final long NANO_ORIGIN = System.nanoTime();
    private final BlockingQueue<Runnable> workQueue;
    private final DelayedWorkQueue delayedWorkQueue;
    private final ReentrantLock mainLock = new ReentrantLock();
    private final Condition termination = this.mainLock.newCondition();
    private final ConcurrentMap<Worker, Object> workers = new NonBlockingHashMap(1024);
    private final Set<Worker> workerSet = this.workers.keySet();
    protected final boolean monitorThreads;
    private volatile ScheduledFuture<?> monitorFuture;
    private final Thread consumerThread;
    private final Thread watcherThread;
    private final DelayedQueueConsumer delayedQueueConsumer;
    private final ActiveTaskWatcher activeTaskWatcher;
    private final AtomicInteger activeCount = new AtomicInteger();
    private volatile long keepAliveTime;
    private volatile int corePoolSize;
    private volatile int maximumPoolSize;
    private volatile int poolSize;
    private volatile boolean continueExistingPeriodicTasksAfterShutdown;
    private volatile boolean executeExistingDelayedTasksAfterShutdown;
    volatile int runState;
    static final int RUNNING = 0;
    static final int SHUTDOWN = 1;
    static final int STOP = 2;
    static final int TERMINATED = 3;
    private volatile RejectedExecutionHandler handler;
    private volatile boolean blocking;
    private volatile ThreadFactory threadFactory;
    private int largestPoolSize;
    private long completedTaskCount;
    private static final RejectedExecutionHandler DEFAULT_HANDLER = new AbortPolicy();

    void rejectCustom(Runnable command) {
        this.handler.rejectedExecution(command, this);
    }

    AtomicLong getSequencer() {
        return sequencer;
    }

    private Thread addThread(final Runnable firstTask) {
        Worker w = new Worker(firstTask);
        Thread t = this.threadFactory.newThread(w);
        if (null != t) {
            if (null != firstTask) {
                Object stringer = new Object(){

                    public String toString() {
                        Task tsk;
                        Object task = firstTask instanceof CustomFutureTask ? ((tsk = ((CustomFutureTask)firstTask).getTask()) instanceof TaskWrapper ? ((TaskWrapper)((Object)tsk)).getWrapped() : tsk) : (firstTask instanceof ScheduledFutureTask ? ((ScheduledFutureTask)firstTask).getWrapped() : firstTask);
                        return task.getClass().getName();
                    }
                };
                LOG.debug("Spawned new thread for {}", stringer, (Object)new Throwable("Thread-Creation-Watcher"));
            }
            w.thread = t;
            this.workers.put(w, PRESENT);
            int nt = ++this.poolSize;
            if (nt > this.largestPoolSize) {
                this.largestPoolSize = nt;
            }
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addIfUnderCorePoolSize(Runnable firstTask) {
        Thread t = null;
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            if (this.poolSize < this.corePoolSize) {
                t = this.addThread(firstTask);
            }
        }
        finally {
            mainLock.unlock();
        }
        if (null == t) {
            return false;
        }
        t.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Runnable addIfUnderMaximumPoolSize(Runnable firstTask) {
        Thread t = null;
        Runnable next = null;
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            if (this.poolSize < this.maximumPoolSize) {
                next = (Runnable)this.workQueue.poll();
                if (null == next) {
                    next = firstTask;
                }
                t = this.addThread(next);
            }
        }
        finally {
            mainLock.unlock();
        }
        if (null == t) {
            return null;
        }
        t.start();
        return next;
    }

    Runnable getTaskCustom() throws InterruptedException {
        block7: while (true) {
            switch (this.runState) {
                case 0: {
                    if (this.poolSize <= this.corePoolSize) {
                        return this.workQueue.take();
                    }
                    long timeout = this.keepAliveTime;
                    if (timeout <= 0L) {
                        return null;
                    }
                    Runnable r = this.workQueue.poll(timeout, TimeUnit.NANOSECONDS);
                    if (null != r) {
                        return r;
                    }
                    if (this.poolSize <= this.corePoolSize) continue block7;
                    return null;
                }
                case 1: {
                    Runnable r = (Runnable)this.workQueue.poll();
                    if (null != r) {
                        return r;
                    }
                    if (this.workQueue.isEmpty()) {
                        this.interruptIdleWorkersCustom();
                        return null;
                    }
                    try {
                        return this.workQueue.take();
                    }
                    catch (InterruptedException ignore) {
                        LOG.debug("", (Throwable)ignore);
                        continue block7;
                    }
                }
                case 2: {
                    return null;
                }
            }
            if (!$assertionsDisabled) break;
        }
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void interruptIdleWorkersCustom() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            for (Worker w : this.workerSet) {
                w.interruptIfIdle();
            }
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void workerDone(Worker w) {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            LogProperties.dropTempFiles();
            this.completedTaskCount += w.completedTasks.get();
            this.workers.remove(w);
            if (--this.poolSize > 0) {
                return;
            }
            int state = this.runState;
            assert (state != 3);
            if (state != 2) {
                if (!this.workQueue.isEmpty()) {
                    Thread t = this.addThread(null);
                    if (null != t) {
                        t.start();
                    }
                    return;
                }
                if (state == 0) {
                    return;
                }
            }
            this.termination.signalAll();
            this.runState = 3;
        }
        finally {
            mainLock.unlock();
        }
        assert (this.runState == 3);
        this.terminated();
    }

    static final long now() {
        return System.nanoTime() - NANO_ORIGIN;
    }

    private long triggerTime(long delay, TimeUnit unit) {
        return this.triggerTime(unit.toNanos(delay < 0L ? 0L : delay));
    }

    long triggerTime(long delay) {
        return CustomThreadPoolExecutor.now() + (delay < 0x3FFFFFFFFFFFFFFFL ? delay : this.overflowFree(delay));
    }

    private long overflowFree(long delay) {
        long headDelay;
        Delayed head = (Delayed)((Object)this.delayedWorkQueue.peek());
        long d = delay;
        if (null != head && (headDelay = head.getDelay(TimeUnit.NANOSECONDS)) < 0L && delay - headDelay < 0L) {
            d = Long.MAX_VALUE + headDelay;
        }
        return d;
    }

    void cancelUnwantedTasks() {
        boolean keepDelayed = this.getExecuteExistingDelayedTasksAfterShutdownPolicy();
        boolean keepPeriodic = this.getContinueExistingPeriodicTasksAfterShutdownPolicy();
        if (!keepDelayed && !keepPeriodic) {
            this.delayedWorkQueue.clear();
        } else if (keepDelayed || keepPeriodic) {
            Object[] entries = this.delayedWorkQueue.toArray();
            for (int i = 0; i < entries.length; ++i) {
                ScheduledFutureTask t;
                Object e = entries[i];
                if (!(e instanceof ScheduledFutureTask) || !((t = (ScheduledFutureTask)e).isPeriodic() ? !keepPeriodic : !keepDelayed)) continue;
                t.cancel(false);
            }
            entries = null;
            this.purge();
        }
    }

    private void delayedExecute(Runnable command) {
        if (this.isShutdown()) {
            this.rejectCustom(command);
            return;
        }
        if (this.getPoolSize() < this.getCorePoolSize()) {
            this.prestartCoreThread();
        }
        this.delayedWorkQueue.add(command);
    }

    public CustomThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, false, Executors.defaultThreadFactory(), DEFAULT_HANDLER);
    }

    public CustomThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, false, threadFactory, DEFAULT_HANDLER);
    }

    public CustomThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, false, Executors.defaultThreadFactory(), handler);
    }

    public CustomThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, boolean blocking, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(0, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1));
        if (corePoolSize < 0 || maximumPoolSize <= 0 || maximumPoolSize < corePoolSize || keepAliveTime < 0L) {
            throw new IllegalArgumentException();
        }
        if (null == workQueue || null == threadFactory || null == handler) {
            throw new NullPointerException();
        }
        this.blocking = blocking;
        this.corePoolSize = corePoolSize;
        this.maximumPoolSize = maximumPoolSize;
        this.workQueue = workQueue;
        this.keepAliveTime = unit.toNanos(keepAliveTime);
        this.threadFactory = threadFactory;
        this.handler = handler;
        this.delayedWorkQueue = new DelayedWorkQueue();
        this.executeExistingDelayedTasksAfterShutdown = true;
        this.delayedQueueConsumer = new DelayedQueueConsumer();
        this.consumerThread = new Thread((Runnable)this.delayedQueueConsumer, "DelayedQueueConsumer");
        this.consumerThread.start();
        this.activeTaskWatcher = new ActiveTaskWatcher();
        this.watcherThread = new Thread((Runnable)this.activeTaskWatcher, "ActiveTaskWatcher");
        this.watcherThread.start();
        this.monitorThreads = false;
    }

    public void startMonitorThreads(final long maxRunningMillis, long delayMillis) {
        if (this.monitorThreads) {
            final Set<Worker> workerSet = this.workerSet;
            Runnable monitorThread = new Runnable(){

                @Override
                public void run() {
                    long stamp = System.currentTimeMillis() - maxRunningMillis;
                    for (Worker worker : workerSet) {
                        if (!worker.isActive() || worker.lastStart >= stamp) continue;
                        worker.interruptNow();
                    }
                }
            };
            this.monitorFuture = this.scheduleWithFixedDelay(monitorThread, delayMillis, delayMillis, TimeUnit.MILLISECONDS);
        }
    }

    public void stopMonitorThreads() {
        ScheduledFuture<?> monitorFuture = this.monitorFuture;
        if (null != monitorFuture) {
            monitorFuture.cancel(false);
            this.monitorFuture = null;
        }
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        if (null == command || null == unit) {
            throw new NullPointerException();
        }
        ScheduledFutureTask<Object> t = new ScheduledFutureTask<Object>(command, null, this.triggerTime(delay, unit));
        if (this.runState != 0) {
            this.rejectCustom(t);
        } else {
            this.delayedExecute(t);
        }
        return t;
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        if (null == callable || null == unit) {
            throw new NullPointerException();
        }
        ScheduledFutureTask<V> t = new ScheduledFutureTask<V>(callable, this.triggerTime(delay, unit));
        if (this.runState != 0) {
            this.rejectCustom(t);
        } else {
            this.delayedExecute(t);
        }
        return t;
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        if (null == command || null == unit) {
            throw new NullPointerException();
        }
        if (period <= 0L) {
            throw new IllegalArgumentException();
        }
        ScheduledFutureTask<Object> t = new ScheduledFutureTask<Object>(command, null, this.triggerTime(initialDelay, unit), unit.toNanos(period));
        if (this.runState != 0) {
            this.rejectCustom(t);
        } else {
            this.delayedExecute(t);
        }
        return t;
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        if (null == command || null == unit) {
            throw new NullPointerException();
        }
        if (delay <= 0L) {
            throw new IllegalArgumentException();
        }
        ScheduledFutureTask<Object> t = new ScheduledFutureTask<Object>(command, null, this.triggerTime(initialDelay, unit), unit.toNanos(-delay));
        if (this.runState != 0) {
            this.rejectCustom(t);
        } else {
            this.delayedExecute(t);
        }
        return t;
    }

    @Override
    public Future<?> submit(Runnable task) {
        throw new UnsupportedOperationException("CustomThreadPoolExecutor.submit(Runnable task)");
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        throw new UnsupportedOperationException("CustomThreadPoolExecutor.submit(Runnable task, T result)");
    }

    @Override
    public <T> Future<T> submit(final Callable<T> callable) {
        if (null == callable) {
            throw new NullPointerException();
        }
        Task<Object> task = callable instanceof Task ? (Task<Object>)callable : new AbstractTask<T>(){

            @Override
            public T call() throws Exception {
                return callable.call();
            }
        };
        CustomFutureTask ftask = new CustomFutureTask(task, callable instanceof MdcProvider ? ((MdcProvider)((Object)callable)).getMdc() : MDC.getCopyOfContextMap());
        this.execute(ftask);
        return ftask;
    }

    @Override
    protected void afterExecute(Runnable r, Throwable throwable) {
        super.afterExecute(r, throwable);
        CustomThreadPoolExecutor.deleteTempFiles();
        MDC.clear();
        if (r instanceof CustomFutureTask) {
            CustomFutureTask customFutureTask = (CustomFutureTask)r;
            if (customFutureTask.isTrackable()) {
                this.activeTaskWatcher.removeTask(customFutureTask.getNumber());
            }
            customFutureTask.getTask().afterExecute(throwable);
            ((CustomThread)Thread.currentThread()).restoreName();
        } else if (r instanceof ScheduledFutureTask) {
            ((CustomThread)Thread.currentThread()).restoreName();
        }
        this.activeCount.decrementAndGet();
    }

    @Override
    protected void beforeExecute(Thread thread, Runnable r) {
        this.activeCount.incrementAndGet();
        thread.setUncaughtExceptionHandler(CustomUncaughtExceptionhandler.getInstance());
        if (r instanceof CustomFutureTask) {
            CustomFutureTask customFutureTask = (CustomFutureTask)r;
            Task task = customFutureTask.getTask();
            task.setThreadName((ThreadRenamer)((Object)thread));
            task.beforeExecute(thread);
            Map<String, Object> mdc = customFutureTask.getMdc();
            if (null != mdc) {
                MDC.setContextMap(mdc);
            }
            if (customFutureTask.isTrackable()) {
                this.activeTaskWatcher.addTask(customFutureTask.getNumber(), thread, customFutureTask.getMdc());
            }
        } else if (r instanceof MdcProvider) {
            Map<String, Object> mdc = ((MdcProvider)((Object)r)).getMdc();
            if (null != mdc) {
                MDC.setContextMap(mdc);
            }
        } else if (r instanceof ScheduledFutureTask) {
            ((ThreadRenamer)((Object)thread)).renamePrefix("OXTimer");
        }
        super.beforeExecute(thread, r);
    }

    @Override
    public void execute(Runnable command) {
        Runnable mdcCommand;
        if (null == command) {
            throw new NullPointerException();
        }
        Runnable runnable = mdcCommand = command instanceof MdcProvider ? command : new MDCProvidingRunnable(command, MDC.getCopyOfContextMap());
        if (this.blocking) {
            if (this.runState != 0) {
                this.rejectCustom(mdcCommand);
                return;
            }
            if (this.poolSize < this.corePoolSize && this.addIfUnderCorePoolSize(mdcCommand)) {
                return;
            }
            boolean acquired = false;
            do {
                try {
                    this.workQueue.put(mdcCommand);
                    acquired = true;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            } while (!acquired);
        } else {
            Runnable r;
            do {
                if (this.runState != 0) {
                    this.rejectCustom(mdcCommand);
                    return;
                }
                if (this.poolSize < this.corePoolSize && this.addIfUnderCorePoolSize(mdcCommand)) {
                    return;
                }
                if (this.workQueue.offer(mdcCommand)) {
                    return;
                }
                r = this.addIfUnderMaximumPoolSize(mdcCommand);
                if (r != mdcCommand) continue;
                return;
            } while (null != r);
            this.rejectCustom(mdcCommand);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        boolean fullyTerminated;
        block12: {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                AccessController.checkPermission(shutdownPerm);
            }
            fullyTerminated = false;
            ReentrantLock mainLock = this.mainLock;
            mainLock.lock();
            try {
                this.delayedQueueConsumer.cancelTasksOnShutdown = true;
                this.consumerThread.interrupt();
                this.activeTaskWatcher.stopWhenFinished();
                this.watcherThread.interrupt();
                if (this.workers.size() > 0) {
                    int state;
                    if (null != security) {
                        for (Worker w : this.workerSet) {
                            security.checkAccess(w.thread);
                        }
                    }
                    if (0 == (state = this.runState)) {
                        this.runState = 1;
                    }
                    try {
                        for (Worker w : this.workerSet) {
                            w.interruptIfIdle();
                        }
                        break block12;
                    }
                    catch (SecurityException se) {
                        this.runState = state;
                        throw se;
                    }
                }
                fullyTerminated = true;
                this.runState = 3;
                this.termination.signalAll();
            }
            finally {
                mainLock.unlock();
            }
        }
        if (fullyTerminated) {
            this.terminated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        boolean fullyTerminated;
        block12: {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                AccessController.checkPermission(shutdownPerm);
            }
            fullyTerminated = false;
            ReentrantLock mainLock = this.mainLock;
            mainLock.lock();
            try {
                this.consumerThread.interrupt();
                this.activeTaskWatcher.stopWhenFinished();
                this.watcherThread.interrupt();
                if (this.workers.size() > 0) {
                    int state;
                    if (security != null) {
                        for (Worker w : this.workerSet) {
                            security.checkAccess(w.thread);
                        }
                    }
                    if ((state = this.runState) != 3) {
                        this.runState = 2;
                    }
                    try {
                        for (Worker w : this.workerSet) {
                            w.interruptNow();
                        }
                        break block12;
                    }
                    catch (SecurityException se) {
                        this.runState = state;
                        throw se;
                    }
                }
                fullyTerminated = true;
                this.runState = 3;
                this.termination.signalAll();
            }
            finally {
                mainLock.unlock();
            }
        }
        if (fullyTerminated) {
            this.terminated();
        }
        return Arrays.asList(this.workQueue.toArray(EMPTY_RUNNABLE_ARRAY));
    }

    @Override
    public boolean isShutdown() {
        return this.runState != 0;
    }

    @Override
    public boolean isTerminating() {
        return this.runState == 2;
    }

    @Override
    public boolean isTerminated() {
        return this.runState == 3;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            while (true) {
                if (this.runState == 3) {
                    boolean bl = true;
                    return bl;
                }
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.termination.awaitNanos(nanos);
            }
        }
        finally {
            mainLock.unlock();
        }
    }

    @Override
    protected void finalize() {
        super.finalize();
        this.shutdown();
    }

    @Override
    public void setThreadFactory(ThreadFactory threadFactory) {
        if (null == threadFactory) {
            throw new NullPointerException();
        }
        this.threadFactory = threadFactory;
    }

    @Override
    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    @Override
    public void setRejectedExecutionHandler(RejectedExecutionHandler handler) {
        if (null == handler) {
            throw new NullPointerException();
        }
        this.handler = handler;
    }

    @Override
    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.handler;
    }

    @Override
    public BlockingQueue<Runnable> getQueue() {
        return this.workQueue;
    }

    public DelayedWorkQueue getDelayedWorkQueue() {
        return this.delayedWorkQueue;
    }

    @Override
    public boolean remove(Runnable task) {
        if (task instanceof ScheduledFutureTask) {
            return this.delayedWorkQueue.remove(task);
        }
        return this.workQueue.remove(task);
    }

    @Override
    public void purge() {
        try {
            Future c;
            Runnable r;
            Iterator<Object> it = this.workQueue.iterator();
            while (it.hasNext()) {
                r = (Runnable)it.next();
                if (!(r instanceof Future) || !(c = (Future)((Object)r)).isCancelled()) continue;
                it.remove();
            }
            it = this.delayedWorkQueue.iterator();
            while (it.hasNext()) {
                r = (Runnable)it.next();
                if (!(r instanceof Future) || !(c = (Future)((Object)r)).isCancelled()) continue;
                it.remove();
            }
        }
        catch (ConcurrentModificationException ex) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCorePoolSize(int corePoolSize) {
        if (corePoolSize < 0) {
            throw new IllegalArgumentException();
        }
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            int extra = this.corePoolSize - corePoolSize;
            this.corePoolSize = corePoolSize;
            if (extra < 0) {
                Thread t;
                int n = this.workQueue.size();
                while (extra++ < 0 && n-- > 0 && this.poolSize < corePoolSize && (t = this.addThread(null)) != null) {
                    t.start();
                }
            } else if (extra > 0 && this.poolSize > corePoolSize) {
                Iterator<Worker> it = this.workerSet.iterator();
                while (it.hasNext() && extra-- > 0 && this.poolSize > corePoolSize && this.workQueue.remainingCapacity() == 0) {
                    it.next().interruptIfIdle();
                }
            }
        }
        finally {
            mainLock.unlock();
        }
    }

    @Override
    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    @Override
    public boolean prestartCoreThread() {
        return this.addIfUnderCorePoolSize(null);
    }

    @Override
    public int prestartAllCoreThreads() {
        int n = 0;
        while (this.addIfUnderCorePoolSize(null)) {
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaximumPoolSize(int maximumPoolSize) {
        if (maximumPoolSize <= 0 || maximumPoolSize < this.corePoolSize) {
            throw new IllegalArgumentException();
        }
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            int extra;
            this.maximumPoolSize = maximumPoolSize;
            if (extra > 0 && this.poolSize > maximumPoolSize) {
                Iterator<Worker> it = this.workerSet.iterator();
                for (extra = this.maximumPoolSize - maximumPoolSize; it.hasNext() && extra > 0 && this.poolSize > maximumPoolSize; --extra) {
                    it.next().interruptIfIdle();
                }
            }
        }
        finally {
            mainLock.unlock();
        }
    }

    @Override
    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    @Override
    public void setKeepAliveTime(long time, TimeUnit unit) {
        if (time < 0L) {
            throw new IllegalArgumentException();
        }
        this.keepAliveTime = unit.toNanos(time);
    }

    @Override
    public long getKeepAliveTime(TimeUnit unit) {
        return unit.convert(this.keepAliveTime, TimeUnit.NANOSECONDS);
    }

    public void setContinueExistingPeriodicTasksAfterShutdownPolicy(boolean value) {
        this.continueExistingPeriodicTasksAfterShutdown = value;
        if (!value && this.isShutdown()) {
            this.cancelUnwantedTasks();
        }
    }

    public boolean getContinueExistingPeriodicTasksAfterShutdownPolicy() {
        return this.continueExistingPeriodicTasksAfterShutdown;
    }

    public void setExecuteExistingDelayedTasksAfterShutdownPolicy(boolean value) {
        this.executeExistingDelayedTasksAfterShutdown = value;
        if (!value && this.isShutdown()) {
            this.cancelUnwantedTasks();
        }
    }

    public boolean getExecuteExistingDelayedTasksAfterShutdownPolicy() {
        return this.executeExistingDelayedTasksAfterShutdown;
    }

    @Override
    public int getPoolSize() {
        return this.poolSize;
    }

    @Override
    public int getActiveCount() {
        return this.activeCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLargestPoolSize() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            int n = this.largestPoolSize;
            return n;
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTaskCount() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            long n = this.completedTaskCount;
            for (Worker w : this.workerSet) {
                n += w.completedTasks.get();
                if (!w.isActive()) continue;
                ++n;
            }
            long l = n + (long)this.workQueue.size();
            return l;
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCompletedTaskCount() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            long n = this.completedTaskCount;
            for (Worker w : this.workerSet) {
                n += w.completedTasks.get();
            }
            long l = n;
            return l;
        }
        finally {
            mainLock.unlock();
        }
    }

    @Override
    protected void terminated() {
    }

    static void deleteTempFiles() {
        String[] tempFiles = LogProperties.getAndRemoveTempFiles();
        if (null != tempFiles) {
            for (String path : tempFiles) {
                File f = new File(path);
                f.delete();
            }
        }
    }

    private static final class MDCProvidingRunnable
    implements Runnable,
    MdcProvider {
        private final Runnable delegate;
        private final Map<String, Object> mdc;

        MDCProvidingRunnable(Runnable delegate, Map<String, Object> mdc) {
            this.delegate = delegate;
            this.mdc = mdc;
        }

        @Override
        public Map<String, Object> getMdc() {
            return this.mdc;
        }

        @Override
        public void run() {
            this.delegate.run();
        }
    }

    public static class DiscardOldestPolicy
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            if (!e.isShutdown()) {
                e.getQueue().poll();
                e.execute(r);
            }
        }
    }

    public static class DiscardPolicy
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
        }
    }

    public static class AbortPolicy
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            throw new RejectedExecutionException("Thread pool is overloaded!");
        }
    }

    public static class CallerRunsPolicy
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            if (!e.isShutdown()) {
                r.run();
            }
        }
    }

    private static final class FastThrowable
    extends Throwable {
        FastThrowable() {
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    private static final class TaskInfo {
        final Thread t;
        final long stamp;
        final Map<String, Object> logProperties;

        TaskInfo(Thread t) {
            this(t, null);
        }

        TaskInfo(Thread t, Map<String, Object> logProperties) {
            this.t = t;
            this.stamp = System.currentTimeMillis();
            this.logProperties = logProperties;
        }
    }

    private final class ActiveTaskWatcher
    implements Runnable {
        private final ReentrantLock lock = new ReentrantLock(true);
        private final Condition notEmpty = this.lock.newCondition();
        private final ConcurrentMap<Long, TaskInfo> tasks;
        private final TaskInfo poison = new TaskInfo(null);
        private final long minWaitTime;
        private final long maxRunningTime;
        private final String lineSeparator = System.getProperty("line.separator");

        ActiveTaskWatcher() {
            this.tasks = new NonBlockingHashMap(8192);
            ConfigurationService service = ThreadPoolServiceRegistry.getService(ConfigurationService.class);
            this.minWaitTime = null == service ? 20000L : (long)service.getIntProperty("com.openexchange.requestwatcher.frequency", 20000);
            this.maxRunningTime = null == service ? 60000L : (long)service.getIntProperty("com.openexchange.requestwatcher.maxRequestAge", 60000);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stopWhenFinished() {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                this.tasks.put(Long.MAX_VALUE, this.poison);
                this.notEmpty.signal();
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addTask(long number, Thread thread, Map<String, Object> logProperties) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                this.tasks.put(number, new TaskInfo(thread, logProperties));
                this.notEmpty.signal();
            }
            finally {
                lock.unlock();
            }
        }

        void removeTask(long number) {
            this.tasks.remove(number);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Could not resolve type clashes
         * Unable to fully structure code
         */
        @Override
        public void run() {
            try {
                lineSeparator = this.lineSeparator;
                maxRunningTime = this.maxRunningTime;
                poison = this.poison;
                minWaitTimeNanos = TimeUnit.MILLISECONDS.toNanos(this.minWaitTime);
                while (true) lbl-1000:
                // 3 sources

                {
                    try {
                        block11: do {
                            LockSupport.parkNanos(minWaitTimeNanos);
                            if (this.tasks.isEmpty()) {
                                lock = this.lock;
                                lock.lockInterruptibly();
                                try {
                                    try {
                                        while (this.tasks.isEmpty()) {
                                            this.notEmpty.await();
                                        }
                                    }
                                    catch (InterruptedException ie) {
                                        this.notEmpty.signal();
                                        throw ie;
                                    }
                                }
                                finally {
                                    lock.unlock();
                                }
                            }
                            max = System.currentTimeMillis() - maxRunningTime;
                            logBuilder = new StringBuilder(1024);
                            poisoned = false;
                            for (TaskInfo taskInfo : this.tasks.values()) {
                                if (poison == taskInfo) {
                                    poisoned = true;
                                    continue block11;
                                }
                                if (taskInfo.stamp >= max) continue;
                                thread = taskInfo.t;
                                logProperties = taskInfo.logProperties;
                                logBuilder.setLength(0);
                                if (null != logProperties) {
                                    sorted = new TreeMap<String, String>();
                                    for (Map.Entry<String, Object> entry : logProperties.entrySet()) {
                                        propertyName = entry.getKey();
                                        value = entry.getValue();
                                        if (null == value) continue;
                                        sorted.put(propertyName, value.toString());
                                    }
                                    for (Map.Entry<String, Object> entry : sorted.entrySet()) {
                                        logBuilder.append(entry.getKey()).append('=').append((String)entry.getValue()).append(lineSeparator);
                                    }
                                    logBuilder.append(lineSeparator);
                                }
                                logBuilder.append("Worker \"").append(thread.getName());
                                logBuilder.append("\" exceeds max. running time of ").append(maxRunningTime);
                                logBuilder.append("msec -> Processing time: ").append(System.currentTimeMillis() - taskInfo.stamp);
                                logBuilder.append("msec");
                                t = new FastThrowable();
                                t.setStackTrace(thread.getStackTrace());
                                CustomThreadPoolExecutor.LOG.info(logBuilder.toString(), (Throwable)t);
                            }
                        } while (!poisoned);
                        return;
                    }
                    catch (InterruptedException e) {
                        CustomThreadPoolExecutor.LOG.debug("Watcher run interrupted", (Throwable)e);
                    }
                    catch (Exception e) {
                        CustomThreadPoolExecutor.LOG.error("Watcher run aborted due to an exception!", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                CustomThreadPoolExecutor.LOG.error("Watcher aborted execution due to an exception! Watcher is no more active!", (Throwable)e);
                return;
            }
            ** GOTO lbl-1000
        }

        void appendStackTrace(StackTraceElement[] trace, StringBuilder sb) {
            if (null == trace) {
                return;
            }
            String lineSeparator = this.lineSeparator;
            for (StackTraceElement ste : trace) {
                String className = ste.getClassName();
                if (null == className) continue;
                sb.append("    at ").append(className).append('.').append(ste.getMethodName());
                if (ste.isNativeMethod()) {
                    sb.append("(Native Method)");
                } else {
                    String fileName = ste.getFileName();
                    if (null == fileName) {
                        sb.append("(Unknown Source)");
                    } else {
                        int lineNumber = ste.getLineNumber();
                        sb.append('(').append(fileName);
                        if (lineNumber >= 0) {
                            sb.append(':').append(lineNumber);
                        }
                        sb.append(')');
                    }
                }
                sb.append(lineSeparator);
            }
        }
    }

    private static class DelayedWorkQueue
    extends AbstractCollection<Runnable>
    implements BlockingQueue<Runnable> {
        final DelayQueue<ScheduledFutureTask<?>> dq = new DelayQueue();

        @Override
        public Runnable poll() {
            return (Runnable)this.dq.poll();
        }

        @Override
        public Runnable peek() {
            return (Runnable)this.dq.peek();
        }

        @Override
        public Runnable take() throws InterruptedException {
            return (Runnable)this.dq.take();
        }

        @Override
        public Runnable poll(long timeout, TimeUnit unit) throws InterruptedException {
            return (Runnable)this.dq.poll(timeout, unit);
        }

        @Override
        public boolean add(Runnable x) {
            return this.dq.add((ScheduledFutureTask)x);
        }

        @Override
        public boolean offer(Runnable x) {
            return this.dq.offer((ScheduledFutureTask)x);
        }

        @Override
        public void put(Runnable x) {
            this.dq.put((ScheduledFutureTask)x);
        }

        @Override
        public boolean offer(Runnable x, long timeout, TimeUnit unit) {
            return this.dq.offer((ScheduledFutureTask)x, timeout, unit);
        }

        @Override
        public Runnable remove() {
            return (Runnable)this.dq.remove();
        }

        @Override
        public Runnable element() {
            return (Runnable)this.dq.element();
        }

        @Override
        public void clear() {
            this.dq.clear();
        }

        @Override
        public int drainTo(Collection<? super Runnable> c) {
            return this.dq.drainTo(c);
        }

        @Override
        public int drainTo(Collection<? super Runnable> c, int maxElements) {
            return this.dq.drainTo(c, maxElements);
        }

        @Override
        public int remainingCapacity() {
            return this.dq.remainingCapacity();
        }

        @Override
        public boolean remove(Object x) {
            return this.dq.remove(x);
        }

        @Override
        public boolean contains(Object x) {
            return this.dq.contains(x);
        }

        @Override
        public int size() {
            return this.dq.size();
        }

        @Override
        public boolean isEmpty() {
            return this.dq.isEmpty();
        }

        @Override
        public Object[] toArray() {
            return this.dq.toArray();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return this.dq.toArray(array);
        }

        @Override
        public Iterator<Runnable> iterator() {
            return new Iterator<Runnable>(){
                private final Iterator<ScheduledFutureTask<?>> it;
                {
                    this.it = DelayedWorkQueue.this.dq.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public Runnable next() {
                    return this.it.next();
                }

                @Override
                public void remove() {
                    this.it.remove();
                }
            };
        }
    }

    private final class DelayedQueueConsumer
    implements Runnable {
        volatile boolean cancelTasksOnShutdown = false;

        @Override
        public void run() {
            Thread currentThread = Thread.currentThread();
            try {
                boolean run = true;
                block6: while (!currentThread.isInterrupted()) {
                    Runnable r;
                    Runnable command;
                    try {
                        command = CustomThreadPoolExecutor.this.getDelayedWorkQueue().take();
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    do {
                        if (CustomThreadPoolExecutor.this.isShutdown()) {
                            if (this.cancelTasksOnShutdown) {
                                CustomThreadPoolExecutor.this.cancelUnwantedTasks();
                            }
                            return;
                        }
                        if (CustomThreadPoolExecutor.this.getPoolSize() < CustomThreadPoolExecutor.this.getCorePoolSize() && CustomThreadPoolExecutor.this.addIfUnderCorePoolSize(command) || CustomThreadPoolExecutor.this.getQueue().offer(command) || (r = CustomThreadPoolExecutor.this.addIfUnderMaximumPoolSize(command)) == command) continue block6;
                    } while (null != r);
                    try {
                        command.run();
                    }
                    catch (Exception e) {
                        LOG.error("", (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                LOG.error("{} thread aborted execution due to an exception! TimerService is no more active!", (Object)currentThread.getName(), (Object)e);
            }
        }
    }

    private class ScheduledFutureTask<V>
    extends FutureTask<V>
    implements ScheduledFuture<V> {
        private final long sequenceNumber;
        private long time;
        private final long period;
        private final Object task;

        ScheduledFutureTask(Runnable r, V result, long ns) {
            super(r, result);
            this.task = r;
            this.time = ns;
            this.period = 0L;
            this.sequenceNumber = CustomThreadPoolExecutor.this.getSequencer().getAndIncrement();
        }

        ScheduledFutureTask(Runnable r, V result, long ns, long period) {
            super(r, result);
            this.task = r;
            this.time = ns;
            this.period = period;
            this.sequenceNumber = CustomThreadPoolExecutor.this.getSequencer().getAndIncrement();
        }

        ScheduledFutureTask(Callable<V> callable, long ns) {
            super(callable);
            this.task = callable;
            this.time = ns;
            this.period = 0L;
            this.sequenceNumber = CustomThreadPoolExecutor.this.getSequencer().getAndIncrement();
        }

        public Object getWrapped() {
            return this.task;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.time - CustomThreadPoolExecutor.now(), TimeUnit.NANOSECONDS);
        }

        @Override
        public int compareTo(Delayed other) {
            if (other == this) {
                return 0;
            }
            if (other instanceof ScheduledFutureTask) {
                ScheduledFutureTask x = (ScheduledFutureTask)other;
                long diff = this.time - x.time;
                if (diff < 0L) {
                    return -1;
                }
                if (diff > 0L) {
                    return 1;
                }
                if (this.sequenceNumber < x.sequenceNumber) {
                    return -1;
                }
                return 1;
            }
            long d = this.getDelay(TimeUnit.NANOSECONDS) - other.getDelay(TimeUnit.NANOSECONDS);
            return d == 0L ? 0 : (d < 0L ? -1 : 1);
        }

        boolean isPeriodic() {
            return this.period != 0L;
        }

        private void runPeriodic() {
            boolean ok = super.runAndReset();
            boolean down = CustomThreadPoolExecutor.this.isShutdown();
            if (ok && (!down || CustomThreadPoolExecutor.this.getContinueExistingPeriodicTasksAfterShutdownPolicy() && !CustomThreadPoolExecutor.this.isTerminating())) {
                long p = this.period;
                this.time = p > 0L ? (this.time += p) : CustomThreadPoolExecutor.this.triggerTime(-p);
                CustomThreadPoolExecutor.this.getDelayedWorkQueue().add(this);
            } else if (down) {
                CustomThreadPoolExecutor.this.interruptIdleWorkersCustom();
            }
        }

        @Override
        public void run() {
            if (this.isPeriodic()) {
                this.runPeriodic();
            } else {
                super.run();
            }
        }
    }

    private class Worker
    implements Runnable {
        private final ReentrantLock runLock = new ReentrantLock();
        private Runnable firstTask;
        volatile long lastStart;
        final AtomicLong completedTasks = new AtomicLong();
        Thread thread;

        Worker(Runnable firstTask) {
            this.firstTask = firstTask;
        }

        boolean isActive() {
            return this.runLock.isLocked();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void interruptIfIdle() {
            ReentrantLock runLock = this.runLock;
            if (runLock.tryLock()) {
                try {
                    this.thread.interrupt();
                }
                finally {
                    runLock.unlock();
                }
            }
        }

        void interruptNow() {
            this.thread.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runTask(Runnable task) {
            ReentrantLock runLock = this.runLock;
            runLock.lock();
            try {
                if (CustomThreadPoolExecutor.this.runState == 2) {
                    return;
                }
                if (CustomThreadPoolExecutor.this.monitorThreads) {
                    this.lastStart = System.currentTimeMillis();
                }
                Thread.interrupted();
                MDC.clear();
                boolean ran = false;
                CustomThreadPoolExecutor.this.beforeExecute(this.thread, task);
                try {
                    task.run();
                    ran = true;
                    CustomThreadPoolExecutor.this.afterExecute(task, null);
                    this.completedTasks.incrementAndGet();
                }
                catch (RuntimeException ex) {
                    if (!ran) {
                        CustomThreadPoolExecutor.this.afterExecute(task, ex);
                    }
                    throw ex;
                }
            }
            finally {
                runLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Runnable task = this.firstTask;
                this.firstTask = null;
                while (null != task || null != (task = CustomThreadPoolExecutor.this.getTaskCustom())) {
                    this.runTask(task);
                    task = null;
                }
            }
            catch (InterruptedException ie) {
            }
            catch (RuntimeException re) {
                LOG.error("Task execution failed unexpectedly", (Throwable)re);
            }
            finally {
                CustomThreadPoolExecutor.this.workerDone(this);
            }
        }
    }
}

