/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.CalendarObject;
import com.openexchange.groupware.container.ExternalGroupParticipant;
import com.openexchange.groupware.container.ExternalUserParticipant;
import com.openexchange.groupware.container.GroupParticipant;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.Participants;
import com.openexchange.groupware.container.ResourceParticipant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.webdav.WebdavExceptionCode;
import com.openexchange.webdav.xml.CommonParser;
import org.xmlpull.v1.XmlPullParser;

public class CalendarParser
extends CommonParser {
    protected void parseElementCalendar(CalendarObject calendarobject, XmlPullParser parser) throws Exception {
        if (this.isTag(parser, "recurrence_id")) {
            calendarobject.setRecurrenceID(this.getValueAsInt(parser));
            return;
        }
        if (this.isTag(parser, "recurrence_position")) {
            calendarobject.setRecurrencePosition(this.getValueAsInt(parser));
            return;
        }
        if (this.isTag(parser, "recurrence_date_position")) {
            calendarobject.setRecurrenceDatePosition(this.getValueAsDate(parser));
            return;
        }
        if (this.isTag(parser, "month")) {
            calendarobject.setMonth(this.getValueAsInt(parser));
            return;
        }
        if (this.isTag(parser, "day_in_month")) {
            calendarobject.setDayInMonth(this.getValueAsInt(parser));
            return;
        }
        if (this.isTag(parser, "days")) {
            calendarobject.setDays(this.getValueAsInt(parser));
            return;
        }
        if (this.isTag(parser, "interval")) {
            calendarobject.setInterval(this.getValueAsInt(parser));
            return;
        }
        if (this.isTag(parser, "until")) {
            calendarobject.setUntil(this.getValueAsDate(parser));
            return;
        }
        if (this.isTag(parser, "occurrences")) {
            calendarobject.setOccurrence(this.getValueAsInt(parser));
            return;
        }
        if (this.isTag(parser, "start_date")) {
            calendarobject.setStartDate(this.getValueAsDate(parser));
            return;
        }
        if (this.isTag(parser, "end_date")) {
            calendarobject.setEndDate(this.getValueAsDate(parser));
            return;
        }
        if (this.isTag(parser, "recurrence_type")) {
            calendarobject.setRecurrenceType(this.parseRecurrenceType(this.getValue(parser)));
            return;
        }
        if (this.isTag(parser, "notify_participants")) {
            calendarobject.setNotification(this.getValueAsBoolean(parser));
            return;
        }
        if (this.isTag(parser, "title")) {
            calendarobject.setTitle(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "note")) {
            calendarobject.setNote(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "confirm")) {
            String s = this.getValue(parser);
            if ("accept".equals(s)) {
                calendarobject.setConfirm(1);
            } else if ("decline".equals(s)) {
                calendarobject.setConfirm(2);
            } else if ("tentative".equals(s)) {
                calendarobject.setConfirm(3);
            } else if ("none".equals(s)) {
                calendarobject.setConfirm(0);
            } else {
                throw WebdavExceptionCode.IO_ERROR.create("invalid value in confirm tag");
            }
            return;
        }
        if (this.isTag(parser, "confirm_message")) {
            calendarobject.setConfirmMessage(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "participants")) {
            this.parseElementParticipants(calendarobject, parser);
        } else {
            this.parseElementCommon(calendarobject, parser);
        }
    }

    protected int parseRecurrenceType(String value) throws Exception {
        if ("none".equals(value)) {
            return 0;
        }
        if ("daily".equals(value)) {
            return 1;
        }
        if ("weekly".equals(value)) {
            return 2;
        }
        if ("monthly".equals(value)) {
            return 3;
        }
        if ("yearly".equals(value)) {
            return 4;
        }
        throw WebdavExceptionCode.IO_ERROR.create("unknown value in recurrence_type: " + value);
    }

    protected void parseElementParticipants(CalendarObject calendarObj, XmlPullParser parser) throws OXException {
        Participants participants = new Participants();
        try {
            boolean isParticipant = true;
            while (isParticipant) {
                parser.nextTag();
                if (CalendarParser.isEnd(parser)) {
                    throw WebdavExceptionCode.IO_ERROR.create("invalid xml in participant!");
                }
                if (parser.getName().equals("participants") && parser.getEventType() == 3) {
                    isParticipant = false;
                    break;
                }
                if (this.isTag(parser, "user")) {
                    this.parseElementUser(parser, participants);
                    continue;
                }
                if (this.isTag(parser, "group")) {
                    this.parseElementGroup(parser, participants);
                    continue;
                }
                if (this.isTag(parser, "resource")) {
                    this.parseElementResource(parser, participants);
                    continue;
                }
                throw WebdavExceptionCode.IO_ERROR.create("unknown xml tag in permissions!");
            }
            calendarObj.setParticipants(participants.getList());
            calendarObj.setUsers(participants.getUsers());
        }
        catch (Exception exc) {
            throw new OXException((Throwable)exc);
        }
    }

    private void parseElementUser(XmlPullParser parser, Participants participants) throws Exception {
        Comparable<Participant> p = null;
        String confirm = parser.getAttributeValue("http://www.open-xchange.org", "confirm");
        String external = parser.getAttributeValue("http://www.open-xchange.org", "external");
        boolean isExternal = false;
        if (external != null && external.equals("true")) {
            isExternal = true;
        }
        if (isExternal) {
            String mail = parser.getAttributeValue("http://www.open-xchange.org", "mail");
            String displayName = parser.getAttributeValue("http://www.open-xchange.org", "displayname");
            p = new ExternalUserParticipant(mail);
            p.setDisplayName(displayName);
            this.getValue(parser);
        } else {
            int userId = this.getValueAsInt(parser);
            UserParticipant userparticipant = new UserParticipant(userId);
            if (confirm != null) {
                if ("accept".equals(confirm)) {
                    userparticipant.setConfirm(1);
                } else if ("decline".equals(confirm)) {
                    userparticipant.setConfirm(2);
                } else if ("tentative".equals(confirm)) {
                    userparticipant.setConfirm(3);
                } else if ("none".equals(confirm)) {
                    userparticipant.setConfirm(0);
                } else {
                    throw WebdavExceptionCode.IO_ERROR.create("unknown value in confirm attribute: " + confirm);
                }
            }
            participants.add(userparticipant);
            p = userparticipant;
        }
        participants.add((Participant)((Object)p));
    }

    private void parseElementGroup(XmlPullParser parser, Participants participants) throws Exception {
        Comparable<Participant> p = null;
        String external = parser.getAttributeValue("http://www.open-xchange.org", "external");
        int id = this.getValueAsInt(parser);
        boolean isExternal = false;
        if (external != null && external.equals("true")) {
            isExternal = true;
        }
        if (isExternal) {
            String displayName = parser.getAttributeValue("http://www.open-xchange.org", "displayname");
            String mail = parser.getAttributeValue("http://www.open-xchange.org", "mail");
            p = new ExternalGroupParticipant(mail);
            p.setDisplayName(displayName);
        } else {
            p = new GroupParticipant(id);
        }
        participants.add((Participant)((Object)p));
    }

    private void parseElementResource(XmlPullParser parser, Participants participants) throws Exception {
        ResourceParticipant p = new ResourceParticipant(this.getValueAsInt(parser));
        participants.add(p);
    }
}

