/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.regex;

public final class RegexUtility {
    private RegexUtility() {
    }

    public static String quote(String s) {
        String slashE = "\\E";
        int slashEIndex = s.indexOf("\\E");
        if (slashEIndex == -1) {
            return new StringBuilder(4 + s.length()).append("\\Q").append(s).append("\\E").toString();
        }
        StringBuilder sb = new StringBuilder(s.length() << 1);
        sb.append("\\Q");
        slashEIndex = 0;
        int current = 0;
        while ((slashEIndex = s.indexOf("\\E", current)) != -1) {
            sb.append(s.substring(current, slashEIndex));
            current = slashEIndex + 2;
            sb.append("\\E\\\\E\\Q");
        }
        sb.append(s.substring(current, s.length()));
        sb.append("\\E");
        return sb.toString();
    }

    public static String concat(String regex, String ... regexes) {
        int length = regex.length();
        for (int i = 0; i < regexes.length; ++i) {
            length += regexes[i].length();
        }
        StringBuilder sb = new StringBuilder(length).append(regex);
        for (int i = 0; i < regexes.length; ++i) {
            sb.append(regexes[i]);
        }
        return sb.toString();
    }

    public static String OR(String regex1, String regex2) {
        return new StringBuilder(regex1.length() + regex2.length() + 1).append(regex1).append('|').append(regex2).toString();
    }

    public static String optional(String regex) {
        return RegexUtility.optional(regex, QuantifierType.GREEDY, GroupType.NONE);
    }

    public static String optional(String regex, GroupType groupType) {
        return RegexUtility.optional(regex, QuantifierType.GREEDY, groupType);
    }

    public static String optional(String regex, QuantifierType qt, GroupType groupType) {
        if (GroupType.NONE.equals((Object)groupType)) {
            return new StringBuilder(regex.length() + 2).append(regex).append('?').append(qt.getAppendix()).toString();
        }
        return RegexUtility._optional(regex, qt, groupType);
    }

    private static String _optional(String regex, QuantifierType qt, GroupType groupType) {
        return new StringBuilder(regex.length() + 7).append(groupType.getOpeningParenthesis()).append(regex).append(')').append('?').append(qt.getAppendix()).toString();
    }

    public static String group(String regex, boolean capturing) {
        return RegexUtility._group(regex, capturing ? GroupType.CAPTURING : GroupType.NON_CAPTURING);
    }

    public static String group(String regex, GroupType groupType) {
        if (GroupType.NONE.equals((Object)groupType)) {
            return regex;
        }
        return RegexUtility._group(regex, groupType);
    }

    private static String _group(String regex, GroupType groupType) {
        return new StringBuilder(regex.length() + 5).append(groupType.getOpeningParenthesis()).append(regex).append(')').toString();
    }

    public static String oneOrMoreTimes(String regex) {
        return RegexUtility.oneOrMoreTimes(regex, QuantifierType.GREEDY, GroupType.NONE);
    }

    public static String oneOrMoreTimes(String regex, GroupType groupType) {
        return RegexUtility.oneOrMoreTimes(regex, QuantifierType.GREEDY, groupType);
    }

    public static String oneOrMoreTimes(String regex, QuantifierType qt, GroupType groupType) {
        if (GroupType.NONE.equals((Object)groupType)) {
            return new StringBuilder(regex.length() + 2).append(regex).append('+').append(qt.getAppendix()).toString();
        }
        return RegexUtility._oneOrMoreTimes(regex, qt, groupType);
    }

    private static String _oneOrMoreTimes(String regex, QuantifierType qt, GroupType groupType) {
        return new StringBuilder(regex.length() + 7).append(groupType.getOpeningParenthesis()).append(regex).append(')').append('+').append(qt.getAppendix()).toString();
    }

    public static String zeroOrMoreTimes(String regex) {
        return RegexUtility.zeroOrMoreTimes(regex, QuantifierType.GREEDY, GroupType.NONE);
    }

    public static String zeroOrMoreTimes(String regex, GroupType groupType) {
        return RegexUtility.zeroOrMoreTimes(regex, QuantifierType.GREEDY, groupType);
    }

    public static String zeroOrMoreTimes(String regex, QuantifierType qt, GroupType groupType) {
        if (GroupType.NONE.equals((Object)groupType)) {
            return new StringBuilder(regex.length() + 2).append(regex).append('*').append(qt.getAppendix()).toString();
        }
        return RegexUtility._zeroOrMoreTimes(regex, qt, groupType);
    }

    private static String _zeroOrMoreTimes(String regex, QuantifierType qt, GroupType groupType) {
        return new StringBuilder(regex.length() + 6).append(groupType.getOpeningParenthesis()).append(regex).append(')').append('*').append(qt.getAppendix()).toString();
    }

    public static String exactlyNTimes(String regex, int n) {
        return RegexUtility.exactlyNTimes(regex, n, QuantifierType.GREEDY, GroupType.NONE);
    }

    public static String exactlyNTimes(String regex, int n, GroupType groupType) {
        return RegexUtility.exactlyNTimes(regex, n, QuantifierType.GREEDY, groupType);
    }

    public static String exactlyNTimes(String regex, int n, QuantifierType qt, GroupType groupType) {
        if (GroupType.NONE.equals((Object)groupType)) {
            return new StringBuilder(regex.length() + 5).append(regex).append('{').append(n).append('}').append(qt.getAppendix()).toString();
        }
        return RegexUtility._exactlyNTimes(regex, n, qt, groupType);
    }

    private static String _exactlyNTimes(String regex, int n, QuantifierType qt, GroupType groupType) {
        return new StringBuilder(regex.length() + 9).append(groupType.getOpeningParenthesis()).append(regex).append(')').append('{').append(n).append('}').append(qt.getAppendix()).toString();
    }

    public static String atLeastNTimes(String regex, int n) {
        return RegexUtility.atLeastNTimes(regex, n, QuantifierType.GREEDY, GroupType.NONE);
    }

    public static String atLeastNTimes(String regex, int n, GroupType groupType) {
        return RegexUtility.atLeastNTimes(regex, n, QuantifierType.GREEDY, groupType);
    }

    public static String atLeastNTimes(String regex, int n, QuantifierType qt, GroupType groupType) {
        if (GroupType.NONE.equals((Object)groupType)) {
            return new StringBuilder(regex.length() + 6).append(regex).append('{').append(n).append(',').append('}').append(qt.getAppendix()).toString();
        }
        return RegexUtility._atLeastNTimes(regex, n, qt, groupType);
    }

    private static String _atLeastNTimes(String regex, int n, QuantifierType qt, GroupType groupType) {
        return new StringBuilder(regex.length() + 10).append(groupType.getOpeningParenthesis()).append(regex).append(')').append('{').append(n).append(',').append('}').append(qt.getAppendix()).toString();
    }

    public static String atLeastNButNotMoreThanMTimes(String regex, int n, int m) {
        return RegexUtility.atLeastNButNotMoreThanMTimes(regex, n, m, QuantifierType.GREEDY, GroupType.NONE);
    }

    public static String atLeastNButNotMoreThanMTimes(String regex, int n, int m, GroupType groupType) {
        return RegexUtility.atLeastNButNotMoreThanMTimes(regex, n, m, QuantifierType.GREEDY, groupType);
    }

    public static String atLeastNButNotMoreThanMTimes(String regex, int n, int m, QuantifierType qt, GroupType groupType) {
        if (GroupType.NONE.equals((Object)groupType)) {
            return new StringBuilder(regex.length() + 8).append(regex).append('{').append(n).append(',').append(m).append('}').append(qt.getAppendix()).toString();
        }
        return RegexUtility._atLeastNButNotMoreThanMTimes(regex, n, m, qt, groupType);
    }

    private static String _atLeastNButNotMoreThanMTimes(String regex, int n, int m, QuantifierType qt, GroupType groupType) {
        return new StringBuilder(regex.length() + 12).append(groupType.getOpeningParenthesis()).append(regex).append(')').append('{').append(n).append(',').append(m).append('}').append(qt.getAppendix()).toString();
    }

    public static enum QuantifierType {
        GREEDY(""),
        RELUCTANT("?"),
        POSSESSIVE("+");

        private final String appendix;

        private QuantifierType(String appendix) {
            this.appendix = appendix;
        }

        String getAppendix() {
            return this.appendix;
        }

        public String toString() {
            return this.appendix;
        }
    }

    public static enum GroupType {
        NONE(""),
        CAPTURING("("),
        NON_CAPTURING("(?:"),
        ZERO_WIDTH_POSITIVE_LOOKAHEAD("(?="),
        ZERO_WIDTH_NEGATIVE_LOOKAHEAD("(?!"),
        ZERO_WIDTH_POSITIVE_LOOKBEHIND("(?<="),
        ZERO_WIDTH_NEGATIVE_LOOKBEHIND("(?<!"),
        INDEPENDENT_NON_CAPTURING("(?>");

        private final String openingParenthesis;

        private GroupType(String openingParenthesis) {
            this.openingParenthesis = openingParenthesis;
        }

        String getOpeningParenthesis() {
            return this.openingParenthesis;
        }

        public String toString() {
            return new StringBuilder(6).append(this.openingParenthesis).append('X').append(')').toString();
        }
    }
}

