/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder;

import com.openexchange.api2.AppointmentSQLInterface;
import com.openexchange.cache.impl.FolderCacheManager;
import com.openexchange.contact.ContactService;
import com.openexchange.database.provider.DBPoolProvider;
import com.openexchange.database.provider.StaticDBPoolProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.AppointmentSqlFactoryService;
import com.openexchange.groupware.contact.ContactExceptionCodes;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.groupware.infostore.facade.impl.InfostoreFacadeImpl;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.tasks.Tasks;
import com.openexchange.groupware.tasks.TasksSQLImpl;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.server.impl.DBPool;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.oxfolder.InfoStoreFolderAdminHelper;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.oxfolder.OXFolderSQL;
import com.openexchange.tools.oxfolder.OXFolderUtility;
import com.openexchange.tools.session.ServerSessionAdapter;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class OXFolderAccess {
    private final Connection readCon;
    private final Context ctx;

    public OXFolderAccess(Context ctx) {
        this(null, ctx);
    }

    public OXFolderAccess(Connection readCon, Context ctx) {
        this.readCon = readCon;
        this.ctx = ctx;
    }

    public boolean exists(int folderId) throws OXException {
        try {
            this.getFolderObject(folderId);
            return true;
        }
        catch (OXException e) {
            if (OXFolderExceptionCode.isNotFound(e)) {
                return false;
            }
            throw e;
        }
    }

    public final FolderObject getFolderObject(int folderId) throws OXException {
        return this.getFolderObject(folderId, true);
    }

    public final FolderObject getFolderObject(int folderId, boolean fromCache) throws OXException {
        FolderObject fo = fromCache && FolderCacheManager.isEnabled() ? FolderCacheManager.getInstance().getFolderObject(folderId, true, this.ctx, this.readCon) : FolderObject.loadFolderObjectFromDB(folderId, this.ctx, this.readCon);
        return fo;
    }

    public final List<FolderObject> getFolderObjects(int[] folderIDs) throws OXException {
        ArrayList<FolderObject> retval = new ArrayList<FolderObject>(folderIDs.length);
        for (int fuid : folderIDs) {
            try {
                retval.add(this.getFolderObject(fuid));
            }
            catch (OXException e) {
                if (OXFolderExceptionCode.NOT_EXISTS.equals(e)) continue;
                throw e;
            }
        }
        return retval;
    }

    public final List<FolderObject> getFolderObjects(Collection<Integer> folderIDs) throws OXException {
        int size = folderIDs.size();
        ArrayList<FolderObject> retval = new ArrayList<FolderObject>(size);
        Iterator<Integer> iter = folderIDs.iterator();
        for (int i = 0; i < size; ++i) {
            try {
                retval.add(this.getFolderObject(iter.next()));
                continue;
            }
            catch (OXException e) {
                if (OXFolderExceptionCode.NOT_EXISTS.equals(e)) continue;
                throw e;
            }
        }
        return retval;
    }

    public final int getFolderType(int folderId, int userId) throws OXException {
        return this.getFolderObject(folderId).getType(userId);
    }

    public final int getFolderType(int folderId) throws OXException {
        return this.getFolderObject(folderId).getType();
    }

    public final int getFolderModule(int folderId) throws OXException {
        return this.getFolderObject(folderId).getModule();
    }

    public final int getFolderOwner(int folderId) throws OXException {
        return this.getFolderObject(folderId).getCreatedBy();
    }

    public final boolean isFolderShared(int folderId, int userId) throws OXException {
        return this.getFolderType(folderId, userId) == 3;
    }

    public final boolean isDefaultFolder(int folderId) throws OXException {
        return this.getFolderObject(folderId).isDefaultFolder();
    }

    public String getFolderName(int folderId) throws OXException {
        return this.getFolderObject(folderId).getFolderName();
    }

    public int getParentFolderID(int folderId) throws OXException {
        return this.getFolderObject(folderId).getParentFolderID();
    }

    public Date getFolderLastModified(int folderId) throws OXException {
        return this.getFolderObject(folderId).getLastModified();
    }

    public final EffectivePermission getFolderPermission(int folderId, int userId, UserConfiguration userConfig) throws OXException {
        try {
            FolderObject fo = this.getFolderObject(folderId);
            return fo.getEffectiveUserPermission(userId, userConfig, this.readCon);
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
    }

    public final EffectivePermission getFolderPermission(int folderId, int userId, UserPermissionBits userPermissionBits) throws OXException {
        try {
            FolderObject fo = this.getFolderObject(folderId);
            return fo.getEffectiveUserPermission(userId, userPermissionBits, this.readCon);
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
    }

    public final boolean isVisibleFor(int folderId, int userId, UserPermissionBits permissions) throws OXException {
        return this.isVisibleFor(folderId, userId, UserStorage.getInstance().getUser(userId, this.ctx).getGroups(), permissions);
    }

    public final boolean isVisibleFor(int folderId, int userId, int[] groups, UserPermissionBits permissions) throws OXException {
        if (null == groups) {
            return this.isVisibleFor(folderId, userId, permissions);
        }
        FolderObject fo = this.getFolderObject(folderId);
        if (null == this.readCon) {
            return fo.getEffectiveUserPermission(userId, permissions).isFolderVisible();
        }
        try {
            return fo.getEffectiveUserPermission(userId, permissions, this.readCon).isFolderVisible();
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
    }

    public final boolean isReadFolder(int folderId, int userId, UserPermissionBits permissions) throws OXException {
        return this.isReadFolder(folderId, userId, UserStorage.getInstance().getUser(userId, this.ctx).getGroups(), permissions);
    }

    public final boolean isReadFolder(int folderId, int userId, int[] groups, UserPermissionBits permissions) throws OXException {
        if (null == groups) {
            return this.isReadFolder(folderId, userId, permissions);
        }
        FolderObject fo = this.getFolderObject(folderId);
        if (null == this.readCon) {
            return fo.getEffectiveUserPermission(userId, permissions).getFolderPermission() >= 2;
        }
        try {
            return fo.getEffectiveUserPermission(userId, permissions, this.readCon).getFolderPermission() >= 2;
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
    }

    public FolderObject getDefaultFolder(int userId, int module) throws OXException {
        return this.getDefaultFolder(userId, module, -1);
    }

    public FolderObject getDefaultFolder(int userId, int module, int type) throws OXException {
        return this.getFolderObject(this.getDefaultFolderID(userId, module, type));
    }

    public int getDefaultFolderID(int userId, int module) throws OXException {
        return this.getDefaultFolderID(userId, module, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDefaultFolderID(int userId, int module, int type) throws OXException {
        try {
            int folderId;
            int n = folderId = -1 == type ? OXFolderSQL.getUserDefaultFolder(userId, module, this.readCon, this.ctx) : OXFolderSQL.getUserDefaultFolder(userId, module, type, this.readCon, this.ctx);
            if (-1 != folderId) {
                return folderId;
            }
            if (8 != module) {
                throw OXFolderExceptionCode.NO_DEFAULT_FOLDER_FOUND.create(OXFolderUtility.folderModule2String(module), userId, this.ctx.getContextId());
            }
            User user = UserStorage.getInstance().getUser(userId, this.ctx);
            if (user.isGuest()) {
                throw OXFolderExceptionCode.NO_DEFAULT_FOLDER_FOUND.create(OXFolderUtility.folderModule2String(module), userId, this.ctx.getContextId());
            }
            Connection wc = DBPool.pickupWriteable(this.ctx);
            boolean rollback = false;
            boolean created = false;
            try {
                wc.setAutoCommit(false);
                rollback = true;
                int n2 = folderId = -1 == type ? OXFolderSQL.getUserDefaultFolder(userId, module, wc, this.ctx) : OXFolderSQL.getUserDefaultFolder(userId, module, type, wc, this.ctx);
                if (-1 == folderId) {
                    int folderType = -1 == type ? 2 : type;
                    folderId = InfoStoreFolderAdminHelper.addDefaultFolder(wc, this.ctx.getContextId(), userId, folderType, user.getLocale());
                    created = true;
                }
                wc.commit();
                rollback = false;
            }
            finally {
                if (rollback) {
                    DBUtils.rollback(wc);
                }
                DBUtils.autocommit(wc);
                if (created) {
                    DBPool.closeWriterSilent(this.ctx, wc);
                } else {
                    DBPool.closeWriterAfterReading(this.ctx, wc);
                }
            }
            return folderId;
        }
        catch (OXException e) {
            throw e;
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(e, this.ctx.getContextId());
        }
    }

    public final boolean canDeleteAllObjectsInFolder(FolderObject folder, Session session, Context ctx) throws OXException {
        int userId = session.getUserId();
        UserConfiguration userConfig = UserConfigurationStorage.getInstance().getUserConfigurationSafe(userId, ctx);
        try {
            EffectivePermission oclPerm = folder.getEffectiveUserPermission(userId, userConfig, this.readCon);
            if (!((OCLPermission)oclPerm).isFolderVisible()) {
                return false;
            }
            if (((OCLPermission)oclPerm).canDeleteAllObjects()) {
                return true;
            }
            if (((OCLPermission)oclPerm).canDeleteOwnObjects()) {
                return !this.containsForeignObjects(folder, session, ctx);
            }
            return this.isEmpty(folder, session, ctx);
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException t) {
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, ctx.getContextId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean containsForeignObjects(FolderObject folder, Session session, Context ctx) throws OXException {
        try {
            int userId = session.getUserId();
            int module = folder.getModule();
            if (module == 1) {
                Tasks tasks2 = Tasks.getInstance();
                if (null != this.readCon) return tasks2.containsNotSelfCreatedTasks(session, this.readCon, folder.getObjectID());
                Connection rc = null;
                try {
                    rc = DBPool.pickup(ctx);
                    boolean bl = tasks2.containsNotSelfCreatedTasks(session, rc, folder.getObjectID());
                    return bl;
                }
                finally {
                    if (null != rc) {
                        DBPool.closeReaderSilent(ctx, rc);
                    }
                }
            }
            if (module == 2) {
                AppointmentSQLInterface calSql = ServerServiceRegistry.getInstance().getService(AppointmentSqlFactoryService.class).createAppointmentSql(session);
                if (this.readCon != null) return calSql.checkIfFolderContainsForeignObjects(userId, folder.getObjectID(), this.readCon);
                return calSql.checkIfFolderContainsForeignObjects(userId, folder.getObjectID());
            }
            if (module == 3) {
                ContactService contactService = ServerServiceRegistry.getInstance().getService(ContactService.class, true);
                return contactService.containsForeignObjectInFolder(session, String.valueOf(folder.getObjectID()));
            }
            if (module != 8) {
                throw OXFolderExceptionCode.UNKNOWN_MODULE.create(OXFolderUtility.folderModule2String(module), ctx.getContextId());
            }
            InfostoreFacadeImpl db = new InfostoreFacadeImpl(this.readCon == null ? new DBPoolProvider() : new StaticDBPoolProvider(this.readCon));
            return db.hasFolderForeignObjects(folder.getObjectID(), ServerSessionAdapter.valueOf(session, ctx));
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException t) {
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, ctx.getContextId());
        }
    }

    public final boolean isEmpty(FolderObject folder, Session session, Context ctx) throws OXException {
        try {
            int userId = session.getUserId();
            int module = folder.getModule();
            switch (module) {
                case 1: {
                    Tasks tasks2 = Tasks.getInstance();
                    return this.readCon == null ? tasks2.isFolderEmpty(ctx, folder.getObjectID()) : tasks2.isFolderEmpty(ctx, this.readCon, folder.getObjectID());
                }
                case 2: {
                    AppointmentSQLInterface calSql = ServerServiceRegistry.getInstance().getService(AppointmentSqlFactoryService.class).createAppointmentSql(session);
                    return this.readCon == null ? calSql.isFolderEmpty(userId, folder.getObjectID()) : calSql.isFolderEmpty(userId, folder.getObjectID(), this.readCon);
                }
                case 3: {
                    ContactService contactService = ServerServiceRegistry.getInstance().getService(ContactService.class, true);
                    return contactService.isFolderEmpty(session, String.valueOf(folder.getObjectID()));
                }
                case 8: {
                    InfostoreFacadeImpl db = new InfostoreFacadeImpl(this.readCon == null ? new DBPoolProvider() : new StaticDBPoolProvider(this.readCon));
                    return db.isFolderEmpty(folder.getObjectID(), ctx);
                }
            }
            throw OXFolderExceptionCode.UNKNOWN_MODULE.create(OXFolderUtility.folderModule2String(module), ctx.getContextId());
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException t) {
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, ctx.getContextId());
        }
    }

    public long getItemCount(FolderObject folder, Session session, Context ctx) throws OXException {
        try {
            session.getUserId();
            switch (folder.getModule()) {
                case 1: {
                    return new TasksSQLImpl(session).countTasks(folder);
                }
                case 2: {
                    AppointmentSqlFactoryService service = ServerServiceRegistry.getInstance().getService(AppointmentSqlFactoryService.class);
                    AppointmentSQLInterface calSql = service.createAppointmentSql(session);
                    return calSql.countObjectsInFolder(folder.getObjectID());
                }
                case 3: {
                    try {
                        ContactService contactService = ServerServiceRegistry.getInstance().getService(ContactService.class);
                        return contactService.countContacts(session, Integer.toString(folder.getObjectID()));
                    }
                    catch (OXException e) {
                        if (ContactExceptionCodes.NO_ACCESS_PERMISSION.equals(e)) {
                            return 0L;
                        }
                        throw e;
                    }
                }
                case 8: {
                    try {
                        InfostoreFacadeImpl db = new InfostoreFacadeImpl(this.readCon == null ? new DBPoolProvider() : new StaticDBPoolProvider(this.readCon));
                        return db.countDocuments(folder.getObjectID(), ServerSessionAdapter.valueOf(session, ctx));
                    }
                    catch (OXException e) {
                        if (InfostoreExceptionCodes.NO_READ_PERMISSION.equals(e)) {
                            return 0L;
                        }
                        throw e;
                    }
                }
            }
            return -1L;
        }
        catch (RuntimeException t) {
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, ctx.getContextId());
        }
    }
}

