/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.impl.ContextImpl;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.java.Autoboxing;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.tools.oxfolder.OXFolderAdminHelper;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.oxfolder.OXFolderSQL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InfoStoreFolderAdminHelper {
    private static final Logger LOG = LoggerFactory.getLogger(InfoStoreFolderAdminHelper.class);

    private InfoStoreFolderAdminHelper() {
    }

    public static void addDefaultFolders(Connection connection, int contextID, int userID) throws OXException {
        int userFolderID = InfoStoreFolderAdminHelper.addDefaultFolder(connection, contextID, userID, 10, 2, false, null);
        InfoStoreFolderAdminHelper.addDefaultFolder(connection, contextID, userID, 9, 16, false, null);
        int documentsFolderID = InfoStoreFolderAdminHelper.addDefaultFolder(connection, contextID, userID, userFolderID, 21, false, null);
        InfoStoreFolderAdminHelper.addDefaultFolder(connection, contextID, userID, documentsFolderID, 24, false, null);
        InfoStoreFolderAdminHelper.addDefaultFolder(connection, contextID, userID, userFolderID, 20, false, null);
        InfoStoreFolderAdminHelper.addDefaultFolder(connection, contextID, userID, userFolderID, 22, false, null);
        InfoStoreFolderAdminHelper.addDefaultFolder(connection, contextID, userID, userFolderID, 23, false, null);
    }

    public static int addDefaultFolder(Connection connection, int contextID, int userID, int type, Locale locale) throws OXException {
        try {
            int parentFolderID = InfoStoreFolderAdminHelper.getParentDefaultFolderID(connection, contextID, userID, type, locale);
            boolean considerExisting = 2 != type && 16 != type;
            return InfoStoreFolderAdminHelper.addDefaultFolder(connection, contextID, userID, parentFolderID, type, considerExisting, locale);
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
    }

    private static int addDefaultFolder(Connection connection, int contextID, int userID, int parentFolderID, int type, boolean considerExisting, Locale locale) throws OXException {
        try {
            String folderName = InfoStoreFolderAdminHelper.getDefaultFolderName(connection, contextID, userID, type);
            ContextImpl context = new ContextImpl(contextID);
            if (considerExisting) {
                String localizedFolderName;
                int existingFolderID = OXFolderSQL.lookUpFolder(parentFolderID, folderName, 8, connection, context);
                if (-1 != existingFolderID) {
                    OXFolderSQL.markAsDefaultFolder(connection, context, existingFolderID, type, folderName, System.currentTimeMillis());
                    LOG.info("Marked existing infostore folder '{}' [type={}, id={}] as default folder for user {} in context {}.", new Object[]{folderName, Autoboxing.I((int)type), Autoboxing.I((int)existingFolderID), Autoboxing.I((int)userID), Autoboxing.I((int)contextID)});
                    OXFolderSQL.updateFolderType(connection, context, type, OXFolderSQL.getSubfolderIDs(existingFolderID, connection, context, true));
                    return existingFolderID;
                }
                if (null != locale && !folderName.equals(localizedFolderName = InfoStoreFolderAdminHelper.getLocalizedDefaultFolderName(connection, locale, contextID, userID, type)) && -1 != (existingFolderID = OXFolderSQL.lookUpFolder(parentFolderID, localizedFolderName, 8, connection, context))) {
                    OXFolderSQL.markAsDefaultFolder(connection, context, existingFolderID, type, folderName, System.currentTimeMillis());
                    LOG.info("Marked existing infostore folder '{}' [type={}, id={}] as default folder for user {} in context {}.", new Object[]{localizedFolderName, Autoboxing.I((int)type), Autoboxing.I((int)existingFolderID), Autoboxing.I((int)userID), Autoboxing.I((int)contextID)});
                    OXFolderSQL.updateFolderType(connection, context, type, OXFolderSQL.getSubfolderIDs(existingFolderID, connection, context, true));
                    return existingFolderID;
                }
            }
            FolderObject folder = InfoStoreFolderAdminHelper.prepareDefaultFolder(userID, parentFolderID, type, folderName);
            int folderID = OXFolderSQL.getNextSerialForAdmin(context, connection);
            OXFolderSQL.insertDefaultFolderSQL(folderID, userID, folder, System.currentTimeMillis(), context, connection);
            LOG.info("Default infostore folder '{}' [type={}, id={}] for user {} in context {} created successfully.", new Object[]{folderName, Autoboxing.I((int)type), Autoboxing.I((int)folderID), Autoboxing.I((int)userID), Autoboxing.I((int)contextID)});
            return folderID;
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
    }

    private static int getOrCreateDefaultFolderID(Connection connection, int contextID, int userID, int type, boolean createAsNeeded, Locale locale) throws OXException, SQLException {
        ContextImpl context = new ContextImpl(contextID);
        int folderID = OXFolderSQL.getUserDefaultFolder(userID, 8, type, connection, context);
        if (-1 == folderID && createAsNeeded) {
            folderID = InfoStoreFolderAdminHelper.addDefaultFolder(connection, contextID, userID, type, locale);
        }
        return folderID;
    }

    private static String getDefaultFolderName(Connection connection, int contextID, int userID, int type) throws OXException, SQLException {
        switch (type) {
            case 2: {
                ContextImpl context = new ContextImpl(contextID);
                String name = OXFolderAdminHelper.getUserDisplayName(userID, contextID, connection);
                int resetLen = name.length();
                int count = 0;
                while (-1 != OXFolderSQL.lookUpFolder(10, name, 8, connection, context)) {
                    name = name.substring(0, resetLen) + " (" + String.valueOf(++count) + ')';
                }
                return name;
            }
            case 16: {
                return "Trash";
            }
            case 21: {
                return "Documents";
            }
            case 20: {
                return "Pictures";
            }
            case 22: {
                return "Music";
            }
            case 23: {
                return "Videos";
            }
            case 24: {
                return "Templates";
            }
        }
        throw OXFolderExceptionCode.INVALID_TYPE.create(0, type, contextID);
    }

    private static String getLocalizedDefaultFolderName(Connection connection, Locale locale, int contextID, int userID, int type) throws OXException, SQLException {
        switch (type) {
            case 2: {
                ContextImpl context = new ContextImpl(contextID);
                String name = OXFolderAdminHelper.getUserDisplayName(userID, contextID, connection);
                int resetLen = name.length();
                int count = 0;
                while (-1 != OXFolderSQL.lookUpFolder(10, name, 8, connection, context)) {
                    name = name.substring(0, resetLen) + " (" + String.valueOf(++count) + ')';
                }
                return name;
            }
            case 16: {
                return StringHelper.valueOf(locale).getString("Trash");
            }
            case 21: {
                return StringHelper.valueOf(locale).getString("Documents");
            }
            case 20: {
                return StringHelper.valueOf(locale).getString("Pictures");
            }
            case 22: {
                return StringHelper.valueOf(locale).getString("Music");
            }
            case 23: {
                return StringHelper.valueOf(locale).getString("Videos");
            }
            case 24: {
                return StringHelper.valueOf(locale).getString("Templates");
            }
        }
        throw OXFolderExceptionCode.INVALID_TYPE.create(0, type, contextID);
    }

    private static int getParentDefaultFolderID(Connection connection, int contextID, int userID, int type, Locale locale) throws OXException, SQLException {
        switch (type) {
            case 2: {
                return 10;
            }
            case 16: {
                return 9;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                return InfoStoreFolderAdminHelper.getOrCreateDefaultFolderID(connection, contextID, userID, 2, true, locale);
            }
            case 24: {
                return InfoStoreFolderAdminHelper.getOrCreateDefaultFolderID(connection, contextID, userID, 21, true, locale);
            }
        }
        throw OXFolderExceptionCode.INVALID_TYPE.create(0, type, contextID);
    }

    private static FolderObject prepareDefaultFolder(int userID, int parentFolderID, int type, String name) {
        FolderObject folder = new FolderObject();
        folder.setPermissionsAsArray(new OCLPermission[]{InfoStoreFolderAdminHelper.getAdminPermissions(userID)});
        folder.setDefaultFolder(true);
        folder.setParentFolderID(parentFolderID);
        folder.setType(type);
        folder.setFolderName(name);
        folder.setModule(8);
        return folder;
    }

    private static OCLPermission getAdminPermissions(int userID) {
        OCLPermission permission = new OCLPermission();
        permission.setEntity(userID);
        permission.setGroupPermission(false);
        permission.setAllPermission(128, 128, 128, 128);
        permission.setFolderAdmin(true);
        return permission;
    }
}

