/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.images.scheduler;

import com.openexchange.config.ConfigurationService;
import com.openexchange.tools.images.osgi.Services;
import com.openexchange.tools.images.scheduler.SchedulerThreadFactory;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Scheduler {
    static final Logger LOGGER = LoggerFactory.getLogger(Scheduler.class);
    static final TaskManager POISON = new TaskManager(){

        @Override
        public Runnable remove() {
            return null;
        }

        @Override
        public void add(Runnable task) {
        }

        @Override
        public Object getExecuterKey() {
            return null;
        }
    };
    private static volatile Scheduler instance;
    private final ExecutorService pool;
    private final int numThreads;
    final BlockingDeque<TaskManager> roundRobinQueue;
    final Map<Object, TaskManager> taskManagers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void shutDown() {
        Scheduler tmp = instance;
        if (null == tmp) return;
        Class<Scheduler> clazz = Scheduler.class;
        synchronized (Scheduler.class) {
            tmp = instance;
            if (null == tmp) return;
            tmp.stop();
            instance = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Scheduler getInstance() {
        Scheduler tmp = instance;
        if (null != tmp) return tmp;
        Class<Scheduler> clazz = Scheduler.class;
        synchronized (Scheduler.class) {
            tmp = instance;
            if (null != tmp) return tmp;
            instance = tmp = new Scheduler();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    private Scheduler() {
        int numThreads;
        ConfigurationService configService = Services.getService(ConfigurationService.class);
        int defaultNumThreads = 10;
        this.numThreads = numThreads = null == configService ? defaultNumThreads : configService.getIntProperty("com.openexchange.tools.images.scheduler.numThreads", defaultNumThreads);
        ThreadPoolExecutor newPool = (ThreadPoolExecutor)Executors.newFixedThreadPool(numThreads, new SchedulerThreadFactory());
        newPool.prestartAllCoreThreads();
        this.pool = newPool;
        this.taskManagers = new HashMap<Object, TaskManager>(256);
        this.roundRobinQueue = new LinkedBlockingDeque<TaskManager>();
        int i = numThreads;
        while (i-- > 0) {
            newPool.execute(new Selector());
        }
    }

    private void stop() {
        int i = this.numThreads;
        while (i-- > 0) {
            this.roundRobinQueue.offerFirst(POISON);
        }
        try {
            this.pool.shutdownNow();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Object optKey, Runnable task) {
        Object key = null == optKey ? Thread.currentThread() : optKey;
        TaskManagerImpl newManager = null;
        Map<Object, TaskManager> map = this.taskManagers;
        synchronized (map) {
            TaskManager existingManager = this.taskManagers.get(key);
            if (existingManager == null) {
                newManager = new TaskManagerImpl(task, key);
                this.taskManagers.put(key, newManager);
            } else {
                existingManager.add(task);
            }
        }
        if (null != newManager) {
            this.roundRobinQueue.offerLast(newManager);
        }
        return true;
    }

    private final class TaskManagerImpl
    implements TaskManager {
        private final LinkedList<Runnable> tasks = new LinkedList();
        private final Object taskKey;

        TaskManagerImpl(Runnable task, Object key) {
            this.taskKey = key;
            this.tasks.offer(task);
        }

        @Override
        public Object getExecuterKey() {
            return this.taskKey;
        }

        @Override
        public Runnable remove() {
            return this.tasks.poll();
        }

        @Override
        public void add(Runnable task) {
            this.tasks.offer(task);
        }
    }

    private final class Selector
    implements Runnable {
        Selector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread currentThread = Thread.currentThread();
            try {
                boolean aborted = false;
                while (!aborted) {
                    try {
                        Runnable task;
                        TaskManager manager = Scheduler.this.roundRobinQueue.takeFirst();
                        if (POISON == manager) {
                            aborted = true;
                            continue;
                        }
                        Map<Object, TaskManager> map = Scheduler.this.taskManagers;
                        synchronized (map) {
                            task = manager.remove();
                            if (null == task) {
                                Scheduler.this.taskManagers.remove(manager.getExecuterKey());
                            }
                        }
                        if (null != task) {
                            Scheduler.this.roundRobinQueue.offerLast(manager);
                            task.run();
                        }
                        aborted = currentThread.isInterrupted();
                    }
                    catch (InterruptedException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        LOGGER.info("Image transformation failed", (Throwable)e);
                    }
                }
            }
            catch (InterruptedException e) {
                currentThread.interrupt();
                LOGGER.info("Image transformation selector '{}' interrupted", (Object)currentThread.getName(), (Object)e);
            }
            LOGGER.info("Image transformation selector '{}' terminated", (Object)currentThread.getName());
        }
    }

    private static interface TaskManager {
        public Runnable remove();

        public void add(Runnable var1);

        public Object getExecuterKey();
    }
}

