/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.server.services;

import com.openexchange.configuration.ServerConfig;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentConfig;
import com.openexchange.groupware.filestore.FilestoreStorage;
import com.openexchange.groupware.infostore.InfostoreConfig;
import com.openexchange.groupware.upload.quotachecker.MailUploadQuotaChecker;
import com.openexchange.jslob.DefaultJSlob;
import com.openexchange.jslob.JSlob;
import com.openexchange.jslob.JSlobId;
import com.openexchange.jslob.shared.SharedJSlobService;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.session.Session;
import com.openexchange.tools.file.QuotaFileStorage;
import com.openexchange.tools.servlet.OXJSONExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import org.json.JSONException;
import org.json.JSONObject;

public class SharedInfostoreJSlob
implements SharedJSlobService {
    private final String serviceId;
    private final String id;

    public SharedInfostoreJSlob() {
        this.serviceId = "com.openexchange.jslob.config";
        this.id = "io.ox/core/properties";
    }

    public JSlob getJSlob(Session session) throws OXException {
        try {
            ServerSession serverSession = ServerSessionAdapter.valueOf(session);
            JSONObject json = new JSONObject(10);
            json.put("maxBodySize", ServerConfig.getInt(ServerConfig.Property.MAX_BODY_SIZE));
            json.put("attachmentMaxUploadSize", AttachmentConfig.getMaxUploadSize());
            if (serverSession.getUserPermissionBits().hasInfostore()) {
                json.put("infostoreMaxUploadSize", InfostoreConfig.getMaxUploadSize());
                QuotaFileStorage fs = QuotaFileStorage.getInstance(FilestoreStorage.createURI(serverSession.getContext()), serverSession.getContext());
                json.put("infostoreQuota", fs.getQuota());
                json.put("infostoreUsage", fs.getUsage());
            }
            if (serverSession.getUserPermissionBits().hasWebMail()) {
                UserSettingMail userSettingMail = UserSettingMailStorage.getInstance().getUserSettingMail(session.getUserId(), serverSession.getContext());
                MailUploadQuotaChecker mailUploadQuotaChecker = new MailUploadQuotaChecker(userSettingMail);
                json.put("attachmentQuota", mailUploadQuotaChecker.getQuotaMax());
                json.put("attachmentQuotaPerFile", mailUploadQuotaChecker.getFileQuotaMax());
            }
            DefaultJSlob jslob = new DefaultJSlob();
            jslob.setJsonObject(json);
            jslob.setId(new JSlobId(this.serviceId, "io.ox/core/properties", session.getUserId(), session.getContextId()));
            return jslob;
        }
        catch (JSONException e) {
            throw OXJSONExceptionCodes.JSON_BUILD_ERROR.create(e, new Object[0]);
        }
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getId() {
        return this.id;
    }
}

