/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.server.reloadable;

import com.openexchange.config.ConfigurationService;
import com.openexchange.config.Reloadable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public final class GenericReloadable
implements Reloadable {
    private static final GenericReloadable INSTANCE = new GenericReloadable();
    private final List<Reloadable> reloadables = new CopyOnWriteArrayList<Reloadable>();

    public static GenericReloadable getInstance() {
        return INSTANCE;
    }

    private GenericReloadable() {
    }

    public void addReloadable(Reloadable reloadable) {
        this.reloadables.add(reloadable);
    }

    public void reloadConfiguration(ConfigurationService configService) {
        for (Reloadable reloadable : this.reloadables) {
            reloadable.reloadConfiguration(configService);
        }
    }

    public Map<String, String[]> getConfigFileNames() {
        return Collections.emptyMap();
    }
}

