/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount;

import com.openexchange.exception.OXException;
import com.openexchange.java.Charsets;
import com.openexchange.mail.FullnameArgument;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.mailaccount.UnifiedInboxManagement;
import com.openexchange.mailaccount.utils.QuotedPrintableCodec;
import java.nio.charset.UnsupportedCharsetException;
import java.util.BitSet;
import org.apache.commons.codec.DecoderException;

public final class UnifiedInboxUID {
    private int accountId;
    private String fullName;
    private String id;
    private String uidl;
    private static final BitSet PRINTABLE_CHARS;

    public static FullnameArgument parsePossibleNestedFullName(String nestedFullName) {
        if (!UnifiedInboxUID.startsWithKnownFullname(nestedFullName)) {
            return null;
        }
        String fn = nestedFullName.substring(nestedFullName.indexOf(47) + 1);
        return MailFolderUtility.prepareMailFolderParam(fn);
    }

    public static FullnameArgument parseNestedFullName(String nestedFullName) throws OXException {
        FullnameArgument ret = UnifiedInboxUID.parsePossibleNestedFullName(nestedFullName);
        if (null == ret) {
            throw MailExceptionCode.FOLDER_NOT_FOUND.create(MailFolderUtility.prepareMailFolderParam(nestedFullName).getFullname());
        }
        return ret;
    }

    private static boolean startsWithKnownFullname(String fullName) {
        for (String knownFullname : UnifiedInboxManagement.KNOWN_FOLDERS) {
            if (!fullName.startsWith(knownFullname)) continue;
            return true;
        }
        return false;
    }

    public UnifiedInboxUID() {
    }

    public UnifiedInboxUID(int accountId, String fullName, String id) {
        this.setUID(accountId, fullName, id);
    }

    public UnifiedInboxUID(String unifiedINBOXUID) throws OXException {
        this.setUIDString(unifiedINBOXUID);
    }

    public UnifiedInboxUID setUID(int accountId, String fullName, String id) {
        this.accountId = accountId;
        this.fullName = fullName;
        this.id = id;
        String mailPath = MailPath.getMailPath(accountId, fullName, id);
        this.uidl = UnifiedInboxUID.encodeQP(mailPath);
        return this;
    }

    public UnifiedInboxUID setUIDString(String unifiedINBOXUID) throws OXException {
        String decoded = UnifiedInboxUID.decodeQP(unifiedINBOXUID);
        MailPath mailPath = new MailPath(decoded);
        this.accountId = mailPath.getAccountId();
        this.fullName = mailPath.getFolder();
        this.id = mailPath.getMailID();
        this.uidl = decoded;
        return this;
    }

    public int getAccountId() {
        return this.accountId;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return this.uidl;
    }

    private static String encodeQP(String string) {
        try {
            return Charsets.toAsciiString((byte[])QuotedPrintableCodec.encodeQuotedPrintable(PRINTABLE_CHARS, string.getBytes(Charsets.UTF_8)));
        }
        catch (UnsupportedCharsetException e) {
            throw new IllegalStateException(e);
        }
    }

    private static String decodeQP(String string) {
        try {
            return new String(QuotedPrintableCodec.decodeQuotedPrintable(Charsets.toAsciiBytes((String)string)), Charsets.UTF_8);
        }
        catch (DecoderException e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        int i;
        PRINTABLE_CHARS = new BitSet(256);
        for (i = 48; i <= 57; ++i) {
            PRINTABLE_CHARS.set(i);
        }
        for (i = 71; i <= 90; ++i) {
            PRINTABLE_CHARS.set(i);
        }
        for (i = 103; i <= 122; ++i) {
            PRINTABLE_CHARS.set(i);
        }
    }
}

