/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.parser;

import com.openexchange.ajax.container.ThresholdFileHolder;
import com.openexchange.exception.OXException;
import com.openexchange.i18n.LocaleTools;
import com.openexchange.java.Charsets;
import com.openexchange.java.CountingOutputStream;
import com.openexchange.java.Strings;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.api.MailConfig;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.ContentDisposition;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MessageHeaders;
import com.openexchange.mail.mime.MimeDefaultSession;
import com.openexchange.mail.mime.MimeFilter;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.MimeSmilFixer;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.mail.mime.TNEFBodyPart;
import com.openexchange.mail.mime.converters.FileBackedMimeMessage;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.mime.dataobjects.MimeMailPart;
import com.openexchange.mail.mime.dataobjects.MimeRawSource;
import com.openexchange.mail.mime.datasource.MessageDataSource;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.parser.ContentProvider;
import com.openexchange.mail.parser.MailMessageHandler;
import com.openexchange.mail.utils.MessageUtility;
import com.openexchange.mail.uuencode.UUEncodedMultiPart;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import com.openexchange.tools.tnef.TNEF2ICal;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Property;
import net.freeutils.tnef.Attachment;
import net.freeutils.tnef.Attr;
import net.freeutils.tnef.CompressedRTFInputStream;
import net.freeutils.tnef.MAPIProp;
import net.freeutils.tnef.MAPIProps;
import net.freeutils.tnef.Message;
import net.freeutils.tnef.RawInputStream;
import net.freeutils.tnef.TNEFInputStream;
import net.freeutils.tnef.TNEFUtils;
import net.freeutils.tnef.mime.ContactHandler;
import net.freeutils.tnef.mime.RawDataSource;
import net.freeutils.tnef.mime.ReadReceiptHandler;
import net.freeutils.tnef.mime.TNEFMime;
import net.freeutils.tnef.mime.TNEFMimeMessage;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.SMIMESigned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MailMessageParser {
    private static final Logger LOG = LoggerFactory.getLogger(MailMessageParser.class);
    private static final String APPL_OCTET = "application/octet-stream";
    private static final String HDR_CONTENT_DISPOSITION = MessageHeaders.HDR_CONTENT_DISPOSITION;
    private static final String HDR_CONTENT_TYPE = MessageHeaders.HDR_CONTENT_TYPE;
    private static final int BUF_SIZE = 8192;
    private static final Iterator<Map.Entry<String, String>> EMPTY_ITER = new Iterator<Map.Entry<String, String>>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Map.Entry<String, String> next() {
            throw new NoSuchElementException("Iterator is empty");
        }

        @Override
        public void remove() {
        }
    };
    private static final InlineDetector LENIENT_DETECTOR = new InlineDetector(){

        @Override
        public boolean isInline(String disposition, String fileName) {
            return "inline".equalsIgnoreCase(disposition) || disposition == null && fileName == null;
        }
    };
    private static final InlineDetector STRICT_DETECTOR = new InlineDetector(){

        @Override
        public boolean isInline(String disposition, String fileName) {
            return ("inline".equalsIgnoreCase(disposition) || disposition == null) && fileName == null;
        }
    };
    private static final String TNEF_IPM_CONTACT = "IPM.Contact";
    private static final String TNEF_IPM_MS_READ_RECEIPT = "IPM.Microsoft Mail.Read Receipt";
    private boolean stop;
    private boolean multipartDetected;
    private InlineDetector inlineDetector = LENIENT_DETECTOR;
    private String subject;
    private MimeFilter mimeFilter = null;
    private boolean handleAllAsParts = false;
    private final List<OXException> warnings = new ArrayList<OXException>(2);
    private String mailId;
    private String folder;
    private static final String PREFIX = "Part_";
    private static final String PRIMARY_TEXT = "text/";
    private static final String[] SUB_TEXT = new String[]{"plain", "enriched", "richtext", "rtf"};
    private static final String PRIMARY_HTML = "text/htm";
    private static final String PRIMARY_MULTI = "multipart/";
    private static final String PRIMARY_IMAGE = "image/";
    private static final String PRIMARY_RFC822 = "message/rfc822";
    private static final String PRIMARY_MESSAGE = "message/";
    private static final String[] SUB_SPECIAL1 = new String[]{"delivery-status", "disposition-notification"};
    private static final String[] SUB_SPECIAL2 = new String[]{"rfc822-headers", "vcard", "x-vcard", "calendar", "x-vcalendar"};

    public MailMessageParser setInlineDetectorBehavior(boolean strict) {
        this.inlineDetector = strict ? STRICT_DETECTOR : LENIENT_DETECTOR;
        return this;
    }

    public MailMessageParser addMimeFilter(MimeFilter mimeFilter) {
        this.mimeFilter = mimeFilter;
        return this;
    }

    public MailMessageParser setHandleAllAsParts(boolean handleAllAsParts) {
        this.handleAllAsParts = handleAllAsParts;
        return this;
    }

    public List<OXException> getWarnings() {
        return Collections.unmodifiableList(this.warnings);
    }

    public MailMessageParser reset() {
        this.stop = false;
        this.multipartDetected = false;
        this.subject = null;
        return this;
    }

    public void parseMailMessage(MailMessage mail, MailMessageHandler handler) throws OXException {
        this.parseMailMessage(mail, handler, null);
    }

    public void parseMailMessage(MailMessage mail, MailMessageHandler handler, String prefix) throws OXException {
        if (null == mail) {
            throw MailExceptionCode.MISSING_PARAMETER.create("mail");
        }
        if (null == handler) {
            throw MailExceptionCode.MISSING_PARAMETER.create("handler");
        }
        try {
            this.parseEnvelope(mail, handler);
            this.mailId = mail.getMailId();
            this.folder = mail.getFolder();
            ContentType contentType = mail.getContentType();
            if (contentType.startsWith("multipart/related") && "application/smil".equals(contentType.getParameter(Strings.toLowerCase((CharSequence)"type")))) {
                this.parseMailContent(MimeSmilFixer.getInstance().process(mail), handler, prefix, 1);
            } else {
                this.parseMailContent(mail, handler, prefix, 1);
            }
        }
        catch (IOException e) {
            if ("No content".equals(e.getMessage())) {
                throw MailExceptionCode.NO_CONTENT.create(e, e.getMessage());
            }
            String mailId = mail.getMailId();
            String folder = mail.getFolder();
            throw MailExceptionCode.UNREADBALE_PART_CONTENT.create(e, null == mailId ? "" : mailId, null == folder ? "" : folder);
        }
        catch (OXException e) {
            if (MailExceptionCode.INVALID_MULTIPART_CONTENT.equals(e)) {
                String mailId = mail.getMailId();
                String folder = mail.getFolder();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Invalid multipart detected ''{}'' ({}-{}-{}):{}{}", new Object[]{e.getMessage(), null == mailId ? "" : mailId, null == folder ? "" : folder, mail.getAccountId(), System.getProperty("line.separator"), mail.getSource()});
                }
            }
            throw e;
        }
        handler.handleMessageEnd(mail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseMailContent(MailPart mailPartArg, MailMessageHandler handler, String prefix, int partCountArg) throws OXException, IOException {
        if (this.stop) {
            return;
        }
        MailPart mailPart = MailConfig.usePartModifier() ? MailConfig.getPartModifier().modifyPart(mailPartArg) : mailPartArg;
        int partCount = partCountArg;
        String disposition = mailPart.containsContentDisposition() ? mailPart.getContentDisposition().getDisposition() : null;
        long size = mailPart.getSize();
        ContentType contentType = mailPart.containsContentType() ? mailPart.getContentType() : new ContentType(APPL_OCTET);
        String lcct = LocaleTools.toLowerCase((CharSequence)contentType.getBaseType());
        if (null != this.mimeFilter && this.mimeFilter.ignorable(lcct, mailPart)) {
            return;
        }
        String fileName = MailMessageParser.getFileName(mailPart.getFileName(), MailMessageParser.getSequenceId(prefix, partCount), lcct);
        boolean isInline = this.inlineDetector.isInline(disposition, mailPart.getFileName());
        if (MailMessageParser.isMultipart(lcct)) {
            MailPart handledSMIME;
            if (lcct.equals("multipart/signed") && null != (handledSMIME = this.checkSMIME(mailPart, lcct, contentType))) {
                this.parseMailContent(handledSMIME, handler, prefix, partCount);
                return;
            }
            try {
                String mpPrefix;
                String mpId;
                int count = mailPart.getEnclosedCount();
                if (count == -1) {
                    throw MailExceptionCode.INVALID_MULTIPART_CONTENT.create();
                }
                String string = mpId = null == prefix && !this.multipartDetected ? "" : MailMessageParser.getSequenceId(prefix, partCount);
                if (!mailPart.containsSequenceId()) {
                    mailPart.setSequenceId(mpId);
                }
                if (!handler.handleMultipart(mailPart, count, mpId)) {
                    this.stop = true;
                    return;
                }
                if (this.multipartDetected) {
                    mpPrefix = mpId;
                } else {
                    mpPrefix = prefix;
                    this.multipartDetected = true;
                }
                for (int i = 0; i < count; ++i) {
                    MailPart enclosedContent = mailPart.getEnclosedMailPart(i);
                    this.parseMailContent(enclosedContent, handler, mpPrefix, i + 1);
                }
                if (handler.handleMultipartEnd(mailPart, mpId)) return;
                this.stop = true;
                return;
            }
            catch (RuntimeException rte) {
                LOG.error("Multipart mail could not be parsed", (Throwable)rte);
                this.warnings.add(MailExceptionCode.UNPARSEABLE_MESSAGE.create(rte, new Object[0]));
                if (handler.handleInlinePlainText("", ContentType.DEFAULT_CONTENT_TYPE, 0L, fileName, MailMessageParser.getSequenceId(prefix, partCount))) return;
                this.stop = true;
                return;
            }
        }
        if (MailMessageParser.isText(lcct, fileName)) {
            if (this.handleAllAsParts) {
                if (!mailPart.containsSequenceId()) {
                    mailPart.setSequenceId(MailMessageParser.getSequenceId(prefix, partCount));
                }
                if (handler.handleAttachment(mailPart, isInline, lcct, fileName, mailPart.getSequenceId())) return;
                this.stop = true;
                return;
            }
            if (isInline) {
                if (null != mailPart.getFileName()) {
                    contentType.setParameter("realfilename", mailPart.getFileName());
                }
                try {
                    String content = MailMessageParser.readContent(mailPart, contentType, this.mailId, this.folder);
                    UUEncodedMultiPart uuencodedMP = new UUEncodedMultiPart(content);
                    if (uuencodedMP.isUUEncoded()) {
                        if (!handler.handleInlineUUEncodedPlainText(uuencodedMP.getCleanText(), contentType, uuencodedMP.getCleanText().length(), fileName, MailMessageParser.getSequenceId(prefix, partCount))) {
                            this.stop = true;
                            return;
                        }
                        int count = uuencodedMP.getCount();
                        if (count <= 0) return;
                        for (int a = 0; a < count; ++a) {
                            if (handler.handleInlineUUEncodedAttachment(uuencodedMP.getBodyPart(a), MailMessageParser.getSequenceId(prefix, ++partCount))) continue;
                            this.stop = true;
                            return;
                        }
                        return;
                    }
                    if (handler.handleInlinePlainText(content, contentType, size, fileName, MailMessageParser.getSequenceId(prefix, partCount))) return;
                    this.stop = true;
                    return;
                }
                finally {
                    contentType.removeParameter("realfilename");
                }
            }
            if (!mailPart.containsSequenceId()) {
                mailPart.setSequenceId(MailMessageParser.getSequenceId(prefix, partCount));
            }
            if (handler.handleAttachment(mailPart, false, lcct, fileName, mailPart.getSequenceId())) return;
            this.stop = true;
            return;
        }
        if (MailMessageParser.isHtml(lcct)) {
            if (this.handleAllAsParts) {
                if (!mailPart.containsSequenceId()) {
                    mailPart.setSequenceId(MailMessageParser.getSequenceId(prefix, partCount));
                }
                if (handler.handleAttachment(mailPart, isInline, lcct, fileName, mailPart.getSequenceId())) return;
                this.stop = true;
                return;
            }
            if (!mailPart.containsSequenceId()) {
                mailPart.setSequenceId(MailMessageParser.getSequenceId(prefix, partCount));
            }
            if (isInline) {
                if (null == mailPart.getFileName()) {
                    if (handler.handleInlineHtml(new ContentProviderImpl(contentType, mailPart, this.mailId, this.folder), contentType, size, fileName, mailPart.getSequenceId())) return;
                    this.stop = true;
                    return;
                }
                contentType.setParameter("realfilename", mailPart.getFileName());
                try {
                    if (handler.handleInlineHtml(new ContentProviderImpl(contentType, mailPart, this.mailId, this.folder), contentType, size, fileName, mailPart.getSequenceId())) return;
                    this.stop = true;
                    return;
                }
                finally {
                    contentType.removeParameter("realfilename");
                }
            }
            if (handler.handleAttachment(mailPart, false, lcct, fileName, mailPart.getSequenceId())) return;
            this.stop = true;
            return;
        }
        if (MailMessageParser.isImage(lcct)) {
            if (!mailPart.containsSequenceId()) {
                mailPart.setSequenceId(MailMessageParser.getSequenceId(prefix, partCount));
            }
            if (handler.handleImagePart(mailPart, mailPart.getContentId(), lcct, isInline, fileName, mailPart.getSequenceId())) return;
            this.stop = true;
            return;
        }
        if (MailMessageParser.isMessage(lcct, fileName)) {
            if (!mailPart.containsSequenceId()) {
                mailPart.setSequenceId(MailMessageParser.getSequenceId(prefix, partCount));
            }
            if (handler.handleNestedMessage(mailPart, MailMessageParser.getSequenceId(prefix, partCount))) return;
            this.stop = true;
            return;
        }
        if (TNEFUtils.isTNEFMimeType((String)lcct)) {
            try {
                List attachments2;
                int s;
                RawInputStream ris;
                Calendar calendar2;
                Multipart mp;
                MAPIProp prop;
                TNEFInputStream tnefInputStream = new TNEFInputStream(mailPart.getInputStream());
                Message message = new Message(tnefInputStream);
                Attr messageClass = message.getAttribute(32776);
                String messageClassName = messageClass == null ? (null == (prop = message.getMAPIProps().getProp(26)) ? "" : prop.getValue().toString()) : (String)messageClass.getValue();
                if (TNEF_IPM_CONTACT.equalsIgnoreCase(messageClassName)) {
                    try {
                        Attr subjetcAttr = message.getAttribute(32772);
                        if (null == subjetcAttr) {
                            message.addAttribute(new Attr(1, 2, 32772, (Object)"vcard"));
                        }
                        mp = ContactHandler.convert((Message)message);
                    }
                    catch (RuntimeException e) {
                        LOG.error("Invalid TNEF contact", (Throwable)e);
                        return;
                    }
                    this.parseMailContent(new MimeMailPart(mp), handler, prefix, partCount);
                    return;
                }
                if (messageClassName.equalsIgnoreCase(TNEF_IPM_MS_READ_RECEIPT)) {
                    try {
                        mp = ReadReceiptHandler.convert((Message)message);
                    }
                    catch (RuntimeException e) {
                        LOG.warn("Invalid TNEF read receipt", (Throwable)e);
                        return;
                    }
                    this.parseMailContent(new MimeMailPart(mp), handler, prefix, partCount);
                    return;
                }
                if (TNEF2ICal.isVPart(messageClassName) && null != (calendar2 = TNEF2ICal.tnef2VPart(message))) {
                    TNEFBodyPart part = new TNEFBodyPart();
                    Property method = calendar2.getProperties().getProperty("METHOD");
                    String contentTypeStr = null == method ? "text/calendar; charset=UTF-8" : "text/calendar; method=" + method.getValue() + "; charset=UTF-8";
                    byte[] bytes = calendar2.toString().getBytes(Charsets.UTF_8);
                    part.setDataHandler(new DataHandler((DataSource)new MessageDataSource(bytes, contentTypeStr)));
                    part.setSize(bytes.length);
                    part.setHeader(HDR_CONTENT_TYPE, contentTypeStr);
                    ContentDisposition cd = new ContentDisposition("attachment");
                    cd.setFilenameParameter(MailMessageParser.getFileName(null, MailMessageParser.getSequenceId(prefix, partCount), "text/calendar"));
                    part.setHeader(HDR_CONTENT_DISPOSITION, cd.toString());
                    part.setHeader(MessageHeaders.HDR_MIME_VERSION, "1.0");
                    Component vEvent = calendar2.getComponents().getComponent("VEVENT");
                    Property summary = vEvent.getProperties().getProperty("SUMMARY");
                    if (summary != null) {
                        part.setFileName(MimeUtility.encodeText((String)summary.getValue().replaceAll("\\s", "_"), (String)MailProperties.getInstance().getDefaultMimeCharset(), (String)"Q") + ".ics");
                    }
                    this.parseMailContent(MimeMessageConverter.convertPart((Part)part), handler, prefix, partCount++);
                    return;
                }
                Attr attrBody = Attr.findAttr((List)message.getAttributes(), (int)32780);
                if (attrBody != null) {
                    TNEFBodyPart bodyPart = new TNEFBodyPart();
                    String value = (String)attrBody.getValue();
                    MessageUtility.setText(value, (Part)bodyPart);
                    bodyPart.setSize(value.length());
                    this.parseMailContent(MimeMessageConverter.convertPart((Part)bodyPart), handler, prefix, partCount++);
                }
                TNEFBodyPart rtfPart = null;
                MAPIProps mapiProps = message.getMAPIProps();
                if (mapiProps != null && (ris = (RawInputStream)mapiProps.getPropValue(4105)) != null) {
                    rtfPart = new TNEFBodyPart();
                    byte[] decompressedBytes = CompressedRTFInputStream.decompressRTF((byte[])ris.toByteArray());
                    String contentTypeStr = "application/rtf";
                    rtfPart.setDataHandler(new DataHandler((DataSource)new MessageDataSource(decompressedBytes, contentTypeStr)));
                    rtfPart.setHeader(HDR_CONTENT_TYPE, contentTypeStr);
                    rtfPart.setSize(decompressedBytes.length);
                    this.parseMailContent(MimeMessageConverter.convertPart((Part)rtfPart), handler, prefix, partCount++);
                }
                if ((s = (attachments2 = message.getAttachments()).size()) > 0) {
                    Iterator iter = attachments2.iterator();
                    UnsynchronizedByteArrayOutputStream os = new UnsynchronizedByteArrayOutputStream(8192);
                    for (int i = 0; !this.stop && i < s; ++i) {
                        Attachment attachment = (Attachment)iter.next();
                        TNEFBodyPart bodyPart = new TNEFBodyPart();
                        if (attachment.getNestedMessage() == null) {
                            String tmp;
                            bodyPart.setTNEFAttributes(attachment.getAttributes());
                            String attachFilename = attachment.getFilename();
                            String contentTypeStr = null;
                            if (attachment.getMAPIProps() != null) {
                                contentTypeStr = (String)attachment.getMAPIProps().getPropValue(14094);
                            }
                            if (null != contentTypeStr && (tmp = contentTypeStr.toLowerCase(Locale.US)).startsWith(PRIMARY_MULTI) && tmp.indexOf("boundary=") < 0) {
                                MimeMessage nested = new MimeMessage(MimeDefaultSession.getDefaultSession(), (InputStream)attachment.getRawData());
                                this.parseMailContent(MimeMessageConverter.convertMessage(nested, false), handler, prefix, partCount++);
                                continue;
                            }
                            if (contentTypeStr == null && attachFilename != null) {
                                contentTypeStr = MimeType2ExtMap.getContentType(attachFilename);
                            }
                            if (contentTypeStr == null) {
                                contentTypeStr = APPL_OCTET;
                            }
                            RawDataSource ds = new RawDataSource(attachment.getRawData(), contentTypeStr);
                            bodyPart.setDataHandler(new DataHandler((DataSource)ds));
                            bodyPart.setHeader(HDR_CONTENT_TYPE, ContentType.prepareContentTypeString(contentTypeStr, attachFilename));
                            if (attachFilename != null) {
                                ContentDisposition cd = new ContentDisposition("attachment");
                                cd.setFilenameParameter(attachFilename);
                                bodyPart.setHeader(HDR_CONTENT_DISPOSITION, MimeMessageUtility.foldContentDisposition(cd.toString()));
                            }
                            CountingOutputStream counter = new CountingOutputStream();
                            attachment.writeTo((OutputStream)counter);
                            bodyPart.setSize((int)counter.getCount());
                            this.parseMailContent(MimeMessageConverter.convertPart((Part)bodyPart), handler, prefix, partCount++);
                            continue;
                        }
                        TNEFMimeMessage nestedMessage = TNEFMime.convert((Session)MimeDefaultSession.getDefaultSession(), (Message)attachment.getNestedMessage());
                        os.reset();
                        nestedMessage.writeTo((OutputStream)os);
                        bodyPart.setDataHandler(new DataHandler((DataSource)new MessageDataSource(os.toByteArray(), PRIMARY_RFC822)));
                        bodyPart.setHeader(HDR_CONTENT_TYPE, PRIMARY_RFC822);
                        this.parseMailContent(MimeMessageConverter.convertPart((Part)bodyPart), handler, prefix, partCount++);
                    }
                    return;
                }
                if (null != rtfPart) {
                    MailPart convertedPart = MimeMessageConverter.convertPart((Part)rtfPart);
                    convertedPart.setFileName(this.subject.replaceAll("\\s+", "_") + ".rtf");
                    this.parseMailContent(convertedPart, handler, prefix, partCount++);
                }
                if (null == messageClass) {
                    if (!mailPart.containsSequenceId()) {
                        mailPart.setSequenceId(MailMessageParser.getSequenceId(prefix, partCount));
                    }
                    if (handler.handleAttachment(mailPart, isInline, lcct, fileName, mailPart.getSequenceId())) return;
                    this.stop = true;
                    return;
                }
                TNEFBodyPart bodyPart = new TNEFBodyPart();
                bodyPart.setTNEFAttributes(message.getAttributes());
                String attachFilename = fileName;
                RawDataSource ds = new RawDataSource(messageClass.getRawData(), APPL_OCTET);
                bodyPart.setDataHandler(new DataHandler((DataSource)ds));
                bodyPart.setHeader(HDR_CONTENT_TYPE, ContentType.prepareContentTypeString(APPL_OCTET, attachFilename));
                if (attachFilename != null) {
                    ContentDisposition cd = new ContentDisposition("attachment");
                    cd.setFilenameParameter(attachFilename);
                    bodyPart.setHeader(HDR_CONTENT_DISPOSITION, MimeMessageUtility.foldContentDisposition(cd.toString()));
                }
                bodyPart.setSize(messageClass.getLength());
                this.parseMailContent(MimeMessageConverter.convertPart((Part)bodyPart), handler, prefix, partCount++);
                return;
            }
            catch (IOException tnefExc) {
                LOG.warn("", (Throwable)tnefExc);
                if (!mailPart.containsSequenceId()) {
                    mailPart.setSequenceId(MailMessageParser.getSequenceId(prefix, partCount));
                }
                if (handler.handleAttachment(mailPart, isInline, lcct, fileName, mailPart.getSequenceId())) return;
                this.stop = true;
                return;
            }
            catch (MessagingException e) {
                LOG.error("", (Throwable)e);
                if (!mailPart.containsSequenceId()) {
                    mailPart.setSequenceId(MailMessageParser.getSequenceId(prefix, partCount));
                }
                if (handler.handleAttachment(mailPart, isInline, lcct, fileName, mailPart.getSequenceId())) return;
                this.stop = true;
                return;
            }
        }
        if (MailMessageParser.isSpecial(lcct)) {
            if (!mailPart.containsSequenceId()) {
                mailPart.setSequenceId(MailMessageParser.getSequenceId(prefix, partCount));
            }
            if (handler.handleSpecialPart(mailPart, lcct, fileName, mailPart.getSequenceId())) return;
            this.stop = true;
            return;
        }
        MailPart handledSMIME = this.checkSMIME(mailPart, lcct, contentType);
        if (null != handledSMIME) {
            this.parseMailContent(handledSMIME, handler, prefix, partCount);
            return;
        }
        if (!mailPart.containsSequenceId()) {
            mailPart.setSequenceId(MailMessageParser.getSequenceId(prefix, partCount));
        }
        if (handler.handleAttachment(mailPart, isInline, lcct, fileName, mailPart.getSequenceId())) return;
        this.stop = true;
    }

    private MailPart checkSMIME(MailPart mailPart, String lcct, ContentType contentType) throws IOException, OXException {
        if (!(mailPart instanceof MimeRawSource)) {
            return null;
        }
        SMIMESigned smimeSigned = null;
        try {
            if (MailMessageParser.isMultipartSigned(lcct, contentType)) {
                Multipart multipart = MimeMessageUtility.getMultipartContentFrom(((MimeRawSource)((Object)mailPart)).getPart(), lcct);
                smimeSigned = new SMIMESigned((MimeMultipart)multipart);
            } else if (MailMessageParser.isSigned(lcct, contentType)) {
                smimeSigned = new SMIMESigned(((MimeRawSource)((Object)mailPart)).getPart());
            }
        }
        catch (MessagingException e) {
            LOG.warn("Failed to handle S/MIME message", (Throwable)e);
        }
        catch (CMSException e) {
            LOG.warn("Failed to handle S/MIME message", (Throwable)e);
        }
        catch (SMIMEException e) {
            LOG.warn("Failed to handle S/MIME message", (Throwable)e);
        }
        return smimeSigned == null ? null : MimeMessageConverter.convertPart((Part)smimeSigned.getContent());
    }

    private void parseEnvelope(MailMessage mail, MailMessageHandler handler) throws OXException {
        int headersSize;
        handler.handleFrom(mail.getFrom());
        handler.handleToRecipient(mail.getTo());
        handler.handleCcRecipient(mail.getCc());
        handler.handleBccRecipient(mail.getBcc());
        String subj = mail.getSubject();
        if (subj == null) {
            subj = "";
        }
        this.subject = subj;
        handler.handleSubject(subj);
        if (mail.getSentDate() != null) {
            handler.handleSentDate(mail.getSentDate());
        }
        if (mail.getReceivedDate() != null) {
            handler.handleReceivedDate(mail.getReceivedDate());
        }
        handler.handleSystemFlags(mail.getFlags());
        handler.handleUserFlags(mail.getUserFlags());
        handler.handleColorLabel(mail.getColorLabel());
        handler.handlePriority(mail.getPriority());
        if (mail.containsContentId()) {
            handler.handleContentId(mail.getContentId());
        }
        if (mail.getMsgref() != null) {
            handler.handleMsgRef(mail.getMsgref().toString());
        }
        if (mail.containsDispositionNotification() && null != mail.getDispositionNotification()) {
            handler.handleDispositionNotification(mail.getDispositionNotification(), mail.containsPrevSeen() ? mail.isPrevSeen() : mail.isSeen());
        }
        handler.handleHeaders(headersSize, (headersSize = mail.getHeadersSize()) > 0 ? mail.getHeadersIterator() : EMPTY_ITER);
    }

    public static String getFileName(String rawFileName, String sequenceId, String baseMimeType) {
        String filename = rawFileName;
        if (filename == null || Strings.isEmpty((String)filename)) {
            List<String> exts = MimeType2ExtMap.getFileExtensions(baseMimeType.toLowerCase(Locale.ENGLISH));
            StringBuilder sb = new StringBuilder(16).append(PREFIX).append(sequenceId).append('.');
            if (exts == null) {
                sb.append("dat");
            } else {
                sb.append(exts.get(0));
            }
            filename = sb.toString();
        } else {
            filename = MimeMessageUtility.decodeMultiEncodedHeader(filename);
        }
        return filename;
    }

    public static String getSequenceId(String prefix, int partCount) {
        if (prefix == null) {
            return String.valueOf(partCount);
        }
        return prefix + '.' + partCount;
    }

    public static String generateFilename(String sequenceId, String baseMimeType) {
        return MailMessageParser.getFileName(null, sequenceId, baseMimeType);
    }

    static String readContent(MailPart mailPart, ContentType contentType, String mailId, String folder) throws OXException, IOException {
        String content = MimeMessageUtility.readContent(mailPart, contentType, true);
        if (null == content) {
            throw MailExceptionCode.MAIL_NOT_FOUND.create(mailId, folder);
        }
        return content;
    }

    private static boolean isText(String contentType, String name) {
        if (name != null && name.endsWith(".eml")) {
            return false;
        }
        if (contentType.startsWith(PRIMARY_TEXT, 0)) {
            int off = PRIMARY_TEXT.length();
            for (String subtype : SUB_TEXT) {
                if (!contentType.startsWith(subtype, off)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isHtml(String contentType) {
        return contentType.startsWith(PRIMARY_HTML, 0);
    }

    private static boolean isMultipart(String contentType) {
        return contentType.startsWith(PRIMARY_MULTI, 0);
    }

    private static boolean isImage(String contentType) {
        return contentType.startsWith(PRIMARY_IMAGE, 0);
    }

    private static boolean isMessage(String contentType, String name) {
        if (name != null && name.endsWith(".eml")) {
            return true;
        }
        return contentType.startsWith(PRIMARY_RFC822, 0);
    }

    private static boolean isSpecial(String contentType) {
        block3: {
            block2: {
                if (!contentType.startsWith(PRIMARY_TEXT, 0)) break block2;
                int off = PRIMARY_TEXT.length();
                for (String subtype : SUB_SPECIAL2) {
                    if (!contentType.startsWith(subtype, off)) continue;
                    return true;
                }
                break block3;
            }
            if (!contentType.startsWith(PRIMARY_MESSAGE, 0)) break block3;
            int off = PRIMARY_MESSAGE.length();
            for (String subtype : SUB_SPECIAL1) {
                if (!contentType.startsWith(subtype, off)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isSigned(String lcct, ContentType ct) {
        return "application/pkcs7-mime".equals(lcct) && "signed-data".equals(ct.getParameter("smime-type")) && "smime.p7m".equals(ct.getNameParameter());
    }

    private static boolean isMultipartSigned(String lcct, ContentType ct) {
        return "multipart/signed".equals(lcct) && "application/pkcs7-signature".equals(ct.getParameter("protocol"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MailMessage getMessageContentFrom(MailPart mailPart) throws OXException {
        ThresholdFileHolder backup;
        block18: {
            if (null == mailPart) {
                return null;
            }
            backup = null;
            Object content = mailPart.getContent();
            if (content instanceof MailMessage) {
                MailMessage mailMessage = (MailMessage)content;
                return mailMessage;
            }
            if (content instanceof MimeMessage) {
                MailMessage mailMessage = MimeMessageConverter.convertMessage((MimeMessage)content, false);
                return mailMessage;
            }
            if (content instanceof InputStream) {
                try {
                    backup = new ThresholdFileHolder();
                    backup.write((InputStream)content);
                    FileBackedMimeMessage mimeMessage = new FileBackedMimeMessage(MimeDefaultSession.getDefaultSession(), backup.getSharedStream());
                    MailMessage mailMessage = MimeMessageConverter.convertMessage(mimeMessage, false);
                    backup = null;
                    MailMessage mailMessage2 = mailMessage;
                    return mailMessage2;
                }
                catch (IOException e) {
                    throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
                }
                catch (MessagingException e) {
                    throw MimeMailException.handleMessagingException(e);
                }
            }
            if (!(content instanceof String)) break block18;
            try {
                MimeMessage mimeMessage = new MimeMessage(MimeDefaultSession.getDefaultSession(), (InputStream)new ByteArrayInputStream(((String)content).getBytes("UTF-8")));
                MailMessage mailMessage = MimeMessageConverter.convertMessage(mimeMessage, false);
                return mailMessage;
            }
            catch (UnsupportedEncodingException e) {
                throw MailExceptionCode.ENCODING_ERROR.create(e, e.getMessage());
            }
            catch (MessagingException e) {
                throw MimeMailException.handleMessagingException(e);
            }
        }
        MailMessage mailMessage = null;
        return mailMessage;
        finally {
            if (null != backup) {
                backup.close();
            }
        }
    }

    private static interface InlineDetector {
        public boolean isInline(String var1, String var2);
    }

    private static final class ContentProviderImpl
    implements ContentProvider {
        private final ContentType contentType;
        private final MailPart mailPart;
        private final String mailId;
        private final String folder;

        ContentProviderImpl(ContentType contentType, MailPart mailPart, String mailId, String folder) {
            this.contentType = contentType;
            this.mailPart = mailPart;
            this.mailId = mailId;
            this.folder = folder;
        }

        @Override
        public String getContent() throws OXException {
            try {
                return MailMessageParser.readContent(this.mailPart, this.contentType, this.mailId, this.folder);
            }
            catch (IOException e) {
                throw MailExceptionCode.UNREADBALE_PART_CONTENT.create(e, null == this.mailId ? "" : this.mailId, null == this.folder ? "" : this.folder);
            }
        }
    }
}

