/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime.filler;

import com.openexchange.ajax.container.ThresholdFileHolder;
import com.openexchange.config.ConfigurationService;
import com.openexchange.config.Reloadable;
import com.openexchange.conversion.ConversionService;
import com.openexchange.conversion.Data;
import com.openexchange.conversion.DataExceptionCodes;
import com.openexchange.conversion.DataProperties;
import com.openexchange.exception.OXException;
import com.openexchange.filemanagement.ManagedFile;
import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.html.HtmlService;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.image.ImageDataSource;
import com.openexchange.image.ImageLocation;
import com.openexchange.image.ImageUtility;
import com.openexchange.java.Charsets;
import com.openexchange.java.HTMLDetector;
import com.openexchange.java.Strings;
import com.openexchange.java.util.UUIDs;
import com.openexchange.log.LogProperties;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.config.MailReloadable;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.dataobjects.compose.ComposeType;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.dataobjects.compose.ComposedMailPart;
import com.openexchange.mail.dataobjects.compose.ReferencedMailPart;
import com.openexchange.mail.dataobjects.compose.TextBodyMailPart;
import com.openexchange.mail.mime.ContentDisposition;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MessageHeaders;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.MimeMailExceptionCode;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.mime.datasource.FileHolderDataSource;
import com.openexchange.mail.mime.datasource.MessageDataSource;
import com.openexchange.mail.mime.filler.CompositionParameters;
import com.openexchange.mail.mime.filler.SessionCompositionParameters;
import com.openexchange.mail.mime.utils.ImageMatcher;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.mime.utils.sourcedimage.SourcedImage;
import com.openexchange.mail.mime.utils.sourcedimage.SourcedImageUtility;
import com.openexchange.mail.text.TextProcessing;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.mail.utils.MessageUtility;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.regex.MatcherReplacer;
import com.openexchange.version.Version;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MailDateFormat;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.net.QuotedPrintableCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeMessageFiller {
    static final Logger LOG = LoggerFactory.getLogger(MimeMessageFiller.class);
    static final String HDR_ORGANIZATION = MessageHeaders.HDR_ORGANIZATION;
    private static final String HDR_X_MAILER = MessageHeaders.HDR_X_MAILER;
    static final String HDR_X_ORIGINATING_CLIENT = MessageHeaders.HDR_X_ORIGINATING_CLIENT;
    private static final String HDR_MIME_VERSION = MessageHeaders.HDR_MIME_VERSION;
    private static final String PREFIX_PART = "part";
    private static final String EXT_EML = ".eml";
    private static final String VERSION_1_0 = "1.0";
    private static final String VCARD_ERROR = "Error while appending user VCard";
    private static final String MP_ALTERNATIVE = "alternative";
    private static final String MP_RELATED = "related";
    protected int accountId;
    private Set<String> uploadFileIDs;
    private Set<String> contentIds;
    private boolean discardReferencedInlinedImages = true;
    private final HtmlService htmlService = ServerServiceRegistry.getInstance().getService(HtmlService.class);
    protected final CompositionParameters compositionParameters;
    private static final Set<String> LOCAL_ADDRS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("127.0.0.1", "localhost", "::1")));
    private static final String[] SUPPRESS_HEADERS = new String[]{MessageHeaders.HDR_X_OX_VCARD, MessageHeaders.HDR_X_OXMSGREF, MessageHeaders.HDR_X_OX_MARKER, MessageHeaders.HDR_X_OX_NOTIFICATION, MessageHeaders.HDR_IMPORTANCE, MessageHeaders.HDR_X_PRIORITY, HDR_X_MAILER};
    private static final String HDR_MESSAGE_ID = MessageHeaders.HDR_MESSAGE_ID;
    private static final String HDR_REFERENCES = MessageHeaders.HDR_REFERENCES;
    private static final String HDR_IN_REPLY_TO = MessageHeaders.HDR_IN_REPLY_TO;
    private static final Pattern BODY_START = Pattern.compile("<body.*?>", 34);
    private static final String MIME_MESSAGE_RFC822 = "message/rfc822";
    private static final String MIME_APPL_OCTET = "application/octet-stream";
    private static final String MIME_MULTIPART_OCTET = "multipart/octet-stream";
    private static volatile Set<String> octetExtensions;
    private static final String HTML_SPACE = "&#160;";
    private static final Pattern PATTERN_IMG;
    private static final Pattern PATTERN_IMG_ALT;
    private static final Pattern PATTERN_SRC;
    private static final Pattern PATTERN_AMP;
    private static final String VERSION_NAME = "Open-Xchange";
    private static final Pattern PATTERN_DASHES;

    public MimeMessageFiller(CompositionParameters compositionParameters) {
        this.compositionParameters = compositionParameters;
    }

    public MimeMessageFiller(Session session, Context ctx) {
        this(session, ctx, UserSettingMailStorage.getInstance().getUserSettingMail(session.getUserId(), ctx));
    }

    public MimeMessageFiller(Session session, Context ctx, UserSettingMail usm) {
        this.compositionParameters = new SessionCompositionParameters(session, ctx, usm);
    }

    public MimeMessageFiller setDiscardReferencedInlinedImages(boolean discardReferencedInlinedImages) {
        this.discardReferencedInlinedImages = discardReferencedInlinedImages;
        return this;
    }

    public MimeMessageFiller setAccountId(int accountId) {
        this.accountId = accountId;
        if (this.compositionParameters instanceof SessionCompositionParameters) {
            ((SessionCompositionParameters)this.compositionParameters).setAccountId(accountId);
        }
        return this;
    }

    public int getAccountId() {
        return this.accountId;
    }

    public void deleteReferencedUploadFiles() {
        if (this.uploadFileIDs != null) {
            int size = this.uploadFileIDs.size();
            Iterator<String> iter = this.uploadFileIDs.iterator();
            ManagedFileManagement mfm = ServerServiceRegistry.getInstance().getService(ManagedFileManagement.class);
            if (mfm != null) {
                for (int i = 0; i < size; ++i) {
                    try {
                        mfm.removeByID(iter.next());
                        continue;
                    }
                    catch (OXException e) {
                        LOG.error("", (Throwable)e);
                    }
                }
            }
            this.uploadFileIDs.clear();
        }
    }

    public void setCommonHeaders(MimeMessage mimeMessage) throws MessagingException, OXException {
        String client;
        String encoded;
        mimeMessage.setHeader(HDR_X_MAILER, "Open-Xchange Mailer v" + Version.getInstance().getVersionString());
        if (this.accountId <= 0) {
            try {
                String organization = this.compositionParameters.getOrganization();
                if (null != organization && 0 < organization.length()) {
                    encoded = MimeUtility.fold((int)14, (String)MimeUtility.encodeText((String)organization, (String)MailProperties.getInstance().getDefaultMimeCharset(), null));
                    mimeMessage.setHeader(HDR_ORGANIZATION, encoded);
                }
            }
            catch (Exception e) {
                LOG.warn("Header \"Organization\" could not be set", (Throwable)e);
            }
        }
        if (MailProperties.getInstance().isAddClientIPAddress()) {
            this.addClientIPAddress(mimeMessage);
        }
        if (!Strings.isEmpty((String)(client = this.compositionParameters.getClient()))) {
            try {
                encoded = MimeUtility.fold((int)20, (String)MimeUtility.encodeText((String)client, (String)MailProperties.getInstance().getDefaultMimeCharset(), null));
                mimeMessage.setHeader(HDR_X_ORIGINATING_CLIENT, encoded);
            }
            catch (Exception e) {
                LOG.warn("Header \"X-Originating-Client\" could not be set", (Throwable)e);
            }
        }
    }

    private void addClientIPAddress(MimeMessage mimeMessage) throws OXException, MessagingException {
        String originatingIP = this.compositionParameters.getOriginatingIP();
        if (originatingIP != null) {
            mimeMessage.setHeader("X-Originating-IP", originatingIP);
        }
    }

    public static void addClientIPAddress(MimeMessage mimeMessage, Session session) throws MessagingException {
        String localIp = session.getLocalIp();
        if (MimeMessageFiller.isLocalhost(localIp)) {
            LOG.debug("Session provides localhost as client IP address: {}", (Object)localIp);
            String clientIp = LogProperties.getLogProperty((LogProperties.Name)LogProperties.Name.GRIZZLY_REMOTE_ADDRESS);
            mimeMessage.setHeader("X-Originating-IP", clientIp == null ? localIp : clientIp);
        } else {
            mimeMessage.setHeader("X-Originating-IP", localIp);
        }
    }

    static boolean isLocalhost(String localIp) {
        return LOCAL_ADDRS.contains(localIp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageHeaders(ComposedMailMessage mail, MimeMessage mimeMessage) throws MessagingException, OXException {
        String[] userFlags;
        InternetAddress sender;
        if (mail.containsFrom()) {
            InternetAddress from = mail.getFrom()[0];
            mimeMessage.setFrom((Address)from);
            sender = this.compositionParameters.getSenderAddress(from);
            if (sender != null) {
                mimeMessage.setSender((Address)sender);
            }
        }
        if (mail.containsTo()) {
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])mail.getTo());
        }
        if (mail.containsCc()) {
            mimeMessage.setRecipients(Message.RecipientType.CC, (Address[])mail.getCc());
        }
        if (mail.containsBcc()) {
            mimeMessage.setRecipients(Message.RecipientType.BCC, (Address[])mail.getBcc());
        }
        this.setReplyTo(mail, mimeMessage);
        if (mail.containsSubject()) {
            mimeMessage.setSubject(mail.getSubject(), MailProperties.getInstance().getDefaultMimeCharset());
        }
        if (mail.containsSentDate()) {
            MailDateFormat mdf = MimeMessageUtility.getMailDateFormat(this.compositionParameters.getTimeZoneID());
            sender = mdf;
            synchronized (sender) {
                mimeMessage.setHeader("Date", mdf.format(mail.getSentDate()));
            }
        }
        Flags msgFlags = new Flags();
        if (mail.isAnswered()) {
            msgFlags.add(Flags.Flag.ANSWERED);
        }
        if (mail.isDeleted()) {
            msgFlags.add(Flags.Flag.DELETED);
        }
        if (mail.isDraft()) {
            msgFlags.add(Flags.Flag.DRAFT);
        }
        if (mail.isFlagged()) {
            msgFlags.add(Flags.Flag.FLAGGED);
        }
        if (mail.isRecent()) {
            msgFlags.add(Flags.Flag.RECENT);
        }
        if (mail.isSeen()) {
            msgFlags.add(Flags.Flag.SEEN);
        }
        if (mail.isUser()) {
            msgFlags.add(Flags.Flag.USER);
        }
        if (mail.isForwarded()) {
            msgFlags.add("$Forwarded");
        }
        if (mail.isReadAcknowledgment()) {
            msgFlags.add("$MDNSent");
        }
        if (mail.getColorLabel() != 0) {
            msgFlags.add(MailMessage.getColorLabelStringValue(mail.getColorLabel()));
        }
        if (null != (userFlags = mail.getUserFlags()) && userFlags.length > 0) {
            for (String userFlag : userFlags) {
                msgFlags.add(userFlag);
            }
        }
        mimeMessage.setFlags(msgFlags, true);
        if (mail.getDispositionNotification() != null) {
            if (mail.isDraft()) {
                mimeMessage.setHeader(MessageHeaders.HDR_X_OX_NOTIFICATION, mail.getDispositionNotification().toString());
            } else {
                mimeMessage.setHeader(MessageHeaders.HDR_DISP_TO, mail.getDispositionNotification().toString());
            }
        }
        int priority = mail.getPriority();
        mimeMessage.setHeader(MessageHeaders.HDR_X_PRIORITY, String.valueOf(priority));
        if (3 == priority) {
            mimeMessage.setHeader(MessageHeaders.HDR_IMPORTANCE, "Medium");
        } else if (priority > 3) {
            mimeMessage.setHeader(MessageHeaders.HDR_IMPORTANCE, "Low");
        } else {
            mimeMessage.setHeader(MessageHeaders.HDR_IMPORTANCE, "High");
        }
        Iterator<Map.Entry<String, String>> iter = mail.getNonMatchingHeaders(SUPPRESS_HEADERS);
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            String name = entry.getKey();
            if (!MimeMessageFiller.isCustomOrReplyHeader(name)) continue;
            String value = entry.getValue();
            if (HDR_REFERENCES.equals(name)) {
                mimeMessage.setHeader(name, MimeMessageUtility.fold(12, value));
                continue;
            }
            mimeMessage.setHeader(name, value);
        }
    }

    private void setReplyTo(ComposedMailMessage mail, MimeMessage mimeMessage) throws OXException, MessagingException {
        if (this.compositionParameters.setReplyTo()) {
            String hdrReplyTo = mail.getFirstHeader("Reply-To");
            if (!Strings.isEmpty((String)hdrReplyTo) && !Strings.toLowerCase((CharSequence)hdrReplyTo).startsWith("null")) {
                InternetAddress[] replyTo = null;
                try {
                    replyTo = QuotedInternetAddress.parse(hdrReplyTo, true);
                }
                catch (AddressException e) {
                    LOG.error("Specified Reply-To address cannot be parsed", (Throwable)e);
                }
                if (null != replyTo) {
                    mimeMessage.setReplyTo((Address[])replyTo);
                } else if (mail.containsFrom()) {
                    mimeMessage.setReplyTo((Address[])mail.getFrom());
                }
            } else {
                String replyTo = this.compositionParameters.getReplyToAddress();
                if (replyTo != null) {
                    try {
                        mimeMessage.setReplyTo((Address[])QuotedInternetAddress.parse(replyTo, true));
                    }
                    catch (AddressException e) {
                        LOG.error("Default Reply-To address cannot be parsed", (Throwable)e);
                        try {
                            mimeMessage.setHeader(MessageHeaders.HDR_REPLY_TO, MimeUtility.encodeWord((String)replyTo, (String)MailProperties.getInstance().getDefaultMimeCharset(), (String)"Q"));
                        }
                        catch (UnsupportedEncodingException e1) {
                            LOG.error("", (Throwable)e1);
                        }
                    }
                } else if (mail.containsFrom()) {
                    mimeMessage.setReplyTo((Address[])mail.getFrom());
                }
            }
        }
    }

    public static boolean isCustomOrReplyHeader(String headerName) {
        if (Strings.isEmpty((String)headerName)) {
            return false;
        }
        char first = headerName.charAt(0);
        if (('X' == first || 'x' == first) && '-' == headerName.charAt(1)) {
            return true;
        }
        String lc = Strings.toLowerCase((CharSequence)headerName);
        return "references".equals(lc) || "in-reply-to".equals(lc) || "message-id".equals(lc);
    }

    public static void setReplyHeaders(MailMessage referencedMail, MimeMessage mimeMessage) throws MessagingException {
        if (null == referencedMail) {
            return;
        }
        String pMsgId = referencedMail.getFirstHeader(HDR_MESSAGE_ID);
        if (pMsgId != null) {
            mimeMessage.setHeader(HDR_IN_REPLY_TO, pMsgId);
        }
        String pReferences = referencedMail.getFirstHeader(HDR_REFERENCES);
        String pInReplyTo = referencedMail.getFirstHeader(HDR_IN_REPLY_TO);
        StringBuilder refBuilder = new StringBuilder();
        if (pReferences != null) {
            refBuilder.append(pReferences);
        } else if (pInReplyTo != null) {
            refBuilder.append(pInReplyTo);
        }
        if (pMsgId != null) {
            if (refBuilder.length() > 0) {
                refBuilder.append(' ');
            }
            refBuilder.append(pMsgId);
            mimeMessage.setHeader(HDR_REFERENCES, MimeMessageUtility.fold(12, refBuilder.toString()));
        } else if (refBuilder.length() > 0) {
            mimeMessage.setHeader(HDR_REFERENCES, MimeMessageUtility.fold(12, refBuilder.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSendHeaders(ComposedMailMessage mail, MimeMessage mimeMessage) throws OXException {
        try {
            MailDateFormat mdf;
            this.setReplyTo(mail, mimeMessage);
            Date sentDate = mimeMessage.getSentDate();
            MailDateFormat mailDateFormat = mdf = MimeMessageUtility.getMailDateFormat(this.compositionParameters.getTimeZoneID());
            synchronized (mailDateFormat) {
                mimeMessage.setHeader("Date", mdf.format(sentDate == null ? new Date() : sentDate));
            }
            if (null == mimeMessage.getSubject()) {
                mimeMessage.setSubject(StringHelper.valueOf(this.compositionParameters.getLocale()).getString("[No Subject]"));
            }
        }
        catch (AddressException e) {
            throw MimeMailException.handleMessagingException((MessagingException)((Object)e));
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    public void fillMailBody(ComposedMailMessage mail, MimeMessage mimeMessage, ComposeType type) throws MessagingException, OXException, IOException {
        boolean embeddedImages;
        boolean sendMultipartAlternative;
        if (ComposeType.NEW_SMS.equals((Object)type)) {
            ContentType contentType = mail.getContentType();
            contentType.setPrimaryType("text").setSubType("plain");
        }
        boolean hasNestedMessages = false;
        int size = mail.getEnclosedCount();
        boolean hasAttachments = size > 0;
        boolean isAttachmentForward = ComposeType.FORWARD.equals((Object)type) && (this.compositionParameters.isForwardAsAttachment() || size > 1 && MimeMessageFiller.hasOnlyReferencedMailAttachments(mail, size));
        MimeMultipart primaryMultipart = null;
        if (hasAttachments || mail.isAppendVCard() || isAttachmentForward) {
            primaryMultipart = new MimeMultipart();
        }
        if (mail.isDraft()) {
            sendMultipartAlternative = false;
            if (mail.getContentType().startsWith("multipart/alternative")) {
                mail.setContentType("text/html");
            }
        } else {
            sendMultipartAlternative = mail.getContentType().startsWith("multipart/alternative");
        }
        TextBodyMailPart textBodyPart = mail.getBodyPart();
        StringBuilder sb = new StringBuilder((String)textBodyPart.getContent());
        Map<String, SourcedImage> images = SourcedImageUtility.hasSourcedImages(sb);
        String content = sb.toString();
        if (sendMultipartAlternative || mail.getContentType().startsWith("text/htm")) {
            embeddedImages = !images.isEmpty() || MimeMessageUtility.hasEmbeddedImages(content) || MimeMessageUtility.hasReferencedLocalImages(content);
        } else {
            content = MimeMessageFiller.dropImages(content, false);
            embeddedImages = false;
        }
        String charset = MailProperties.getInstance().getDefaultMimeCharset();
        if (hasAttachments || sendMultipartAlternative || isAttachmentForward || mail.isAppendVCard() || embeddedImages) {
            MimeBodyPart bodyPart;
            if (sendMultipartAlternative) {
                Multipart alternativeMultipart = this.createMultipartAlternative(mail, content, embeddedImages, images, textBodyPart, type);
                if (primaryMultipart == null) {
                    primaryMultipart = alternativeMultipart;
                } else {
                    bodyPart = new MimeBodyPart();
                    MessageUtility.setContent(alternativeMultipart, (Part)bodyPart);
                    primaryMultipart.addBodyPart((BodyPart)bodyPart);
                }
            } else if (embeddedImages && !mail.getContentType().startsWith("text/plain")) {
                Multipart relatedMultipart = this.createMultipartRelated(mail, content, images, new String[1]);
                if (primaryMultipart == null) {
                    primaryMultipart = relatedMultipart;
                } else {
                    bodyPart = new MimeBodyPart();
                    MessageUtility.setContent(relatedMultipart, (Part)bodyPart);
                    primaryMultipart.addBodyPart((BodyPart)bodyPart);
                }
            } else {
                if (primaryMultipart == null) {
                    primaryMultipart = new MimeMultipart();
                }
                if (mail.getContentType().startsWith("text/plain")) {
                    String plainText = textBodyPart.getPlainText();
                    if (null == plainText) {
                        primaryMultipart.addBodyPart(this.createTextBodyPart(MimeMessageFiller.toArray(content, content), charset, false, true, type), 0);
                    } else {
                        primaryMultipart.addBodyPart(this.createTextBodyPart(MimeMessageFiller.toArray(plainText, plainText), charset, false, false, type), 0);
                    }
                } else {
                    String wellFormedHTMLContent = this.htmlService.getConformHTML(content, charset);
                    primaryMultipart.addBodyPart(this.createHtmlBodyPart(wellFormedHTMLContent, charset));
                }
            }
            int size2 = mail.getEnclosedCount();
            if (size2 > 0) {
                if (isAttachmentForward) {
                    StringBuilder sb2 = new StringBuilder(32);
                    for (int i = 0; i < size2; ++i) {
                        MailPart enclosedMailPart = mail.getEnclosedMailPart(i);
                        if (this.isMessage(enclosedMailPart)) {
                            this.addNestedMessage(enclosedMailPart, Boolean.FALSE, (Multipart)primaryMultipart, sb2);
                            continue;
                        }
                        this.addMessageBodyPart((Multipart)primaryMultipart, enclosedMailPart, false);
                    }
                } else {
                    List<String> cidList = null;
                    for (int i = 0; i < size2; ++i) {
                        String contentId;
                        boolean add;
                        MailPart mailPart;
                        if (null == this.contentIds) {
                            if (this.discardReferencedInlinedImages) {
                                mailPart = mail.getEnclosedMailPart(i);
                                add = false;
                                if (embeddedImages && mailPart.getContentType().startsWith("image/")) {
                                    contentId = mailPart.getContentId();
                                    if (null != contentId) {
                                        if (null == cidList) {
                                            cidList = MimeMessageUtility.getContentIDs(content);
                                        }
                                        add = !MimeMessageUtility.containsContentId(contentId, cidList);
                                    } else {
                                        add = true;
                                    }
                                } else {
                                    add = true;
                                }
                                if (!add) continue;
                                this.addMessageBodyPart((Multipart)primaryMultipart, mailPart, false);
                                continue;
                            }
                            this.addMessageBodyPart((Multipart)primaryMultipart, mail.getEnclosedMailPart(i), false);
                            continue;
                        }
                        mailPart = mail.getEnclosedMailPart(i);
                        add = true;
                        if (mailPart.getContentType().startsWith("image/") && null != (contentId = mailPart.getContentId())) {
                            boolean bl = add = !MimeMessageUtility.containsContentId(contentId, this.contentIds);
                        }
                        if (!add) continue;
                        this.addMessageBodyPart((Multipart)primaryMultipart, mailPart, false);
                    }
                }
            }
            if ((primaryMultipart = this.appendVCard(mail, (Multipart)primaryMultipart, mimeMessage)) != null) {
                Object cto;
                if (1 == primaryMultipart.getCount() && (cto = primaryMultipart.getBodyPart(0).getContent()) instanceof Multipart) {
                    primaryMultipart = (Multipart)cto;
                }
                mimeMessage.setContent((Multipart)primaryMultipart);
            }
            return;
        }
        ContentType contentType = mail.getContentType();
        if (contentType.startsWith("text/")) {
            boolean isPlainText = contentType.startsWith("text/plain");
            if (contentType.getCharsetParameter() == null) {
                contentType.setCharsetParameter(charset);
            }
            if (primaryMultipart == null) {
                if (isPlainText) {
                    String text;
                    boolean isHtml;
                    String plainText = textBodyPart.getPlainText();
                    if (null == plainText) {
                        if (HTMLDetector.containsHTMLTags((String)content, (boolean)true)) {
                            isHtml = true;
                            if (BODY_START.matcher(content).find()) {
                                String wellFormedHTMLContent;
                                text = wellFormedHTMLContent = this.htmlService.getConformHTML(content, charset);
                            } else {
                                StringBuilder sb3 = new StringBuilder(content.length() + 512);
                                sb3.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n");
                                sb3.append("<html xmlns=\"http://www.w3.org/1999/xhtml\">\n");
                                sb3.append("<head>\n");
                                sb3.append("    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=").append(charset).append("\" />\n");
                                sb3.append("</head>\n");
                                sb3.append("<body>\n");
                                sb3.append(content);
                                sb3.append("</body>\n");
                                sb3.append("</html>");
                                text = sb3.toString();
                            }
                        } else {
                            isHtml = false;
                            text = content;
                        }
                    } else {
                        isHtml = false;
                        text = plainText;
                    }
                    String mailText = text == null || text.length() == 0 ? "" : (isHtml ? (ComposeType.NEW_SMS.equals((Object)type) ? content : TextProcessing.performLineFolding(this.htmlService.html2text(text, true), this.compositionParameters.getAutoLinebreak())) : (ComposeType.NEW_SMS.equals((Object)type) ? content : TextProcessing.performLineFolding(text, this.compositionParameters.getAutoLinebreak())));
                    mimeMessage.setDataHandler(new DataHandler((DataSource)new MessageDataSource(mailText, contentType)));
                } else {
                    String wellFormedHTMLContent = this.htmlService.getConformHTML(content, contentType.getCharsetParameter());
                    if (wellFormedHTMLContent == null || wellFormedHTMLContent.length() == 0) {
                        mimeMessage.setDataHandler(new DataHandler((DataSource)new MessageDataSource(this.htmlService.getConformHTML(HTML_SPACE, charset).replaceFirst(HTML_SPACE, ""), contentType)));
                    } else {
                        mimeMessage.setDataHandler(new DataHandler((DataSource)new MessageDataSource(wellFormedHTMLContent, contentType)));
                    }
                }
                mimeMessage.setHeader(HDR_MIME_VERSION, VERSION_1_0);
                mimeMessage.setHeader(MessageHeaders.HDR_CONTENT_TYPE, MimeMessageUtility.foldContentType(contentType.toString()));
            } else {
                MimeBodyPart msgBodyPart = new MimeBodyPart();
                mimeMessage.setDataHandler(new DataHandler((DataSource)new MessageDataSource(mail.getContent().toString(), contentType)));
                msgBodyPart.setHeader(HDR_MIME_VERSION, VERSION_1_0);
                msgBodyPart.setHeader(MessageHeaders.HDR_CONTENT_TYPE, MimeMessageUtility.foldContentType(contentType.toString()));
                primaryMultipart.addBodyPart((BodyPart)msgBodyPart);
            }
        } else {
            MimeMultipart mp = null;
            if (primaryMultipart == null) {
                primaryMultipart = mp = new MimeMultipart();
            } else {
                mp = primaryMultipart;
            }
            MimeBodyPart msgBodyPart = new MimeBodyPart();
            MessageUtility.setText("", charset, (Part)msgBodyPart);
            String disposition = msgBodyPart.getHeader(MessageHeaders.HDR_CONTENT_DISPOSITION, null);
            if (disposition == null) {
                msgBodyPart.setHeader(MessageHeaders.HDR_CONTENT_DISPOSITION, "inline");
            } else {
                ContentDisposition contentDisposition = new ContentDisposition(disposition);
                contentDisposition.setDisposition("inline");
                msgBodyPart.setHeader(MessageHeaders.HDR_CONTENT_DISPOSITION, MimeMessageUtility.foldContentDisposition(contentDisposition.toString()));
            }
            mp.addBodyPart((BodyPart)msgBodyPart);
            this.addMessageBodyPart((Multipart)mp, mail, true);
        }
        if (primaryMultipart != null) {
            MessageUtility.setContent((Multipart)primaryMultipart, (Part)mimeMessage);
        }
    }

    private Multipart appendVCard(ComposedMailMessage mail, Multipart primaryMultipart, MimeMessage mimeMessage) throws OXException, MessagingException, UnsupportedEncodingException {
        block7: {
            String charset = MailProperties.getInstance().getDefaultMimeCharset();
            String fileName = this.compositionParameters.getUserVCardFileName();
            if (mail.isAppendVCard() && fileName != null) {
                String encodedFileName = MimeUtility.encodeText((String)fileName, (String)charset, (String)"Q");
                for (int i = 0; i < mail.getEnclosedCount(); ++i) {
                    MailPart part = mail.getEnclosedMailPart(i);
                    if (!encodedFileName.equalsIgnoreCase(part.getFileName())) {
                        continue;
                    }
                    break block7;
                }
                try {
                    MimeBodyPart vcardPart = new MimeBodyPart();
                    ContentType ct = new ContentType("text/vcard");
                    ct.setCharsetParameter(charset);
                    vcardPart.setDataHandler(new DataHandler((DataSource)new MessageDataSource(this.compositionParameters.getUserVCard(), ct.toString())));
                    if (!ct.containsNameParameter()) {
                        ct.setNameParameter(encodedFileName);
                    }
                    vcardPart.setHeader(MessageHeaders.HDR_CONTENT_TYPE, MimeMessageUtility.foldContentType(ct.toString()));
                    vcardPart.setHeader(HDR_MIME_VERSION, VERSION_1_0);
                    ContentDisposition cd = new ContentDisposition("attachment");
                    cd.setFilenameParameter(encodedFileName);
                    vcardPart.setHeader(MessageHeaders.HDR_CONTENT_DISPOSITION, MimeMessageUtility.foldContentDisposition(cd.toString()));
                    Multipart mp = null == primaryMultipart ? new MimeMultipart() : primaryMultipart;
                    mp.addBodyPart((BodyPart)vcardPart);
                    if (mail.isDraft()) {
                        mimeMessage.setHeader(MessageHeaders.HDR_X_OX_VCARD, "true");
                    }
                    return mp;
                }
                catch (OXException e) {
                    LOG.error(VCARD_ERROR, (Throwable)e);
                }
            }
        }
        return primaryMultipart;
    }

    private boolean isMessage(MailPart enclosedMailPart) {
        ContentType contentType = enclosedMailPart.getContentType();
        if (contentType.startsWith(MIME_MESSAGE_RFC822)) {
            return true;
        }
        String nameParameter = contentType.getNameParameter();
        return nameParameter != null && nameParameter.endsWith(EXT_EML);
    }

    protected final Multipart createMultipartAlternative(ComposedMailMessage mail, String mailBody, boolean embeddedImages, Map<String, SourcedImage> images, TextBodyMailPart textBodyPart) throws OXException, MessagingException {
        return this.createMultipartAlternative(mail, mailBody, embeddedImages, images, textBodyPart, null);
    }

    protected final Multipart createMultipartAlternative(ComposedMailMessage mail, String mailBody, boolean embeddedImages, Map<String, SourcedImage> images, TextBodyMailPart textBodyPart, ComposeType type) throws OXException, MessagingException {
        String htmlContent;
        MimeMultipart alternativeMultipart = new MimeMultipart(MP_ALTERNATIVE);
        String charset = MailProperties.getInstance().getDefaultMimeCharset();
        if (embeddedImages) {
            String[] arr = new String[1];
            Multipart relatedMultipart = this.createMultipartRelated(mail, mailBody, images, arr);
            htmlContent = arr[0];
            MimeBodyPart altBodyPart = new MimeBodyPart();
            MessageUtility.setContent(relatedMultipart, (Part)altBodyPart);
            alternativeMultipart.addBodyPart((BodyPart)altBodyPart);
        } else {
            String wellFormedHTMLContent;
            htmlContent = wellFormedHTMLContent = this.htmlService.getConformHTML(mailBody, charset);
            BodyPart html = this.createHtmlBodyPart(wellFormedHTMLContent, charset);
            alternativeMultipart.addBodyPart(html);
        }
        String plainText = textBodyPart.getPlainText();
        if (null == plainText) {
            alternativeMultipart.addBodyPart(this.createTextBodyPart(MimeMessageFiller.toArray(htmlContent, mailBody), charset, true, true, type), 0);
        } else {
            alternativeMultipart.addBodyPart(this.createTextBodyPart(MimeMessageFiller.toArray(plainText, plainText), charset, true, false, type), 0);
        }
        return alternativeMultipart;
    }

    protected Multipart createMultipartRelated(ComposedMailMessage mail, String mailBody, Map<String, SourcedImage> images, String[] htmlContent) throws OXException, MessagingException {
        MimeMultipart relatedMultipart = new MimeMultipart(MP_RELATED);
        String charset = MailProperties.getInstance().getDefaultMimeCharset();
        String wellFormedHTMLContent = this.htmlService.getConformHTML(mailBody, charset);
        htmlContent[0] = this.processReferencedLocalImages(wellFormedHTMLContent, (Multipart)relatedMultipart, this, mail);
        relatedMultipart.addBodyPart(this.createHtmlBodyPart(htmlContent[0], charset), 0);
        List<String> cidList = MimeMessageUtility.getContentIDs(wellFormedHTMLContent);
        StringBuilder tmp = new StringBuilder(32);
        for (String cid : cidList) {
            MimeBodyPart relatedImageBodyPart;
            SourcedImage image = images.get(cid);
            if (null == image) {
                MailPart imgPart = MimeMessageFiller.getAndRemoveImageAttachment(cid, mail);
                if (imgPart == null) continue;
                relatedImageBodyPart = new MimeBodyPart();
                relatedImageBodyPart.setDataHandler(imgPart.getDataHandler());
                Iterator<Map.Entry<String, String>> iter = imgPart.getHeadersIterator();
                while (iter.hasNext()) {
                    Map.Entry<String, String> e = iter.next();
                    relatedImageBodyPart.setHeader(e.getKey(), e.getValue());
                }
            } else {
                MessageDataSource dataSource;
                if ("base64".equalsIgnoreCase(image.getTransferEncoding())) {
                    dataSource = new MessageDataSource(Base64.decodeBase64((byte[])Charsets.toAsciiBytes((String)image.getData())), image.getContentType());
                } else {
                    try {
                        byte[] bs = QuotedPrintableCodec.decodeQuotedPrintable((byte[])image.getData().getBytes());
                        dataSource = new MessageDataSource(bs, image.getContentType());
                    }
                    catch (DecoderException e) {
                        LOG.warn("Couldn't decode {} image data.", (Object)image.getTransferEncoding(), (Object)e);
                        continue;
                    }
                }
                MimeBodyPart imgBodyPart = new MimeBodyPart();
                imgBodyPart.setDataHandler(new DataHandler((DataSource)dataSource));
                tmp.setLength(0);
                imgBodyPart.setContentID(tmp.append('<').append(cid).append('>').toString());
                ContentDisposition contentDisposition = new ContentDisposition("inline");
                imgBodyPart.setHeader(MessageHeaders.HDR_CONTENT_DISPOSITION, MimeMessageUtility.foldContentDisposition(contentDisposition.toString()));
                ContentType ct = new ContentType(image.getContentType());
                imgBodyPart.setHeader(MessageHeaders.HDR_CONTENT_TYPE, MimeMessageUtility.foldContentType(ct.toString()));
                relatedImageBodyPart = imgBodyPart;
            }
            relatedMultipart.addBodyPart((BodyPart)relatedImageBodyPart);
        }
        this.contentIds = new HashSet<String>(8);
        int count = relatedMultipart.getCount();
        for (int i = 0; i < count; ++i) {
            BodyPart bodyPart = relatedMultipart.getBodyPart(i);
            String[] header = bodyPart.getHeader(MessageHeaders.HDR_CONTENT_TYPE);
            if (null == header || 0 >= header.length || !header[0].toLowerCase(Locale.US).startsWith("image/") || null == (header = bodyPart.getHeader(MessageHeaders.HDR_CONTENT_ID)) || 0 >= header.length) continue;
            this.contentIds.add(header[0]);
        }
        return relatedMultipart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Set<String> octetExtensions() {
        Set<String> tmp = octetExtensions;
        if (null != tmp) return tmp;
        Class<MimeMessageFiller> clazz = MimeMessageFiller.class;
        synchronized (MimeMessageFiller.class) {
            tmp = octetExtensions;
            if (null != tmp) return tmp;
            String defaultValue = "pgp";
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            if (null == service) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return new HashSet<String>(Arrays.asList(defaultValue));
            }
            String csv = service.getProperty("com.openexchange.mail.octetExtensions", defaultValue);
            octetExtensions = tmp = new HashSet<String>(Arrays.asList(Strings.splitByComma((String)csv)));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    private static String extensionFor(String fileName) {
        if (null == fileName) {
            return null;
        }
        int pos = fileName.lastIndexOf(46);
        return Strings.asciiLowerCase((String)(pos > 0 ? fileName.substring(pos + 1) : fileName));
    }

    protected final void addMessageBodyPart(Multipart mp, MailPart part, boolean inline) throws MessagingException, OXException {
        String partId;
        ContentDisposition cd;
        String disposition;
        if (part.getContentType().startsWith(MIME_MESSAGE_RFC822)) {
            StringBuilder sb = new StringBuilder(32);
            this.addNestedMessage(part, null, mp, sb);
            return;
        }
        String fileName = part.getFileName();
        ContentType ct = part.getContentType();
        if (fileName != null && (ct.startsWith(MIME_APPL_OCTET) || ct.startsWith(MIME_MULTIPART_OCTET)) && !MimeMessageFiller.octetExtensions().contains(MimeMessageFiller.extensionFor(fileName))) {
            String ct2 = MimeType2ExtMap.getContentType(fileName);
            int pos = ct2.indexOf(47);
            ct.setPrimaryType(ct2.substring(0, pos));
            ct.setSubType(ct2.substring(pos + 1));
        }
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setDataHandler(part.getDataHandler());
        if (fileName != null && !ct.containsNameParameter()) {
            ct.setNameParameter(fileName);
        }
        messageBodyPart.setHeader(MessageHeaders.HDR_CONTENT_TYPE, MimeMessageUtility.foldContentType(ct.toString()));
        if (!inline) {
            messageBodyPart.setHeader(MessageHeaders.HDR_CONTENT_TRANSFER_ENC, "base64");
        }
        if ((disposition = messageBodyPart.getHeader(MessageHeaders.HDR_CONTENT_DISPOSITION, null)) == null) {
            cd = new ContentDisposition(inline ? "inline" : "attachment");
        } else {
            cd = new ContentDisposition(disposition);
            cd.setDisposition(inline ? "inline" : "attachment");
        }
        if (fileName != null && !cd.containsFilenameParameter()) {
            cd.setFilenameParameter(fileName);
        }
        messageBodyPart.setHeader(MessageHeaders.HDR_CONTENT_DISPOSITION, MimeMessageUtility.foldContentDisposition(cd.toString()));
        String contentId = part.getContentId();
        if (contentId != null) {
            if (contentId.charAt(0) == '<') {
                messageBodyPart.setContentID(contentId);
            } else {
                messageBodyPart.setContentID(new StringBuilder(contentId.length() + 2).append('<').append(contentId).append('>').toString());
            }
        }
        if ((partId = part.getFirstHeader(MessageHeaders.HDR_X_PART_ID)) == null) {
            messageBodyPart.setHeader(MessageHeaders.HDR_X_PART_ID, UUIDs.getUnformattedStringFromRandom());
            mp.addBodyPart((BodyPart)messageBodyPart);
        } else {
            messageBodyPart.setHeader(MessageHeaders.HDR_X_PART_ID, partId);
            if (!MimeMessageFiller.contains(partId, MessageHeaders.HDR_X_PART_ID, mp)) {
                mp.addBodyPart((BodyPart)messageBodyPart);
            }
        }
    }

    private static final boolean contains(String partId, String hdrName, Multipart mp) throws MessagingException {
        int count = mp.getCount();
        for (int i = 0; i < count; ++i) {
            MimeBodyPart mimeBodyPart;
            String header;
            BodyPart bodyPart = mp.getBodyPart(i);
            if (!(bodyPart instanceof MimeBodyPart) || (header = (mimeBodyPart = (MimeBodyPart)bodyPart).getHeader(hdrName, null)) == null || !partId.equals(header)) continue;
            return true;
        }
        return false;
    }

    protected void addNestedMessage(MailPart mailPart, Boolean inline, Multipart primaryMultipart, StringBuilder sb) throws OXException, MessagingException {
        boolean bInline;
        String fn;
        ThresholdFileHolder sink = new ThresholdFileHolder(65536, 65536);
        sink.write(mailPart.getInputStream());
        if (null == mailPart.getFileName()) {
            String subject = MimeMessageUtility.checkNonAscii(new InternetHeaders(sink.getStream()).getHeader(MessageHeaders.HDR_SUBJECT, null));
            if (null == subject || subject.length() == 0) {
                fn = sb.append(PREFIX_PART).append(EXT_EML).toString();
            } else {
                subject = MimeMessageUtility.decodeMultiEncodedHeader(MimeMessageUtility.unfold(subject));
                fn = sb.append(subject.replaceAll("\\p{Blank}+", "_")).append(EXT_EML).toString();
                sb.setLength(0);
            }
        } else {
            fn = mailPart.getFileName();
        }
        boolean bl = bInline = null != inline ? inline.booleanValue() : "inline".equalsIgnoreCase(mailPart.getContentDisposition().getDisposition());
        if (sink.isInMemory()) {
            ByteArrayOutputStream buffer = sink.getBuffer();
            if (null == buffer) {
                this.addNestedMessage(primaryMultipart, new DataHandler((DataSource)new FileHolderDataSource(sink, MIME_MESSAGE_RFC822)), fn, bInline);
            } else {
                this.addNestedMessage(primaryMultipart, new DataHandler((DataSource)new ByteArrayDataSource(buffer.toByteArray(), MIME_MESSAGE_RFC822)), fn, bInline);
            }
        } else {
            this.addNestedMessage(primaryMultipart, new DataHandler((DataSource)new FileHolderDataSource(sink, MIME_MESSAGE_RFC822)), fn, bInline);
        }
    }

    private final void addNestedMessage(Multipart mp, DataHandler dataHandler, String filename, boolean inline) throws MessagingException, OXException {
        ContentDisposition cd;
        MimeBodyPart origMsgPart = new MimeBodyPart();
        origMsgPart.setDataHandler(dataHandler);
        ContentType ct = new ContentType(MIME_MESSAGE_RFC822);
        if (null != filename) {
            ct.setNameParameter(filename);
        }
        origMsgPart.setHeader(MessageHeaders.HDR_CONTENT_TYPE, MimeMessageUtility.foldContentType(ct.toString()));
        String disposition = origMsgPart.getHeader(MessageHeaders.HDR_CONTENT_DISPOSITION, null);
        if (disposition == null) {
            cd = new ContentDisposition(inline ? "inline" : "attachment");
        } else {
            cd = new ContentDisposition(disposition);
            cd.setDisposition(inline ? "inline" : "attachment");
        }
        if (null != filename && !cd.containsFilenameParameter()) {
            cd.setFilenameParameter(filename);
        }
        origMsgPart.setHeader(MessageHeaders.HDR_CONTENT_DISPOSITION, MimeMessageUtility.foldContentDisposition(cd.toString()));
        mp.addBodyPart((BodyPart)origMsgPart);
    }

    protected final BodyPart createTextBodyPart(String[] contents, String charset, boolean appendHref, boolean isHtml, ComposeType type) throws MessagingException {
        MimeBodyPart text = new MimeBodyPart();
        String content = contents[0];
        String textContent = content == null || content.length() == 0 ? "" : (isHtml ? (ComposeType.NEW_SMS.equals((Object)type) ? contents[1] : TextProcessing.performLineFolding(this.htmlService.html2text(content, appendHref), this.compositionParameters.getAutoLinebreak())) : (ComposeType.NEW_SMS.equals((Object)type) ? content : TextProcessing.performLineFolding(content, this.compositionParameters.getAutoLinebreak())));
        MessageUtility.setText(textContent, charset, (Part)text);
        text.setHeader(HDR_MIME_VERSION, VERSION_1_0);
        text.setHeader(MessageHeaders.HDR_CONTENT_TYPE, "text/plain; charset=" + charset);
        return text;
    }

    protected final BodyPart createHtmlBodyPart(String wellFormedHTMLContent, String charset) throws MessagingException, OXException {
        try {
            String contentType = "text/html; charset=" + charset;
            MimeBodyPart html = new MimeBodyPart();
            if (wellFormedHTMLContent == null || wellFormedHTMLContent.length() == 0) {
                html.setDataHandler(new DataHandler((DataSource)new MessageDataSource(this.htmlService.getConformHTML(HTML_SPACE, charset).replaceFirst(HTML_SPACE, ""), contentType)));
            } else {
                html.setDataHandler(new DataHandler((DataSource)new MessageDataSource(wellFormedHTMLContent, contentType)));
            }
            html.setHeader(HDR_MIME_VERSION, VERSION_1_0);
            html.setHeader(MessageHeaders.HDR_CONTENT_TYPE, contentType);
            return html;
        }
        catch (UnsupportedEncodingException e) {
            throw new MessagingException("Unsupported encoding.", (Exception)e);
        }
    }

    protected static final String dropImages(String htmlContent, boolean considerAlt) {
        Matcher m = PATTERN_IMG.matcher(htmlContent);
        if (!m.find()) {
            return htmlContent;
        }
        MatcherReplacer mr = new MatcherReplacer(m, htmlContent);
        StringBuilder sb = new StringBuilder(htmlContent.length());
        if (considerAlt) {
            Matcher tmp = null;
            do {
                String alternative = (tmp = PATTERN_IMG_ALT.matcher(m.group())).find() ? tmp.group(1) : null;
                mr.appendLiteralReplacement(sb, null == alternative ? "" : " " + alternative + " ");
            } while (m.find());
        } else {
            do {
                mr.appendLiteralReplacement(sb, "");
            } while (m.find());
        }
        mr.appendTail(sb);
        return sb.toString();
    }

    private static String blankSrc(String imageTag) {
        return MimeMessageUtility.blankSrc(imageTag);
    }

    protected final String processReferencedLocalImages(String htmlContent, Multipart mp, MimeMessageFiller msgFiller, ComposedMailMessage mail) throws MessagingException, OXException {
        if (Strings.isEmpty((String)htmlContent)) {
            return htmlContent;
        }
        ImageMatcher m = ImageMatcher.matcher(htmlContent);
        StringBuffer sb = new StringBuffer(htmlContent.length());
        if (m.find()) {
            msgFiller.uploadFileIDs = new HashSet<String>(4);
            HashSet<String> uploadFileIDs = msgFiller.uploadFileIDs;
            HashSet<String> trackedIds = new HashSet<String>(4);
            ManagedFileManagement mfm = ServerServiceRegistry.getInstance().getService(ManagedFileManagement.class);
            ConversionService conversionService = ServerServiceRegistry.getInstance().getService(ConversionService.class);
            do {
                String imageTag;
                if (MimeMessageUtility.isValidImageUri(imageTag = m.group())) {
                    String iid;
                    ImageProvider imageProvider;
                    String id;
                    block30: {
                        id = m.getManagedFileId();
                        if (null != id) {
                            if (mfm.contains(id)) {
                                try {
                                    imageProvider = new ManagedFileImageProvider(mfm.getByID(id));
                                    break block30;
                                }
                                catch (OXException e) {
                                    LOG.warn("Image with id \"{}\" could not be loaded. Referenced image is skipped.", (Object)id, (Object)e);
                                    m.appendLiteralReplacement(sb, MimeMessageFiller.blankSrc(imageTag));
                                    continue;
                                }
                            }
                            int size = mail.getEnclosedCount();
                            if (size <= 0) {
                                LOG.warn("Image with id \"{}\" could not be loaded. Referenced image is skipped.", (Object)id);
                                m.appendLiteralReplacement(sb, MimeMessageFiller.blankSrc(imageTag));
                                continue;
                            }
                            ReferencedPartImageProvider tmp = null;
                            String prefix = "<" + UUIDs.getUnformattedString((UUID)UUID.fromString(id));
                            int i = size;
                            while (null == tmp && i-- > 0) {
                                String contentId;
                                MailPart part = mail.getEnclosedMailPart(i);
                                if (!ComposedMailPart.ComposedPartType.REFERENCE.equals((Object)((ComposedMailPart)((Object)part)).getType()) || null == (contentId = part.getContentId()) || !contentId.startsWith(prefix, 0)) continue;
                                tmp = new ReferencedPartImageProvider(part);
                                mail.removeEnclosedPart(i);
                            }
                            if (null == tmp) {
                                LOG.warn("Image with id \"{}\" could not be loaded. Referenced image is skipped.", (Object)id);
                                m.appendLiteralReplacement(sb, MimeMessageFiller.blankSrc(imageTag));
                                continue;
                            }
                            imageProvider = tmp;
                        } else {
                            ImageLocation imageLocation;
                            ImageLocation il;
                            String blankImageTag = null;
                            Matcher srcMatcher = PATTERN_SRC.matcher(imageTag);
                            if (srcMatcher.find()) {
                                try {
                                    il = ImageUtility.parseImageLocationFrom(PATTERN_AMP.matcher(srcMatcher.group(1)).replaceAll("&"));
                                }
                                catch (IllegalArgumentException e) {
                                    StringBuffer bblankImageTag = new StringBuffer(imageTag.length());
                                    srcMatcher.appendReplacement(bblankImageTag, "");
                                    srcMatcher.appendTail(bblankImageTag);
                                    blankImageTag = bblankImageTag.toString();
                                    il = null;
                                }
                                imageLocation = il;
                            } else {
                                try {
                                    il = ImageUtility.parseImageLocationFrom(imageTag);
                                }
                                catch (IllegalArgumentException e) {
                                    il = null;
                                }
                                imageLocation = il;
                            }
                            if (null == imageLocation) {
                                LOG.warn("Image with id \"{}\" could not be loaded. Referenced image is skipped.", (Object)m.getImageId());
                                m.appendLiteralReplacement(sb, null == blankImageTag ? MimeMessageFiller.blankSrc(imageTag) : blankImageTag);
                                continue;
                            }
                            ImageDataSource dataSource = (ImageDataSource)conversionService.getDataSource(imageLocation.getRegistrationName());
                            if (null == dataSource) {
                                LOG.warn("No image data source found with id \"{}\". Referenced image is skipped.", (Object)imageLocation.getRegistrationName());
                                m.appendLiteralReplacement(sb, MimeMessageFiller.blankSrc(imageTag));
                                continue;
                            }
                            try {
                                imageProvider = this.compositionParameters.createImageProvider(dataSource, imageLocation);
                            }
                            catch (OXException e) {
                                imageProvider = null;
                                if (MailExceptionCode.MAIL_NOT_FOUND.equals(e)) {
                                    String contentId = new StringBuilder(48).append('<').append(imageLocation.getImageId()).append('>').toString();
                                    MailPart imagePart = null;
                                    int size = mail.getEnclosedCount();
                                    for (int i = 0; null == imagePart && i < size; ++i) {
                                        MailPart part = mail.getEnclosedMailPart(i);
                                        if (!ComposedMailPart.ComposedPartType.REFERENCE.equals((Object)((ComposedMailPart)((Object)part)).getType()) || !contentId.equals(part.getContentId())) continue;
                                        imagePart = part;
                                    }
                                    if (null != imagePart) {
                                        imageProvider = new ReferencedPartImageProvider(imagePart);
                                    }
                                }
                                if (null == imageProvider) {
                                    if (MimeMessageFiller.isIgnorableException(e)) {
                                        m.appendLiteralReplacement(sb, MimeMessageFiller.blankSrc(imageTag));
                                        continue;
                                    }
                                    throw e;
                                }
                            }
                            catch (RuntimeException rte) {
                                LOG.warn("Couldn't load image data", (Throwable)rte);
                                m.appendLiteralReplacement(sb, MimeMessageFiller.blankSrc(imageTag));
                                continue;
                            }
                        }
                    }
                    if (null == id) {
                        iid = MimeMessageFiller.urlDecode(m.getImageId());
                    } else {
                        uploadFileIDs.add(id);
                        iid = id;
                    }
                    boolean appendBodyPart = trackedIds.add(iid);
                    String iTag = imageTag.replaceFirst("(?i)src=\"[^\"]*\"", Strings.quoteReplacement((String)("src=\"cid:" + MimeMessageFiller.processLocalImage(imageProvider, iid, appendBodyPart, mp) + "\"")));
                    iTag = iTag.replaceFirst("(?i)id=\"[^\"]*@Open-Xchange\"", "");
                    m.appendLiteralReplacement(sb, iTag);
                    continue;
                }
                m.appendLiteralReplacement(sb, imageTag);
            } while (m.find());
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private static boolean isIgnorableException(OXException e) {
        return MimeMailExceptionCode.IMAGE_ATTACHMENTS_UNSUPPORTED.equals(e) || MailExceptionCode.IMAGE_ATTACHMENT_NOT_FOUND.equals(e) || DataExceptionCodes.ERROR.equals(e) || MailExceptionCode.MAIL_NOT_FOUND.equals(e) || MailExceptionCode.ATTACHMENT_NOT_FOUND.equals(e) || MimeMessageFiller.isFolderNotFound(e);
    }

    private static String urlDecode(String s) {
        return MimeMessageUtility.urlDecode(s);
    }

    private static final String processLocalImage(ImageProvider imageProvider, String id, boolean appendBodyPart, Multipart mp) throws MessagingException, OXException {
        String cid;
        String fileName = imageProvider.getFileName();
        if (null == fileName) {
            List<String> exts = MimeType2ExtMap.getFileExtensions(imageProvider.getContentType().toLowerCase(Locale.ENGLISH));
            StringBuilder sb = new StringBuilder("image.");
            if (exts == null) {
                sb.append("dat");
            } else {
                sb.append(exts.get(0));
            }
            fileName = sb.toString();
        } else {
            try {
                fileName = MimeUtility.encodeText((String)fileName, (String)MailProperties.getInstance().getDefaultMimeCharset(), (String)"Q");
            }
            catch (UnsupportedEncodingException e) {
                fileName = imageProvider.getFileName();
            }
        }
        StringBuilder tmp = new StringBuilder(32);
        if (imageProvider.isLocalFile()) {
            tmp.setLength(0);
            tmp.append(PATTERN_DASHES.matcher(id).replaceAll(""));
            tmp.append('@').append(VERSION_NAME);
            cid = tmp.toString();
        } else {
            cid = id;
        }
        if (appendBodyPart) {
            boolean found = false;
            HashSet<String> set = new HashSet<String>(2);
            int count = mp.getCount();
            for (int i = 0; !found && i < count; ++i) {
                BodyPart bodyPart = mp.getBodyPart(i);
                String[] header = bodyPart.getHeader(MessageHeaders.HDR_CONTENT_ID);
                if (null == header || 0 >= header.length) continue;
                set.clear();
                set.addAll(Arrays.asList(header));
                found = set.contains(cid);
            }
            if (!found) {
                MimeBodyPart imgBodyPart = new MimeBodyPart();
                imgBodyPart.setDataHandler(new DataHandler(imageProvider.getDataSource()));
                tmp.setLength(0);
                imgBodyPart.setContentID(tmp.append('<').append(cid).append('>').toString());
                ContentDisposition contentDisposition = new ContentDisposition("inline");
                if (fileName != null) {
                    contentDisposition.setFilenameParameter(fileName);
                }
                imgBodyPart.setHeader(MessageHeaders.HDR_CONTENT_DISPOSITION, MimeMessageUtility.foldContentDisposition(contentDisposition.toString()));
                ContentType ct = new ContentType(imageProvider.getContentType());
                if (fileName != null && !ct.containsNameParameter()) {
                    ct.setNameParameter(fileName);
                }
                imgBodyPart.setHeader(MessageHeaders.HDR_CONTENT_TYPE, MimeMessageUtility.foldContentType(ct.toString()));
                mp.addBodyPart((BodyPart)imgBodyPart);
            }
        }
        return cid;
    }

    protected static final MailPart getAndRemoveImageAttachment(String cid, ComposedMailMessage mail) throws OXException {
        int size = mail.getEnclosedCount();
        for (int i = 0; i < size; ++i) {
            MailPart enclosedPart = mail.getEnclosedMailPart(i);
            if (!enclosedPart.containsContentId() || !MimeMessageUtility.equalsCID(cid, enclosedPart.getContentId())) continue;
            return mail.removeEnclosedPart(i);
        }
        return null;
    }

    private static final boolean hasOnlyReferencedMailAttachments(ComposedMailMessage mail, int size) throws OXException {
        for (int i = 0; i < size; ++i) {
            MailPart part = mail.getEnclosedMailPart(i);
            if (ComposedMailPart.ComposedPartType.REFERENCE.equals((Object)((ComposedMailPart)((Object)part)).getType()) && ((ReferencedMailPart)part).isMail()) continue;
            return false;
        }
        return true;
    }

    private static String[] toArray(String ... contents) {
        if (null == contents) {
            return new String[0];
        }
        int length = contents.length;
        if (0 == length) {
            return new String[0];
        }
        String[] ret = new String[length];
        System.arraycopy(contents, 0, ret, 0, length);
        return ret;
    }

    private static boolean isFolderNotFound(OXException e) {
        if (null == e) {
            return false;
        }
        return MimeMailExceptionCode.FOLDER_NOT_FOUND.equals(e) || MailExceptionCode.FOLDER_DOES_NOT_HOLD_MESSAGES.equals(e) || "IMAP".equals(e.getPrefix()) && MimeMailExceptionCode.FOLDER_NOT_FOUND.getNumber() == e.getCode();
    }

    static {
        MailReloadable.getInstance().addReloadable(new Reloadable(){

            public void reloadConfiguration(ConfigurationService configService) {
                octetExtensions = null;
            }

            public Map<String, String[]> getConfigFileNames() {
                return null;
            }
        });
        PATTERN_IMG = Pattern.compile("<img[^>]*/?>", 2);
        PATTERN_IMG_ALT = Pattern.compile("alt=\"([^\"]+)\"", 2);
        PATTERN_SRC = MimeMessageUtility.PATTERN_SRC;
        PATTERN_AMP = Pattern.compile(Pattern.quote("&amp;"));
        PATTERN_DASHES = Pattern.compile("-+");
    }

    static class ImageDataImageProvider
    implements ImageProvider {
        private final Data<InputStream> data;
        private final String contentType;
        private final String fileName;

        public ImageDataImageProvider(ImageDataSource imageData, ImageLocation imageLocation, Session session) throws OXException {
            this.data = imageData.getData(InputStream.class, imageData.generateDataArgumentsFrom(imageLocation), session);
            DataProperties dataProperties = this.data.getDataProperties();
            this.fileName = dataProperties.get("com.openexchange.conversion.name");
            String contentType = dataProperties.get("com.openexchange.conversion.content-type");
            if (null != contentType) {
                String contentTypeByFileName;
                String lcct = Strings.toLowerCase((CharSequence)contentType).trim();
                String defaultContentType = MimeMessageFiller.MIME_APPL_OCTET;
                if (!lcct.startsWith("image/") && !lcct.startsWith(MimeMessageFiller.MIME_APPL_OCTET)) {
                    throw MailExceptionCode.ATTACHMENT_NOT_FOUND.create(imageLocation.getImageId(), imageLocation.getId(), imageLocation.getFolder());
                }
                if (lcct.startsWith(MimeMessageFiller.MIME_APPL_OCTET) && !Strings.isEmpty((String)this.fileName) && !MimeMessageFiller.MIME_APPL_OCTET.equals(contentTypeByFileName = MimeType2ExtMap.getContentType(this.fileName))) {
                    contentType = contentTypeByFileName + (lcct.length() > MimeMessageFiller.MIME_APPL_OCTET.length() ? lcct.substring(MimeMessageFiller.MIME_APPL_OCTET.length()) : "");
                }
            }
            this.contentType = contentType;
        }

        @Override
        public boolean isLocalFile() {
            return false;
        }

        @Override
        public String getContentType() {
            return this.contentType;
        }

        @Override
        public DataSource getDataSource() throws OXException {
            try {
                return new MessageDataSource((InputStream)this.data.getData(), this.contentType);
            }
            catch (IOException e) {
                if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName()) || e.getCause() instanceof MessageRemovedException) {
                    throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
                }
                throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
            }
        }

        @Override
        public String getFileName() {
            return this.fileName;
        }
    }

    private static class ManagedFileImageProvider
    implements ImageProvider {
        private final ManagedFile managedFile;

        public ManagedFileImageProvider(ManagedFile managedFile) {
            this.managedFile = managedFile;
        }

        @Override
        public boolean isLocalFile() {
            return true;
        }

        @Override
        public String getContentType() {
            return this.managedFile.getContentType();
        }

        @Override
        public DataSource getDataSource() throws OXException {
            return new FileDataSource(this.managedFile.getFile());
        }

        @Override
        public String getFileName() {
            return this.managedFile.getFileName();
        }
    }

    private static class ReferencedPartImageProvider
    implements ImageProvider {
        private final MailPart mailPart;

        public ReferencedPartImageProvider(MailPart mailPart) {
            this.mailPart = mailPart;
        }

        @Override
        public boolean isLocalFile() {
            return false;
        }

        @Override
        public String getContentType() {
            return this.mailPart.getContentType().toString();
        }

        @Override
        public DataSource getDataSource() throws OXException {
            return this.mailPart.getDataHandler().getDataSource();
        }

        @Override
        public String getFileName() {
            return this.mailPart.getFileName();
        }
    }

    public static interface ImageProvider {
        public boolean isLocalFile();

        public String getFileName();

        public DataSource getDataSource() throws OXException;

        public String getContentType();
    }
}

