/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime.filler;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.image.ImageDataSource;
import com.openexchange.image.ImageLocation;
import com.openexchange.mail.mime.MimeMailExceptionCode;
import com.openexchange.mail.mime.filler.CompositionParameters;
import com.openexchange.mail.mime.filler.MimeMessageFiller;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.user.UserService;
import java.util.Locale;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.idn.IDNA;

public class ContextCompositionParameters
implements CompositionParameters {
    private final String envelopeFrom;
    private final InternetAddress senderAddress;
    private final User contextAdmin;
    private final UserSettingMail contextAdminUSM;

    public ContextCompositionParameters(Context context) throws OXException {
        this(context, "<>", null);
    }

    public ContextCompositionParameters(Context context, String envelopeFrom, InternetAddress senderAddress) throws OXException {
        this.envelopeFrom = envelopeFrom;
        this.senderAddress = senderAddress;
        this.contextAdmin = ServerServiceRegistry.getServize(UserService.class, true).getUser(context.getMailadmin(), context);
        this.contextAdminUSM = UserSettingMailStorage.getInstance().getUserSettingMail(context.getMailadmin(), context);
    }

    @Override
    public String getOrganization() throws OXException {
        return null;
    }

    @Override
    public String getClient() throws OXException {
        return null;
    }

    @Override
    public String getOriginatingIP() throws OXException {
        return null;
    }

    @Override
    public String getEnvelopeFrom() throws OXException {
        try {
            return IDNA.toACE((String)this.envelopeFrom);
        }
        catch (AddressException e) {
            throw MimeMailExceptionCode.INVALID_EMAIL_ADDRESS.create(this.envelopeFrom);
        }
    }

    @Override
    public InternetAddress getSenderAddress(InternetAddress from) throws OXException, AddressException {
        if (this.senderAddress != null && !this.senderAddress.equals((Object)from)) {
            return this.senderAddress;
        }
        return null;
    }

    @Override
    public String getTimeZoneID() throws OXException {
        return this.contextAdmin.getTimeZone();
    }

    @Override
    public String getReplyToAddress() throws OXException {
        return null;
    }

    @Override
    public boolean setReplyTo() {
        return true;
    }

    @Override
    public Locale getLocale() throws OXException {
        return this.contextAdmin.getLocale();
    }

    @Override
    public String getUserVCardFileName() throws OXException {
        return null;
    }

    @Override
    public byte[] getUserVCard() throws OXException {
        return null;
    }

    @Override
    public int getAutoLinebreak() {
        if (this.contextAdminUSM != null) {
            return this.contextAdminUSM.getAutoLinebreak();
        }
        return -1;
    }

    @Override
    public boolean isForwardAsAttachment() {
        if (this.contextAdminUSM != null) {
            return this.contextAdminUSM.isForwardAsAttachment();
        }
        return false;
    }

    @Override
    public MimeMessageFiller.ImageProvider createImageProvider(ImageDataSource dataSource, ImageLocation imageLocation) throws OXException {
        throw MimeMailExceptionCode.IMAGE_ATTACHMENTS_UNSUPPORTED.create();
    }
}

