/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime;

import com.openexchange.ajax.helper.CombinedInputStream;
import com.openexchange.java.Charsets;
import com.openexchange.mail.mime.HeaderCollection;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import java.io.InputStream;

public final class MimeHeaderNameChecker {
    private static final byte[] PATTERN_LFCRLF = new byte[]{10, 13, 10};
    private static final byte[] PATTERN_LFLF = new byte[]{10, 10};

    private MimeHeaderNameChecker() {
    }

    public static InputStream sanitizeHeaderNames(byte[] bytes) {
        int length = bytes.length;
        int index = MimeHeaderNameChecker.indexOf(bytes, PATTERN_LFCRLF, 0, length);
        if (index < 0 && (index = MimeHeaderNameChecker.indexOf(bytes, PATTERN_LFLF, 0, length)) < 0) {
            return new UnsynchronizedByteArrayInputStream(bytes);
        }
        try {
            byte[] csb;
            HeaderCollection hc = new HeaderCollection((InputStream)new UnsynchronizedByteArrayInputStream(bytes, 0, index));
            String hcStr = hc.toString();
            if (hcStr.endsWith("\r\n")) {
                byte[] src = hcStr.getBytes(Charsets.ISO_8859_1);
                csb = new byte[src.length - 2];
                System.arraycopy(src, 0, csb, 0, csb.length);
            } else {
                csb = hcStr.getBytes(Charsets.ISO_8859_1);
            }
            return new CombinedInputStream(csb, (InputStream)new UnsynchronizedByteArrayInputStream(bytes, index, length));
        }
        catch (Exception e) {
            return new UnsynchronizedByteArrayInputStream(bytes);
        }
    }

    private static int indexOf(byte[] data, byte[] pattern, int beginIndex, int endIndex) {
        if (beginIndex < 0 || beginIndex > data.length) {
            throw new IndexOutOfBoundsException(String.valueOf(beginIndex));
        }
        if (endIndex < 0 || endIndex > data.length) {
            throw new IndexOutOfBoundsException(String.valueOf(endIndex));
        }
        if (beginIndex > endIndex) {
            throw new IndexOutOfBoundsException(String.valueOf(endIndex - beginIndex));
        }
        int[] failure = MimeHeaderNameChecker.computeFailure(pattern);
        if (failure == null) {
            throw new IllegalArgumentException("pattern is null");
        }
        int j = 0;
        if (data.length == 0) {
            return -1;
        }
        for (int i = beginIndex; i < endIndex; ++i) {
            while (j > 0 && pattern[j] != data[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == data[i]) {
                ++j;
            }
            if (j != pattern.length) continue;
            return i - pattern.length + 1;
        }
        return -1;
    }

    private static int[] computeFailure(byte[] pattern) {
        if (pattern == null) {
            return null;
        }
        int[] failure = new int[pattern.length];
        int j = 0;
        for (int i = 1; i < pattern.length; ++i) {
            while (j > 0 && pattern[j] != pattern[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == pattern[i]) {
                // empty if block
            }
            failure[i] = ++j;
        }
        return failure;
    }
}

