/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime;

import com.openexchange.config.ConfigurationService;
import com.openexchange.config.Reloadable;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.config.MailReloadable;
import com.openexchange.mail.mime.MimeSessionPropertyNames;
import java.util.Map;
import java.util.Properties;
import javax.mail.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MimeDefaultSession {
    private static volatile Session instance;
    private static volatile Properties properties;

    private MimeDefaultSession() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Session getDefaultSession() {
        Session tmp = instance;
        if (tmp != null) return tmp;
        Class<MimeDefaultSession> clazz = MimeDefaultSession.class;
        synchronized (MimeDefaultSession.class) {
            tmp = instance;
            if (tmp != null) return tmp;
            Properties systemProperties = System.getProperties();
            systemProperties.putAll((Map<?, ?>)MimeDefaultSession.getDefaultMailProperties());
            instance = tmp = Session.getInstance((Properties)((Properties)systemProperties.clone()), null);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Properties getDefaultMailProperties() {
        Properties p = properties;
        if (null != properties) return (Properties)p.clone();
        Class<MimeDefaultSession> clazz = MimeDefaultSession.class;
        synchronized (MimeDefaultSession.class) {
            p = properties;
            if (null != properties) return (Properties)p.clone();
            p = new Properties();
            p.put("mail.mime.base64.ignoreerrors", "true");
            p.put("mail.imap.allowreadonlyselect", "true");
            p.put("mail.mime.encodeeol.strict", "true");
            p.put("mail.mime.decodetext.strict", "false");
            p.put(MimeSessionPropertyNames.PROP_MAIL_MIME_MULTIPART_ALLOWEMPTY, "true");
            MailProperties mailProperties = MailProperties.getInstance();
            String defaultMimeCharset = mailProperties.getDefaultMimeCharset();
            if (null == defaultMimeCharset) {
                Logger log = LoggerFactory.getLogger(MimeDefaultSession.class);
                log.warn("Missing default MIME charset in mail configuration. Mail configuration is probably not initialized. Using fallback 'UTF-8' instead");
                p.put("mail.mime.charset", "UTF-8");
            } else {
                p.put("mail.mime.charset", defaultMimeCharset);
            }
            Properties javaMailProperties = mailProperties.getJavaMailProperties();
            if (javaMailProperties != null) {
                p.putAll((Map<?, ?>)javaMailProperties);
            }
            properties = p;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (Properties)p.clone();
        }
    }

    static {
        MailReloadable.getInstance().addReloadable(new Reloadable(){

            public void reloadConfiguration(ConfigurationService configService) {
                instance = null;
                properties = null;
            }

            public Map<String, String[]> getConfigFileNames() {
                return null;
            }
        });
    }
}

