/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.exception.OXException;
import com.openexchange.json.cache.JsonCacheService;
import com.openexchange.json.cache.JsonCaches;
import com.openexchange.log.LogProperties;
import com.openexchange.mail.FullnameArgument;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailField;
import com.openexchange.mail.MailFields;
import com.openexchange.mail.MailListField;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.OrderDirection;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.ThreadedStructure;
import com.openexchange.mail.json.ColumnCollection;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.MailRequestSha1Calculator;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.mail.json.converters.MailConverter;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.server.ServiceLookup;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.tools.collections.PropertizedList;
import com.openexchange.tools.session.ServerSession;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SimpleThreadStructureAction
extends AbstractMailAction
implements MailRequestSha1Calculator {
    protected static final Logger LOG = LoggerFactory.getLogger(SimpleThreadStructureAction.class);

    public SimpleThreadStructureAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(MailRequest req) throws OXException {
        JsonCacheService jsonCache;
        boolean cache = req.optBool("cache", false);
        if (cache && CACHABLE_FORMATS.contains(req.getRequest().getFormat()) && (jsonCache = JsonCaches.getCache()) != null) {
            AJAXRequestResult result;
            ServerSession session;
            String sha1Sum = this.getSha1For(req);
            final String id = "com.openexchange.mail." + sha1Sum;
            JSONValue jsonValue = jsonCache.opt(id, (session = req.getSession()).getUserId(), session.getContextId());
            if (jsonValue == null || jsonValue.length() == 0) {
                int fetchLimit;
                String folderId;
                long max = req.getMax();
                MailServletInterface mailInterface = this.getMailInterface(req);
                int messageCount = mailInterface.getMessageCount(folderId = req.checkParameter("folder"));
                if (messageCount <= 0 || messageCount <= (fetchLimit = this.getFetchLimit(mailInterface)) || max > 0L && max <= (long)fetchLimit) {
                    return this.perform0(req, mailInterface, false);
                }
                result = new AJAXRequestResult((Object)new JSONArray(0), "json");
                result.setResponseProperty("cached", Boolean.TRUE);
            } else {
                result = new AJAXRequestResult((Object)jsonValue, "json");
                result.setResponseProperty("cached", Boolean.TRUE);
            }
            AJAXRequestData requestData = req.getRequest().copyOf();
            requestData.setProperty("mail.sha1", sha1Sum);
            requestData.setProperty("mail.sha1calc", this);
            requestData.setProperty(id, jsonValue);
            final MailRequest mailRequest = new MailRequest(requestData, session);
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ServerSession session = mailRequest.getSession();
                    MailServletInterface mailInterface = null;
                    boolean locked = false;
                    try {
                        if (!jsonCache.lock(id, session.getUserId(), session.getContextId())) {
                            return;
                        }
                        locked = true;
                        mailInterface = MailServletInterface.getInstance(session);
                        AJAXRequestResult requestResult = SimpleThreadStructureAction.this.perform0(mailRequest, mailInterface, true);
                        MailConverter.getInstance().convert(mailRequest.getRequest(), requestResult, session, null);
                    }
                    catch (Exception e) {
                        try {
                            jsonCache.delete(id, session.getUserId(), session.getContextId());
                        }
                        catch (Exception ignore) {
                            // empty catch block
                        }
                    }
                    finally {
                        if (null != mailInterface) {
                            try {
                                mailInterface.close(true);
                            }
                            catch (Exception e) {}
                        }
                        if (locked) {
                            try {
                                jsonCache.unlock(id, session.getUserId(), session.getContextId());
                            }
                            catch (Exception e) {}
                        }
                    }
                }
            };
            ThreadPools.getThreadPool().submit(ThreadPools.trackableTask((Runnable)r));
            return result;
        }
        return this.perform0(req, this.getMailInterface(req), cache);
    }

    private int getFetchLimit(MailServletInterface mailInterface) throws OXException {
        if (null == mailInterface) {
            return MailProperties.getInstance().getMailFetchLimit();
        }
        try {
            return mailInterface.getMailConfig().getMailProperties().getMailFetchLimit();
        }
        catch (RuntimeException e) {
            return MailProperties.getInstance().getMailFetchLimit();
        }
    }

    protected AJAXRequestResult perform0(MailRequest req, MailServletInterface mailInterface, boolean cache) throws OXException {
        try {
            int sortCol;
            int i;
            boolean found;
            int fieldFlags;
            boolean filterApplied;
            int[] fromToIndices;
            String folderId = req.checkParameter("folder");
            FullnameArgument arg = MailFolderUtility.prepareMailFolderParam(folderId);
            LogProperties.put((LogProperties.Name)LogProperties.Name.MAIL_FULL_NAME, (Object)arg.getFullname());
            LogProperties.put((LogProperties.Name)LogProperties.Name.MAIL_ACCOUNT_ID, (Object)Integer.toString(arg.getAccountId()));
            ColumnCollection columnCollection = req.checkColumnsAndHeaders();
            int[] columns = columnCollection.getFields();
            String[] headers = columnCollection.getHeaders();
            String sort = req.getParameter("sort");
            String order = req.getParameter("order");
            if (sort != null && order == null) {
                throw MailExceptionCode.MISSING_PARAM.create("order");
            }
            String s = req.getParameter("limit");
            if (null == s) {
                int leftHandLimit = req.optInt("left_hand_limit");
                int rightHandLimit = req.optInt("right_hand_limit");
                if (leftHandLimit == -9999 || rightHandLimit == -9999) {
                    fromToIndices = null;
                } else {
                    fromToIndices = new int[]{leftHandLimit < 0 ? 0 : leftHandLimit, rightHandLimit < 0 ? 0 : rightHandLimit};
                    if (fromToIndices[0] >= fromToIndices[1]) {
                        return new AJAXRequestResult((Object)ThreadedStructure.valueOf(Collections.emptyList()), "mail");
                    }
                }
            } else {
                int end;
                int start;
                try {
                    int i2;
                    int pos = s.indexOf(44);
                    if (pos < 0) {
                        start = 0;
                        i2 = Integer.parseInt(s.trim());
                        end = i2 < 0 ? 0 : i2;
                    } else {
                        i2 = Integer.parseInt(s.substring(0, pos).trim());
                        start = i2 < 0 ? 0 : i2;
                        i2 = Integer.parseInt(s.substring(pos + 1).trim());
                        end = i2 < 0 ? 0 : i2;
                    }
                }
                catch (NumberFormatException e) {
                    throw MailExceptionCode.INVALID_INT_VALUE.create(e, s);
                }
                if (start >= end) {
                    return new AJAXRequestResult((Object)ThreadedStructure.valueOf(Collections.emptyList()), "mail");
                }
                fromToIndices = new int[]{start, end};
            }
            long lookAhead = req.getMax();
            boolean includeSent = req.optBool("includeSent", false);
            boolean ignoreSeen = req.optBool("unseen", false);
            boolean ignoreDeleted = !req.optBool("deleted", true);
            boolean bl = filterApplied = ignoreSeen || ignoreDeleted;
            if (filterApplied) {
                fieldFlags = MailListField.FLAGS.getField();
                found = false;
                for (i = 0; !found && i < columns.length; ++i) {
                    found = fieldFlags == columns[i];
                }
                if (!found) {
                    int[] tmp = columns;
                    columns = new int[columns.length + 1];
                    System.arraycopy(tmp, 0, columns, 0, tmp.length);
                    columns[tmp.length] = fieldFlags;
                }
            }
            if (null != headers && headers.length > 0) {
                fieldFlags = MailListField.ID.getField();
                found = false;
                for (i = 0; !found && i < columns.length; ++i) {
                    found = fieldFlags == columns[i];
                }
                if (!found) {
                    int[] tmp = columns;
                    columns = new int[columns.length + 1];
                    System.arraycopy(tmp, 0, columns, 0, tmp.length);
                    columns[tmp.length] = fieldFlags;
                }
            }
            columns = SimpleThreadStructureAction.prepareColumns(columns);
            int orderDir = OrderDirection.ASC.getOrder();
            if (order != null) {
                if (order.equalsIgnoreCase("asc")) {
                    orderDir = OrderDirection.ASC.getOrder();
                } else if (order.equalsIgnoreCase("desc")) {
                    orderDir = OrderDirection.DESC.getOrder();
                } else {
                    throw MailExceptionCode.INVALID_INT_VALUE.create("order");
                }
            }
            long start = System.currentTimeMillis();
            int n = sortCol = sort == null ? MailListField.RECEIVED_DATE.getField() : Integer.parseInt(sort);
            if (!filterApplied) {
                List<List<MailMessage>> mails = mailInterface.getAllSimpleThreadStructuredMessages(folderId, includeSent, cache, sortCol, orderDir, columns, fromToIndices, lookAhead);
                if (null != headers && headers.length > 0) {
                    this.enrichWithHeaders(mails, headers, mailInterface.getMailAccess().getMessageStorage());
                }
                return new AJAXRequestResult((Object)ThreadedStructure.valueOf(mails), "mail");
            }
            List<List<MailMessage>> mails = mailInterface.getAllSimpleThreadStructuredMessages(folderId, includeSent, false, sortCol, orderDir, columns, null, lookAhead);
            boolean cached = false;
            int more = -1;
            if (mails instanceof PropertizedList) {
                PropertizedList propertizedList = (PropertizedList)mails;
                Boolean b = (Boolean)propertizedList.getProperty("cached");
                cached = null != b && b != false;
                Integer i3 = (Integer)propertizedList.getProperty("more");
                more = null == i3 ? -1 : i3;
            }
            Iterator<List<MailMessage>> iterator = mails.iterator();
            while (iterator.hasNext()) {
                List<MailMessage> list = iterator.next();
                boolean foundUnseen = false;
                Iterator<MailMessage> tmp = list.iterator();
                while (tmp.hasNext()) {
                    MailMessage message = tmp.next();
                    if (SimpleThreadStructureAction.discardMail(message, false, ignoreDeleted)) {
                        tmp.remove();
                        continue;
                    }
                    foundUnseen |= !message.isSeen();
                }
                if (!ignoreSeen || foundUnseen) continue;
                iterator.remove();
            }
            if (null != fromToIndices) {
                int fromIndex = fromToIndices[0];
                int toIndex = fromToIndices[1];
                int sz = mails.size();
                if (fromIndex > sz) {
                    mails = Collections.emptyList();
                } else {
                    if (toIndex >= sz) {
                        toIndex = sz;
                    }
                    mails = mails.subList(fromIndex, toIndex);
                }
            }
            if (null != headers && headers.length > 0) {
                this.enrichWithHeaders(mails, headers, mailInterface.getMailAccess().getMessageStorage());
            }
            AJAXRequestResult result = new AJAXRequestResult((Object)ThreadedStructure.valueOf(mails), "mail");
            result.setResponseProperty("cached", cached);
            if (more > 0) {
                result.setResponseProperty("more", more);
            }
            return result.setDurationByStart(start);
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    private void enrichWithHeaders(List<List<MailMessage>> conversations, String[] headerNames, IMailMessageStorage messageStorage) throws OXException {
        HashMap<String, LinkedList<MailMessage>> folders2 = new HashMap<String, LinkedList<MailMessage>>(4);
        for (List<MailMessage> list : conversations) {
            for (MailMessage mail : list) {
                if (null == mail) continue;
                String fullName = mail.getFolder();
                LinkedList<MailMessage> msgs = (LinkedList<MailMessage>)folders2.get(fullName);
                if (null == msgs) {
                    msgs = new LinkedList<MailMessage>();
                    folders2.put(fullName, msgs);
                }
                msgs.add(mail);
            }
        }
        for (Map.Entry entry : folders2.entrySet()) {
            this.enrichWithHeaders((String)entry.getKey(), (List)entry.getValue(), headerNames, messageStorage);
        }
    }

    private void enrichWithHeaders(String fullName, List<MailMessage> mails, String[] headerNames, IMailMessageStorage messageStorage) throws OXException {
        LinkedList<String> ids = new LinkedList<String>();
        for (MailMessage mail : mails) {
            if (null == mail) continue;
            ids.add(mail.getMailId());
        }
        MailMessage[] ms = messageStorage.getMessages(fullName, ids.toArray(new String[ids.size()]), MailFields.toArray(MailField.ID, MailField.HEADERS));
        HashMap<String, MailMessage> headers = new HashMap<String, MailMessage>(ms.length);
        for (MailMessage header : ms) {
            headers.put(header.getMailId(), header);
        }
        for (MailMessage mail : mails) {
            MailMessage header;
            if (null == mail || null == (header = (MailMessage)headers.get(mail.getMailId()))) continue;
            for (String headerName : headerNames) {
                String[] values = header.getHeader(headerName);
                if (null == values) continue;
                for (String value : values) {
                    mail.addHeader(headerName, value);
                }
            }
        }
    }

    @Override
    public String getSha1For(MailRequest req) throws OXException {
        String id = (String)req.getRequest().getProperty("mail.sha1");
        if (null != id) {
            return id;
        }
        String sha1Sum = JsonCaches.getSHA1Sum((String[])new String[]{"threadedAll", req.checkParameter("folder"), req.checkParameter("columns"), req.getParameter("sort"), req.getParameter("order"), req.getParameter("limit"), req.getParameter("max"), req.getParameter("left_hand_limit"), req.getParameter("right_hand_limit"), req.getParameter("includeSent"), req.getParameter("unseen"), req.getParameter("deleted")});
        return sha1Sum;
    }
}

