/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.container.ThresholdFileHolder;
import com.openexchange.ajax.helper.DownloadUtility;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.java.Streams;
import com.openexchange.java.Strings;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipException;
import javax.mail.MessageRemovedException;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Action(method=RequestMethod.GET, name="zip_messages", description="Get multiple mails as a ZIP file.", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="folder", description="The folder identifier."), @Parameter(name="id", description="A comma-separated list of Object IDs of the requested mails.")}, responseDescription="The raw byte data of the ZIP file.")
public final class GetMultipleMessagesAction
extends AbstractMailAction {
    public GetMultipleMessagesAction(ServiceLookup services) {
        super(services);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AJAXRequestResult perform(MailRequest req) throws OXException, JSONException {
        ArrayList<IdFolderPair> pairs;
        String value = req.getParameter("body");
        if (GetMultipleMessagesAction.isEmpty(value)) {
            String[] ids;
            String folderPath = req.checkParameter("folder");
            String parameterId = "id";
            String sIds = req.getParameter("id");
            if (null == sIds) {
                JSONArray jArray = (JSONArray)req.getRequest().requireData();
                int length = jArray.length();
                ids = new String[length];
                for (int i = 0; i < length; ++i) {
                    ids[i] = jArray.getJSONObject(i).getString("id");
                }
            } else {
                ids = Strings.splitByComma((String)sIds);
            }
            pairs = new ArrayList(ids.length);
            for (int i = 0; i < ids.length; ++i) {
                pairs.add(new IdFolderPair(ids[i], folderPath));
            }
        } else {
            JSONArray jsonArray = new JSONArray(value);
            int len = jsonArray.length();
            pairs = new ArrayList<IdFolderPair>(len);
            for (int i = 0; i < len; ++i) {
                JSONObject tuple = jsonArray.getJSONObject(i);
                String id = tuple.getString("id");
                String folderId = tuple.optString("folder_id", null);
                if (null == folderId) {
                    folderId = tuple.optString("folder", null);
                }
                IdFolderPair pair = new IdFolderPair(id, folderId);
                pairs.add(pair);
            }
        }
        Collections.sort(pairs);
        AJAXRequestData ajaxRequestData = req.getRequest();
        if (ajaxRequestData.setResponseHeader("Content-Type", "application/zip")) {
            StringBuilder sb = new StringBuilder(512);
            sb.append("attachment");
            DownloadUtility.appendFilenameParameter("mails.zip", "application/zip", ajaxRequestData.getUserAgent(), sb);
            ajaxRequestData.setResponseHeader("Content-Disposition", sb.toString());
            try {
                this.performMultipleFolder(req, pairs, ajaxRequestData.optOutputStream());
                return new AJAXRequestResult(AJAXRequestResult.DIRECT_OBJECT, "direct").setType(AJAXRequestResult.ResultType.DIRECT);
            }
            catch (IOException e) {
                throw AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage());
            }
        }
        ThresholdFileHolder thresholdFileHolder = new ThresholdFileHolder();
        boolean error = true;
        try {
            this.performMultipleFolder(req, pairs, thresholdFileHolder.asOutputStream());
            error = false;
        }
        finally {
            if (error) {
                Streams.close((Closeable)((Object)thresholdFileHolder));
            }
        }
        req.getRequest().setFormat("file");
        thresholdFileHolder.setContentType("application/zip");
        thresholdFileHolder.setName("mails.zip");
        return new AJAXRequestResult((Object)thresholdFileHolder, "file");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void performMultipleFolder(MailRequest req, List<IdFolderPair> pairs, OutputStream out) throws OXException {
        MailServletInterface mailInterface = this.getMailInterface(req);
        ZipArchiveOutputStream zipOutput = null;
        try {
            zipOutput = new ZipArchiveOutputStream(out);
            zipOutput.setEncoding("UTF-8");
            zipOutput.setUseLanguageEncodingFlag(true);
            int size = pairs.size();
            HashSet<String> names = new HashSet<String>(size);
            String ext = ".eml";
            for (int i = 0; i < size; ++i) {
                ZipArchiveEntry entry;
                IdFolderPair pair = pairs.get(i);
                MailMessage message = mailInterface.getMessage(pair.folderId, pair.identifier, false);
                if (null == message) continue;
                String subject = message.getSubject();
                String name = (GetMultipleMessagesAction.isEmpty(subject) ? "mail" + (i + 1) : MailServletInterface.saneForFileName(subject)) + ext;
                int reslen = name.lastIndexOf(46);
                int count = 1;
                while (!names.add(name)) {
                    name = name.substring(0, reslen);
                    name = name + "_(" + count++ + ')' + ext;
                }
                int num = 1;
                while (true) {
                    try {
                        int pos = name.indexOf(ext);
                        String entryName = name.substring(0, pos) + (num > 1 ? "_(" + num + ")" : "") + ext;
                        entry = new ZipArchiveEntry(entryName);
                        zipOutput.putArchiveEntry((ArchiveEntry)entry);
                    }
                    catch (ZipException e) {
                        String eMessage = e.getMessage();
                        if (eMessage == null) throw e;
                        if (!eMessage.startsWith("duplicate entry")) {
                            throw e;
                        }
                        ++num;
                        continue;
                    }
                    break;
                }
                long before = zipOutput.getBytesWritten();
                message.writeTo((OutputStream)zipOutput);
                long entrySize = zipOutput.getBytesWritten() - before;
                entry.setSize(entrySize);
                zipOutput.closeArchiveEntry();
            }
        }
        catch (IOException e) {
            try {
                if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName())) throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
                if (e.getCause() instanceof MessageRemovedException) {
                    throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
                }
                throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
                catch (RuntimeException e2) {
                    throw MailExceptionCode.UNEXPECTED_ERROR.create(e2, e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                Streams.close(zipOutput);
                throw throwable;
            }
        }
        Streams.close((Closeable)zipOutput);
    }

    private final class IdFolderPair
    implements Comparable<IdFolderPair> {
        final String identifier;
        final String folderId;

        IdFolderPair(String identifier, String folderId) {
            this.identifier = identifier;
            this.folderId = folderId;
        }

        @Override
        public int compareTo(IdFolderPair o) {
            int retval = this.folderId.compareTo(o.folderId);
            if (0 == retval) {
                retval = this.identifier.compareTo(o.identifier);
            }
            return retval;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            if (this.identifier != null) {
                builder.append("identifier=").append(this.identifier).append(", ");
            }
            if (this.folderId != null) {
                builder.append("folderId=").append(this.folderId);
            }
            builder.append("]");
            return builder.toString();
        }
    }
}

