/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.cache.CacheFolderStorage;
import com.openexchange.java.Strings;
import com.openexchange.mail.FullnameArgument;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailField;
import com.openexchange.mail.MailSortField;
import com.openexchange.mail.OrderDirection;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailFolderDescription;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractArchiveMailAction;
import com.openexchange.mail.permission.DefaultMailPermission;
import com.openexchange.mail.search.ComparisonType;
import com.openexchange.mail.search.ReceivedDateTerm;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.session.ServerSession;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@Action(method=RequestMethod.PUT, name="archive_folder", description="Moves mails to archive folder from given folder using certain criteria", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="days", description="The days threshold to use."), @Parameter(name="folder", description="Object ID of the source folder.")}, responseDescription="A JSON true response.")
public final class ArchiveFolderAction
extends AbstractArchiveMailAction {
    public ArchiveFolderAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(MailRequest req) throws OXException {
        MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess = null;
        try {
            String sDays = req.getRequest().getParameter("days");
            int days = Strings.isEmpty((String)sDays) ? MailProperties.getInstance().getDefaultArchiveDays() : Strings.parsePositiveInt((String)sDays.trim());
            String sourceFolder = req.checkParameter("folder");
            ServerSession session = req.getSession();
            FullnameArgument fa = MailFolderUtility.prepareMailFolderParam(sourceFolder);
            int accountId = fa.getAccountId();
            mailAccess = MailAccess.getInstance(session, accountId);
            mailAccess.connect();
            int[] separatorRef = new int[1];
            String archiveFullname = this.checkArchiveFullNameFor(mailAccess, req, separatorRef);
            char separator = (char)separatorRef[0];
            String fullName = fa.getFullname();
            if (fullName.equals(archiveFullname) || fullName.startsWith(archiveFullname + separator)) {
                AJAXRequestResult aJAXRequestResult = new AJAXRequestResult((Object)Boolean.TRUE, "native");
                return aJAXRequestResult;
            }
            Calendar cal = Calendar.getInstance(TimeZoneUtils.getTimeZone("UTC"));
            cal.set(14, 0);
            cal.set(13, 0);
            cal.set(12, 0);
            cal.set(11, 0);
            cal.add(5, days * -1);
            ReceivedDateTerm term = new ReceivedDateTerm(ComparisonType.LESS_THAN, cal.getTime());
            MailMessage[] msgs = mailAccess.getMessageStorage().searchMessages(fa.getFullname(), null, MailSortField.RECEIVED_DATE, OrderDirection.DESC, term, new MailField[]{MailField.ID, MailField.RECEIVED_DATE});
            if (null == msgs || msgs.length <= 0) {
                AJAXRequestResult aJAXRequestResult = new AJAXRequestResult((Object)Boolean.TRUE, "native");
                return aJAXRequestResult;
            }
            HashMap<Integer, LinkedList<String>> map = new HashMap<Integer, LinkedList<String>>(4);
            for (MailMessage mailMessage : msgs) {
                Date receivedDate = mailMessage.getReceivedDate();
                cal.setTime(receivedDate);
                Integer year = cal.get(1);
                LinkedList<String> ids = (LinkedList<String>)map.get(year);
                if (null == ids) {
                    ids = new LinkedList<String>();
                    map.put(year, ids);
                }
                ids.add(mailMessage.getMailId());
            }
            for (Map.Entry entry : map.entrySet()) {
                String sYear = ((Integer)entry.getKey()).toString();
                String fn = archiveFullname + separator + sYear;
                if (!mailAccess.getFolderStorage().exists(fn)) {
                    MailFolderDescription toCreate = new MailFolderDescription();
                    toCreate.setAccountId(accountId);
                    toCreate.setParentAccountId(accountId);
                    toCreate.setParentFullname(archiveFullname);
                    toCreate.setExists(false);
                    toCreate.setFullname(fn);
                    toCreate.setName(sYear);
                    toCreate.setSeparator(separator);
                    DefaultMailPermission mp = new DefaultMailPermission();
                    mp.setEntity(session.getUserId());
                    int p = 128;
                    mp.setAllPermission(128, 128, 128, 128);
                    mp.setFolderAdmin(true);
                    mp.setGroupPermission(false);
                    toCreate.addPermission(mp);
                    mailAccess.getFolderStorage().createFolder(toCreate);
                    CacheFolderStorage.getInstance().removeFromCache(archiveFullname, "0", true, session);
                }
                List ids = (List)entry.getValue();
                mailAccess.getMessageStorage().moveMessages(fa.getFullname(), fn, ids.toArray(new String[ids.size()]), true);
            }
            AJAXRequestResult aJAXRequestResult = new AJAXRequestResult((Object)Boolean.TRUE, "native");
            return aJAXRequestResult;
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            if (null != mailAccess) {
                mailAccess.close(true);
            }
        }
    }
}

