/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.cache.CacheFolderStorage;
import com.openexchange.groupware.i18n.MailStrings;
import com.openexchange.groupware.ldap.User;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.dataobjects.MailFolderDescription;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.mail.permission.DefaultMailPermission;
import com.openexchange.mailaccount.Attribute;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountDescription;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.ServiceLookup;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.threadpool.AbstractTask;
import com.openexchange.threadpool.Task;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.tools.session.ServerSession;
import java.util.EnumSet;

public abstract class AbstractArchiveMailAction
extends AbstractMailAction {
    protected AbstractArchiveMailAction(ServiceLookup services) {
        super(services);
    }

    protected String checkArchiveFullNameFor(MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess, MailRequest req, int[] separatorRef) throws OXException {
        String parentFullName;
        char separator;
        String archiveName;
        final int accountId = mailAccess.getAccountId();
        final ServerSession session = req.getSession();
        MailAccountStorageService service = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class);
        if (null == service) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{MailAccountStorageService.class.getName()});
        }
        MailAccount mailAccount = service.getMailAccount(accountId, session.getUserId(), session.getContextId());
        String archiveFullName = mailAccount.getArchiveFullname();
        if (AbstractArchiveMailAction.isEmpty(archiveFullName)) {
            MailAccountStorageService mass;
            String prefix;
            archiveName = mailAccount.getArchive();
            boolean updateAccount = false;
            if (AbstractArchiveMailAction.isEmpty(archiveName)) {
                User user = session.getUser();
                if (!AJAXRequestDataTools.parseBoolParameter("useDefaultName", req.getRequest(), true)) {
                    String i18nArchive = StringHelper.valueOf(user.getLocale()).getString(MailStrings.ARCHIVE);
                    throw MailExceptionCode.MISSING_DEFAULT_FOLDER_NAME.create(Category.CATEGORY_USER_INPUT, new Object[]{i18nArchive});
                }
                archiveName = StringHelper.valueOf(user.getLocale()).getString(MailStrings.DEFAULT_ARCHIVE);
                updateAccount = true;
            }
            if (AbstractArchiveMailAction.isEmpty(prefix = mailAccess.getFolderStorage().getDefaultFolderPrefix())) {
                separator = mailAccess.getFolderStorage().getFolder("INBOX").getSeparator();
                archiveFullName = archiveName;
                parentFullName = "default";
            } else {
                separator = prefix.charAt(prefix.length() - 1);
                archiveFullName = prefix + archiveName;
                parentFullName = prefix.substring(0, prefix.length() - 1);
            }
            if (updateAccount && null != (mass = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class))) {
                final String af = archiveFullName;
                ThreadPools.getThreadPool().submit((Task)new AbstractTask<Void>(){

                    public Void call() throws Exception {
                        MailAccountDescription mad = new MailAccountDescription();
                        mad.setId(accountId);
                        mad.setArchiveFullname(af);
                        mass.updateMailAccount(mad, EnumSet.of(Attribute.ARCHIVE_FULLNAME_LITERAL), session.getUserId(), session.getContextId(), session);
                        return null;
                    }
                });
            }
        } else {
            separator = mailAccess.getFolderStorage().getFolder("INBOX").getSeparator();
            int pos = archiveFullName.lastIndexOf(separator);
            if (pos > 0) {
                parentFullName = archiveFullName.substring(0, pos);
                archiveName = archiveFullName.substring(pos + 1);
            } else {
                parentFullName = "default";
                archiveName = archiveFullName;
            }
        }
        if (!mailAccess.getFolderStorage().exists(archiveFullName)) {
            if (!AJAXRequestDataTools.parseBoolParameter("createIfAbsent", req.getRequest(), true)) {
                throw MailExceptionCode.FOLDER_NOT_FOUND.create(archiveFullName);
            }
            MailFolderDescription toCreate = new MailFolderDescription();
            toCreate.setAccountId(accountId);
            toCreate.setParentAccountId(accountId);
            toCreate.setParentFullname(parentFullName);
            toCreate.setExists(false);
            toCreate.setFullname(archiveFullName);
            toCreate.setName(archiveName);
            toCreate.setSeparator(separator);
            DefaultMailPermission mp = new DefaultMailPermission();
            mp.setEntity(session.getUserId());
            int p = 128;
            mp.setAllPermission(128, 128, 128, 128);
            mp.setFolderAdmin(true);
            mp.setGroupPermission(false);
            toCreate.addPermission(mp);
            mailAccess.getFolderStorage().createFolder(toCreate);
            CacheFolderStorage.getInstance().removeFromCache(parentFullName, "0", true, session);
        }
        separatorRef[0] = separator;
        return archiveFullName;
    }
}

