/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.tasks.TaskExceptionCode;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class TaskCreateUserSettingServer
implements UpdateTask {
    private static final String TABLE_NAME = "user_setting_server";
    private static final String CREATE_STATEMENT = "CREATE TABLE user_setting_server (cid INT4 UNSIGNED NOT NULL,user INT4 UNSIGNED NOT NULL,contact_collect_folder INT4 UNSIGNED,contact_collect_enabled BOOL,FOREIGN KEY(cid, user) REFERENCES user(cid, id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";

    @Override
    public int addedWithVersion() {
        return 27;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.NORMAL.priority;
    }

    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        Connection con = null;
        try {
            con = Database.getNoTimeout(contextId, true);
        }
        catch (OXException e) {
            throw TaskExceptionCode.NO_CONNECTION.create(e, new Object[0]);
        }
        try {
            if (!Tools.tableExists(con, TABLE_NAME)) {
                this.createTable(con);
            }
        }
        catch (SQLException e) {
            throw TaskExceptionCode.SQL_ERROR.create(e, new Object[0]);
        }
        finally {
            Database.backNoTimeout(contextId, true, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTable(Connection con) throws SQLException {
        try (Statement stmt = con.createStatement();){
            stmt.execute(CREATE_STATEMENT);
        }
    }
}

