/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.database.Databases;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.tasks.GenconfAttributesStringsAddUuidUpdateTask;
import com.openexchange.java.util.UUIDs;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Column;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.UUID;

public class GenconfAttributesStringsAddPrimaryKey
extends UpdateTaskAdapter {
    @Override
    public void perform(PerformParameters params) throws OXException {
        int cid = params.getContextId();
        Connection con = Database.getNoTimeout(cid, true);
        Column column = new Column("uuid", "BINARY(16) NOT NULL");
        try {
            con.setAutoCommit(false);
            this.setUUID(con);
            Tools.modifyColumns(con, "genconf_attributes_strings", column);
            this.dropDuplicates(con);
            Tools.createPrimaryKeyIfAbsent(con, "genconf_attributes_strings", new String[]{"cid", "id", column.name});
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(cid, true, con);
        }
    }

    @Override
    public String[] getDependencies() {
        return new String[]{GenconfAttributesStringsAddUuidUpdateTask.class.getName()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropDuplicates(Connection con) throws SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        block6: {
            stmt = null;
            rs = null;
            stmt = con.prepareStatement("SELECT cid, id, HEX(uuid) FROM genconf_attributes_strings GROUP BY cid, id, uuid HAVING count(*) > 1");
            rs = stmt.executeQuery();
            if (rs.next()) break block6;
            Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
            return;
        }
        try {
            class Dup {
                final UUID uuid;
                final int cid;
                final int id;

                Dup(int cid, int id, UUID uuid) {
                    this.cid = cid;
                    this.id = id;
                    this.uuid = uuid;
                }
            }
            LinkedList<Dup> dups = new LinkedList<Dup>();
            do {
                dups.add(new Dup(rs.getInt(1), rs.getInt(2), UUIDs.fromUnformattedString((String)rs.getString(3))));
            } while (rs.next());
            Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
            rs = null;
            stmt = null;
            for (Dup dup : dups) {
                stmt = con.prepareStatement("SELECT cid, id, name, value, widget FROM genconf_attributes_strings WHERE cid=? AND id=? AND ?=HEX(uuid)");
                stmt.setInt(1, dup.cid);
                stmt.setInt(2, dup.id);
                stmt.setString(3, UUIDs.getUnformattedString((UUID)dup.uuid));
                rs = stmt.executeQuery();
                if (rs.next()) {
                    int cid = rs.getInt(1);
                    int id = rs.getInt(2);
                    String name = rs.getString(3);
                    String value = rs.getString(4);
                    String widget = rs.getString(5);
                    Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
                    rs = null;
                    stmt = null;
                    stmt = con.prepareStatement("DELETE FROM genconf_attributes_strings WHERE cid=? AND id=? AND ?=HEX(uuid)");
                    stmt.setInt(1, dup.cid);
                    stmt.setInt(2, dup.id);
                    stmt.setString(3, UUIDs.getUnformattedString((UUID)dup.uuid));
                    stmt.executeUpdate();
                    Databases.closeSQLStuff((Statement)stmt);
                    stmt = null;
                    stmt = con.prepareStatement("INSERT INTO genconf_attributes_strings (cid,id,name,value,widget,uuid) VALUES (?,?,?,?,?,UNHEX(?))");
                    stmt.setInt(1, cid);
                    stmt.setInt(2, id);
                    stmt.setString(3, name);
                    stmt.setString(4, value);
                    stmt.setString(5, widget);
                    stmt.setString(6, UUIDs.getUnformattedString((UUID)dup.uuid));
                    stmt.executeUpdate();
                    Databases.closeSQLStuff((Statement)stmt);
                    stmt = null;
                }
                Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
                rs = null;
                stmt = null;
            }
        }
        catch (Throwable throwable) {
            Databases.closeSQLStuff(rs, (Statement)stmt);
            throw throwable;
        }
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUUID(Connection con) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT cid, id, name, value FROM genconf_attributes_strings WHERE uuid IS NULL FOR UPDATE");
            rs = stmt.executeQuery();
            PreparedStatement stmt2 = null;
            try {
                while (rs.next()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("UPDATE genconf_attributes_strings SET uuid = ? WHERE cid ");
                    int oldPos = 1;
                    int cid = rs.getInt(oldPos++);
                    if (rs.wasNull()) {
                        sb.append("IS ? ");
                    } else {
                        sb.append("= ? ");
                    }
                    sb.append("AND id ");
                    int id = rs.getInt(oldPos++);
                    if (rs.wasNull()) {
                        sb.append("IS ? ");
                    } else {
                        sb.append("= ? ");
                    }
                    sb.append("AND name ");
                    String name = rs.getString(oldPos++);
                    if (rs.wasNull()) {
                        sb.append("IS ? ");
                    } else {
                        sb.append("= ? ");
                    }
                    sb.append("AND value ");
                    String value = rs.getString(oldPos++);
                    if (rs.wasNull()) {
                        sb.append("IS ? ");
                    } else {
                        sb.append("= ? ");
                    }
                    stmt2 = con.prepareStatement(sb.toString());
                    int newPos = 1;
                    UUID uuid = UUID.randomUUID();
                    stmt2.setBytes(newPos++, UUIDs.toByteArray((UUID)uuid));
                    stmt2.setInt(newPos++, cid);
                    stmt2.setInt(newPos++, id);
                    stmt2.setString(newPos++, name);
                    stmt2.setString(newPos++, value);
                    stmt2.execute();
                }
            }
            finally {
                DBUtils.closeSQLStuff(stmt2);
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs, stmt);
    }
}

