/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import com.openexchange.event.impl.EventClient;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.search.Order;
import com.openexchange.groupware.search.TaskSearchObject;
import com.openexchange.groupware.tasks.Folder;
import com.openexchange.groupware.tasks.FolderStorage;
import com.openexchange.groupware.tasks.InsertData;
import com.openexchange.groupware.tasks.InternalParticipant;
import com.openexchange.groupware.tasks.Mapper;
import com.openexchange.groupware.tasks.Mapping;
import com.openexchange.groupware.tasks.ParticipantStorage;
import com.openexchange.groupware.tasks.Permission;
import com.openexchange.groupware.tasks.Reminder;
import com.openexchange.groupware.tasks.StorageType;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TaskExceptionCode;
import com.openexchange.groupware.tasks.TaskIterator;
import com.openexchange.groupware.tasks.TaskLogic;
import com.openexchange.groupware.tasks.TaskParticipant;
import com.openexchange.groupware.tasks.TaskStorage;
import com.openexchange.groupware.tasks.Tools;
import com.openexchange.groupware.tasks.mapping.Status;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.java.Autoboxing;
import com.openexchange.server.impl.DBPool;
import com.openexchange.session.Session;
import com.openexchange.tools.arrays.Arrays;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class UpdateData {
    private final Context ctx;
    private final User user;
    private final UserPermissionBits permissionBits;
    private final FolderObject folder;
    private FolderObject destFolder;
    private final Date lastRead;
    private final StorageType type;
    private final Task changed;
    private Task origTask;
    private Task updated;
    private int[] modifiedFields;
    private Set<TaskParticipant> changedParticipants;
    private Set<TaskParticipant> origParticipants;
    private Set<TaskParticipant> updatedParticipants;
    private Set<Folder> origFolders;
    private Set<Folder> updatedFolders;
    private final Set<TaskParticipant> added = new HashSet<TaskParticipant>();
    private final Set<TaskParticipant> removed = new HashSet<TaskParticipant>();
    private final Set<InternalParticipant> changedGroup = new HashSet<InternalParticipant>();
    private final Set<Folder> addedFolder = new HashSet<Folder>();
    private final Set<Folder> removedFolder = new HashSet<Folder>();
    private static final TaskStorage storage = TaskStorage.getInstance();
    private static final ParticipantStorage partStor = ParticipantStorage.getInstance();
    private static final FolderStorage foldStor = FolderStorage.getInstance();
    private boolean preparedFields;
    private boolean preparedFolder;
    private Set<InternalParticipant> addedGroupParticipants = null;
    private boolean preparedParts;

    UpdateData(Context ctx, User user, UserPermissionBits permissionBits, FolderObject folder, Task changed, Date lastRead) {
        this(ctx, user, permissionBits, folder, changed, lastRead, StorageType.ACTIVE);
    }

    UpdateData(Context ctx, User user, UserPermissionBits permissionBits, FolderObject folder, Task changed, Date lastRead, StorageType type) {
        this.ctx = ctx;
        this.user = user;
        this.permissionBits = permissionBits;
        this.folder = folder;
        this.changed = changed;
        this.lastRead = lastRead;
        this.type = type;
    }

    private Task getOrigTask() throws OXException {
        if (null == this.origTask) {
            this.origTask = storage.selectTask(this.ctx, this.getTaskId(), this.type);
            this.origTask.setParentFolderID(this.getFolderId());
            this.origTask.setUsers(TaskLogic.createUserParticipants(this.getOrigParticipants()));
            this.origTask.setParticipants(TaskLogic.createParticipants(this.getOrigParticipants()));
        }
        return this.origTask;
    }

    private Set<TaskParticipant> getChangedParticipants() throws OXException {
        if (null == this.changedParticipants) {
            this.changedParticipants = TaskLogic.createParticipants(this.ctx, this.changed.getParticipants());
        }
        return this.changedParticipants;
    }

    private Set<TaskParticipant> getOrigParticipants() throws OXException {
        if (null == this.origParticipants) {
            this.origParticipants = partStor.selectParticipants(this.ctx, this.getTaskId(), this.type);
            if (Tools.isFolderPrivate(this.folder)) {
                Tools.fillStandardFolders(this.ctx.getContextId(), this.getTaskId(), this.getOrigParticipants(), this.getOrigFolder(), true);
            }
        }
        return this.origParticipants;
    }

    Set<TaskParticipant> getUpdatedParticipants() throws OXException {
        if (null == this.updatedParticipants) {
            this.updatedParticipants = new HashSet<TaskParticipant>();
            if (this.changed.containsParticipants()) {
                this.updatedParticipants.addAll(this.getChangedParticipants());
            } else {
                this.updatedParticipants.addAll(this.getOrigParticipants());
            }
        }
        return this.updatedParticipants;
    }

    private Set<Folder> getOrigFolder() throws OXException {
        if (null == this.origFolders) {
            this.origFolders = foldStor.selectFolder(this.ctx, this.getTaskId(), this.type);
        }
        return this.origFolders;
    }

    Set<Folder> getUpdatedFolder() throws OXException {
        if (null == this.updatedFolders) {
            this.updatedFolders = new HashSet<Folder>();
            this.updatedFolders.addAll(this.getOrigFolder());
            this.updatedFolders.addAll(this.getAddedFolder());
            this.updatedFolders.removeAll(this.getRemovedFolder());
        }
        return this.updatedFolders;
    }

    void prepare() throws OXException {
        if (this.getOrigTask().getLastModified().after(this.lastRead)) {
            throw TaskExceptionCode.MODIFIED.create();
        }
        this.checkPermission();
        TaskLogic.checkUpdateTask(this.changed, this.getOrigTask(), this.user, this.permissionBits, this.getChangedParticipants(), this.getOrigParticipants());
        this.prepareWithoutChecks();
    }

    void prepareWithoutChecks() throws OXException {
        this.prepareFields();
        this.prepareParticipants();
        this.prepareFolder();
    }

    private void prepareFields() throws OXException {
        if (this.preparedFields) {
            return;
        }
        this.modifiedFields = TaskLogic.findModifiedFields(this.getOrigTask(), this.changed);
        this.preparedFields = true;
    }

    private void prepareFolder() throws OXException {
        if (this.preparedFolder) {
            return;
        }
        this.prepareParticipants();
        int sourceType = this.folder.getType();
        int destType = this.getDestFolder().getType();
        if (this.isMove()) {
            this.removedFolder.add(new Folder(this.getFolderId(), this.getUserId()));
            this.addedFolder.add(new Folder(this.getDestFolderId(), this.getUserId()));
        }
        if (2 == sourceType) {
            if (1 == destType) {
                Set<InternalParticipant> internal = ParticipantStorage.extractInternal(this.getUpdatedParticipants());
                Tools.fillStandardFolders(this.ctx, internal);
                this.addedFolder.addAll(TaskLogic.createFolderMapping(internal));
            }
        } else if (2 == destType) {
            this.removedFolder.addAll(this.getOrigFolder());
        } else {
            Set<InternalParticipant> addedInternal = ParticipantStorage.extractInternal(this.added);
            Tools.fillStandardFolders(this.ctx, addedInternal);
            this.addedFolder.addAll(TaskLogic.createFolderMapping(addedInternal));
            this.removedFolder.addAll(TaskLogic.createFolderMapping(ParticipantStorage.extractInternal(this.removed)));
        }
        Iterator<Folder> iter = this.addedFolder.iterator();
        while (iter.hasNext()) {
            Folder testFolder = iter.next();
            for (Folder origFolder : this.getOrigFolder()) {
                if (testFolder.getUser() != origFolder.getUser() || this.removedFolder.contains(origFolder)) continue;
                iter.remove();
            }
        }
        HashSet<Folder> empty = new HashSet<Folder>();
        empty.addAll(this.getOrigFolder());
        empty.addAll(this.addedFolder);
        empty.removeAll(this.removedFolder);
        if (empty.isEmpty()) {
            this.addedFolder.add(FolderStorage.extractFolderOfUser(this.getOrigFolder(), this.getUserId()));
        }
        if (this.getUserId() == this.getOrigTask().getCreatedBy() && null == FolderStorage.extractFolderOfUser(empty, this.getUserId()) && 1 == destType) {
            Folder delegatorFolder = FolderStorage.extractFolderOfUser(this.getOrigFolder(), this.getUserId());
            if (null == delegatorFolder) {
                delegatorFolder = new Folder(Tools.getUserTaskStandardFolder(this.ctx, this.getUserId()), this.getUserId());
            }
            this.addedFolder.add(delegatorFolder);
        }
        this.preparedFolder = true;
    }

    private void checkPermission() throws OXException {
        if (this.isMove()) {
            Permission.checkDelete(this.ctx, this.user, this.permissionBits, this.folder, this.getOrigTask());
            Permission.checkCreate(this.ctx, this.user, this.permissionBits, this.getDestFolder());
            if (Tools.isFolderShared(this.folder, this.user)) {
                throw TaskExceptionCode.NO_SHARED_MOVE.create(this.folder.getFolderName(), Autoboxing.I((int)this.getFolderId()));
            }
            if (Tools.isFolderShared(this.getDestFolder(), this.user)) {
                throw TaskExceptionCode.NO_SHARED_MOVE.create(this.getDestFolder().getFolderName(), Autoboxing.I((int)this.getDestFolderId()));
            }
            if (this.getOrigTask().getPrivateFlag() && Tools.isFolderPublic(this.getDestFolder())) {
                throw TaskExceptionCode.NO_PRIVATE_MOVE_TO_PUBLIC.create(this.getDestFolder().getFolderName(), Autoboxing.I((int)this.getDestFolderId()));
            }
        } else {
            Permission.checkWriteInFolder(this.ctx, this.user, this.permissionBits, this.folder, this.getOrigTask());
            if (null == FolderStorage.getFolder(this.getOrigFolder(), this.getFolderId())) {
                throw TaskExceptionCode.NOT_IN_FOLDER.create(Autoboxing.I((int)this.getTaskId()), this.folder.getFolderName(), Autoboxing.I((int)this.getFolderId()));
            }
            if (Tools.isFolderShared(this.folder, this.user) && this.getOrigTask().getPrivateFlag()) {
                throw TaskExceptionCode.NO_PERMISSION.create(Autoboxing.I((int)this.getTaskId()), this.folder.getFolderName(), Autoboxing.I((int)this.getFolderId()));
            }
        }
    }

    private Set<InternalParticipant> getGroupParticipants() throws OXException {
        if (null == this.addedGroupParticipants) {
            this.addedGroupParticipants = TaskLogic.getGroupParticipants(this.ctx, this.changed.getParticipants());
        }
        return this.addedGroupParticipants;
    }

    private void prepareParticipants() throws OXException {
        if (this.preparedParts) {
            return;
        }
        if (this.changed.containsParticipants()) {
            this.added.addAll(this.getChangedParticipants());
            this.added.removeAll(this.getOrigParticipants());
            this.changedGroup.addAll(this.getGroupParticipants());
            this.changedGroup.retainAll(this.getOrigParticipants());
            this.prepareParticipantsWithChangedGroup();
            if (StorageType.ACTIVE == this.type) {
                Set<TaskParticipant> origRemovedParts = partStor.selectParticipants(this.ctx, this.getTaskId(), StorageType.REMOVED);
                origRemovedParts.retainAll(this.added);
                this.added.addAll(origRemovedParts);
            }
            this.removed.addAll(this.getOrigParticipants());
            this.removed.removeAll(this.getChangedParticipants());
        }
        this.preparedParts = true;
    }

    private void prepareParticipantsWithChangedGroup() throws OXException {
        HashSet<TaskParticipant> toCheck = new HashSet<TaskParticipant>();
        Set<InternalParticipant> changedInternals = ParticipantStorage.extractInternal(this.getChangedParticipants());
        toCheck.addAll(this.getOrigParticipants());
        toCheck.retainAll(this.getChangedParticipants());
        for (InternalParticipant ip : ParticipantStorage.extractInternal(toCheck)) {
            InternalParticipant cp = ParticipantStorage.getParticipant(changedInternals, ip.getIdentifier());
            if (cp == null) continue;
            cp.setConfirm(ip.getConfirm());
            cp.setConfirmMessage(ip.getConfirmMessage());
            this.changedGroup.add(cp);
        }
    }

    private void generateUpdated() throws OXException {
        this.updated = new Task();
        this.updated.setObjectID(this.getTaskId());
        for (Mapper<? extends Object> mapper : Mapping.MAPPERS) {
            if (mapper.isSet(this.changed)) {
                if (null == mapper.get(this.changed)) continue;
                mapper.set(this.updated, mapper.get(this.changed));
                continue;
            }
            if (!mapper.isSet(this.getOrigTask())) continue;
            mapper.set(this.updated, mapper.get(this.getOrigTask()));
        }
        if (this.changed.containsNotification()) {
            this.updated.setNotification(this.changed.getNotification());
        }
        if (this.changed.containsAlarm()) {
            this.updated.setAlarm(this.changed.getAlarm());
        }
        this.updated.setParentFolderID(this.getDestFolderId());
        Set<TaskParticipant> parts = this.getUpdatedParticipants();
        if (Tools.isFolderPrivate(this.getDestFolder())) {
            Tools.fillStandardFolders(this.ctx.getContextId(), this.getTaskId(), parts, this.getUpdatedFolder(), true);
        }
        this.updated.setParticipants(TaskLogic.createParticipants(parts));
        this.updated.setUsers(TaskLogic.createUserParticipants(parts));
    }

    Set<TaskParticipant> getAdded() throws OXException {
        this.prepareParticipants();
        return this.added;
    }

    Set<InternalParticipant> getChangedGroup() throws OXException {
        this.prepareParticipants();
        return this.changedGroup;
    }

    Set<Folder> getAddedFolder() throws OXException {
        this.prepareFolder();
        return this.addedFolder;
    }

    int[] getModifiedFields() throws OXException {
        this.prepareFields();
        return this.modifiedFields;
    }

    Set<TaskParticipant> getRemoved() throws OXException {
        this.prepareParticipants();
        return this.removed;
    }

    Set<Folder> getRemovedFolder() throws OXException {
        this.prepareFolder();
        return this.removedFolder;
    }

    Task getUpdated() throws OXException {
        if (null == this.updated) {
            this.generateUpdated();
        }
        return this.updated;
    }

    private int getFolderId() {
        return this.folder.getObjectID();
    }

    private int getUserId() {
        return this.user.getId();
    }

    private int getTaskId() {
        return this.changed.getObjectID();
    }

    boolean isMove() {
        return this.changed.containsParentFolderID() && this.changed.getParentFolderID() != this.getFolderId();
    }

    private FolderObject getDestFolder() throws OXException {
        if (null == this.destFolder) {
            this.destFolder = this.isMove() ? Tools.getFolder(this.ctx, this.changed.getParentFolderID()) : this.folder;
        }
        return this.destFolder;
    }

    private int getDestFolderId() throws OXException {
        return this.getDestFolder().getObjectID();
    }

    void doUpdate() throws OXException {
        Connection con = DBPool.pickupWriteable(this.ctx);
        try {
            con.setAutoCommit(false);
            UpdateData.updateTask(this.ctx, con, this.changed, this.lastRead, this.getModifiedFields(), this.getAdded(), this.getRemoved(), this.getChangedGroup(), this.getAddedFolder(), this.getRemovedFolder(), this.type);
            if (StorageType.ACTIVE == this.type && this.isMove()) {
                Task dummy = Tools.createDummyTask(this.getTaskId(), this.getUserId(), this.getOrigTask().getUid());
                storage.insertTask(this.ctx, con, dummy, StorageType.DELETED, true, TaskStorage.TOMBSTONE_ATTRS);
                Folder sourceFolder = FolderStorage.getFolder(this.getRemovedFolder(), this.getFolderId());
                foldStor.insertFolder(this.ctx, con, this.getTaskId(), sourceFolder, StorageType.DELETED);
                foldStor.deleteFolder(this.ctx, con, this.getTaskId(), this.getDestFolderId(), StorageType.DELETED, false);
            }
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw TaskExceptionCode.UPDATE_FAILED.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.rollback(con);
            throw e;
        }
        finally {
            DBUtils.autocommit(con);
            DBPool.closeWriterSilent(this.ctx, con);
        }
    }

    static void updateTask(Context ctx, Connection con, Task task, Date lastRead, int[] modified, Set<TaskParticipant> add, Set<TaskParticipant> remove, Set<Folder> addFolder, Set<Folder> removeFolder) throws OXException {
        UpdateData.updateTask(ctx, con, task, lastRead, modified, add, remove, null, addFolder, removeFolder, StorageType.ACTIVE);
    }

    static void updateTask(Context ctx, Connection con, Task task, Date lastRead, int[] modified, Set<TaskParticipant> add, Set<TaskParticipant> remove, Set<InternalParticipant> changedGroup, Set<Folder> addFolder, Set<Folder> removeFolder, StorageType type) throws OXException {
        int taskId = task.getObjectID();
        storage.updateTask(ctx, con, task, lastRead, modified, type);
        if (null != add) {
            partStor.insertParticipants(ctx, con, taskId, add, type);
            if (StorageType.ACTIVE == type) {
                partStor.deleteParticipants(ctx, con, taskId, add, StorageType.REMOVED, false);
            }
        }
        if (null != remove) {
            if (StorageType.ACTIVE == type) {
                partStor.insertParticipants(ctx, con, taskId, remove, StorageType.REMOVED);
            }
            partStor.deleteParticipants(ctx, con, taskId, remove, type, true);
        }
        if (null != changedGroup) {
            partStor.updateInternal(ctx, con, taskId, changedGroup, type);
        }
        if (null != removeFolder) {
            foldStor.deleteFolder(ctx, con, taskId, removeFolder, type);
        }
        if (null != addFolder) {
            foldStor.insertFolder(ctx, con, taskId, addFolder, type);
        }
    }

    void sentEvent(Session session) throws OXException {
        Task orig = this.getOrigTask();
        if (this.getUserId() != orig.getCreatedBy() && null == ParticipantStorage.getParticipant(ParticipantStorage.extractInternal(this.getChangedParticipants()), orig.getCreatedBy())) {
            Folder delegatorFolder = FolderStorage.extractFolderOfUser(this.getOrigFolder(), orig.getCreatedBy());
            if (null == delegatorFolder) {
                delegatorFolder = FolderStorage.extractFolderOfUser(this.getOrigFolder(), this.getUserId());
            }
            if (null == delegatorFolder && 1 == this.getOrigFolder().size()) {
                delegatorFolder = this.getOrigFolder().toArray(new Folder[1])[0];
            }
            if (null != delegatorFolder) {
                orig.setParentFolderID(delegatorFolder.getIdentifier());
            }
        }
        UpdateData.sentEvent(session, this.getUpdated(), orig, this.getDestFolder());
    }

    static void sentEvent(Session session, Task updated, Task orig, FolderObject dest) throws OXException {
        try {
            new EventClient(session).modify(orig, updated, dest);
        }
        catch (OXException e) {
            throw TaskExceptionCode.EVENT.create(e, new Object[0]);
        }
    }

    void updateReminder() throws OXException, OXException {
        if (this.isMove() && this.getUpdatedParticipants().isEmpty()) {
            Reminder.updateReminderOnMove(this.ctx, this.getUpdated().getObjectID(), this.getFolderId(), this.getDestFolderId(), this.getUpdated().getPrivateFlag());
        }
        UpdateData.updateReminder(this.ctx, this.getUpdated(), this.user, this.isMove(), this.getRemoved(), this.getDestFolder(), this.getUpdatedParticipants(), this.getUpdatedFolder());
    }

    static void updateReminder(Context ctx, Task updated, User user, boolean move, Set<TaskParticipant> removed, FolderObject destFolder, Set<TaskParticipant> participants, Set<Folder> folders2) throws OXException {
        if (updated.containsAlarm()) {
            Reminder.updateAlarm(ctx, updated, user);
        }
        if (move) {
            if (Tools.isFolderPrivate(destFolder)) {
                Tools.fillStandardFolders(ctx.getContextId(), updated.getObjectID(), participants, folders2, true);
            }
            Reminder.fixAlarm(ctx, updated, removed, participants, folders2);
        }
    }

    void makeNextRecurrence(Session session) throws OXException {
        if (0 != this.updated.getRecurrenceType() && 3 == this.updated.getStatus() && Arrays.contains((int[])this.getModifiedFields(), (int)Status.SINGLETON.getId())) {
            TaskSearchObject search = new TaskSearchObject();
            search.setTitle(this.updated.getTitle());
            search.setStatus(this.updated.getStatus());
            Permission.checkReadInFolder(this.ctx, this.user, this.permissionBits, this.folder);
            boolean own = Permission.canReadInFolder(this.ctx, this.user, this.permissionBits, this.destFolder);
            ArrayList<Integer> emptyList = new ArrayList<Integer>();
            ArrayList<Integer> listWithFolder = new ArrayList<Integer>();
            listWithFolder.add(Autoboxing.I((int)this.destFolder.getObjectID()));
            TaskIterator ti = own ? storage.search(this.ctx, this.getUserId(), search, 0, Order.ASCENDING, new int[]{301, 2, 201, 200}, emptyList, listWithFolder, emptyList) : storage.search(this.ctx, this.getUserId(), search, 0, Order.ASCENDING, new int[]{301, 2, 201, 200}, listWithFolder, emptyList, emptyList);
            boolean next = TaskLogic.makeRecurrence(this.updated);
            boolean duplicateExists = false;
            while (ti.hasNext()) {
                long uStartDateLong;
                long aStartDateLong;
                boolean title;
                Task actual = (Task)ti.next();
                boolean percentComplete = actual.getPercentComplete() == this.updated.getPercentComplete();
                boolean createdBy = actual.getCreatedBy() == this.updated.getCreatedBy();
                boolean bl = title = null != actual.getTitle() && actual.getTitle().equals(this.updated.getTitle());
                boolean startDate = actual.getStartDate() != null ? (aStartDateLong = actual.getStartDate().getTime()) / 1000L == (uStartDateLong = this.updated.getStartDate().getTime()) / 1000L : this.updated.getStartDate() == null;
                if (!percentComplete || !createdBy || !startDate || !title) continue;
                duplicateExists = true;
                break;
            }
            if (!duplicateExists && next) {
                UpdateData.insertNextRecurrence(session, this.ctx, this.getUserId(), this.permissionBits, this.folder, this.getUpdated(), this.getUpdatedParticipants(), this.getUpdatedFolder());
            }
        }
    }

    private static void insertNextRecurrence(Session session, Context ctx, int userId, UserPermissionBits permissionBits, FolderObject folder, Task task, Set<TaskParticipant> parts, Set<Folder> folders2) throws OXException, OXException {
        TaskLogic.checkNewTask(task, userId, permissionBits, parts);
        InsertData.insertTask(ctx, task, parts, folders2);
        new EventClient(session).create(task, folder);
    }
}

