/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import com.openexchange.annotation.Nullable;
import com.openexchange.event.impl.EventClient;
import com.openexchange.exception.OXException;
import com.openexchange.group.GroupStorage;
import com.openexchange.groupware.calendar.CalendarCollectionService;
import com.openexchange.groupware.calendar.RecurringResultInterface;
import com.openexchange.groupware.calendar.RecurringResultsInterface;
import com.openexchange.groupware.container.ExternalUserParticipant;
import com.openexchange.groupware.container.GroupParticipant;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.data.Check;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.tasks.ExternalParticipant;
import com.openexchange.groupware.tasks.Folder;
import com.openexchange.groupware.tasks.FolderStorage;
import com.openexchange.groupware.tasks.InternalParticipant;
import com.openexchange.groupware.tasks.Mapper;
import com.openexchange.groupware.tasks.Mapping;
import com.openexchange.groupware.tasks.ParticipantStorage;
import com.openexchange.groupware.tasks.Permission;
import com.openexchange.groupware.tasks.Reminder;
import com.openexchange.groupware.tasks.StorageType;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TaskExceptionCode;
import com.openexchange.groupware.tasks.TaskParticipant;
import com.openexchange.groupware.tasks.TaskStorage;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.java.Autoboxing;
import com.openexchange.server.impl.DBPool;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public final class TaskLogic {
    private static final TaskStorage storage = TaskStorage.getInstance();
    private static final FolderStorage foldStor = FolderStorage.getInstance();
    private static final ParticipantStorage partStor = ParticipantStorage.getInstance();
    private static final int[] ALL_COLUMNS = Task.ALL_COLUMNS;

    private TaskLogic() {
    }

    static void checkNewTask(Task task, int userId, UserPermissionBits permissionBits, Set<TaskParticipant> participants) throws OXException {
        TaskLogic.checkMissingAttributes(task, userId);
        TaskLogic.checkData(task);
        TaskLogic.checkDates(task);
        TaskLogic.checkStateAndProgress(task);
        Permission.checkDelegation(permissionBits, task.getParticipants());
        TaskLogic.checkPrivateFlag(task.getPrivateFlag(), false, participants, null);
        TaskLogic.checkParticipants(participants);
        TaskLogic.checkRecurrence(task, null);
        TaskLogic.checkPriority(task);
    }

    static void checkUpdateTask(Task task, Task oldTask, User user, UserPermissionBits permissionBits, Set<TaskParticipant> newParts, Set<TaskParticipant> oldParts) throws OXException {
        if (task.containsUid()) {
            if (!oldTask.getUid().equals(task.getUid())) {
                throw TaskExceptionCode.NO_UID_CHANGE.create();
            }
            task.removeUid();
        }
        if (!task.containsLastModified()) {
            task.setLastModified(new Date());
        }
        if (!task.containsModifiedBy()) {
            task.setModifiedBy(user.getId());
        }
        TaskLogic.checkData(task);
        TaskLogic.checkDates(task, oldTask);
        TaskLogic.checkStateAndProgress(task);
        Permission.checkDelegation(permissionBits, task.getParticipants());
        boolean changedParts = task.containsParticipants();
        if (task.containsPrivateFlag() && task.getPrivateFlag() && oldTask.getCreatedBy() != user.getId()) {
            throw TaskExceptionCode.ONLY_CREATOR_PRIVATE.create();
        }
        boolean privat = task.containsPrivateFlag() ? task.getPrivateFlag() : oldTask.getPrivateFlag();
        TaskLogic.checkPrivateFlag(privat, changedParts, oldParts, newParts);
        Set<TaskParticipant> destParts = changedParts ? newParts : oldParts;
        TaskLogic.checkParticipants(destParts);
        TaskLogic.checkRecurrence(task, oldTask);
        TaskLogic.checkPriority(task);
    }

    private static void checkMissingAttributes(Task task, int userId) throws OXException {
        if (!task.containsParentFolderID()) {
            throw TaskExceptionCode.FOLDER_IS_MISSING.create();
        }
        if (!task.containsUid()) {
            task.setUid(UUID.randomUUID().toString());
        }
        Date timestamp = new Date();
        if (!task.containsCreationDate()) {
            task.setCreationDate(timestamp);
        }
        if (!task.containsLastModified()) {
            task.setLastModified(timestamp);
        }
        if (!task.containsCreatedBy()) {
            task.setCreatedBy(userId);
        }
        if (!task.containsModifiedBy()) {
            task.setModifiedBy(userId);
        }
        if (!task.containsPrivateFlag()) {
            task.setPrivateFlag(false);
        }
        if (!task.containsRecurrenceType()) {
            task.setRecurrenceType(0);
        }
        if (!task.containsNumberOfAttachments()) {
            task.setNumberOfAttachments(0);
        }
    }

    private static void checkData(Task task) throws OXException {
        for (Mapper<String> mapper : Mapping.STRING_MAPPERS) {
            String result;
            if (!mapper.isSet(task) || null == mapper.get(task) || null == (result = Check.containsInvalidChars(mapper.get(task)))) continue;
            throw TaskExceptionCode.INVALID_DATA.create(result);
        }
    }

    private static void checkDates(Task task) throws OXException {
        if (task.containsStartDate() && task.containsEndDate()) {
            TaskLogic.checkDates(task.getStartDate(), task.getEndDate());
        }
    }

    private static void checkDates(Task task, Task oldTask) throws OXException {
        Date start = null;
        if (task.containsStartDate()) {
            start = task.getStartDate();
        } else if (oldTask.containsStartDate()) {
            start = oldTask.getStartDate();
        }
        Date end = null;
        if (task.containsEndDate()) {
            end = task.getEndDate();
        } else if (oldTask.containsEndDate()) {
            end = oldTask.getEndDate();
        }
        TaskLogic.checkDates(start, end);
    }

    private static void checkDates(Date start, Date end) throws OXException {
        if (null != start && null != end && start.after(end)) {
            throw TaskExceptionCode.START_NOT_BEFORE_END.create(start, end);
        }
    }

    private static void checkStateAndProgress(Task task) throws OXException {
        if (!task.containsPercentComplete() || !task.containsStatus()) {
            return;
        }
        int progress = task.getPercentComplete();
        if (progress < 0 || progress > 100) {
            throw TaskExceptionCode.INVALID_PERCENTAGE.create(progress);
        }
        switch (task.getStatus()) {
            case 1: {
                if (0 == progress) break;
                throw TaskExceptionCode.PERCENTAGE_NOT_ZERO.create(progress);
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw TaskExceptionCode.INVALID_TASK_STATE.create(task.getStatus());
            }
        }
    }

    private static void checkPrivateFlag(boolean privat, boolean changed, Set<TaskParticipant> oldParts, Set<TaskParticipant> newParts) throws OXException {
        if (!privat) {
            return;
        }
        if (changed ? newParts.size() > 0 : oldParts.size() > 0) {
            throw TaskExceptionCode.NO_PRIVATE_DELEGATE.create();
        }
    }

    private static void checkParticipants(Set<TaskParticipant> participants) throws OXException {
        if (null == participants) {
            return;
        }
        TaskLogic.checkExternal(ParticipantStorage.extractExternal(participants));
    }

    private static void checkExternal(Set<ExternalParticipant> participants) throws OXException {
        for (ExternalParticipant participant : participants) {
            String mail = participant.getMail();
            if (null != mail && !mail.isEmpty()) continue;
            throw TaskExceptionCode.EXTERNAL_WITHOUT_MAIL.create();
        }
    }

    private static void checkRecurrence(Task task, @Nullable Task oldTask) throws OXException {
        if (0 == task.getRecurrenceType() && oldTask != null && 0 == oldTask.getRecurrenceType()) {
            return;
        }
        if (0 != task.getRecurrenceType() || null != oldTask && 0 != oldTask.getRecurrenceType()) {
            if (null == oldTask) {
                if (!task.containsStartDate()) {
                    throw TaskExceptionCode.MISSING_RECURRENCE_VALUE.create(201);
                }
                if (!task.containsEndDate()) {
                    throw TaskExceptionCode.MISSING_RECURRENCE_VALUE.create(202);
                }
            } else {
                if (task.containsStartDate() && null == task.getStartDate()) {
                    throw TaskExceptionCode.MISSING_RECURRENCE_VALUE.create(201);
                }
                if (task.containsEndDate() && null == task.getEndDate()) {
                    throw TaskExceptionCode.MISSING_RECURRENCE_VALUE.create(201);
                }
            }
        }
        TaskLogic.copyRecurringValues(task, oldTask);
        boolean daysRemoved = false;
        if (0 != task.getRecurrenceType() && task.containsDays() && 0 == task.getDays()) {
            daysRemoved = true;
            task.removeDays();
        }
        boolean occurrenceRemoved = false;
        if (task.containsOccurrence() && 0 == task.getOccurrence()) {
            task.removeOccurrence();
            task.setUntil(null);
            occurrenceRemoved = true;
        }
        CalendarCollectionService recColl = ServerServiceRegistry.getInstance().getService(CalendarCollectionService.class, true);
        recColl.checkRecurring(task);
        if (daysRemoved) {
            task.setDays(0);
        }
        if (occurrenceRemoved) {
            task.setOccurrence(0);
        }
        TaskLogic.moveToFirstOccurrence(task);
    }

    private static void checkPriority(Task task) throws OXException {
        int priority;
        if (task.containsPriority() && null != task.getPriority() && ((priority = Autoboxing.i((Integer)task.getPriority())) < 1 || priority > 3)) {
            throw TaskExceptionCode.INVALID_PRIORITY.create(task.getPriority());
        }
    }

    private static void copyRecurringValues(Task task, Task oldTask) {
        if (null == oldTask) {
            return;
        }
        if (task.containsRecurrenceType() && 0 != task.getRecurrenceType() || !task.containsRecurrenceType() && oldTask.containsRecurrenceType()) {
            if (!task.containsRecurrenceType()) {
                task.setRecurrenceType(oldTask.getRecurrenceType());
            }
            if ((1 == task.getRecurrenceType() || 2 == task.getRecurrenceType() || 3 == task.getRecurrenceType()) && !task.containsInterval() && oldTask.containsInterval()) {
                task.setInterval(oldTask.getInterval());
            }
            if (2 == task.getRecurrenceType() && !task.containsDays() && oldTask.containsDays()) {
                task.setDays(oldTask.getDays());
            }
            if ((3 == task.getRecurrenceType() || 4 == task.getRecurrenceType()) && !task.containsDayInMonth() && oldTask.containsDayInMonth()) {
                task.setDayInMonth(oldTask.getDayInMonth());
            }
            if (4 == task.getRecurrenceType() && !task.containsMonth() && oldTask.containsMonth()) {
                task.setMonth(oldTask.getMonth());
            }
        }
    }

    private static void moveToFirstOccurrence(Task task) throws OXException {
        if (!(task.containsStartDate() && task.containsEndDate() && null != task.getStartDate() && null != task.getEndDate() && task.containsRecurrenceType() && 0 != task.getRecurrenceType())) {
            return;
        }
        task.setRecurrenceCalculator((int)((task.getEndDate().getTime() - task.getStartDate().getTime()) / 86400000L));
        CalendarCollectionService service = ServerServiceRegistry.getInstance().getService(CalendarCollectionService.class);
        RecurringResultsInterface results = service.calculateRecurring(task, 0L, 0L, 1);
        if (null == results || 0 == results.size()) {
            return;
        }
        RecurringResultInterface result = results.getRecurringResult(0);
        if (!new Date(result.getStart()).equals(task.getStartDate())) {
            task.setStartDate(new Date(result.getStart()));
        }
        if (!new Date(result.getEnd()).equals(task.getEndDate())) {
            task.setEndDate(new Date(result.getEnd()));
        }
    }

    static Set<InternalParticipant> getGroupParticipants(Context ctx, Participant[] participants) throws OXException {
        HashSet<InternalParticipant> retval = new HashSet<InternalParticipant>();
        block4: for (Participant participant : participants) {
            switch (participant.getType()) {
                case 2: {
                    GroupParticipant group = (GroupParticipant)participant;
                    int[] member = GroupStorage.getInstance().getGroup(group.getIdentifier(), ctx).getMember();
                    if (member.length == 0) {
                        throw TaskExceptionCode.GROUP_IS_EMPTY.create(group.getDisplayName());
                    }
                    for (int userId : member) {
                        retval.add(new InternalParticipant(new UserParticipant(userId), Autoboxing.I((int)group.getIdentifier())));
                    }
                    continue block4;
                }
                case 1: 
                case 5: {
                    continue block4;
                }
                default: {
                    throw TaskExceptionCode.UNKNOWN_PARTICIPANT.create(participant.getType());
                }
            }
        }
        return retval;
    }

    static Set<TaskParticipant> createParticipants(Context ctx, Participant[] participants) throws OXException {
        HashSet<TaskParticipant> retval = new HashSet<TaskParticipant>();
        if (null == participants) {
            return retval;
        }
        block5: for (Participant participant : participants) {
            switch (participant.getType()) {
                case 1: {
                    retval.add(new InternalParticipant((UserParticipant)participant, null));
                    continue block5;
                }
                case 2: {
                    GroupParticipant group = (GroupParticipant)participant;
                    int[] member = GroupStorage.getInstance().getGroup(group.getIdentifier(), ctx).getMember();
                    if (member.length == 0) {
                        throw TaskExceptionCode.GROUP_IS_EMPTY.create(group.getDisplayName());
                    }
                    for (int userId : member) {
                        InternalParticipant tParticipant = new InternalParticipant(new UserParticipant(userId), Autoboxing.I((int)group.getIdentifier()));
                        if (retval.contains(tParticipant)) continue;
                        retval.add(tParticipant);
                    }
                    continue block5;
                }
                case 5: {
                    retval.add(new ExternalParticipant((ExternalUserParticipant)participant));
                    continue block5;
                }
                default: {
                    throw TaskExceptionCode.UNKNOWN_PARTICIPANT.create(participant.getType());
                }
            }
        }
        return retval;
    }

    static UserParticipant[] createUserParticipants(Set<TaskParticipant> participants) {
        ArrayList<UserParticipant> retval = new ArrayList<UserParticipant>(participants.size());
        for (TaskParticipant participant : participants) {
            if (TaskParticipant.Type.INTERNAL != participant.getType()) continue;
            InternalParticipant internal = (InternalParticipant)participant;
            retval.add(internal.getUser());
        }
        return retval.toArray(new UserParticipant[retval.size()]);
    }

    static Participant[] createParticipants(Set<TaskParticipant> participants) {
        ArrayList<Comparable<Participant>> retval = new ArrayList<Comparable<Participant>>();
        HashMap<Integer, GroupParticipant> groups = new HashMap<Integer, GroupParticipant>();
        block4: for (TaskParticipant participant : participants) {
            switch (participant.getType()) {
                case INTERNAL: {
                    InternalParticipant internal = (InternalParticipant)participant;
                    Integer groupId = internal.getGroupId();
                    if (null == groupId) {
                        retval.add(internal.getUser());
                        break;
                    }
                    GroupParticipant group = new GroupParticipant(groupId);
                    if (groups.containsKey(groupId)) continue block4;
                    groups.put(groupId, group);
                    break;
                }
                case EXTERNAL: {
                    ExternalParticipant external = (ExternalParticipant)participant;
                    retval.add(external.getExternal());
                    break;
                }
            }
        }
        retval.addAll(groups.values());
        return retval.toArray(new Participant[retval.size()]);
    }

    static Set<Folder> createFolderMapping(Set<InternalParticipant> participants) {
        return TaskLogic.createFolderMapping(-1, -1, participants);
    }

    static Set<Folder> createFolderMapping(int folderId, int userId, Set<InternalParticipant> participants) {
        HashSet<Folder> retval = new HashSet<Folder>();
        if (-1 != userId) {
            retval.add(new Folder(folderId, userId));
        }
        for (InternalParticipant participant : participants) {
            Folder folder;
            if (participant.getIdentifier() == userId || retval.contains(folder = new Folder(participant.getFolderId(), participant.getIdentifier()))) continue;
            retval.add(folder);
        }
        return retval;
    }

    static int[] findModifiedFields(Task oldTask, Task task) {
        ArrayList<Integer> fields = new ArrayList<Integer>();
        for (Mapper<? extends Object> mapper : Mapping.MAPPERS) {
            if (!mapper.isSet(task) || mapper.isSet(oldTask) && mapper.equals(task, oldTask)) continue;
            fields.add(mapper.getId());
        }
        if (oldTask.containsOccurrence() && !task.containsOccurrence() && task.containsUntil()) {
            fields.add(Autoboxing.I((int)222));
        }
        int[] retval = new int[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            retval[i] = (Integer)fields.get(i);
        }
        return retval;
    }

    public static boolean makeRecurrence(Task task) throws OXException {
        if (task.containsOccurrence() && 0 == task.getOccurrence()) {
            return false;
        }
        if (!task.containsStartDate() || null == task.getStartDate() || !task.containsEndDate() || null == task.getEndDate()) {
            return false;
        }
        Date[] newTaskDates = TaskLogic.calculateRecurring(task);
        if (0 == newTaskDates.length) {
            return false;
        }
        task.setStartDate(newTaskDates[0]);
        task.setEndDate(newTaskDates[1]);
        task.setStatus(1);
        task.setPercentComplete(0);
        task.removeDateCompleted();
        if (task.containsOccurrence()) {
            task.setOccurrence(task.getOccurrence() - 1);
        }
        return true;
    }

    private static Date[] calculateRecurring(Task task) throws OXException {
        Date origStart = task.getStartDate();
        task.setRecurrenceCalculator((int)((task.getEndDate().getTime() - origStart.getTime()) / 86400000L));
        CalendarCollectionService recColl = ServerServiceRegistry.getInstance().getService(CalendarCollectionService.class);
        RecurringResultsInterface rr = recColl.calculateRecurring(task, 0L, 0L, 2);
        RecurringResultInterface result = rr.getRecurringResult(0);
        Date[] retval = null == result ? new Date[]{} : new Date[]{new Date(result.getStart()), new Date(result.getEnd())};
        return retval;
    }

    static Set<InternalParticipant> extractWithGroup(Set<InternalParticipant> participants, int groupId) {
        HashSet<InternalParticipant> retval = new HashSet<InternalParticipant>();
        for (InternalParticipant participant : participants) {
            if (null == participant.getGroupId() || groupId != participant.getGroupId()) continue;
            retval.add(participant);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteTask(Session session, Context ctx, int userId, Task task, Date lastModified) throws OXException {
        try {
            DBUtils.TransactionRollbackCondition condition = new DBUtils.TransactionRollbackCondition(3);
            do {
                Connection con = DBPool.pickupWriteable(ctx);
                condition.resetTransactionRollbackException();
                try {
                    DBUtils.startTransaction(con);
                    Task t = TaskLogic.clone(task);
                    TaskLogic.deleteTask(ctx, con, userId, t, lastModified);
                    Reminder.deleteReminder(ctx, con, task);
                    con.commit();
                    TaskLogic.informDelete(session, t);
                }
                catch (SQLException e) {
                    DBUtils.rollback(con);
                    if (condition.isFailedTransactionRollback(e)) continue;
                    throw TaskExceptionCode.DELETE_FAILED.create(e, e.getMessage());
                }
                catch (OXException e) {
                    DBUtils.rollback(con);
                    if (condition.isFailedTransactionRollback((Exception)((Object)e))) continue;
                    throw e;
                }
                catch (RuntimeException e) {
                    DBUtils.rollback(con);
                    if (condition.isFailedTransactionRollback(e)) continue;
                    throw TaskExceptionCode.DELETE_FAILED.create(e, e.getMessage());
                }
                finally {
                    DBUtils.autocommit(con);
                    DBPool.closeWriterSilent(ctx, con);
                }
            } while (condition.checkRetry());
        }
        catch (SQLException e) {
            if (DBUtils.isTransactionRollbackException(e)) {
                throw TaskExceptionCode.DELETE_FAILED_RETRY.create(e, e.getMessage());
            }
            throw TaskExceptionCode.DELETE_FAILED.create(e, e.getMessage());
        }
    }

    static Task clone(Task task) {
        Task ret = new Task();
        for (int field : ALL_COLUMNS) {
            if (!task.contains(field)) continue;
            ret.set(field, task.get(field));
        }
        return ret;
    }

    private static Set<Folder> deleteParticipants(Context ctx, Connection con, int taskId) throws OXException {
        HashSet<InternalParticipant> participants = new HashSet<InternalParticipant>(partStor.selectInternal(ctx, con, taskId, StorageType.ACTIVE));
        partStor.deleteInternal(ctx, con, taskId, participants, StorageType.ACTIVE, true);
        Set<InternalParticipant> removed = partStor.selectInternal(ctx, con, taskId, StorageType.REMOVED);
        partStor.deleteInternal(ctx, con, taskId, removed, StorageType.REMOVED, true);
        Set<Folder> retval = TaskLogic.createFolderMapping(removed);
        participants.addAll(removed);
        partStor.insertInternals(ctx, con, taskId, participants, StorageType.DELETED);
        Set<ExternalParticipant> externals = partStor.selectExternal(ctx, con, taskId, StorageType.ACTIVE);
        partStor.insertExternals(ctx, con, taskId, externals, StorageType.DELETED);
        partStor.deleteExternal(ctx, con, taskId, externals, StorageType.ACTIVE, true);
        return retval;
    }

    private static void deleteFolder(Context ctx, Connection con, int taskId, Set<Folder> removed) throws OXException {
        Set<Folder> folders2 = foldStor.selectFolder(ctx, con, taskId, StorageType.ACTIVE);
        foldStor.deleteFolder(ctx, con, taskId, folders2, StorageType.ACTIVE);
        for (Folder folder : removed) {
            if (folder.getIdentifier() <= 0) continue;
            folders2.add(folder);
        }
        foldStor.insertFolder(ctx, con, taskId, folders2, StorageType.DELETED);
    }

    static void informDelete(Session session, Task task) throws OXException {
        new EventClient(session).delete(task);
    }

    public static void removeTask(Session session, Context ctx, Connection con, int folderId, int taskId, StorageType type) throws OXException {
        Task task = storage.selectTask(ctx, con, taskId, type);
        task.setParentFolderID(folderId);
        Set<InternalParticipant> internal = partStor.selectInternal(ctx, con, taskId, type);
        Set<ExternalParticipant> external = partStor.selectExternal(ctx, con, taskId, type);
        Set<Folder> folders2 = foldStor.selectFolder(ctx, con, taskId, type);
        HashSet<TaskParticipant> parts = new HashSet<TaskParticipant>();
        parts.addAll(internal);
        parts.addAll(external);
        task.setParticipants(TaskLogic.createParticipants(parts));
        task.setUsers(TaskLogic.createUserParticipants(parts));
        partStor.deleteInternal(ctx, con, taskId, internal, type, true);
        if (StorageType.ACTIVE == type) {
            Set<InternalParticipant> removed = partStor.selectInternal(ctx, con, taskId, StorageType.REMOVED);
            partStor.deleteInternal(ctx, con, taskId, removed, StorageType.REMOVED, true);
        }
        partStor.deleteExternal(ctx, con, taskId, external, type, true);
        foldStor.deleteFolder(ctx, con, taskId, folders2, type);
        storage.delete(ctx, con, taskId, task.getLastModified(), type);
        Reminder.deleteReminder(ctx, con, task);
        if (StorageType.ACTIVE == type) {
            TaskLogic.informDelete(session, task);
        }
    }

    public static void deleteTask(Context ctx, Connection con, int userId, Task task, Date lastModified) throws OXException {
        int taskId = task.getObjectID();
        Set<Folder> movedSourceFolders = foldStor.selectFolder(ctx, con, taskId, StorageType.DELETED);
        foldStor.deleteFolder(ctx, con, taskId, movedSourceFolders, StorageType.DELETED, true);
        storage.delete(ctx, con, taskId, new Date(Long.MAX_VALUE), StorageType.DELETED, false);
        task.setLastModified(new Date());
        task.setModifiedBy(userId);
        storage.insertTask(ctx, con, task, StorageType.DELETED, TaskStorage.TOMBSTONE_ATTRS);
        Set<Folder> removed = TaskLogic.deleteParticipants(ctx, con, task.getObjectID());
        TaskLogic.deleteFolder(ctx, con, task.getObjectID(), removed);
        storage.delete(ctx, con, task.getObjectID(), lastModified, StorageType.ACTIVE);
        foldStor.insertFolder(ctx, con, taskId, movedSourceFolders, StorageType.DELETED);
    }
}

