/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.validation;

import com.openexchange.database.provider.DBProvider;
import com.openexchange.exception.OXException;
import com.openexchange.group.Group;
import com.openexchange.group.GroupService;
import com.openexchange.groupware.container.ObjectPermission;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.groupware.infostore.validation.DocumentMetadataValidation;
import com.openexchange.groupware.infostore.validation.InfostoreValidator;
import com.openexchange.groupware.userconfiguration.UserConfigurationCodes;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.groupware.userconfiguration.UserPermissionBitsStorage;
import com.openexchange.java.Autoboxing;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.session.ServerSession;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.LoggerFactory;

public class ObjectPermissionValidator
implements InfostoreValidator {
    private final DBProvider dbProvider;

    public ObjectPermissionValidator(DBProvider dbProvider) {
        this.dbProvider = dbProvider;
    }

    @Override
    public String getName() {
        return ObjectPermissionValidator.class.getSimpleName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentMetadataValidation validate(ServerSession session, DocumentMetadata metadata) {
        DocumentMetadataValidation validation = new DocumentMetadataValidation();
        List<ObjectPermission> objectPermissions = metadata.getObjectPermissions();
        if (null != objectPermissions) {
            int[] userIDs;
            if (!session.getUserConfiguration().hasFullSharedFolderAccess()) {
                String name = session.getUser().getDisplayName();
                validation.setError(Metadata.OBJECT_PERMISSIONS_LITERAL, "User " + session.getUser().getDisplayName() + " has no permission to share items.");
                validation.setException(InfostoreExceptionCodes.VALIDATION_FAILED_INAPPLICABLE_PERMISSIONS.create(name));
                return validation;
            }
            for (ObjectPermission permission : objectPermissions) {
                int bits = permission.getPermissions();
                if (4 == bits) {
                    validation.setError(Metadata.OBJECT_PERMISSIONS_LITERAL, "DELETE object permission is not allowed.");
                    validation.setException(InfostoreExceptionCodes.VALIDATION_FAILED_INAPPLICABLE_PERMISSIONS.create(Autoboxing.I((int)permission.getEntity())));
                    return validation;
                }
                if (2 == bits || 1 == bits) continue;
                validation.setError(Metadata.OBJECT_PERMISSIONS_LITERAL, "Invalid permission bits: " + bits);
                validation.setException(InfostoreExceptionCodes.VALIDATION_FAILED_INAPPLICABLE_PERMISSIONS.create(Autoboxing.I((int)permission.getEntity())));
                return validation;
            }
            int[] groupIDs = ObjectPermissionValidator.getGroupEntities(objectPermissions);
            if (null != groupIDs) {
                for (int groupID : groupIDs) {
                    try {
                        Group group = ServerServiceRegistry.getServize(GroupService.class).getGroup(session.getContext(), groupID);
                        if (Integer.MAX_VALUE == group.getIdentifier()) {
                            validation.setError(Metadata.OBJECT_PERMISSIONS_LITERAL, "Group " + group.getDisplayName() + " can't be used for object permissions.");
                            validation.setException(InfostoreExceptionCodes.VALIDATION_FAILED_INAPPLICABLE_PERMISSIONS.create(Autoboxing.I((int)groupID)));
                            return validation;
                        }
                    }
                    catch (OXException e) {
                        if ("GRP-0017".equals(e.getErrorCode())) {
                            validation.setError(Metadata.OBJECT_PERMISSIONS_LITERAL, e.getDisplayMessage(session.getUser().getLocale()));
                            validation.setException(InfostoreExceptionCodes.VALIDATION_FAILED_INAPPLICABLE_PERMISSIONS.create(Autoboxing.I((int)groupID)));
                            return validation;
                        }
                        LoggerFactory.getLogger(ObjectPermissionValidator.class).warn("Error getting group for permission entity {}", (Object)Autoboxing.I((int)groupID), (Object)e);
                    }
                }
            }
            if (null != (userIDs = ObjectPermissionValidator.getUserEntities(objectPermissions))) {
                UserPermissionBitsStorage permissionBitsStorage = UserPermissionBitsStorage.getInstance();
                Connection connection = null;
                try {
                    connection = this.dbProvider.getReadConnection(session.getContext());
                    for (int userID : userIDs) {
                        try {
                            UserPermissionBits permissionBits = permissionBitsStorage.getUserPermissionBits(connection, userID, session.getContext());
                            if (permissionBits.hasFullSharedFolderAccess() && permissionBits.hasInfostore()) continue;
                            validation.setError(Metadata.OBJECT_PERMISSIONS_LITERAL, "User " + userID + " has no permission to see share items.");
                            validation.setException(InfostoreExceptionCodes.VALIDATION_FAILED_INAPPLICABLE_PERMISSIONS.create(Autoboxing.I((int)userID)));
                            DocumentMetadataValidation documentMetadataValidation = validation;
                            return documentMetadataValidation;
                        }
                        catch (OXException e) {
                            if (UserConfigurationCodes.NOT_FOUND.equals(e)) {
                                validation.setError(Metadata.OBJECT_PERMISSIONS_LITERAL, e.getDisplayMessage(session.getUser().getLocale()));
                                validation.setException(InfostoreExceptionCodes.VALIDATION_FAILED_INAPPLICABLE_PERMISSIONS.create(Autoboxing.I((int)userID)));
                                DocumentMetadataValidation documentMetadataValidation = validation;
                                if (null != connection) {
                                    this.dbProvider.releaseReadConnection(session.getContext(), connection);
                                }
                                return documentMetadataValidation;
                            }
                            LoggerFactory.getLogger(ObjectPermissionValidator.class).warn("Error getting user configuration for permission entity {}", (Object)Autoboxing.I((int)userID), (Object)e);
                        }
                    }
                }
                catch (OXException e) {
                    LoggerFactory.getLogger(ObjectPermissionValidator.class).warn("Error getting user configuration for permission entities", (Throwable)e);
                }
                finally {
                    if (null != connection) {
                        this.dbProvider.releaseReadConnection(session.getContext(), connection);
                    }
                }
            }
        }
        return validation;
    }

    private static int[] getGroupEntities(List<ObjectPermission> objectPermissions) {
        if (null != objectPermissions && 0 < objectPermissions.size()) {
            ArrayList<Integer> groupIDs = new ArrayList<Integer>();
            for (ObjectPermission objectPermission : objectPermissions) {
                if (!objectPermission.isGroup()) continue;
                groupIDs.add(Autoboxing.I((int)objectPermission.getEntity()));
            }
            return 0 < groupIDs.size() ? Autoboxing.I2i(groupIDs) : null;
        }
        return null;
    }

    private static int[] getUserEntities(List<ObjectPermission> objectPermissions) {
        if (null != objectPermissions && 0 < objectPermissions.size()) {
            ArrayList<Integer> userIDs = new ArrayList<Integer>();
            for (ObjectPermission objectPermission : objectPermissions) {
                if (objectPermission.isGroup()) continue;
                userIDs.add(Autoboxing.I((int)objectPermission.getEntity()));
            }
            return 0 < userIDs.size() ? Autoboxing.I2i(userIDs) : null;
        }
        return null;
    }
}

