/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.database.impl.versioncontrol;

import com.openexchange.database.Databases;
import com.openexchange.database.provider.DBProvider;
import com.openexchange.exception.OXException;
import com.openexchange.filestore.FileStorages;
import com.openexchange.filestore.QuotaFileStorage;
import com.openexchange.filestore.QuotaFileStorageService;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.groupware.infostore.database.impl.DocumentMetadataImpl;
import com.openexchange.groupware.infostore.database.impl.versioncontrol.VersionControlRestored;
import com.openexchange.groupware.infostore.database.impl.versioncontrol.VersionControlResult;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class VersionControlUtil {
    private VersionControlUtil() {
    }

    private static void releaseWriteConnection(Context context, Connection con, boolean afterReading, DBProvider provider) {
        if (afterReading) {
            provider.releaseWriteConnectionAfterReading(context, con);
        } else {
            provider.releaseWriteConnection(context, con);
        }
    }

    private static Map<Integer, DocumentMetadata> asMap(List<DocumentMetadata> documents) {
        if (null == documents) {
            return null;
        }
        HashMap<Integer, DocumentMetadata> m = new HashMap<Integer, DocumentMetadata>(documents.size());
        for (DocumentMetadata document : documents) {
            m.put(document.getId(), document);
        }
        return m;
    }

    private static List<DocumentMetadata> loadVersionsFor(int id, int contextId, Connection con) throws OXException {
        LinkedList<DocumentMetadata> linkedList;
        ResultSet rs;
        PreparedStatement stmt;
        block6: {
            stmt = null;
            rs = null;
            stmt = con.prepareStatement("SELECT version_number, file_store_location FROM infostore_document WHERE cid=? AND infostore_id=?");
            stmt.setInt(1, contextId);
            stmt.setInt(2, id);
            rs = stmt.executeQuery();
            if (rs.next()) break block6;
            List<DocumentMetadata> list = Collections.emptyList();
            Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
            return list;
        }
        try {
            LinkedList<DocumentMetadata> l = new LinkedList<DocumentMetadata>();
            do {
                DocumentMetadataImpl version2 = new DocumentMetadataImpl();
                version2.setId(id);
                String filestoreLocation = rs.getString(2);
                if (rs.wasNull()) continue;
                version2.setVersion(rs.getInt(1));
                version2.setFilestoreLocation(filestoreLocation);
                l.add(version2);
            } while (rs.next());
            linkedList = l;
        }
        catch (SQLException e) {
            try {
                throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                Databases.closeSQLStuff(rs, (Statement)stmt);
                throw throwable;
            }
        }
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Integer, List<VersionControlResult>> doVersionControl(DBProvider provider, List<DocumentMetadata> documents, List<DocumentMetadata> oldDocuments, long destinationFolder, Context context) throws OXException {
        Map<Integer, List<VersionControlResult>> resultMap = null;
        Connection wcon = provider.getWriteConnection(context);
        try {
            resultMap = VersionControlUtil.doVersionControl(documents, oldDocuments, destinationFolder, context, wcon);
            VersionControlUtil.releaseWriteConnection(context, wcon, null == resultMap || resultMap.isEmpty(), provider);
        }
        catch (Throwable throwable) {
            VersionControlUtil.releaseWriteConnection(context, wcon, null == resultMap || resultMap.isEmpty(), provider);
            throw throwable;
        }
        return resultMap;
    }

    public static Map<Integer, List<VersionControlResult>> doVersionControl(List<DocumentMetadata> documents, List<DocumentMetadata> oldDocuments, long destinationFolder, Context context, Connection con) throws OXException {
        OXFolderAccess folderAccess = new OXFolderAccess(con, context);
        int contextId = context.getContextId();
        QuotaFileStorageService qfs = FileStorages.getQuotaFileStorageService();
        QuotaFileStorage destFs = qfs.getQuotaFileStorage(folderAccess.getFolderOwner((int)destinationFolder), contextId);
        Map<Integer, DocumentMetadata> oldDocs = VersionControlUtil.asMap(oldDocuments);
        LinkedHashMap<Integer, List<VersionControlResult>> resultMap = new LinkedHashMap<Integer, List<VersionControlResult>>(documents.size());
        for (DocumentMetadata document : documents) {
            QuotaFileStorage srcFs;
            Integer id = document.getId();
            DocumentMetadata oldDoc = oldDocs.get(id);
            if (null == oldDoc || (srcFs = qfs.getQuotaFileStorage(folderAccess.getFolderOwner((int)oldDoc.getFolderId()), contextId)).getUri().equals(destFs.getUri())) continue;
            List<DocumentMetadata> versions = VersionControlUtil.loadVersionsFor(document.getId(), contextId, con);
            LinkedList<VersionControlResult> results = new LinkedList<VersionControlResult>();
            for (DocumentMetadata version2 : versions) {
                String copiedLocation = destFs.saveNewFile(srcFs.getFile(version2.getFilestoreLocation()));
                srcFs.deleteFile(version2.getFilestoreLocation());
                results.add(new VersionControlResult(srcFs, destFs, version2.getVersion(), version2.getFilestoreLocation(), copiedLocation));
            }
            resultMap.put(id, results);
        }
        if (!resultMap.isEmpty()) {
            VersionControlUtil.applyVersionControl(resultMap, context, con);
        }
        return resultMap;
    }

    private static void applyVersionControl(Map<Integer, List<VersionControlResult>> resultMap, Context context, Connection con) throws OXException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("UPDATE infostore_document SET file_store_location=? WHERE cid=? AND infostore_id=? AND version_number=?");
            int contextId = context.getContextId();
            for (Map.Entry<Integer, List<VersionControlResult>> entry : resultMap.entrySet()) {
                int id = entry.getKey();
                for (VersionControlResult result : entry.getValue()) {
                    stmt.setString(1, result.getDestLocation());
                    stmt.setInt(2, contextId);
                    stmt.setInt(3, id);
                    stmt.setInt(4, result.getVersion());
                    stmt.addBatch();
                }
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            Databases.closeSQLStuff((Statement)stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Integer, List<VersionControlRestored>> restoreVersionControl(DBProvider provider, Map<Integer, List<VersionControlResult>> resultMap, Context context) throws OXException {
        Map<Integer, List<VersionControlRestored>> restoredMap = null;
        Connection wcon = provider.getWriteConnection(context);
        try {
            restoredMap = VersionControlUtil.restoreVersionControl(resultMap, context, wcon);
            VersionControlUtil.releaseWriteConnection(context, wcon, null == restoredMap || restoredMap.isEmpty(), provider);
        }
        catch (Throwable throwable) {
            VersionControlUtil.releaseWriteConnection(context, wcon, null == restoredMap || restoredMap.isEmpty(), provider);
            throw throwable;
        }
        return restoredMap;
    }

    public static Map<Integer, List<VersionControlRestored>> restoreVersionControl(Map<Integer, List<VersionControlResult>> resultMap, Context context, Connection con) throws OXException {
        LinkedHashMap<Integer, List<VersionControlRestored>> restoredMap = new LinkedHashMap<Integer, List<VersionControlRestored>>(resultMap.size());
        for (Map.Entry<Integer, List<VersionControlResult>> entry : resultMap.entrySet()) {
            Integer id = entry.getKey();
            LinkedList<VersionControlRestored> restoreds = new LinkedList<VersionControlRestored>();
            for (VersionControlResult result : entry.getValue()) {
                QuotaFileStorage destFs = result.getDestFileStorage();
                String restoredLocation = result.getSourceFileStorage().saveNewFile(destFs.getFile(result.getDestLocation()));
                destFs.deleteFile(result.getDestLocation());
                restoreds.add(new VersionControlRestored(result.getVersion(), restoredLocation));
            }
            restoredMap.put(id, restoreds);
        }
        if (!restoredMap.isEmpty()) {
            VersionControlUtil.applyRestoreds(restoredMap, context, con);
        }
        return restoredMap;
    }

    private static void applyRestoreds(Map<Integer, List<VersionControlRestored>> restoredMap, Context context, Connection con) throws OXException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("UPDATE infostore_document SET file_store_location=? WHERE cid=? AND infostore_id=? AND version_number=?");
            int contextId = context.getContextId();
            for (Map.Entry<Integer, List<VersionControlRestored>> entry : restoredMap.entrySet()) {
                int id = entry.getKey();
                for (VersionControlRestored restored : entry.getValue()) {
                    stmt.setString(1, restored.getLocation());
                    stmt.setInt(2, contextId);
                    stmt.setInt(3, id);
                    stmt.setInt(4, restored.getVersion());
                    stmt.addBatch();
                }
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            Databases.closeSQLStuff((Statement)stmt);
        }
    }
}

