/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.delete;

import com.openexchange.caching.Cache;
import com.openexchange.caching.CacheService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.delete.ContextDelete;
import com.openexchange.groupware.delete.DeleteEvent;
import com.openexchange.server.services.ServerServiceRegistry;
import java.sql.Connection;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CacheClearerOnContextDelete
extends ContextDelete {
    @Override
    public void deletePerformed(DeleteEvent event, Connection readCon, Connection writeCon) throws OXException {
        if (!this.isContextDelete(event)) {
            return;
        }
        Logger logger = LoggerFactory.getLogger(CacheClearerOnContextDelete.class);
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (null == cacheService) {
            logger.warn(CacheService.class.getSimpleName() + " is absent.");
            return;
        }
        List<String> cacheNames = Arrays.asList("USMOXObjectIDToUUIDCache", "USMUUIDToOXObjectIDCache", "USMUUIDCache");
        for (String cacheName : cacheNames) {
            try {
                Cache cache = cacheService.getCache(cacheName);
                cache.clear();
            }
            catch (OXException e) {
                logger.warn("Clearing cache \"{}\" failed.", (Object)cacheName, (Object)e);
            }
        }
    }
}

