/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contact;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorException;
import com.openexchange.tools.iterator.SearchIterators;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ContactMergerator
implements SearchIterator<Contact> {
    private Contact next = null;
    private List<RememberingIterator> iterators = null;
    private List<SearchIterator<Contact>> delegates = null;
    private OXException e;
    private OXException oxe;
    private final Comparator<Contact> comparator;

    public ContactMergerator(Comparator<Contact> comparator, SearchIterator<Contact> ... iterators) throws OXException {
        this(comparator, Arrays.asList(iterators));
    }

    public ContactMergerator(Comparator<Contact> comparator, List<SearchIterator<Contact>> iterators) throws OXException {
        this.iterators = new ArrayList<RememberingIterator>(iterators.size());
        this.delegates = iterators;
        for (SearchIterator<Contact> searchIterator : iterators) {
            if (!searchIterator.hasNext()) continue;
            this.iterators.add(new RememberingIterator(searchIterator));
        }
        this.comparator = comparator;
        this.grabNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grabNext() throws OXException {
        if (this.iterators.isEmpty()) {
            this.next = null;
            return;
        }
        try {
            if (this.iterators.size() > 1) {
                Collections.sort(this.iterators, new TopMostComparator(this.comparator));
            }
            this.next = this.iterators.get(0).currentOrNext();
        }
        catch (ExceptionTransporter transporter) {
            this.e = transporter.e;
        }
        catch (SearchIteratorException e) {
            this.e = e;
        }
        catch (OXException e) {
            this.oxe = e;
        }
        finally {
            if (this.iterators.get(0).hasNext()) {
                this.iterators.get(0).forgetCurrent();
            } else {
                this.iterators.remove(0);
            }
        }
    }

    public void addWarning(OXException warning) {
    }

    public void close() {
        for (SearchIterator<Contact> iter : this.delegates) {
            SearchIterators.close(iter);
        }
    }

    public OXException[] getWarnings() {
        return null;
    }

    public boolean hasNext() throws OXException {
        return this.next != null;
    }

    public boolean hasWarnings() {
        return false;
    }

    public Contact next() throws OXException {
        this.throwExceptions();
        Contact nextContact = this.next;
        this.grabNext();
        return nextContact;
    }

    private void throwExceptions() throws OXException {
        if (this.e != null) {
            throw this.e;
        }
        if (this.oxe != null) {
            throw this.oxe;
        }
    }

    public int size() {
        return -1;
    }

    private static final class ExceptionTransporter
    extends RuntimeException {
        public OXException e;

        public ExceptionTransporter(OXException x) {
            this.e = x;
        }
    }

    private static final class TopMostComparator
    implements Comparator<RememberingIterator> {
        private Comparator<Contact> contactComparator = null;

        public TopMostComparator(Comparator<Contact> comparator) {
            this.contactComparator = comparator;
        }

        @Override
        public int compare(RememberingIterator o1, RememberingIterator o2) {
            try {
                Contact v1 = o1.currentOrNext();
                Contact v2 = o2.currentOrNext();
                return this.contactComparator.compare(v1, v2);
            }
            catch (OXException e) {
                throw new ExceptionTransporter(e);
            }
        }
    }

    private static final class RememberingIterator {
        private final SearchIterator<Contact> iterator;
        private Contact element;

        public RememberingIterator(SearchIterator<Contact> iterator) {
            this.iterator = iterator;
        }

        public void forgetCurrent() {
            this.element = null;
        }

        public Contact currentOrNext() throws OXException {
            return this.element == null ? this.next() : this.getCurrent();
        }

        public Contact getCurrent() {
            return this.element;
        }

        public boolean hasNext() throws OXException {
            return this.iterator.hasNext();
        }

        public Contact next() throws OXException {
            this.element = (Contact)this.iterator.next();
            return this.element;
        }
    }
}

