/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contact;

import com.openexchange.cache.impl.FolderCacheManager;
import com.openexchange.event.impl.EventClient;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.ContactExceptionCodes;
import com.openexchange.groupware.container.CommonObject;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderChildObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.delete.DeleteEvent;
import com.openexchange.groupware.delete.DeleteListener;
import com.openexchange.java.Autoboxing;
import com.openexchange.session.Session;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.sql.DBUtils;
import gnu.trove.list.array.TIntArrayList;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContactDeleteListener
implements DeleteListener {
    private static Logger LOG = LoggerFactory.getLogger(ContactDeleteListener.class);

    @Override
    public void deletePerformed(DeleteEvent deleteEvent, Connection readCon, Connection writeCon) throws OXException {
        if (deleteEvent.getType() == 1) {
            ContactDeleteListener.dropDListEntries("prg_dlist", "prg_contacts", deleteEvent.getId(), deleteEvent.getContext().getContextId(), writeCon);
            ContactDeleteListener.dropDListEntries("del_dlist", "del_contacts", deleteEvent.getId(), deleteEvent.getContext().getContextId(), writeCon);
            ContactDeleteListener.trashAllUserContacts(deleteEvent.getContext(), deleteEvent.getId(), deleteEvent.getSession(), readCon, writeCon);
        }
    }

    private static void dropDListEntries(String dlistTable, String contactTable, int userId, int contextId, Connection writeCon) throws OXException {
        String sql = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            sql = "SELECT d.intfield01, d.intfield02 FROM " + dlistTable + " AS d JOIN " + contactTable + " AS c ON d.cid = ? AND c.cid = ? AND d.intfield02 = c.intfield01 WHERE c.userId IS NOT NULL AND c.userId = ?";
            stmt = writeCon.prepareStatement(sql);
            stmt.setInt(1, contextId);
            stmt.setInt(2, contextId);
            stmt.setInt(3, userId);
            rs = stmt.executeQuery();
            ArrayList<int[]> l = new ArrayList<int[]>();
            while (rs.next()) {
                l.add(new int[]{rs.getInt(1), rs.getInt(2)});
            }
            DBUtils.closeSQLStuff(rs, stmt);
            sql = "DELETE FROM " + dlistTable + " WHERE cid = ? AND intfield01 = ? AND intfield02 = ?";
            stmt = writeCon.prepareStatement(sql);
            for (int[] arr : l) {
                stmt.setInt(1, contextId);
                stmt.setInt(2, arr[0]);
                stmt.setInt(3, arr[1]);
                stmt.addBatch();
            }
            stmt.executeBatch();
            DBUtils.closeSQLStuff(rs, stmt);
            TIntArrayList toDelete = new TIntArrayList();
            sql = "SELECT COUNT(intfield02) FROM " + dlistTable + " WHERE cid = ? AND intfield01 = ?";
            for (int[] arr : l) {
                int count;
                int dlistId = arr[0];
                stmt = writeCon.prepareStatement(sql);
                stmt.setInt(1, contextId);
                stmt.setInt(2, dlistId);
                rs = stmt.executeQuery();
                if (rs.next() && 0 == (count = rs.getInt(1))) {
                    toDelete.add(dlistId);
                }
                DBUtils.closeSQLStuff(rs, stmt);
            }
            if (!toDelete.isEmpty()) {
                sql = "DELETE FROM " + contactTable + " WHERE cid = ? AND intfield01 = ?";
                stmt = writeCon.prepareStatement(sql);
                for (int id : toDelete.toArray()) {
                    stmt.setInt(1, contextId);
                    stmt.setInt(2, id);
                    stmt.addBatch();
                }
                stmt.executeBatch();
                DBUtils.closeSQLStuff(rs, stmt);
            }
        }
        catch (SQLException e) {
            try {
                throw ContactExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
    }

    private static void trashAllUserContacts(Context context, int userID, Session session, Connection readConnection, Connection writeConnection) throws OXException {
        List<Contact> contacts2 = ContactDeleteListener.getContactsCreatedBy(readConnection, context.getContextId(), userID);
        if (null == contacts2 || 0 == contacts2.size()) {
            return;
        }
        Map<Integer, FolderObject> parentFolders = ContactDeleteListener.getParentFolders(contacts2, context, readConnection);
        ArrayList<Contact> toAdmin = new ArrayList<Contact>();
        ArrayList<Contact> toAdminsFolder = new ArrayList<Contact>();
        ArrayList<Contact> toDelete = new ArrayList<Contact>();
        for (Map.Entry<FolderObject, List<Contact>> entry : ContactDeleteListener.mapToParentFolders(contacts2, parentFolders).entrySet()) {
            ContactDeleteListener.orderContacts(entry.getKey(), entry.getValue(), userID, toAdmin, toAdminsFolder, toDelete);
        }
        if (0 < toAdminsFolder.size()) {
            if (userID == context.getMailadmin()) {
                toDelete.addAll(toAdminsFolder);
            }
            try {
                int moved = ContactDeleteListener.moveToAdminsFolder(writeConnection, context, toAdminsFolder);
                LOG.debug("Moved {} entries originally owned by user {} in context {} to context administrator's default folder.", new Object[]{Autoboxing.I((int)moved), Autoboxing.I((int)userID), Autoboxing.I((int)context.getContextId())});
            }
            catch (OXException e) {
                LOG.error("Error moving stale contacts to context administrator's default folder, deleting affected contacts.", (Throwable)e);
                toDelete.addAll(toAdminsFolder);
            }
        }
        if (0 < toAdmin.size()) {
            int updated = ContactDeleteListener.reassignContacts(writeConnection, "prg_contacts", context.getContextId(), userID, context.getMailadmin());
            LOG.debug("Reassigned {} entries in 'prg_contacts' table to user {} originally owned by user {} in context {}.", new Object[]{Autoboxing.I((int)updated), Autoboxing.I((int)context.getMailadmin()), Autoboxing.I((int)userID), Autoboxing.I((int)context.getContextId())});
        }
        if (0 < toDelete.size()) {
            int deleted = ContactDeleteListener.deleteContacts(writeConnection, context.getContextId(), toDelete);
            LOG.debug("Deleted {} entries from 'prg_contacts' table originally owned by user {} in context {}.", new Object[]{Autoboxing.I((int)deleted), Autoboxing.I((int)userID), Autoboxing.I((int)context.getContextId())});
            EventClient eventClient = new EventClient(session);
            for (Contact contact : toDelete) {
                try {
                    FolderObject parentFolder = parentFolders.get(contact.getParentFolderID());
                    if (null != parentFolder) {
                        eventClient.delete(contact, parentFolder);
                        continue;
                    }
                    eventClient.delete(contact);
                }
                catch (Exception e) {
                    LOG.error("Error triggering delete event for contact delete: id={} cid={}", new Object[]{Autoboxing.I((int)contact.getObjectID()), Autoboxing.I((int)contact.getContextId()), e});
                }
            }
        }
        if (userID == context.getMailadmin()) {
            int deleted = ContactDeleteListener.deleteFromDelContacts(writeConnection, context.getContextId(), userID);
            LOG.debug("Deleted {} entries from 'del_contacts' table originally owned by user {} in context {}.", new Object[]{Autoboxing.I((int)deleted), Autoboxing.I((int)userID), Autoboxing.I((int)context.getContextId())});
        } else {
            int updated = ContactDeleteListener.reassignContacts(writeConnection, "del_contacts", context.getContextId(), userID, context.getMailadmin());
            LOG.debug("Reassigned {} entries in 'del_contacts' table to user {} originally owned by user {} in context {}.", new Object[]{Autoboxing.I((int)updated), Autoboxing.I((int)context.getMailadmin()), Autoboxing.I((int)userID), Autoboxing.I((int)context.getContextId())});
        }
    }

    private static void orderContacts(FolderObject folder, List<Contact> contacts2, int userID, List<Contact> toAdmin, List<Contact> toAdminsFolder, List<Contact> toDelete) throws OXException {
        for (Contact contact : contacts2) {
            if (contact.getPrivateFlag()) {
                LOG.debug("Contact marked as 'private' will be deleted [Context={} Folder={} User={} Contact={}].", new Object[]{Autoboxing.I((int)contact.getContextId()), Autoboxing.I((int)contact.getParentFolderID()), Autoboxing.I((int)userID), Autoboxing.I((int)contact.getObjectID())});
                toDelete.add(contact);
                continue;
            }
            if (null == folder) {
                LOG.warn("Contact with no valid parent folder will be moved to context administrator's address book. [Context={} Folder={} User={} Contact={}]", new Object[]{Autoboxing.I((int)contact.getContextId()), Autoboxing.I((int)contact.getParentFolderID()), Autoboxing.I((int)userID), Autoboxing.I((int)contact.getObjectID())});
                toAdminsFolder.add(contact);
                continue;
            }
            if (3 != folder.getModule()) {
                throw ContactExceptionCodes.NON_CONTACT_FOLDER.create(Autoboxing.I((int)folder.getObjectID()), Autoboxing.I((int)contact.getContextId()), Autoboxing.I((int)userID));
            }
            if (1 == folder.getType(userID)) {
                LOG.debug("Contact in 'private' folder will be deleted [Context={} Folder={} User={} Contact={}].", new Object[]{Autoboxing.I((int)contact.getContextId()), Autoboxing.I((int)contact.getParentFolderID()), Autoboxing.I((int)userID), Autoboxing.I((int)contact.getObjectID())});
                toDelete.add(contact);
                continue;
            }
            LOG.debug("Contact in non-'private' folder will be transferred to context administrator [Context={} Folder={} User={} Contact={}].", new Object[]{Autoboxing.I((int)contact.getContextId()), Autoboxing.I((int)contact.getParentFolderID()), Autoboxing.I((int)userID), Autoboxing.I((int)contact.getObjectID())});
            toAdmin.add(contact);
        }
    }

    private static Map<FolderObject, List<Contact>> mapToParentFolders(List<Contact> contacts2, Map<Integer, FolderObject> knownFolders) {
        HashMap<FolderObject, List<Contact>> contactsByFolder = new HashMap<FolderObject, List<Contact>>();
        for (Contact contact : contacts2) {
            Integer folderID = contact.getParentFolderID();
            FolderObject folder = knownFolders.get(folderID);
            ArrayList<Contact> contactsInFolder = (ArrayList<Contact>)contactsByFolder.get(folder);
            if (null == contactsInFolder) {
                contactsInFolder = new ArrayList<Contact>();
                contactsByFolder.put(folder, contactsInFolder);
            }
            contactsInFolder.add(contact);
        }
        return contactsByFolder;
    }

    private static Map<Integer, FolderObject> getParentFolders(List<Contact> contacts2, Context context, Connection readConnection) {
        HashMap<Integer, FolderObject> knownFolders = new HashMap<Integer, FolderObject>();
        for (Contact contact : contacts2) {
            Integer folderID = contact.getParentFolderID();
            if (knownFolders.containsKey(folderID)) continue;
            knownFolders.put(folderID, ContactDeleteListener.getFolder(context, readConnection, folderID));
        }
        return knownFolders;
    }

    private static List<Contact> getContactsCreatedBy(Connection connection, int contextID, int createdBy) throws OXException {
        Cloneable contact;
        String sql = "SELECT intfield01,fid,pflag FROM prg_contacts WHERE cid=? AND created_from=?;";
        ArrayList<Cloneable> contacts2 = new ArrayList<Cloneable>();
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = connection.prepareStatement(sql);
            stmt.setInt(1, contextID);
            stmt.setInt(2, createdBy);
            result = stmt.executeQuery();
            while (result.next()) {
                contact = new Contact();
                ((Contact)contact).setContextId(contextID);
                ((DataObject)((Object)contact)).setCreatedBy(createdBy);
                ((DataObject)((Object)contact)).setObjectID(result.getInt(1));
                ((FolderChildObject)((Object)contact)).setParentFolderID(result.getInt(2));
                int pflag = result.getInt(3);
                if (result.wasNull()) {
                    pflag = 0;
                }
                ((CommonObject)contact).setPrivateFlag(0 != pflag);
                contacts2.add(contact);
            }
            contact = contacts2;
        }
        catch (SQLException e) {
            try {
                throw ContactExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        return contact;
    }

    private static int deleteFromDelContacts(Connection writeConnection, int contextID, int createdBy) throws OXException {
        String sql = "DELETE FROM del_contacts WHERE cid=? AND created_from=?;";
        PreparedStatement stmt = null;
        try {
            stmt = writeConnection.prepareStatement(sql);
            stmt.setInt(1, contextID);
            stmt.setInt(2, createdBy);
            int n = stmt.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw ContactExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    private static int reassignContacts(Connection writeConnection, String table, int contextID, int oldCreatedBy, int newCreatedBy) throws OXException {
        String sql = "UPDATE " + table + ' ' + "SET created_from=?,changed_from=?,changing_date=? " + "WHERE cid=? AND created_from=?;";
        PreparedStatement stmt = null;
        try {
            stmt = writeConnection.prepareStatement(sql);
            stmt.setInt(1, newCreatedBy);
            stmt.setInt(2, newCreatedBy);
            stmt.setLong(3, System.currentTimeMillis());
            stmt.setInt(4, contextID);
            stmt.setInt(5, oldCreatedBy);
            int n = stmt.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw ContactExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    private static int moveToAdminsFolder(Connection writeConnection, Context context, List<Contact> contacts2) throws OXException {
        int targetFolderID = new OXFolderAccess(writeConnection, context).getDefaultFolderID(context.getMailadmin(), 3);
        StringBuilder stringBuilder = new StringBuilder().append("UPDATE prg_contacts ").append("SET fid=?,created_from=?,changed_from=?,changing_date=? ").append("WHERE cid=? AND intfield01");
        if (1 == contacts2.size()) {
            stringBuilder.append("=?;");
        } else {
            stringBuilder.append(" IN (?");
            for (int i = 1; i < contacts2.size(); ++i) {
                stringBuilder.append(",?");
            }
            stringBuilder.append(");");
        }
        String sql = stringBuilder.toString();
        PreparedStatement stmt = null;
        try {
            int i;
            stmt = writeConnection.prepareStatement(sql);
            stmt.setInt(1, targetFolderID);
            stmt.setInt(2, context.getMailadmin());
            stmt.setInt(3, context.getMailadmin());
            stmt.setLong(4, System.currentTimeMillis());
            stmt.setInt(5, context.getContextId());
            for (i = 0; i < contacts2.size(); ++i) {
                stmt.setInt(i + 6, contacts2.get(i).getObjectID());
            }
            i = stmt.executeUpdate();
            return i;
        }
        catch (SQLException e) {
            throw ContactExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int deleteContacts(Connection writeConnection, int contextID, List<Contact> contacts2) throws OXException {
        int n;
        int i;
        StringBuilder stringBuilder = new StringBuilder();
        if (1 == contacts2.size()) {
            stringBuilder.append("=?");
        } else {
            stringBuilder.append(" IN (?");
            for (int i2 = 1; i2 < contacts2.size(); ++i2) {
                stringBuilder.append(",?");
            }
            stringBuilder.append(')');
        }
        String inClause = stringBuilder.toString();
        PreparedStatement stmt = null;
        try {
            stmt = writeConnection.prepareStatement("DELETE FROM prg_dlist WHERE cid=? AND intfield01" + inClause + ';');
            stmt.setInt(1, contextID);
            for (i = 0; i < contacts2.size(); ++i) {
                stmt.setInt(i + 2, contacts2.get(i).getObjectID());
            }
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(stmt);
        try {
            stmt = writeConnection.prepareStatement("DELETE FROM prg_contacts_linkage WHERE cid=? AND (intfield01" + inClause + " OR intfield02" + inClause + ");");
            stmt.setInt(1, contextID);
            for (i = 0; i < contacts2.size(); ++i) {
                stmt.setInt(i + 2, contacts2.get(i).getObjectID());
                stmt.setInt(i + 2 + contacts2.size(), contacts2.get(i).getObjectID());
            }
            stmt.executeUpdate();
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
        try {
            stmt = writeConnection.prepareStatement("DELETE FROM prg_contacts_image WHERE cid=? AND intfield01" + inClause + ';');
            stmt.setInt(1, contextID);
            for (i = 0; i < contacts2.size(); ++i) {
                stmt.setInt(i + 2, contacts2.get(i).getObjectID());
            }
            stmt.executeUpdate();
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
        try {
            stmt = writeConnection.prepareStatement("DELETE FROM prg_contacts WHERE cid=? AND intfield01" + inClause + ';');
            stmt.setInt(1, contextID);
            for (i = 0; i < contacts2.size(); ++i) {
                stmt.setInt(i + 2, contacts2.get(i).getObjectID());
            }
            n = stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            try {
                DBUtils.closeSQLStuff(stmt);
                throw throwable;
            }
            catch (SQLException e) {
                throw ContactExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
        }
        DBUtils.closeSQLStuff(stmt);
        return n;
    }

    private static FolderObject getFolder(Context context, Connection readConnection, int folderID) {
        try {
            if (FolderCacheManager.isEnabled()) {
                return FolderCacheManager.getInstance().getFolderObject(folderID, true, context, readConnection);
            }
            return FolderObject.loadFolderObjectFromDB(folderID, context, readConnection);
        }
        catch (OXException e) {
            LOG.warn("No folder found for id {} in context {}.", (Object)folderID, (Object)context.getContextId());
            return null;
        }
    }
}

