/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.osgi;

import com.openexchange.exception.OXException;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.share.ShareService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class FolderStorageServices
implements ServiceTrackerCustomizer<Object, Object> {
    private static final FolderStorageServices INSTANCE = new FolderStorageServices();
    private final ConcurrentMap<Class<?>, Object> services = new ConcurrentHashMap();
    private BundleContext context;
    private Class<?>[] serviceClasses;

    private FolderStorageServices() {
    }

    static FolderStorageServices init(BundleContext context, Class<?>[] services) {
        FolderStorageServices.INSTANCE.context = context;
        FolderStorageServices.INSTANCE.serviceClasses = services;
        return INSTANCE;
    }

    public Object addingService(ServiceReference<Object> reference) {
        if (this.context == null) {
            return null;
        }
        Object service = this.context.getService(reference);
        if (service == null) {
            return null;
        }
        for (Class<?> clazz : this.serviceClasses) {
            if (!clazz.isAssignableFrom(service.getClass())) continue;
            this.services.put(clazz, service);
            break;
        }
        return service;
    }

    public void modifiedService(ServiceReference<Object> reference, Object service) {
    }

    public void removedService(ServiceReference<Object> reference, Object service) {
        for (Class<?> clazz : this.serviceClasses) {
            if (!clazz.isAssignableFrom(service.getClass())) continue;
            this.services.remove(clazz, service);
            break;
        }
    }

    public static <T> T getService(Class<T> clazz) {
        return (T)FolderStorageServices.INSTANCE.services.get(clazz);
    }

    public static <T> T requireService(Class<T> clazz) throws OXException {
        Object service = FolderStorageServices.INSTANCE.services.get(clazz);
        if (service == null) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{ShareService.class.getName()});
        }
        return (T)service;
    }
}

