/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.messaging;

import com.openexchange.folderstorage.AbstractFolder;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.Type;
import com.openexchange.folderstorage.messaging.MessagingFolderIdentifier;
import com.openexchange.folderstorage.messaging.MessagingFolderImpl;
import com.openexchange.folderstorage.messaging.MessagingPermissionImpl;
import com.openexchange.folderstorage.type.MailType;
import com.openexchange.folderstorage.type.SystemType;
import com.openexchange.messaging.MessagingAccount;
import com.openexchange.session.Session;
import com.openexchange.tools.id.IDMangler;

public final class ExternalMessagingAccountRootFolder
extends AbstractFolder {
    private static final long serialVersionUID = -7259106085690350497L;
    private final MessagingFolderImpl.MessagingFolderType messagingFolderType;

    public ExternalMessagingAccountRootFolder(MessagingAccount msgAccount, String serviceId, Session session) {
        this(msgAccount, serviceId, session, null);
    }

    public ExternalMessagingAccountRootFolder(MessagingAccount msgAccount, String serviceId, Session session, int[] rootPerms) {
        String fullname = "";
        this.id = MessagingFolderIdentifier.getFQN(serviceId, msgAccount.getId(), "");
        this.parent = FolderStorage.PRIVATE_ID;
        this.name = msgAccount.getDisplayName();
        this.accountId = IDMangler.mangle((String[])new String[]{serviceId, Integer.toString(msgAccount.getId())});
        MessagingPermissionImpl mp = new MessagingPermissionImpl();
        mp.setEntity(session.getUserId());
        if (null == rootPerms) {
            mp.setAllPermissions(2, 4, 0, 0);
        } else {
            mp.setAllPermissions(rootPerms[0], rootPerms[1], rootPerms[2], rootPerms[3]);
        }
        mp.setAdmin(false);
        this.permissions = new Permission[]{mp};
        this.type = SystemType.getInstance();
        this.subscribed = true;
        this.subscribedSubfolders = true;
        this.capabilities = 0;
        this.summary = "";
        this.deefault = false;
        this.total = 0;
        this.nu = 0;
        this.unread = 0;
        this.deleted = 0;
        this.messagingFolderType = MessagingFolderImpl.MessagingFolderType.ROOT;
    }

    @Override
    public ExternalMessagingAccountRootFolder clone() {
        return (ExternalMessagingAccountRootFolder)super.clone();
    }

    @Override
    public boolean isCacheable() {
        return false;
    }

    @Override
    public ContentType getContentType() {
        return this.messagingFolderType.getContentType();
    }

    @Override
    public int getDefaultType() {
        return this.messagingFolderType.getType();
    }

    @Override
    public void setDefaultType(int defaultType) {
    }

    @Override
    public Type getType() {
        return MailType.getInstance();
    }

    @Override
    public void setContentType(ContentType contentType) {
    }

    @Override
    public void setType(Type type) {
    }

    @Override
    public boolean isGlobalID() {
        return false;
    }
}

