/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.internal.performers;

import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderServiceDecorator;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderStorageDiscoverer;
import com.openexchange.folderstorage.FolderType;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.SortableId;
import com.openexchange.folderstorage.internal.CalculatePermission;
import com.openexchange.folderstorage.internal.TransactionManager;
import com.openexchange.folderstorage.internal.performers.AbstractUserizedFolderPerformer;
import com.openexchange.folderstorage.virtual.VirtualFolderStorage;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.tools.session.ServerSession;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public final class DeletePerformer
extends AbstractUserizedFolderPerformer {
    public DeletePerformer(ServerSession session, FolderServiceDecorator decorator) throws OXException {
        super(session, decorator);
    }

    public DeletePerformer(User user, Context context, FolderServiceDecorator decorator) {
        super(user, context, decorator);
    }

    public DeletePerformer(ServerSession session, FolderServiceDecorator decorator, FolderStorageDiscoverer folderStorageDiscoverer) throws OXException {
        super(session, decorator, folderStorageDiscoverer);
    }

    public DeletePerformer(User user, Context context, FolderServiceDecorator decorator, FolderStorageDiscoverer folderStorageDiscoverer) {
        super(user, context, decorator, folderStorageDiscoverer);
    }

    public void doDelete(String treeId, String folderId, Date timeStamp) throws OXException {
        if (KNOWN_TREES.contains(treeId)) {
            FolderStorage folderStorage = this.folderStorageDiscoverer.getFolderStorage(treeId, folderId);
            if (null == folderStorage) {
                throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, folderId);
            }
            if (null != timeStamp) {
                this.storageParameters.setTimeStamp(timeStamp);
            }
            TransactionManager transactionManager = TransactionManager.initTransaction(this.storageParameters);
            List<FolderStorage> openedStorages = Collections.emptyList();
            this.checkOpenedStorage(folderStorage, openedStorages);
            try {
                if (FolderStorage.REAL_TREE_ID.equals(treeId)) {
                    this.deleteRealFolder(folderId, folderStorage, transactionManager);
                } else {
                    FolderStorage realStorage = this.folderStorageDiscoverer.getFolderStorage(FolderStorage.REAL_TREE_ID, folderId);
                    if (null == realStorage) {
                        throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(FolderStorage.REAL_TREE_ID, folderId);
                    }
                    if (folderStorage.equals(realStorage)) {
                        this.deleteRealFolder(folderId, realStorage, transactionManager);
                    } else {
                        this.deleteVirtualFolder(folderId, treeId, folderStorage, openedStorages, transactionManager);
                    }
                }
                transactionManager.commit();
            }
            catch (OXException e) {
                transactionManager.rollback();
                throw e;
            }
            catch (Exception e) {
                transactionManager.rollback();
                throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
            }
        } else if (VirtualFolderStorage.FOLDER_TREE_EAS.equals(treeId)) {
            FolderStorage folderStorage = this.folderStorageDiscoverer.getFolderStorage(treeId, folderId);
            if (null == folderStorage) {
                throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, folderId);
            }
            folderStorage.deleteFolder(treeId, folderId, this.storageParameters);
        } else {
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create("Delete not supported by tree " + treeId);
        }
    }

    private void deleteVirtualFolder(String folderId, String treeId, FolderStorage folderStorage, List<FolderStorage> openedStorages, TransactionManager transactionManager) throws OXException {
        SortableId[] subfolders;
        Folder folder = folderStorage.getFolder(treeId, folderId, this.storageParameters);
        this.storageParameters.putParameter(FolderType.GLOBAL, "global", folder.isGlobalID());
        Permission permission = CalculatePermission.calculate(folder, this, (List<ContentType>)ALL_ALLOWED);
        if (!permission.isVisible()) {
            throw FolderExceptionErrorMessage.FOLDER_NOT_VISIBLE.create(this.getFolderInfo4Error(folder), this.getUserInfo4Error(), this.getContextInfo4Error());
        }
        if (!permission.isAdmin()) {
            throw FolderExceptionErrorMessage.FOLDER_NOT_DELETEABLE.create(this.getFolderInfo4Error(folder), this.getUserInfo4Error(), this.getContextInfo4Error());
        }
        if (!this.canDeleteAllObjects(permission, folderId, treeId, folderStorage)) {
            throw FolderExceptionErrorMessage.FOLDER_NOT_DELETEABLE.create(this.getFolderInfo4Error(folder), this.getUserInfo4Error(), this.getContextInfo4Error());
        }
        for (SortableId subfolder : subfolders = folderStorage.getSubfolders(treeId, folderId, this.storageParameters)) {
            FolderStorage subfolderStorage;
            String id = subfolder.getId();
            if (folderStorage.getFolderType().servesFolderId(id)) {
                subfolderStorage = folderStorage;
            } else {
                subfolderStorage = this.folderStorageDiscoverer.getFolderStorage(treeId, id);
                if (null == subfolderStorage) {
                    throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, id);
                }
                this.checkOpenedStorage(subfolderStorage, openedStorages);
            }
            this.deleteVirtualFolder(id, treeId, subfolderStorage, openedStorages, transactionManager);
        }
        FolderStorage realStorage = this.folderStorageDiscoverer.getFolderStorage(FolderStorage.REAL_TREE_ID, folderId);
        if (null == realStorage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(FolderStorage.REAL_TREE_ID, folderId);
        }
        this.checkOpenedStorage(realStorage, openedStorages);
        this.deleteRealFolder(folder, realStorage, transactionManager);
        folderStorage.deleteFolder(treeId, folderId, this.storageParameters);
    }

    private void deleteRealFolder(String id, FolderStorage storage, TransactionManager transactionManager) throws OXException {
        this.deleteRealFolder(storage.getFolder(FolderStorage.REAL_TREE_ID, id, this.storageParameters), storage, transactionManager);
    }

    private void deleteRealFolder(Folder folder, FolderStorage storage, TransactionManager transactionManager) throws OXException {
        storage.deleteFolder(FolderStorage.REAL_TREE_ID, folder.getID(), this.storageParameters);
    }

    private boolean canDeleteAllObjects(Permission permission, String folderId, String treeId, FolderStorage folderStorage) throws OXException {
        int deletePermission = permission.getDeletePermission();
        if (deletePermission >= 4) {
            return true;
        }
        if (deletePermission >= 2) {
            return !folderStorage.containsForeignObjects(this.user, treeId, folderId, this.storageParameters);
        }
        return folderStorage.isEmpty(treeId, folderId, this.storageParameters);
    }

    private void checkOpenedStorage(FolderStorage storage, List<FolderStorage> openedStorages) throws OXException {
        for (FolderStorage openedStorage : openedStorages) {
            if (!openedStorage.equals(storage)) continue;
            return;
        }
        if (storage.startTransaction(this.storageParameters, true)) {
            openedStorages.add(storage);
        }
    }
}

