/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.contact.internal.mapping;

import com.openexchange.config.ConfigurationService;
import com.openexchange.contact.internal.ContactServiceLookup;
import com.openexchange.contact.internal.mapping.ContactMapping;
import com.openexchange.contact.internal.mapping.EMailMapping;
import com.openexchange.contact.internal.mapping.StringMapping;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.ContactExceptionCodes;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DistributionListEntryObject;
import com.openexchange.groupware.data.Check;
import com.openexchange.groupware.tools.mappings.DefaultMapper;
import com.openexchange.groupware.tools.mappings.Mapping;
import com.openexchange.groupware.upload.impl.UploadUtility;
import com.openexchange.mail.mime.QuotedInternetAddress;
import java.util.Date;
import java.util.EnumMap;
import javax.mail.internet.AddressException;

public class ContactMapper
extends DefaultMapper<Contact, ContactField> {
    private static final ContactMapper INSTANCE = new ContactMapper();
    private static final EnumMap<ContactField, ContactMapping<? extends Object>> mappings = new EnumMap(ContactField.class);

    public static ContactMapper getInstance() {
        return INSTANCE;
    }

    private ContactMapper() {
    }

    public void validateAll(Contact contact) throws OXException {
        for (ContactMapping<? extends Object> mapping : mappings.values()) {
            mapping.validate(contact);
        }
    }

    public ContactMapping<? extends Object> get(ContactField field) throws OXException {
        if (null == field) {
            throw new IllegalArgumentException("field");
        }
        ContactMapping<? extends Object> mapping = mappings.get((Object)field);
        if (null == mapping) {
            throw OXException.notFound((String)field.toString());
        }
        return mapping;
    }

    public Contact newInstance() {
        return new Contact();
    }

    public ContactField[] newArray(int size) {
        return new ContactField[size];
    }

    protected EnumMap<ContactField, ? extends Mapping<? extends Object, Contact>> getMappings() {
        return mappings;
    }

    static {
        mappings.put(ContactField.DISPLAY_NAME, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setDisplayName(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsDisplayName();
            }

            public String get(Contact contact) {
                return contact.getDisplayName();
            }

            public void remove(Contact contact) {
                contact.removeDisplayName();
            }
        });
        mappings.put(ContactField.SUR_NAME, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setSurName(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsSurName();
            }

            public String get(Contact contact) {
                return contact.getSurName();
            }

            public void remove(Contact contact) {
                contact.removeSurName();
            }
        });
        mappings.put(ContactField.GIVEN_NAME, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setGivenName(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsGivenName();
            }

            public String get(Contact contact) {
                return contact.getGivenName();
            }

            public void remove(Contact contact) {
                contact.removeGivenName();
            }
        });
        mappings.put(ContactField.MIDDLE_NAME, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setMiddleName(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsMiddleName();
            }

            public String get(Contact contact) {
                return contact.getMiddleName();
            }

            public void remove(Contact contact) {
                contact.removeMiddleName();
            }
        });
        mappings.put(ContactField.SUFFIX, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setSuffix(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsSuffix();
            }

            public String get(Contact contact) {
                return contact.getSuffix();
            }

            public void remove(Contact contact) {
                contact.removeSuffix();
            }
        });
        mappings.put(ContactField.TITLE, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setTitle(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsTitle();
            }

            public String get(Contact contact) {
                return contact.getTitle();
            }

            public void remove(Contact contact) {
                contact.removeTitle();
            }
        });
        mappings.put(ContactField.STREET_HOME, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setStreetHome(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsStreetHome();
            }

            public String get(Contact contact) {
                return contact.getStreetHome();
            }

            public void remove(Contact contact) {
                contact.removeStreetHome();
            }
        });
        mappings.put(ContactField.POSTAL_CODE_HOME, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setPostalCodeHome(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsPostalCodeHome();
            }

            public String get(Contact contact) {
                return contact.getPostalCodeHome();
            }

            public void remove(Contact contact) {
                contact.removePostalCodeHome();
            }
        });
        mappings.put(ContactField.CITY_HOME, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setCityHome(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsCityHome();
            }

            public String get(Contact contact) {
                return contact.getCityHome();
            }

            public void remove(Contact contact) {
                contact.removeCityHome();
            }
        });
        mappings.put(ContactField.STATE_HOME, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setStateHome(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsStateHome();
            }

            public String get(Contact contact) {
                return contact.getStateHome();
            }

            public void remove(Contact contact) {
                contact.removeStateHome();
            }
        });
        mappings.put(ContactField.COUNTRY_HOME, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setCountryHome(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsCountryHome();
            }

            public String get(Contact contact) {
                return contact.getCountryHome();
            }

            public void remove(Contact contact) {
                contact.removeCountryHome();
            }
        });
        mappings.put(ContactField.MARITAL_STATUS, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setMaritalStatus(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsMaritalStatus();
            }

            public String get(Contact contact) {
                return contact.getMaritalStatus();
            }

            public void remove(Contact contact) {
                contact.removeMaritalStatus();
            }
        });
        mappings.put(ContactField.NUMBER_OF_CHILDREN, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setNumberOfChildren(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsNumberOfChildren();
            }

            public String get(Contact contact) {
                return contact.getNumberOfChildren();
            }

            public void remove(Contact contact) {
                contact.removeNumberOfChildren();
            }
        });
        mappings.put(ContactField.PROFESSION, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setProfession(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsProfession();
            }

            public String get(Contact contact) {
                return contact.getProfession();
            }

            public void remove(Contact contact) {
                contact.removeProfession();
            }
        });
        mappings.put(ContactField.NICKNAME, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setNickname(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsNickname();
            }

            public String get(Contact contact) {
                return contact.getNickname();
            }

            public void remove(Contact contact) {
                contact.removeNickname();
            }
        });
        mappings.put(ContactField.SPOUSE_NAME, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setSpouseName(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsSpouseName();
            }

            public String get(Contact contact) {
                return contact.getSpouseName();
            }

            public void remove(Contact contact) {
                contact.removeSpouseName();
            }
        });
        mappings.put(ContactField.NOTE, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setNote(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsNote();
            }

            public String get(Contact contact) {
                return contact.getNote();
            }

            public void remove(Contact contact) {
                contact.removeNote();
            }
        });
        mappings.put(ContactField.COMPANY, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setCompany(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsCompany();
            }

            public String get(Contact contact) {
                return contact.getCompany();
            }

            public void remove(Contact contact) {
                contact.removeCompany();
            }
        });
        mappings.put(ContactField.DEPARTMENT, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setDepartment(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsDepartment();
            }

            public String get(Contact contact) {
                return contact.getDepartment();
            }

            public void remove(Contact contact) {
                contact.removeDepartment();
            }
        });
        mappings.put(ContactField.POSITION, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setPosition(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsPosition();
            }

            public String get(Contact contact) {
                return contact.getPosition();
            }

            public void remove(Contact contact) {
                contact.removePosition();
            }
        });
        mappings.put(ContactField.EMPLOYEE_TYPE, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setEmployeeType(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsEmployeeType();
            }

            public String get(Contact contact) {
                return contact.getEmployeeType();
            }

            public void remove(Contact contact) {
                contact.removeEmployeeType();
            }
        });
        mappings.put(ContactField.ROOM_NUMBER, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setRoomNumber(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsRoomNumber();
            }

            public String get(Contact contact) {
                return contact.getRoomNumber();
            }

            public void remove(Contact contact) {
                contact.removeRoomNumber();
            }
        });
        mappings.put(ContactField.STREET_BUSINESS, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setStreetBusiness(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsStreetBusiness();
            }

            public String get(Contact contact) {
                return contact.getStreetBusiness();
            }

            public void remove(Contact contact) {
                contact.removeStreetBusiness();
            }
        });
        mappings.put(ContactField.POSTAL_CODE_BUSINESS, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setPostalCodeBusiness(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsPostalCodeBusiness();
            }

            public String get(Contact contact) {
                return contact.getPostalCodeBusiness();
            }

            public void remove(Contact contact) {
                contact.removePostalCodeBusiness();
            }
        });
        mappings.put(ContactField.CITY_BUSINESS, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setCityBusiness(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsCityBusiness();
            }

            public String get(Contact contact) {
                return contact.getCityBusiness();
            }

            public void remove(Contact contact) {
                contact.removeCityBusiness();
            }
        });
        mappings.put(ContactField.STATE_BUSINESS, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setStateBusiness(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsStateBusiness();
            }

            public String get(Contact contact) {
                return contact.getStateBusiness();
            }

            public void remove(Contact contact) {
                contact.removeStateBusiness();
            }
        });
        mappings.put(ContactField.COUNTRY_BUSINESS, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setCountryBusiness(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsCountryBusiness();
            }

            public String get(Contact contact) {
                return contact.getCountryBusiness();
            }

            public void remove(Contact contact) {
                contact.removeCountryBusiness();
            }
        });
        mappings.put(ContactField.NUMBER_OF_EMPLOYEE, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setNumberOfEmployee(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsNumberOfEmployee();
            }

            public String get(Contact contact) {
                return contact.getNumberOfEmployee();
            }

            public void remove(Contact contact) {
                contact.removeNumberOfEmployee();
            }
        });
        mappings.put(ContactField.SALES_VOLUME, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setSalesVolume(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsSalesVolume();
            }

            public String get(Contact contact) {
                return contact.getSalesVolume();
            }

            public void remove(Contact contact) {
                contact.removeSalesVolume();
            }
        });
        mappings.put(ContactField.TAX_ID, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setTaxID(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsTaxID();
            }

            public String get(Contact contact) {
                return contact.getTaxID();
            }

            public void remove(Contact contact) {
                contact.removeTaxID();
            }
        });
        mappings.put(ContactField.COMMERCIAL_REGISTER, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setCommercialRegister(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsCommercialRegister();
            }

            public String get(Contact contact) {
                return contact.getCommercialRegister();
            }

            public void remove(Contact contact) {
                contact.removeCommercialRegister();
            }
        });
        mappings.put(ContactField.BRANCHES, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setBranches(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsBranches();
            }

            public String get(Contact contact) {
                return contact.getBranches();
            }

            public void remove(Contact contact) {
                contact.removeBranches();
            }
        });
        mappings.put(ContactField.BUSINESS_CATEGORY, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setBusinessCategory(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsBusinessCategory();
            }

            public String get(Contact contact) {
                return contact.getBusinessCategory();
            }

            public void remove(Contact contact) {
                contact.removeBusinessCategory();
            }
        });
        mappings.put(ContactField.INFO, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setInfo(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsInfo();
            }

            public String get(Contact contact) {
                return contact.getInfo();
            }

            public void remove(Contact contact) {
                contact.removeInfo();
            }
        });
        mappings.put(ContactField.MANAGER_NAME, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setManagerName(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsManagerName();
            }

            public String get(Contact contact) {
                return contact.getManagerName();
            }

            public void remove(Contact contact) {
                contact.removeManagerName();
            }
        });
        mappings.put(ContactField.ASSISTANT_NAME, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setAssistantName(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsAssistantName();
            }

            public String get(Contact contact) {
                return contact.getAssistantName();
            }

            public void remove(Contact contact) {
                contact.removeAssistantName();
            }
        });
        mappings.put(ContactField.STREET_OTHER, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setStreetOther(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsStreetOther();
            }

            public String get(Contact contact) {
                return contact.getStreetOther();
            }

            public void remove(Contact contact) {
                contact.removeStreetOther();
            }
        });
        mappings.put(ContactField.POSTAL_CODE_OTHER, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setPostalCodeOther(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsPostalCodeOther();
            }

            public String get(Contact contact) {
                return contact.getPostalCodeOther();
            }

            public void remove(Contact contact) {
                contact.removePostalCodeOther();
            }
        });
        mappings.put(ContactField.CITY_OTHER, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setCityOther(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsCityOther();
            }

            public String get(Contact contact) {
                return contact.getCityOther();
            }

            public void remove(Contact contact) {
                contact.removeCityOther();
            }
        });
        mappings.put(ContactField.STATE_OTHER, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setStateOther(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsStateOther();
            }

            public String get(Contact contact) {
                return contact.getStateOther();
            }

            public void remove(Contact contact) {
                contact.removeStateOther();
            }
        });
        mappings.put(ContactField.COUNTRY_OTHER, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setCountryOther(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsCountryOther();
            }

            public String get(Contact contact) {
                return contact.getCountryOther();
            }

            public void remove(Contact contact) {
                contact.removeCountryOther();
            }
        });
        mappings.put(ContactField.TELEPHONE_ASSISTANT, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setTelephoneAssistant(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsTelephoneAssistant();
            }

            public String get(Contact contact) {
                return contact.getTelephoneAssistant();
            }

            public void remove(Contact contact) {
                contact.removeTelephoneAssistant();
            }
        });
        mappings.put(ContactField.TELEPHONE_BUSINESS1, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setTelephoneBusiness1(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsTelephoneBusiness1();
            }

            public String get(Contact contact) {
                return contact.getTelephoneBusiness1();
            }

            public void remove(Contact contact) {
                contact.removeTelephoneBusiness1();
            }
        });
        mappings.put(ContactField.TELEPHONE_BUSINESS2, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setTelephoneBusiness2(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsTelephoneBusiness2();
            }

            public String get(Contact contact) {
                return contact.getTelephoneBusiness2();
            }

            public void remove(Contact contact) {
                contact.removeTelephoneBusiness2();
            }
        });
        mappings.put(ContactField.FAX_BUSINESS, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setFaxBusiness(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsFaxBusiness();
            }

            public String get(Contact contact) {
                return contact.getFaxBusiness();
            }

            public void remove(Contact contact) {
                contact.removeFaxBusiness();
            }
        });
        mappings.put(ContactField.TELEPHONE_CALLBACK, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setTelephoneCallback(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsTelephoneCallback();
            }

            public String get(Contact contact) {
                return contact.getTelephoneCallback();
            }

            public void remove(Contact contact) {
                contact.removeTelephoneCallback();
            }
        });
        mappings.put(ContactField.TELEPHONE_CAR, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setTelephoneCar(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsTelephoneCar();
            }

            public String get(Contact contact) {
                return contact.getTelephoneCar();
            }

            public void remove(Contact contact) {
                contact.removeTelephoneCar();
            }
        });
        mappings.put(ContactField.TELEPHONE_COMPANY, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setTelephoneCompany(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsTelephoneCompany();
            }

            public String get(Contact contact) {
                return contact.getTelephoneCompany();
            }

            public void remove(Contact contact) {
                contact.removeTelephoneCompany();
            }
        });
        mappings.put(ContactField.TELEPHONE_HOME1, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setTelephoneHome1(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsTelephoneHome1();
            }

            public String get(Contact contact) {
                return contact.getTelephoneHome1();
            }

            public void remove(Contact contact) {
                contact.removeTelephoneHome1();
            }
        });
        mappings.put(ContactField.TELEPHONE_HOME2, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setTelephoneHome2(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsTelephoneHome2();
            }

            public String get(Contact contact) {
                return contact.getTelephoneHome2();
            }

            public void remove(Contact contact) {
                contact.removeTelephoneHome2();
            }
        });
        mappings.put(ContactField.FAX_HOME, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setFaxHome(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsFaxHome();
            }

            public String get(Contact contact) {
                return contact.getFaxHome();
            }

            public void remove(Contact contact) {
                contact.removeFaxHome();
            }
        });
        mappings.put(ContactField.TELEPHONE_ISDN, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setTelephoneISDN(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsTelephoneISDN();
            }

            public String get(Contact contact) {
                return contact.getTelephoneISDN();
            }

            public void remove(Contact contact) {
                contact.removeTelephoneISDN();
            }
        });
        mappings.put(ContactField.CELLULAR_TELEPHONE1, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setCellularTelephone1(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsCellularTelephone1();
            }

            public String get(Contact contact) {
                return contact.getCellularTelephone1();
            }

            public void remove(Contact contact) {
                contact.removeCellularTelephone1();
            }
        });
        mappings.put(ContactField.CELLULAR_TELEPHONE2, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setCellularTelephone2(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsCellularTelephone2();
            }

            public String get(Contact contact) {
                return contact.getCellularTelephone2();
            }

            public void remove(Contact contact) {
                contact.removeCellularTelephone2();
            }
        });
        mappings.put(ContactField.TELEPHONE_OTHER, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setTelephoneOther(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsTelephoneOther();
            }

            public String get(Contact contact) {
                return contact.getTelephoneOther();
            }

            public void remove(Contact contact) {
                contact.removeTelephoneOther();
            }
        });
        mappings.put(ContactField.FAX_OTHER, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setFaxOther(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsFaxOther();
            }

            public String get(Contact contact) {
                return contact.getFaxOther();
            }

            public void remove(Contact contact) {
                contact.removeFaxOther();
            }
        });
        mappings.put(ContactField.TELEPHONE_PAGER, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setTelephonePager(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsTelephonePager();
            }

            public String get(Contact contact) {
                return contact.getTelephonePager();
            }

            public void remove(Contact contact) {
                contact.removeTelephonePager();
            }
        });
        mappings.put(ContactField.TELEPHONE_PRIMARY, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setTelephonePrimary(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsTelephonePrimary();
            }

            public String get(Contact contact) {
                return contact.getTelephonePrimary();
            }

            public void remove(Contact contact) {
                contact.removeTelephonePrimary();
            }
        });
        mappings.put(ContactField.TELEPHONE_RADIO, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setTelephoneRadio(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsTelephoneRadio();
            }

            public String get(Contact contact) {
                return contact.getTelephoneRadio();
            }

            public void remove(Contact contact) {
                contact.removeTelephoneRadio();
            }
        });
        mappings.put(ContactField.TELEPHONE_TELEX, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setTelephoneTelex(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsTelephoneTelex();
            }

            public String get(Contact contact) {
                return contact.getTelephoneTelex();
            }

            public void remove(Contact contact) {
                contact.removeTelephoneTelex();
            }
        });
        mappings.put(ContactField.TELEPHONE_TTYTDD, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setTelephoneTTYTTD(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsTelephoneTTYTTD();
            }

            public String get(Contact contact) {
                return contact.getTelephoneTTYTTD();
            }

            public void remove(Contact contact) {
                contact.removeTelephoneTTYTTD();
            }
        });
        mappings.put(ContactField.INSTANT_MESSENGER1, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setInstantMessenger1(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsInstantMessenger1();
            }

            public String get(Contact contact) {
                return contact.getInstantMessenger1();
            }

            public void remove(Contact contact) {
                contact.removeInstantMessenger1();
            }
        });
        mappings.put(ContactField.INSTANT_MESSENGER2, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setInstantMessenger2(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsInstantMessenger2();
            }

            public String get(Contact contact) {
                return contact.getInstantMessenger2();
            }

            public void remove(Contact contact) {
                contact.removeInstantMessenger2();
            }
        });
        mappings.put(ContactField.TELEPHONE_IP, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setTelephoneIP(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsTelephoneIP();
            }

            public String get(Contact contact) {
                return contact.getTelephoneIP();
            }

            public void remove(Contact contact) {
                contact.removeTelephoneIP();
            }
        });
        mappings.put(ContactField.EMAIL1, new EMailMapping(){

            public void set(Contact contact, String value) {
                contact.setEmail1(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsEmail1();
            }

            public String get(Contact contact) {
                return contact.getEmail1();
            }

            public void remove(Contact contact) {
                contact.removeEmail1();
            }
        });
        mappings.put(ContactField.EMAIL2, new EMailMapping(){

            public void set(Contact contact, String value) {
                contact.setEmail2(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsEmail2();
            }

            public String get(Contact contact) {
                return contact.getEmail2();
            }

            public void remove(Contact contact) {
                contact.removeEmail2();
            }
        });
        mappings.put(ContactField.EMAIL3, new EMailMapping(){

            public void set(Contact contact, String value) {
                contact.setEmail3(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsEmail3();
            }

            public String get(Contact contact) {
                return contact.getEmail3();
            }

            public void remove(Contact contact) {
                contact.removeEmail3();
            }
        });
        mappings.put(ContactField.URL, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setURL(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsURL();
            }

            public String get(Contact contact) {
                return contact.getURL();
            }

            public void remove(Contact contact) {
                contact.removeURL();
            }
        });
        mappings.put(ContactField.CATEGORIES, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setCategories(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsCategories();
            }

            public String get(Contact contact) {
                return contact.getCategories();
            }

            public void remove(Contact contact) {
                contact.removeCategories();
            }
        });
        mappings.put(ContactField.USERFIELD01, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setUserField01(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsUserField01();
            }

            public String get(Contact contact) {
                return contact.getUserField01();
            }

            public void remove(Contact contact) {
                contact.removeUserField01();
            }
        });
        mappings.put(ContactField.USERFIELD02, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setUserField02(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsUserField02();
            }

            public String get(Contact contact) {
                return contact.getUserField02();
            }

            public void remove(Contact contact) {
                contact.removeUserField02();
            }
        });
        mappings.put(ContactField.USERFIELD03, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setUserField03(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsUserField03();
            }

            public String get(Contact contact) {
                return contact.getUserField03();
            }

            public void remove(Contact contact) {
                contact.removeUserField03();
            }
        });
        mappings.put(ContactField.USERFIELD04, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setUserField04(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsUserField04();
            }

            public String get(Contact contact) {
                return contact.getUserField04();
            }

            public void remove(Contact contact) {
                contact.removeUserField04();
            }
        });
        mappings.put(ContactField.USERFIELD05, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setUserField05(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsUserField05();
            }

            public String get(Contact contact) {
                return contact.getUserField05();
            }

            public void remove(Contact contact) {
                contact.removeUserField05();
            }
        });
        mappings.put(ContactField.USERFIELD06, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setUserField06(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsUserField06();
            }

            public String get(Contact contact) {
                return contact.getUserField06();
            }

            public void remove(Contact contact) {
                contact.removeUserField06();
            }
        });
        mappings.put(ContactField.USERFIELD07, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setUserField07(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsUserField07();
            }

            public String get(Contact contact) {
                return contact.getUserField07();
            }

            public void remove(Contact contact) {
                contact.removeUserField07();
            }
        });
        mappings.put(ContactField.USERFIELD08, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setUserField08(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsUserField08();
            }

            public String get(Contact contact) {
                return contact.getUserField08();
            }

            public void remove(Contact contact) {
                contact.removeUserField08();
            }
        });
        mappings.put(ContactField.USERFIELD09, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setUserField09(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsUserField09();
            }

            public String get(Contact contact) {
                return contact.getUserField09();
            }

            public void remove(Contact contact) {
                contact.removeUserField09();
            }
        });
        mappings.put(ContactField.USERFIELD10, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setUserField10(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsUserField10();
            }

            public String get(Contact contact) {
                return contact.getUserField10();
            }

            public void remove(Contact contact) {
                contact.removeUserField10();
            }
        });
        mappings.put(ContactField.USERFIELD11, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setUserField11(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsUserField11();
            }

            public String get(Contact contact) {
                return contact.getUserField11();
            }

            public void remove(Contact contact) {
                contact.removeUserField11();
            }
        });
        mappings.put(ContactField.USERFIELD12, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setUserField12(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsUserField12();
            }

            public String get(Contact contact) {
                return contact.getUserField12();
            }

            public void remove(Contact contact) {
                contact.removeUserField12();
            }
        });
        mappings.put(ContactField.USERFIELD13, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setUserField13(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsUserField13();
            }

            public String get(Contact contact) {
                return contact.getUserField13();
            }

            public void remove(Contact contact) {
                contact.removeUserField13();
            }
        });
        mappings.put(ContactField.USERFIELD14, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setUserField14(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsUserField14();
            }

            public String get(Contact contact) {
                return contact.getUserField14();
            }

            public void remove(Contact contact) {
                contact.removeUserField14();
            }
        });
        mappings.put(ContactField.USERFIELD15, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setUserField15(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsUserField15();
            }

            public String get(Contact contact) {
                return contact.getUserField15();
            }

            public void remove(Contact contact) {
                contact.removeUserField15();
            }
        });
        mappings.put(ContactField.USERFIELD16, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setUserField16(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsUserField16();
            }

            public String get(Contact contact) {
                return contact.getUserField16();
            }

            public void remove(Contact contact) {
                contact.removeUserField16();
            }
        });
        mappings.put(ContactField.USERFIELD17, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setUserField17(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsUserField17();
            }

            public String get(Contact contact) {
                return contact.getUserField17();
            }

            public void remove(Contact contact) {
                contact.removeUserField17();
            }
        });
        mappings.put(ContactField.USERFIELD18, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setUserField18(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsUserField18();
            }

            public String get(Contact contact) {
                return contact.getUserField18();
            }

            public void remove(Contact contact) {
                contact.removeUserField18();
            }
        });
        mappings.put(ContactField.USERFIELD19, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setUserField19(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsUserField19();
            }

            public String get(Contact contact) {
                return contact.getUserField19();
            }

            public void remove(Contact contact) {
                contact.removeUserField19();
            }
        });
        mappings.put(ContactField.USERFIELD20, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setUserField20(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsUserField20();
            }

            public String get(Contact contact) {
                return contact.getUserField20();
            }

            public void remove(Contact contact) {
                contact.removeUserField20();
            }
        });
        mappings.put(ContactField.OBJECT_ID, (ContactMapping<? extends Object>)new ContactMapping<Integer>(){

            public void set(Contact contact, Integer value) {
                contact.setObjectID(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsObjectID();
            }

            public Integer get(Contact contact) {
                return contact.getObjectID();
            }

            public void remove(Contact contact) {
                contact.removeObjectID();
            }
        });
        mappings.put(ContactField.PRIVATE_FLAG, (ContactMapping<? extends Object>)new ContactMapping<Boolean>(){

            public void set(Contact contact, Boolean value) {
                contact.setPrivateFlag(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsPrivateFlag();
            }

            public Boolean get(Contact contact) {
                return contact.getPrivateFlag();
            }

            public void remove(Contact contact) {
                contact.removePrivateFlag();
            }
        });
        mappings.put(ContactField.NUMBER_OF_DISTRIBUTIONLIST, (ContactMapping<? extends Object>)new ContactMapping<Integer>(){

            public void set(Contact contact, Integer value) {
                contact.setNumberOfDistributionLists(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsNumberOfDistributionLists();
            }

            public Integer get(Contact contact) {
                return contact.getNumberOfDistributionLists();
            }

            public void remove(Contact contact) {
                contact.removeNumberOfDistributionLists();
            }
        });
        mappings.put(ContactField.DISTRIBUTIONLIST, (ContactMapping<? extends Object>)new ContactMapping<DistributionListEntryObject[]>(){

            public void set(Contact contact, DistributionListEntryObject[] value) {
                contact.setDistributionList(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsDistributionLists();
            }

            public DistributionListEntryObject[] get(Contact contact) {
                return contact.getDistributionList();
            }

            private void validateString(String value) throws OXException {
                String result;
                if (null != value && null != (result = Check.containsInvalidChars(value))) {
                    throw ContactExceptionCodes.BAD_CHARACTER.create(result, this.toString());
                }
            }

            @Override
            public void validate(Contact contact) throws OXException {
                DistributionListEntryObject[] members = this.get(contact);
                if (null != members && 0 < members.length) {
                    for (DistributionListEntryObject member : members) {
                        this.validateString(member.getDisplayname());
                        this.validateString(member.getEmailaddress());
                        this.validateString(member.getLastname());
                        this.validateString(member.getFirstname());
                        if (0 == member.getEmailfield()) {
                            if (null == member.getEmailaddress() || 0 == member.getEmailaddress().trim().length()) {
                                throw ContactExceptionCodes.EMAIL_MANDATORY_FOR_EXTERNAL_MEMBERS.create();
                            }
                            try {
                                new QuotedInternetAddress(member.getEmailaddress()).validate();
                                continue;
                            }
                            catch (AddressException e) {
                                throw ContactExceptionCodes.INVALID_EMAIL.create(e, member.getEmailaddress());
                            }
                        }
                        if (0 != member.getEntryID()) continue;
                        throw ContactExceptionCodes.OBJECT_ID_MANDATORY_FOR_REFERENCED_MEMBERS.create();
                    }
                }
            }

            public void remove(Contact contact) {
                contact.removeDistributionLists();
            }
        });
        mappings.put(ContactField.FOLDER_ID, (ContactMapping<? extends Object>)new ContactMapping<Integer>(){

            public void set(Contact contact, Integer value) {
                contact.setParentFolderID(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsParentFolderID();
            }

            public Integer get(Contact contact) {
                return contact.getParentFolderID();
            }

            public void remove(Contact contact) {
                contact.removeParentFolderID();
            }
        });
        mappings.put(ContactField.CONTEXTID, (ContactMapping<? extends Object>)new ContactMapping<Integer>(){

            public void set(Contact contact, Integer value) {
                contact.setContextId(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsContextId();
            }

            public Integer get(Contact contact) {
                return contact.getContextId();
            }

            public void remove(Contact contact) {
                contact.removeContextID();
            }
        });
        mappings.put(ContactField.CREATED_BY, (ContactMapping<? extends Object>)new ContactMapping<Integer>(){

            public void set(Contact contact, Integer value) {
                contact.setCreatedBy(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsCreatedBy();
            }

            public Integer get(Contact contact) {
                return contact.getCreatedBy();
            }

            public void remove(Contact contact) {
                contact.removeCreatedBy();
            }
        });
        mappings.put(ContactField.MODIFIED_BY, (ContactMapping<? extends Object>)new ContactMapping<Integer>(){

            public void set(Contact contact, Integer value) {
                contact.setModifiedBy(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsModifiedBy();
            }

            public Integer get(Contact contact) {
                return contact.getModifiedBy();
            }

            public void remove(Contact contact) {
                contact.removeModifiedBy();
            }
        });
        mappings.put(ContactField.CREATION_DATE, (ContactMapping<? extends Object>)new ContactMapping<Date>(){

            public void set(Contact contact, Date value) {
                contact.setCreationDate(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsCreationDate();
            }

            public Date get(Contact contact) {
                return contact.getCreationDate();
            }

            public void remove(Contact contact) {
                contact.removeCreationDate();
            }
        });
        mappings.put(ContactField.LAST_MODIFIED, (ContactMapping<? extends Object>)new ContactMapping<Date>(){

            public void set(Contact contact, Date value) {
                contact.setLastModified(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsLastModified();
            }

            public Date get(Contact contact) {
                return contact.getLastModified();
            }

            public void remove(Contact contact) {
                contact.removeLastModified();
            }
        });
        mappings.put(ContactField.BIRTHDAY, (ContactMapping<? extends Object>)new ContactMapping<Date>(){

            public void set(Contact contact, Date value) {
                contact.setBirthday(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsBirthday();
            }

            public Date get(Contact contact) {
                return contact.getBirthday();
            }

            public void remove(Contact contact) {
                contact.removeBirthday();
            }
        });
        mappings.put(ContactField.ANNIVERSARY, (ContactMapping<? extends Object>)new ContactMapping<Date>(){

            public void set(Contact contact, Date value) {
                contact.setAnniversary(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsAnniversary();
            }

            public Date get(Contact contact) {
                return contact.getAnniversary();
            }

            public void remove(Contact contact) {
                contact.removeAnniversary();
            }
        });
        mappings.put(ContactField.IMAGE1, (ContactMapping<? extends Object>)new ContactMapping<byte[]>(){
            private Integer maxImageSize = null;

            private int getMaxImageSize() throws OXException {
                if (null == this.maxImageSize) {
                    this.maxImageSize = ContactServiceLookup.getService(ConfigurationService.class).getIntProperty("max_image_size", 0x400000);
                }
                return this.maxImageSize;
            }

            public void set(Contact contact, byte[] value) {
                contact.setImage1(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsImage1();
            }

            public byte[] get(Contact contact) {
                return contact.getImage1();
            }

            @Override
            public void validate(Contact contact) throws OXException {
                byte[] image;
                int maxSize = this.getMaxImageSize();
                if (null != contact && 0 < maxSize && null != (image = contact.getImage1()) && image.length > maxSize) {
                    throw ContactExceptionCodes.IMAGE_TOO_LARGE.create(UploadUtility.getSize(image.length), UploadUtility.getSize(maxSize));
                }
            }

            public void remove(Contact contact) {
                contact.removeImage1();
            }
        });
        mappings.put(ContactField.IMAGE_LAST_MODIFIED, (ContactMapping<? extends Object>)new ContactMapping<Date>(){

            public void set(Contact contact, Date value) {
                contact.setImageLastModified(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsImageLastModified();
            }

            public Date get(Contact contact) {
                return contact.getImageLastModified();
            }

            public void remove(Contact contact) {
                contact.removeImageLastModified();
            }
        });
        mappings.put(ContactField.IMAGE1_CONTENT_TYPE, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setImageContentType(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsImageContentType();
            }

            public String get(Contact contact) {
                return contact.getImageContentType();
            }

            public void remove(Contact contact) {
                contact.removeImageContentType();
            }
        });
        mappings.put(ContactField.INTERNAL_USERID, (ContactMapping<? extends Object>)new ContactMapping<Integer>(){

            public void set(Contact contact, Integer value) {
                contact.setInternalUserId(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsInternalUserId();
            }

            public Integer get(Contact contact) {
                return contact.getInternalUserId();
            }

            public void remove(Contact contact) {
                contact.removeInternalUserId();
            }
        });
        mappings.put(ContactField.COLOR_LABEL, (ContactMapping<? extends Object>)new ContactMapping<Integer>(){

            public void set(Contact contact, Integer value) {
                contact.setLabel(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsLabel();
            }

            public Integer get(Contact contact) {
                return contact.getLabel();
            }

            public void remove(Contact contact) {
                contact.removeLabel();
            }
        });
        mappings.put(ContactField.FILE_AS, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setFileAs(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsFileAs();
            }

            public String get(Contact contact) {
                return contact.getFileAs();
            }

            public void remove(Contact contact) {
                contact.removeFileAs();
            }
        });
        mappings.put(ContactField.DEFAULT_ADDRESS, (ContactMapping<? extends Object>)new ContactMapping<Integer>(){

            public void set(Contact contact, Integer value) {
                contact.setDefaultAddress(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsDefaultAddress();
            }

            public Integer get(Contact contact) {
                return contact.getDefaultAddress();
            }

            public void remove(Contact contact) {
                contact.removeDefaultAddress();
            }
        });
        mappings.put(ContactField.MARK_AS_DISTRIBUTIONLIST, (ContactMapping<? extends Object>)new ContactMapping<Boolean>(){

            public void set(Contact contact, Boolean value) {
                contact.setMarkAsDistributionlist(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsMarkAsDistributionlist();
            }

            public Boolean get(Contact contact) {
                return contact.getMarkAsDistribtuionlist();
            }

            @Override
            public void validate(Contact contact) throws OXException {
            }

            public void remove(Contact contact) {
                contact.removeMarkAsDistributionlist();
            }
        });
        mappings.put(ContactField.NUMBER_OF_ATTACHMENTS, (ContactMapping<? extends Object>)new ContactMapping<Integer>(){

            public void set(Contact contact, Integer value) {
                contact.setNumberOfAttachments(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsNumberOfAttachments();
            }

            public Integer get(Contact contact) {
                return contact.getNumberOfAttachments();
            }

            public void remove(Contact contact) {
                contact.removeNumberOfAttachments();
            }
        });
        mappings.put(ContactField.YOMI_FIRST_NAME, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setYomiFirstName(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsYomiFirstName();
            }

            public String get(Contact contact) {
                return contact.getYomiFirstName();
            }

            public void remove(Contact contact) {
                contact.removeYomiFirstName();
            }
        });
        mappings.put(ContactField.YOMI_LAST_NAME, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setYomiLastName(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsYomiLastName();
            }

            public String get(Contact contact) {
                return contact.getYomiLastName();
            }

            public void remove(Contact contact) {
                contact.removeYomiLastName();
            }
        });
        mappings.put(ContactField.YOMI_COMPANY, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setYomiCompany(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsYomiCompany();
            }

            public String get(Contact contact) {
                return contact.getYomiCompany();
            }

            public void remove(Contact contact) {
                contact.removeYomiCompany();
            }
        });
        mappings.put(ContactField.NUMBER_OF_IMAGES, (ContactMapping<? extends Object>)new ContactMapping<Integer>(){

            public void set(Contact contact, Integer value) {
                contact.setNumberOfImages(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsImage1();
            }

            public Integer get(Contact contact) {
                return contact.getNumberOfImages();
            }

            public void remove(Contact contact) {
                contact.setNumberOfImages(0);
            }
        });
        mappings.put(ContactField.LAST_MODIFIED_OF_NEWEST_ATTACHMENT, (ContactMapping<? extends Object>)new ContactMapping<Date>(){

            public void set(Contact contact, Date value) {
                contact.setLastModifiedOfNewestAttachment(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsLastModifiedOfNewestAttachment();
            }

            public Date get(Contact contact) {
                return contact.getLastModifiedOfNewestAttachment();
            }

            public void remove(Contact contact) {
                contact.removeLastModifiedOfNewestAttachment();
            }
        });
        mappings.put(ContactField.USE_COUNT, (ContactMapping<? extends Object>)new ContactMapping<Integer>(){

            public void set(Contact contact, Integer value) {
                contact.setUseCount(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsUseCount();
            }

            public Integer get(Contact contact) {
                return contact.getUseCount();
            }

            public void remove(Contact contact) {
                contact.removeUseCount();
            }
        });
        mappings.put(ContactField.HOME_ADDRESS, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setAddressHome(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsAddressHome();
            }

            public String get(Contact contact) {
                return contact.getAddressHome();
            }

            public void remove(Contact contact) {
                contact.removeAddressHome();
            }
        });
        mappings.put(ContactField.BUSINESS_ADDRESS, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setAddressBusiness(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsAddressBusiness();
            }

            public String get(Contact contact) {
                return contact.getAddressBusiness();
            }

            public void remove(Contact contact) {
                contact.removeAddressBusiness();
            }
        });
        mappings.put(ContactField.OTHER_ADDRESS, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setAddressOther(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsAddressOther();
            }

            public String get(Contact contact) {
                return contact.getAddressOther();
            }

            public void remove(Contact contact) {
                contact.removeAddressOther();
            }
        });
        mappings.put(ContactField.UID, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setUid(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsUid();
            }

            public String get(Contact contact) {
                return contact.getUid();
            }

            public void remove(Contact contact) {
                contact.removeUid();
            }
        });
        mappings.put(ContactField.FILENAME, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setFilename(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsFilename();
            }

            public String get(Contact contact) {
                return contact.getFilename();
            }

            public void remove(Contact contact) {
                contact.removeFilename();
            }
        });
        mappings.put(ContactField.VCARD_ID, new StringMapping(){

            public void set(Contact contact, String value) {
                contact.setVCardId(value);
            }

            public boolean isSet(Contact contact) {
                return contact.containsVCardId();
            }

            public String get(Contact contact) {
                return contact.getVCardId();
            }

            public void remove(Contact contact) {
                contact.removeVCardId();
            }
        });
    }
}

