/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.consistency.solver;

import com.openexchange.consistency.Entity;
import com.openexchange.consistency.solver.ProblemSolver;
import com.openexchange.exception.OXException;
import com.openexchange.filestore.FileStorage;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveFileSolver
implements ProblemSolver {
    private static final Logger LOG = LoggerFactory.getLogger(RemoveFileSolver.class);
    private final FileStorage storage;

    public RemoveFileSolver(FileStorage storage) {
        this.storage = storage;
    }

    @Override
    public void solve(Entity entity, Set<String> problems) {
        try {
            for (String identifier : problems) {
                try {
                    if (!this.storage.deleteFile(identifier)) continue;
                    LOG.info("Deleted identifier: {}", (Object)identifier);
                }
                catch (Exception e) {}
            }
            this.storage.recreateStateFile();
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
        }
    }

    @Override
    public String description() {
        return "delete file";
    }
}

